/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Snapshot;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.auth.CassandraAuthorizer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.CIDRFilteringMetricsTableMBean;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.db.virtual.VirtualTable;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.metrics.CIDRAuthorizerMetrics;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.MBeanWrapper;

public class CIDRFilteringMetricsTable
implements CIDRFilteringMetricsTableMBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=CIDRFilteringMetricsTable";
    private static final CIDRFilteringMetricsTable instance = new CIDRFilteringMetricsTable();

    CIDRFilteringMetricsTable() {
        if (!MBeanWrapper.instance.isRegistered(MBEAN_NAME)) {
            MBeanWrapper.instance.registerMBean((Object)this, MBEAN_NAME);
        }
    }

    public static Collection<VirtualTable> getAll(String keyspace) {
        return Arrays.asList(new CIDRFilteringMetricsCountsTable(keyspace), new CIDRFilteringMetricsLatenciesTable(keyspace));
    }

    private UntypedResultSet retrieveRows(SelectStatement statement) {
        QueryOptions options = QueryOptions.forInternalCalls(CassandraAuthorizer.authReadConsistencyLevel(), Collections.emptyList());
        ResultMessage.Rows rows = statement.execute(QueryState.forInternalCalls(), options, Clock.Global.nanoTime());
        return UntypedResultSet.create(rows.result);
    }

    @Override
    public Map<String, Long> getCountsMetricsFromVtable() {
        String countsMetricsTableName = "system_views.cidr_filtering_metrics_counts";
        SelectStatement getCountsMetricsStatement = (SelectStatement)QueryProcessor.getStatement(String.format("SELECT * FROM %s", countsMetricsTableName), ClientState.forInternalCalls());
        HashMap<String, Long> metrics = new HashMap<String, Long>();
        UntypedResultSet result = this.retrieveRows(getCountsMetricsStatement);
        for (UntypedResultSet.Row row : result) {
            if (!row.has("name") || !row.has("value")) {
                throw new RuntimeException("Invalid row " + row + " in table: " + countsMetricsTableName);
            }
            metrics.put(row.getString("name"), row.getLong("value"));
        }
        return metrics;
    }

    @Override
    public Map<String, List<Double>> getLatenciesMetricsFromVtable() {
        String latenciesMetricsTableName = "system_views.cidr_filtering_metrics_latencies";
        SelectStatement getLatenciesMetricsStatement = (SelectStatement)QueryProcessor.getStatement(String.format("SELECT * FROM %s", latenciesMetricsTableName), ClientState.forInternalCalls());
        HashMap<String, List<Double>> metrics = new HashMap<String, List<Double>>();
        UntypedResultSet result = this.retrieveRows(getLatenciesMetricsStatement);
        for (UntypedResultSet.Row row : result) {
            if (!row.has("name") || !row.has("p50th")) {
                throw new RuntimeException("Invalid row " + row + " in table: " + latenciesMetricsTableName);
            }
            metrics.put(row.getString("name"), Arrays.asList(row.getDouble("p50th"), row.getDouble("p95th"), row.getDouble("p99th"), row.getDouble("p999th"), row.getDouble("max")));
        }
        return metrics;
    }

    public static class CIDRFilteringMetricsLatenciesTable
    extends AbstractVirtualTable {
        public static final String TABLE_NAME = "cidr_filtering_metrics_latencies";
        public static final String NAME_COL = "name";
        public static final String P50_COL = "p50th";
        public static final String P95_COL = "p95th";
        public static final String P99_COL = "p99th";
        public static final String P999_COL = "p999th";
        public static final String MAX_COL = "max";
        public static final String CIDR_CHECKS_LATENCY_NAME = "CIDR checks latency (ns)";
        public static final String CIDR_GROUPS_CACHE_RELOAD_LATENCY_NAME = "CIDR groups cache reload latency (ns)";
        public static final String LOOKUP_CIDR_GROUPS_FOR_IP_LATENCY_NAME = "Lookup IP in CIDR groups cache latency (ns)";

        @VisibleForTesting
        CIDRFilteringMetricsLatenciesTable(String keyspace) {
            super(TableMetadata.builder(keyspace, TABLE_NAME).comment("Latency metrics specific to CIDR filtering").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(NAME_COL, UTF8Type.instance).addRegularColumn(P50_COL, DoubleType.instance).addRegularColumn(P95_COL, DoubleType.instance).addRegularColumn(P99_COL, DoubleType.instance).addRegularColumn(P999_COL, DoubleType.instance).addRegularColumn(MAX_COL, DoubleType.instance).build());
        }

        private void addRow(SimpleDataSet dataSet, String name, Snapshot snapshot) {
            dataSet.row(name).column(P50_COL, snapshot.getMedian()).column(P95_COL, snapshot.get95thPercentile()).column(P99_COL, snapshot.get99thPercentile()).column(P999_COL, snapshot.get999thPercentile()).column(MAX_COL, snapshot.getMax());
        }

        @Override
        public AbstractVirtualTable.DataSet data() {
            SimpleDataSet result = new SimpleDataSet(this.metadata());
            CIDRAuthorizerMetrics cidrAuthorizerMetrics = DatabaseDescriptor.getCIDRAuthorizer().getCidrAuthorizerMetrics();
            this.addRow(result, CIDR_CHECKS_LATENCY_NAME, cidrAuthorizerMetrics.cidrChecksLatency.getSnapshot());
            this.addRow(result, CIDR_GROUPS_CACHE_RELOAD_LATENCY_NAME, cidrAuthorizerMetrics.cacheReloadLatency.getSnapshot());
            this.addRow(result, LOOKUP_CIDR_GROUPS_FOR_IP_LATENCY_NAME, cidrAuthorizerMetrics.lookupCidrGroupsForIpLatency.getSnapshot());
            return result;
        }
    }

    public static class CIDRFilteringMetricsCountsTable
    extends AbstractVirtualTable {
        public static final String TABLE_NAME = "cidr_filtering_metrics_counts";
        public static final String NAME_COL = "name";
        public static final String VALUE_COL = "value";
        public static final String CIDR_ACCESSES_ACCEPTED_COUNT_NAME_PREFIX = "Number of CIDR accesses accepted from CIDR group - ";
        public static final String CIDR_ACCESSES_REJECTED_COUNT_NAME_PREFIX = "Number of CIDR accesses rejected from CIDR group - ";
        public static final String CIDR_GROUPS_CACHE_RELOAD_COUNT_NAME = "CIDR groups cache reload count";

        @VisibleForTesting
        CIDRFilteringMetricsCountsTable(String keyspace) {
            super(TableMetadata.builder(keyspace, TABLE_NAME).comment("Count metrics specific to CIDR filtering").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(NAME_COL, UTF8Type.instance).addRegularColumn(VALUE_COL, LongType.instance).build());
        }

        private void addRow(SimpleDataSet dataSet, String name, long value) {
            dataSet.row(name).column(VALUE_COL, value);
        }

        @Override
        public AbstractVirtualTable.DataSet data() {
            SimpleDataSet result = new SimpleDataSet(this.metadata());
            CIDRAuthorizerMetrics cidrAuthorizerMetrics = DatabaseDescriptor.getCIDRAuthorizer().getCidrAuthorizerMetrics();
            for (Map.Entry<String, Counter> entry : cidrAuthorizerMetrics.acceptedCidrAccessCount.entrySet()) {
                this.addRow(result, CIDR_ACCESSES_ACCEPTED_COUNT_NAME_PREFIX + entry.getKey(), entry.getValue().getCount());
            }
            for (Map.Entry<String, Counter> entry : cidrAuthorizerMetrics.rejectedCidrAccessCount.entrySet()) {
                this.addRow(result, CIDR_ACCESSES_REJECTED_COUNT_NAME_PREFIX + entry.getKey(), entry.getValue().getCount());
            }
            this.addRow(result, CIDR_GROUPS_CACHE_RELOAD_COUNT_NAME, cidrAuthorizerMetrics.cacheReloadCount.getCount());
            return result;
        }
    }
}

