/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Field getModifiersField() throws NoSuchFieldException {
        return ReflectionUtils.getField(Field.class, "modifiers");
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            try {
                Field[] fields;
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                getDeclaredFields0.setAccessible(true);
                for (Field field : fields = (Field[])getDeclaredFields0.invoke(clazz, false)) {
                    if (!fieldName.equals(field.getName())) continue;
                    return field;
                }
            }
            catch (ReflectiveOperationException ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> void clearMapField(Class<?> clazz, Object instance, String mapName, Predicate<Map.Entry<K, V>> shouldRemove) {
        try {
            Map map;
            Field mapField = ReflectionUtils.getField(clazz, mapName);
            mapField.setAccessible(true);
            Map map2 = map = (Map)mapField.get(instance);
            synchronized (map2) {
                Iterator it = map.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (!shouldRemove.test(entry)) continue;
                    it.remove();
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new RuntimeException(String.format("Could not clear map field %s in class %s", mapName, clazz), ex);
        }
    }
}

