/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.PaxosMetrics;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.PendingRangeCalculatorService;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.Paxos;
import org.apache.cassandra.service.paxos.PaxosPrepareRefresh;
import org.apache.cassandra.service.paxos.PaxosRequestCallback;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.CollectionSerializer;
import org.apache.cassandra.utils.concurrent.Awaitable;
import org.apache.cassandra.utils.vint.VIntCoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosPrepare
extends PaxosRequestCallback<Response>
implements PaxosPrepareRefresh.Callbacks,
Paxos.Async<Status> {
    private static final Logger logger = LoggerFactory.getLogger(PaxosPrepare.class);
    private static Runnable onLinearizabilityViolation;
    public static final RequestHandler requestHandler;
    public static final RequestSerializer requestSerializer;
    public static final ResponseSerializer responseSerializer;
    private final boolean acceptEarlyReadPermission;
    private final AbstractRequest<?> request;
    private Ballot supersededBy;
    private Commit.Accepted latestAccepted;
    private Commit.Committed latestCommitted;
    private final Paxos.Participants participants;
    private final List<Message<ReadResponse>> readResponses;
    private boolean haveReadResponseWithLatest;
    private boolean haveQuorumOfPermissions;
    private List<InetAddressAndPort> withLatest;
    private List<InetAddressAndPort> needLatest;
    private int failures;
    private boolean hasProposalStability = true;
    private boolean hasOnlyPromises = true;
    private long maxLowBound;
    private Status outcome;
    private final Consumer<Status> onDone;
    private PaxosPrepareRefresh refreshStaleParticipants;
    private boolean linearizabilityViolationDetected = false;

    PaxosPrepare(Paxos.Participants participants, AbstractRequest<?> request, boolean acceptEarlyReadPermission, Consumer<Status> onDone) {
        this.acceptEarlyReadPermission = acceptEarlyReadPermission;
        assert (participants.sizeOfConsensusQuorum > 0);
        this.participants = participants;
        this.request = request;
        this.readResponses = new ArrayList<Message<ReadResponse>>(participants.sizeOfConsensusQuorum);
        this.withLatest = new ArrayList<InetAddressAndPort>(participants.sizeOfConsensusQuorum);
        this.latestCommitted = Commit.Committed.none(request.partitionKey, request.table);
        this.latestAccepted = this.latestCommitted;
        this.onDone = onDone;
    }

    private boolean hasInProgressProposal() {
        if (this.latestAccepted.update.isEmpty()) {
            return false;
        }
        if (!this.latestAccepted.isAfter(this.latestCommitted)) {
            return false;
        }
        if (this.latestAccepted.ballot.uuidTimestamp() <= this.maxLowBound) {
            return false;
        }
        return !this.latestAccepted.isReproposalOf(this.latestCommitted);
    }

    static PaxosPrepare prepare(Paxos.Participants participants, SinglePartitionReadCommand readCommand, boolean isWrite, boolean acceptEarlyReadPermission) throws UnavailableException {
        return PaxosPrepare.prepare(null, participants, readCommand, isWrite, acceptEarlyReadPermission);
    }

    static PaxosPrepare prepare(Ballot minimumBallot, Paxos.Participants participants, SinglePartitionReadCommand readCommand, boolean isWrite, boolean acceptEarlyReadPermission) throws UnavailableException {
        return PaxosPrepare.prepareWithBallot(Paxos.newBallot(minimumBallot, participants.consistencyForConsensus), participants, readCommand, isWrite, acceptEarlyReadPermission);
    }

    static PaxosPrepare prepareWithBallot(Ballot ballot, Paxos.Participants participants, SinglePartitionReadCommand readCommand, boolean isWrite, boolean acceptEarlyReadPermission) {
        Tracing.trace("Preparing {} with read", (Object)ballot);
        Request request = new Request(ballot, participants.electorate, readCommand, isWrite);
        return PaxosPrepare.prepareWithBallotInternal(participants, request, acceptEarlyReadPermission, null);
    }

    static <T extends Consumer<Status>> T prepareWithBallot(Ballot ballot, Paxos.Participants participants, DecoratedKey partitionKey, TableMetadata table, boolean isWrite, boolean acceptEarlyReadPermission, T onDone) {
        Tracing.trace("Preparing {}", (Object)ballot);
        PaxosPrepare.prepareWithBallotInternal(participants, new Request(ballot, participants.electorate, partitionKey, table, isWrite), acceptEarlyReadPermission, onDone);
        return onDone;
    }

    private static PaxosPrepare prepareWithBallotInternal(Paxos.Participants participants, Request request, boolean acceptEarlyReadPermission, Consumer<Status> onDone) {
        PaxosPrepare prepare = new PaxosPrepare(participants, request, acceptEarlyReadPermission, onDone);
        Message<Request> message = Message.out(Verb.PAXOS2_PREPARE_REQ, request);
        PaxosPrepare.start(prepare, participants, message, RequestHandler::execute);
        return prepare;
    }

    static <R extends AbstractRequest<R>> void start(PaxosPrepare prepare, Paxos.Participants participants, Message<R> send, BiFunction<R, InetAddressAndPort, Response> selfHandler) {
        boolean executeOnSelf = false;
        int size = participants.sizeOfPoll();
        for (int i = 0; i < size; ++i) {
            InetAddressAndPort destination = participants.voter(i);
            boolean isPending = participants.electorate.isPending(destination);
            logger.trace("{} to {}", send.payload, (Object)destination);
            if (PaxosPrepare.shouldExecuteOnSelf(destination)) {
                executeOnSelf = true;
                continue;
            }
            MessagingService.instance().sendWithCallback(isPending ? PaxosPrepare.withoutRead(send) : send, destination, prepare);
        }
        if (executeOnSelf) {
            send.verb().stage.execute(() -> prepare.executeOnSelf((AbstractRequest)send.payload, selfHandler));
        }
    }

    @Override
    public synchronized Status awaitUntil(long deadline) {
        try {
            while (!this.isDone() && Awaitable.SyncAwaitable.waitUntil(this, deadline)) {
            }
            if (!this.isDone()) {
                this.signalDone(Status.Outcome.MAYBE_FAILURE);
            }
            return this.outcome;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new MaybeFailure(new Paxos.MaybeFailure(true, this.participants.sizeOfPoll(), this.participants.sizeOfConsensusQuorum, 0, Collections.emptyMap()), this.participants);
        }
    }

    private boolean isDone() {
        return this.outcome != null;
    }

    private int withLatest() {
        return this.withLatest.size();
    }

    private int needLatest() {
        return this.needLatest == null ? 0 : this.needLatest.size();
    }

    private static boolean needsGossipUpdate(Map<InetAddressAndPort, EndpointState> gossipInfo) {
        if (gossipInfo.isEmpty()) {
            return false;
        }
        for (Map.Entry<InetAddressAndPort, EndpointState> entry : gossipInfo.entrySet()) {
            EndpointState local;
            EndpointState remote = entry.getValue();
            if (remote == null || (local = Gossiper.instance.getEndpointStateForEndpoint(entry.getKey())) != null && !local.isSupersededBy(remote)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void onResponse(Response response, InetAddressAndPort from) {
        if (logger.isTraceEnabled()) {
            logger.trace("{} for {} from {}", new Object[]{response, this.request.ballot, from});
        }
        if (this.isDone()) {
            this.maybeCheckForLinearizabilityViolation(response, from);
            return;
        }
        if (response.isRejected()) {
            Rejected rejected = response.rejected();
            this.supersededBy = rejected.supersededBy;
            this.signalDone(Status.Outcome.SUPERSEDED);
            return;
        }
        Permitted permitted = response.permitted();
        if (permitted.gossipInfo.isEmpty()) {
            this.permitted(permitted, from);
        } else if (!PaxosPrepare.needsGossipUpdate(permitted.gossipInfo)) {
            this.permittedOrTerminateIfElectorateMismatch(permitted, from);
        } else {
            Stage.GOSSIP.executor().execute(() -> {
                Gossiper.instance.notifyFailureDetector(permitted.gossipInfo);
                Gossiper.instance.applyStateLocally(permitted.gossipInfo);
                PendingRangeCalculatorService.instance.executeWhenFinished(() -> this.permittedOrTerminateIfElectorateMismatch(permitted, from));
            });
        }
    }

    private synchronized void permittedOrTerminateIfElectorateMismatch(Permitted permitted, InetAddressAndPort from) {
        if (this.isDone()) {
            return;
        }
        if (!Paxos.Electorate.get(this.request.table, this.request.partitionKey, Paxos.consistency(this.request.ballot)).equals(this.participants.electorate)) {
            this.signalDone(Status.Outcome.ELECTORATE_MISMATCH);
            return;
        }
        this.permitted(permitted, from);
    }

    private void permitted(Permitted permitted, InetAddressAndPort from) {
        if (permitted.outcome != PaxosState.MaybePromise.Outcome.PROMISE) {
            this.hasOnlyPromises = false;
            if (this.supersededBy == null) {
                this.supersededBy = permitted.supersededBy;
            }
        }
        if (permitted.lowBound > this.maxLowBound) {
            this.maxLowBound = permitted.lowBound;
        }
        if (!this.haveQuorumOfPermissions) {
            Commit.CompareResult compareLatest = permitted.latestCommitted.compareWith(this.latestCommitted);
            switch (compareLatest) {
                default: {
                    throw new IllegalStateException();
                }
                case IS_REPROPOSAL: {
                    this.latestCommitted = permitted.latestCommitted;
                }
                case WAS_REPROPOSED_BY: 
                case SAME: {
                    this.withLatest.add(from);
                    this.haveReadResponseWithLatest |= permitted.readResponse != null;
                    break;
                }
                case BEFORE: {
                    if (this.needLatest == null) {
                        this.needLatest = new ArrayList<InetAddressAndPort>(this.participants.sizeOfPoll() - this.withLatest.size());
                    }
                    this.needLatest.add(from);
                    break;
                }
                case AFTER: {
                    if (!this.withLatest.isEmpty()) {
                        if (this.needLatest == null) {
                            this.needLatest = this.withLatest;
                            this.withLatest = new ArrayList<InetAddressAndPort>(Math.min(this.participants.sizeOfPoll() - this.needLatest.size(), this.participants.sizeOfConsensusQuorum));
                        } else {
                            this.needLatest.addAll(this.withLatest);
                            this.withLatest.clear();
                        }
                    }
                    this.withLatest.add(from);
                    this.haveReadResponseWithLatest = permitted.readResponse != null;
                    this.latestCommitted = permitted.latestCommitted;
                }
            }
            if (Commit.isAfter((Commit)permitted.latestAcceptedButNotCommitted, (Commit)this.latestAccepted)) {
                this.latestAccepted = permitted.latestAcceptedButNotCommitted;
            }
            if (permitted.readResponse != null) {
                this.hasProposalStability &= permitted.hadProposalStability;
                this.addReadResponse(permitted.readResponse, from);
            }
        } else {
            switch (permitted.latestCommitted.compareWith(this.latestCommitted)) {
                default: {
                    throw new IllegalStateException();
                }
                case IS_REPROPOSAL: 
                case WAS_REPROPOSED_BY: 
                case SAME: {
                    this.withLatest.add(from);
                    break;
                }
                case AFTER: {
                    if (this.maybeCheckForLinearizabilityViolation(permitted, from)) {
                        return;
                    }
                }
                case BEFORE: {
                    if (this.needLatest == null) {
                        this.needLatest = new ArrayList<InetAddressAndPort>(this.participants.sizeOfPoll() - this.withLatest.size());
                    }
                    this.needLatest.add(from);
                }
            }
        }
        this.haveQuorumOfPermissions |= this.withLatest() + this.needLatest() >= this.participants.sizeOfConsensusQuorum;
        if (this.haveQuorumOfPermissions) {
            if (this.request.read != null && this.readResponses.size() < this.participants.sizeOfReadQuorum) {
                throw new IllegalStateException("Insufficient read responses: " + this.readResponses + "; need " + this.participants.sizeOfReadQuorum);
            }
            if (!this.hasOnlyPromises && !this.hasProposalStability) {
                this.signalDone(Status.Outcome.SUPERSEDED);
            } else if (this.hasInProgressProposal()) {
                this.signalDone(this.hasOnlyPromises ? Status.Outcome.FOUND_INCOMPLETE_ACCEPTED : Status.Outcome.SUPERSEDED);
            } else if (this.withLatest() >= this.participants.sizeOfConsensusQuorum) {
                this.signalDone(this.hasOnlyPromises ? Status.Outcome.PROMISED : Status.Outcome.READ_PERMITTED);
            } else if (this.haveReadResponseWithLatest) {
                this.refreshStaleParticipants();
                if (this.hasProposalStability && this.acceptEarlyReadPermission) {
                    this.signalDone(Status.Outcome.READ_PERMITTED);
                }
            } else {
                this.signalDone(Status.Outcome.FOUND_INCOMPLETE_COMMITTED);
            }
        }
    }

    private boolean maybeCheckForLinearizabilityViolation(Response response, InetAddressAndPort from) {
        if (!(response.isPromised() && this.haveQuorumOfPermissions && this.hasOnlyPromises)) {
            return false;
        }
        Permitted permitted = response.permitted();
        if (permitted.latestCommitted.compareWith(this.latestCommitted) == Commit.CompareResult.AFTER) {
            return this.checkForLinearizabilityViolation(permitted, from);
        }
        return false;
    }

    private static boolean isRunningLegacyPaxos() {
        switch (Paxos.getPaxosVariant()) {
            case v1: 
            case v1_without_linearizable_reads_or_rejected_writes: {
                return true;
            }
        }
        return false;
    }

    private Ballot getLowBoundForKey() {
        ColumnFamilyStore cfs = Schema.instance.getColumnFamilyStoreInstance(this.request.table.id);
        return cfs != null ? cfs.getPaxosRepairLowBound(this.request.partitionKey) : Ballot.none();
    }

    private boolean isCompatibleWithLinearizabilityCheck() {
        if (PaxosPrepare.isRunningLegacyPaxos()) {
            return false;
        }
        return this.getLowBoundForKey() != Ballot.none();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForLinearizabilityViolation(Permitted permitted, InetAddressAndPort from) {
        if (!this.isCompatibleWithLinearizabilityCheck()) {
            return false;
        }
        if (this.linearizabilityViolationDetected) {
            return false;
        }
        if (permitted.latestCommitted.hasSameBallot(this.latestAccepted)) {
            return false;
        }
        if (this.latestAccepted != null && this.latestAccepted.update.isEmpty() && this.latestAccepted.isAfter(permitted.latestCommitted)) {
            return false;
        }
        if (permitted.latestCommitted.ballot.uuidTimestamp() <= this.maxLowBound) {
            return false;
        }
        if (permitted.latestCommitted.ballot.flag() == Ballot.Flag.NONE) {
            return false;
        }
        if (this.latestAccepted != null && this.outcome.outcome == Status.Outcome.FOUND_INCOMPLETE_ACCEPTED) {
            switch (permitted.latestCommitted.compareWith(this.latestAccepted)) {
                case WAS_REPROPOSED_BY: 
                case SAME: {
                    return false;
                }
            }
        }
        long gcGraceMicros = TimeUnit.SECONDS.toMicros(permitted.latestCommitted.update.metadata().params.gcGraceSeconds);
        long maxNowMicros = Math.max(Clock.Global.currentTimeMillis() * 1000L, this.request.ballot.unixMicros());
        long ageMicros = maxNowMicros - permitted.latestCommitted.ballot.unixMicros();
        String modifier = "";
        boolean isTtlViolation = ageMicros >= gcGraceMicros;
        if (isTtlViolation) {
            modifier = this.participants.hasOldParticipants() ? " (older than legacy TTL expiry with at least one legacy participant)" : " (older than legacy TTL expiry)";
        }
        String message = String.format("Linearizability violation%s: %s witnessed %s of latest %s (withLatest: %s, readResponses: %s, maxLowBound: %s, status: %s); %s promised with latest %s", new Object[]{modifier, this.request.ballot, Paxos.consistency(this.request.ballot), this.latestCommitted, this.withLatest, this.readResponses.stream().map(Message::from).map(Object::toString).collect(Collectors.joining(", ", "[", "]")), this.maxLowBound, this.outcome, from, permitted.latestCommitted});
        PaxosMetrics.linearizabilityViolations.inc();
        this.linearizabilityViolationDetected = true;
        try {
            switch (DatabaseDescriptor.paxosOnLinearizabilityViolations()) {
                default: {
                    throw new AssertionError();
                }
                case fail: {
                    this.signalDone(new MaybeFailure(new Paxos.MaybeFailure(true, "A linearizability violation was detected", this.participants.sizeOfPoll(), this.participants.sizeOfConsensusQuorum, this.withLatest() + this.needLatest(), Collections.emptyMap()), this.participants));
                    boolean bl = true;
                    return bl;
                }
                case log: {
                    if (isTtlViolation && Paxos.LOG_TTL_LINEARIZABILITY_VIOLATIONS) {
                        logger.warn(message);
                    } else {
                        logger.error(message);
                    }
                    boolean bl = false;
                    return bl;
                }
                case ignore: 
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Runnable run = onLinearizabilityViolation;
            if (run != null) {
                run.run();
            }
        }
    }

    private void addReadResponse(ReadResponse response, InetAddressAndPort from) {
        this.readResponses.add(Message.synthetic(from, Verb.PAXOS2_PREPARE_RSP, response));
    }

    @Override
    public synchronized void onFailure(InetAddressAndPort from, RequestFailureReason reason) {
        if (logger.isTraceEnabled()) {
            logger.trace("{} {} failure from {}", new Object[]{this.request, reason, from});
        }
        if (this.isDone()) {
            return;
        }
        super.onFailureWithMutex(from, reason);
        ++this.failures;
        if (this.failures + this.participants.sizeOfConsensusQuorum == 1 + this.participants.sizeOfPoll()) {
            this.signalDone(Status.Outcome.MAYBE_FAILURE);
        }
    }

    private void signalDone(Status.Outcome kindOfOutcome) {
        this.signalDone(this.toStatus(kindOfOutcome));
    }

    private void signalDone(Status status) {
        if (this.isDone()) {
            throw new IllegalStateException();
        }
        this.outcome = status;
        if (this.onDone != null) {
            this.onDone.accept(this.outcome);
        }
        this.notifyAll();
    }

    private Status toStatus(Status.Outcome outcome) {
        switch (outcome) {
            case ELECTORATE_MISMATCH: {
                return new ElectorateMismatch(this.participants, this.request.ballot);
            }
            case SUPERSEDED: {
                return new Superseded(this.supersededBy, this.participants);
            }
            case FOUND_INCOMPLETE_ACCEPTED: {
                return new FoundIncompleteAccepted(this.request.ballot, this.participants, this.latestAccepted);
            }
            case FOUND_INCOMPLETE_COMMITTED: {
                return new FoundIncompleteCommitted(this.request.ballot, this.participants, this.latestCommitted);
            }
            case PROMISED: {
                return Success.readOrWrite(this.request.ballot, this.participants, this.readResponses, this.hasProposalStability);
            }
            case READ_PERMITTED: {
                if (!this.hasProposalStability) {
                    throw new IllegalStateException();
                }
                return Success.read(this.request.ballot, this.participants, this.readResponses, this.supersededBy);
            }
            case MAYBE_FAILURE: {
                return new MaybeFailure(new Paxos.MaybeFailure(this.participants, this.withLatest(), this.failureReasonsAsMap()), this.participants);
            }
        }
        throw new IllegalStateException();
    }

    private void refreshStaleParticipants() {
        if (this.refreshStaleParticipants == null) {
            this.refreshStaleParticipants = new PaxosPrepareRefresh(this.request.ballot, this.participants, this.latestCommitted, this);
        }
        this.refreshStaleParticipants.refresh(this.needLatest);
        this.needLatest.clear();
    }

    @Override
    public void onRefreshFailure(InetAddressAndPort from, RequestFailureReason reason) {
        this.onFailure(from, reason);
    }

    @Override
    public synchronized void onRefreshSuccess(Ballot isSupersededBy, InetAddressAndPort from) {
        if (logger.isTraceEnabled()) {
            logger.trace("Refresh {} from {}", isSupersededBy == null ? "Success" : "SupersededBy(" + isSupersededBy + ")", (Object)from);
        }
        if (this.isDone()) {
            return;
        }
        if (isSupersededBy != null) {
            this.supersededBy = isSupersededBy;
            if (this.hasProposalStability) {
                this.signalDone(Status.Outcome.READ_PERMITTED);
            } else {
                this.signalDone(Status.Outcome.SUPERSEDED);
            }
        } else {
            this.withLatest.add(from);
            if (this.withLatest.size() >= this.participants.sizeOfConsensusQuorum) {
                this.signalDone(this.hasOnlyPromises ? Status.Outcome.PROMISED : Status.Outcome.READ_PERMITTED);
            }
        }
    }

    static <R extends AbstractRequest<R>> Message<R> withoutRead(Message<R> send) {
        if (((AbstractRequest)send.payload).read == null) {
            return send;
        }
        return send.withPayload(((AbstractRequest)send.payload).withoutRead());
    }

    public static void setOnLinearizabilityViolation(Runnable runnable) {
        assert (onLinearizabilityViolation == null || runnable == null);
        onLinearizabilityViolation = runnable;
    }

    static {
        requestHandler = new RequestHandler();
        requestSerializer = new RequestSerializer();
        responseSerializer = new ResponseSerializer();
    }

    public static class ResponseSerializer
    implements IVersionedSerializer<Response> {
        @Override
        public void serialize(Response response, DataOutputPlus out, int version) throws IOException {
            if (response.isRejected()) {
                out.writeByte(0);
                Rejected rejected = (Rejected)response;
                rejected.supersededBy.serialize(out);
            } else {
                Permitted promised = (Permitted)response;
                out.writeByte(1 | (promised.latestAcceptedButNotCommitted != null ? 2 : 0) | (promised.readResponse != null ? 4 : 0) | (promised.hadProposalStability ? 8 : 0) | (promised.outcome == PaxosState.MaybePromise.Outcome.PERMIT_READ ? 16 : 0));
                out.writeUnsignedVInt(promised.lowBound);
                if (promised.latestAcceptedButNotCommitted != null) {
                    Commit.Accepted.serializer.serialize(promised.latestAcceptedButNotCommitted, out, version);
                }
                Commit.Committed.serializer.serialize(promised.latestCommitted, out, version);
                if (promised.readResponse != null) {
                    ReadResponse.serializer.serialize(promised.readResponse, out, version);
                }
                CollectionSerializer.serializeMap(InetAddressAndPort.Serializer.inetAddressAndPortSerializer, EndpointState.nullableSerializer, promised.gossipInfo, out, version);
                if (promised.outcome == PaxosState.MaybePromise.Outcome.PERMIT_READ) {
                    promised.supersededBy.serialize(out);
                }
            }
        }

        @Override
        public Response deserialize(DataInputPlus in, int version) throws IOException {
            byte flags = in.readByte();
            if (flags == 0) {
                Ballot supersededBy = Ballot.deserialize(in);
                return new Rejected(supersededBy);
            }
            long lowBound = in.readUnsignedVInt();
            Commit.Accepted acceptedNotCommitted = (flags & 2) != 0 ? (Commit.Accepted)Commit.Accepted.serializer.deserialize(in, version) : null;
            Commit.Committed committed = (Commit.Committed)Commit.Committed.serializer.deserialize(in, version);
            ReadResponse readResponse = (flags & 4) != 0 ? (ReadResponse)ReadResponse.serializer.deserialize(in, version) : null;
            Map<InetAddressAndPort, EndpointState> gossipInfo = CollectionSerializer.deserializeMap(InetAddressAndPort.Serializer.inetAddressAndPortSerializer, EndpointState.nullableSerializer, CollectionSerializer.newHashMap(), in, version);
            PaxosState.MaybePromise.Outcome outcome = (flags & 0x10) != 0 ? PaxosState.MaybePromise.Outcome.PERMIT_READ : PaxosState.MaybePromise.Outcome.PROMISE;
            boolean hasProposalStability = (flags & 8) != 0;
            Ballot supersededBy = null;
            if (outcome == PaxosState.MaybePromise.Outcome.PERMIT_READ) {
                supersededBy = Ballot.deserialize(in);
            }
            return new Permitted(outcome, lowBound, acceptedNotCommitted, committed, readResponse, hasProposalStability, gossipInfo, supersededBy);
        }

        @Override
        public long serializedSize(Response response, int version) {
            if (response.isRejected()) {
                return 1L + Ballot.sizeInBytes();
            }
            Permitted permitted = (Permitted)response;
            return (long)(1 + VIntCoding.computeUnsignedVIntSize(permitted.lowBound)) + (permitted.latestAcceptedButNotCommitted == null ? 0L : Commit.Accepted.serializer.serializedSize(permitted.latestAcceptedButNotCommitted, version)) + Commit.Committed.serializer.serializedSize(permitted.latestCommitted, version) + (permitted.readResponse == null ? 0L : ReadResponse.serializer.serializedSize(permitted.readResponse, version)) + CollectionSerializer.serializedSizeMap(InetAddressAndPort.Serializer.inetAddressAndPortSerializer, EndpointState.nullableSerializer, permitted.gossipInfo, version) + (permitted.outcome == PaxosState.MaybePromise.Outcome.PERMIT_READ ? Ballot.sizeInBytes() : 0L);
        }
    }

    public static class RequestSerializer
    extends AbstractRequestSerializer<Request, Object> {
        @Override
        Request construct(Object ignore, Ballot ballot, Paxos.Electorate electorate, SinglePartitionReadCommand read, boolean isWrite) {
            return new Request(ballot, electorate, read, isWrite);
        }

        @Override
        Request construct(Object ignore, Ballot ballot, Paxos.Electorate electorate, DecoratedKey partitionKey, TableMetadata table, boolean isWrite) {
            return new Request(ballot, electorate, partitionKey, table, isWrite);
        }

        @Override
        public Request deserialize(DataInputPlus in, int version) throws IOException {
            return (Request)this.deserialize((Object)null, in, version);
        }
    }

    static abstract class AbstractRequestSerializer<R extends AbstractRequest<R>, T>
    implements IVersionedSerializer<R> {
        AbstractRequestSerializer() {
        }

        abstract R construct(T var1, Ballot var2, Paxos.Electorate var3, SinglePartitionReadCommand var4, boolean var5);

        abstract R construct(T var1, Ballot var2, Paxos.Electorate var3, DecoratedKey var4, TableMetadata var5, boolean var6);

        @Override
        public void serialize(R request, DataOutputPlus out, int version) throws IOException {
            ((AbstractRequest)request).ballot.serialize(out);
            Paxos.Electorate.serializer.serialize(((AbstractRequest)request).electorate, out, version);
            out.writeByte((((AbstractRequest)request).read != null ? 1 : 0) | (((AbstractRequest)request).isForWrite ? 0 : 2));
            if (((AbstractRequest)request).read != null) {
                ReadCommand.serializer.serialize(((AbstractRequest)request).read, out, version);
            } else {
                ((AbstractRequest)request).table.id.serialize(out);
                DecoratedKey.serializer.serialize(((AbstractRequest)request).partitionKey, out, version);
            }
        }

        public R deserialize(T param, DataInputPlus in, int version) throws IOException {
            Ballot ballot = Ballot.deserialize(in);
            Paxos.Electorate electorate = Paxos.Electorate.serializer.deserialize(in, version);
            byte flag = in.readByte();
            if ((flag & 1) != 0) {
                SinglePartitionReadCommand readCommand = (SinglePartitionReadCommand)ReadCommand.serializer.deserialize(in, version);
                return this.construct(param, ballot, electorate, readCommand, (flag & 2) == 0);
            }
            TableMetadata table = Schema.instance.getExistingTableMetadata(TableId.deserialize(in));
            DecoratedKey partitionKey = (DecoratedKey)DecoratedKey.serializer.deserialize(in, table.partitioner, version);
            return this.construct(param, ballot, electorate, partitionKey, table, (flag & 2) != 0);
        }

        @Override
        public long serializedSize(R request, int version) {
            return Ballot.sizeInBytes() + Paxos.Electorate.serializer.serializedSize(((AbstractRequest)request).electorate, version) + 1L + (((AbstractRequest)request).read != null ? ReadCommand.serializer.serializedSize(((AbstractRequest)request).read, version) : (long)((AbstractRequest)request).table.id.serializedSize() + DecoratedKey.serializer.serializedSize(((AbstractRequest)request).partitionKey, version));
        }
    }

    public static class RequestHandler
    implements IVerbHandler<Request> {
        @Override
        public void doVerb(Message<Request> message) {
            Response response = RequestHandler.execute((AbstractRequest)message.payload, message.from());
            if (response == null) {
                MessagingService.instance().respondWithFailure(RequestFailureReason.UNKNOWN, message);
            } else {
                MessagingService.instance().respond(response, message);
            }
        }

        static Response execute(AbstractRequest<?> request, InetAddressAndPort from) {
            if (!Paxos.isInRangeAndShouldProcess(from, request.partitionKey, request.table, request.read != null)) {
                return null;
            }
            long start = Clock.Global.nanoTime();
            try {
                PaxosState state = PaxosState.get(request.partitionKey, request.table);
                try {
                    Response response = RequestHandler.execute(request, state);
                    if (state != null) {
                        state.close();
                    }
                    return response;
                }
                catch (Throwable throwable) {
                    if (state != null) {
                        try {
                            state.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            finally {
                Keyspace.openAndGetStore((TableMetadata)request.table).metric.casPrepare.addNano(Clock.Global.nanoTime() - start);
            }
        }

        /*
         * Unable to fully structure code
         */
        static Response execute(AbstractRequest<?> request, PaxosState state) {
            result = state.promiseIfNewer(request.ballot, request.isForWrite);
            switch (1.$SwitchMap$org$apache$cassandra$service$paxos$PaxosState$MaybePromise$Outcome[result.outcome.ordinal()]) {
                case 1: 
                case 2: {
                    gossipInfo = Paxos.verifyElectorate(request.electorate, Paxos.Electorate.get(request.table, request.partitionKey, Paxos.consistency(request.ballot)));
                    readResponse = null;
                    mostRecentCommit = result.before.accepted != null && result.before.accepted.ballot.compareTo(result.before.committed.ballot) > 0 && result.before.accepted.update.isEmpty() != false ? result.before.accepted.ballot : result.before.committed.ballot;
                    v0 = hasProposalStability = mostRecentCommit.equals(result.before.promisedWrite) != false || mostRecentCommit.compareTo(result.before.promisedWrite) > 0;
                    if (request.read == null) ** GOTO lbl26
                    executionController = request.read.executionController();
                    try {
                        iterator = request.read.executeLocally(executionController);
                        try {
                            readResponse = request.read.createResponse(iterator, executionController.getRepairedDataInfo());
                        }
                        finally {
                            if (iterator != null) {
                                iterator.close();
                            }
                        }
                    }
                    finally {
                        if (executionController != null) {
                            executionController.close();
                        }
                    }
                    if (hasProposalStability) {
                        now = state.current(request.ballot);
                        hasProposalStability = now.promisedWrite == result.after.promisedWrite && now.committed == result.after.committed && now.accepted == result.after.accepted;
                    }
lbl26:
                    // 4 sources

                    supersededBy = result.outcome == PaxosState.MaybePromise.Outcome.PROMISE ? null : result.after.latestWitnessedOrLowBound();
                    acceptedButNotCommitted = result.after.accepted;
                    committed = result.after.committed;
                    cfs = Schema.instance.getColumnFamilyStoreInstance(request.table.id);
                    lowBound = cfs.getPaxosRepairLowBound(request.partitionKey).uuidTimestamp();
                    return new Permitted(result.outcome, lowBound, acceptedButNotCommitted, committed, readResponse, hasProposalStability, gossipInfo, supersededBy);
                }
                case 3: {
                    return new Rejected(result.supersededBy());
                }
            }
            throw new IllegalStateException();
        }
    }

    static class Rejected
    extends Response {
        final Ballot supersededBy;

        Rejected(Ballot supersededBy) {
            super(PaxosState.MaybePromise.Outcome.REJECT);
            this.supersededBy = supersededBy;
        }

        public String toString() {
            return "RejectPromise(supersededBy=" + this.supersededBy + ")";
        }
    }

    static class Permitted
    extends Response {
        final long lowBound;
        @Nullable
        final Commit.Accepted latestAcceptedButNotCommitted;
        final Commit.Committed latestCommitted;
        @Nullable
        final ReadResponse readResponse;
        final boolean hadProposalStability;
        final Map<InetAddressAndPort, EndpointState> gossipInfo;
        @Nullable
        final Ballot supersededBy;

        Permitted(PaxosState.MaybePromise.Outcome outcome, long lowBound, @Nullable Commit.Accepted latestAcceptedButNotCommitted, Commit.Committed latestCommitted, @Nullable ReadResponse readResponse, boolean hadProposalStability, Map<InetAddressAndPort, EndpointState> gossipInfo, @Nullable Ballot supersededBy) {
            super(outcome);
            this.lowBound = lowBound;
            this.latestAcceptedButNotCommitted = latestAcceptedButNotCommitted;
            this.latestCommitted = latestCommitted;
            this.hadProposalStability = hadProposalStability;
            this.readResponse = readResponse;
            this.gossipInfo = gossipInfo;
            this.supersededBy = supersededBy;
        }

        public String toString() {
            return "Promise(" + this.latestAcceptedButNotCommitted + ", " + this.latestCommitted + ", " + this.hadProposalStability + ", " + this.gossipInfo + ")";
        }
    }

    static class Response {
        final PaxosState.MaybePromise.Outcome outcome;

        Response(PaxosState.MaybePromise.Outcome outcome) {
            this.outcome = outcome;
        }

        Permitted permitted() {
            return (Permitted)this;
        }

        Rejected rejected() {
            return (Rejected)this;
        }

        public boolean isRejected() {
            return this.outcome == PaxosState.MaybePromise.Outcome.REJECT;
        }

        public boolean isPromised() {
            return this.outcome == PaxosState.MaybePromise.Outcome.PROMISE;
        }
    }

    static class Request
    extends AbstractRequest<Request> {
        Request(Ballot ballot, Paxos.Electorate electorate, SinglePartitionReadCommand read, boolean isWrite) {
            super(ballot, electorate, read, isWrite);
        }

        private Request(Ballot ballot, Paxos.Electorate electorate, DecoratedKey partitionKey, TableMetadata table, boolean isWrite) {
            super(ballot, electorate, partitionKey, table, isWrite);
        }

        @Override
        Request withoutRead() {
            return this.read == null ? this : new Request(this.ballot, this.electorate, this.partitionKey, this.table, this.isForWrite);
        }

        @Override
        public String toString() {
            return "Prepare(" + this.ballot + ")";
        }
    }

    static abstract class AbstractRequest<R extends AbstractRequest<R>> {
        final Ballot ballot;
        final Paxos.Electorate electorate;
        final SinglePartitionReadCommand read;
        final boolean isForWrite;
        final DecoratedKey partitionKey;
        final TableMetadata table;

        AbstractRequest(Ballot ballot, Paxos.Electorate electorate, SinglePartitionReadCommand read, boolean isForWrite) {
            this.ballot = ballot;
            this.electorate = electorate;
            this.read = read;
            this.isForWrite = isForWrite;
            this.partitionKey = read.partitionKey();
            this.table = read.metadata();
        }

        AbstractRequest(Ballot ballot, Paxos.Electorate electorate, DecoratedKey partitionKey, TableMetadata table, boolean isForWrite) {
            this.ballot = ballot;
            this.electorate = electorate;
            this.partitionKey = partitionKey;
            this.table = table;
            this.read = null;
            this.isForWrite = isForWrite;
        }

        abstract R withoutRead();

        public String toString() {
            return "Prepare(" + this.ballot + ")";
        }
    }

    static class ElectorateMismatch
    extends WithRequestedBallot {
        private ElectorateMismatch(Paxos.Participants participants, Ballot ballot) {
            super(Status.Outcome.ELECTORATE_MISMATCH, participants, ballot);
        }
    }

    static class MaybeFailure
    extends Status {
        final Paxos.MaybeFailure info;

        private MaybeFailure(Paxos.MaybeFailure info, Paxos.Participants participants) {
            super(Status.Outcome.MAYBE_FAILURE, participants);
            this.info = info;
        }

        public String toString() {
            return this.info.toString();
        }
    }

    static class FoundIncompleteCommitted
    extends FoundIncomplete {
        final Commit.Committed committed;

        private FoundIncompleteCommitted(Ballot promisedBallot, Paxos.Participants participants, Commit.Committed committed) {
            super(Status.Outcome.FOUND_INCOMPLETE_COMMITTED, participants, promisedBallot);
            this.committed = committed;
        }

        public String toString() {
            return "FoundIncomplete" + this.committed;
        }
    }

    static class FoundIncompleteAccepted
    extends FoundIncomplete {
        final Commit.Accepted accepted;

        private FoundIncompleteAccepted(Ballot promisedBallot, Paxos.Participants participants, Commit.Accepted accepted) {
            super(Status.Outcome.FOUND_INCOMPLETE_ACCEPTED, participants, promisedBallot);
            this.accepted = accepted;
        }

        public String toString() {
            return "FoundIncomplete" + this.accepted;
        }
    }

    static class FoundIncomplete
    extends WithRequestedBallot {
        private FoundIncomplete(Status.Outcome outcome, Paxos.Participants participants, Ballot promisedBallot) {
            super(outcome, participants, promisedBallot);
        }
    }

    static class WithRequestedBallot
    extends Status {
        final Ballot ballot;

        WithRequestedBallot(Status.Outcome outcome, Paxos.Participants participants, Ballot ballot) {
            super(outcome, participants);
            this.ballot = ballot;
        }
    }

    static class Superseded
    extends Status {
        final Ballot by;

        Superseded(Ballot by, Paxos.Participants participants) {
            super(Status.Outcome.SUPERSEDED, participants);
            this.by = by;
        }

        public String toString() {
            return "Superseded(" + this.by + ")";
        }
    }

    static class Success
    extends WithRequestedBallot {
        final List<Message<ReadResponse>> responses;
        final boolean isReadSafe;
        @Nullable
        final Ballot supersededBy;

        Success(Status.Outcome outcome, Ballot ballot, Paxos.Participants participants, List<Message<ReadResponse>> responses, boolean isReadSafe, @Nullable Ballot supersededBy) {
            super(outcome, participants, ballot);
            this.responses = responses;
            this.isReadSafe = isReadSafe;
            this.supersededBy = supersededBy;
        }

        static Success read(Ballot ballot, Paxos.Participants participants, List<Message<ReadResponse>> responses, @Nullable Ballot supersededBy) {
            return new Success(Status.Outcome.READ_PERMITTED, ballot, participants, responses, true, supersededBy);
        }

        static Success readOrWrite(Ballot ballot, Paxos.Participants participants, List<Message<ReadResponse>> responses, boolean isReadConsistent) {
            return new Success(Status.Outcome.PROMISED, ballot, participants, responses, isReadConsistent, null);
        }

        public String toString() {
            return "Success(" + this.ballot + ", " + this.participants.electorate + ")";
        }
    }

    static class Status {
        final Outcome outcome;
        final Paxos.Participants participants;

        Status(Outcome outcome, Paxos.Participants participants) {
            this.outcome = outcome;
            this.participants = participants;
        }

        @Nullable
        Ballot retryWithAtLeast() {
            switch (this.outcome) {
                case READ_PERMITTED: {
                    return ((Success)this).supersededBy;
                }
                case SUPERSEDED: {
                    return ((Superseded)this).by;
                }
            }
            return null;
        }

        Success success() {
            return (Success)this;
        }

        FoundIncompleteAccepted incompleteAccepted() {
            return (FoundIncompleteAccepted)this;
        }

        FoundIncompleteCommitted incompleteCommitted() {
            return (FoundIncompleteCommitted)this;
        }

        Paxos.MaybeFailure maybeFailure() {
            return ((MaybeFailure)this).info;
        }

        static enum Outcome {
            READ_PERMITTED,
            PROMISED,
            SUPERSEDED,
            FOUND_INCOMPLETE_ACCEPTED,
            FOUND_INCOMPLETE_COMMITTED,
            MAYBE_FAILURE,
            ELECTORATE_MISMATCH;

        }
    }
}

