/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.channel.EventLoop;
import java.nio.ByteBuffer;
import org.apache.cassandra.net.BufferPoolAllocator;
import org.apache.cassandra.utils.memory.BufferPool;
import org.apache.cassandra.utils.memory.BufferPools;

class LocalBufferPoolAllocator
extends BufferPoolAllocator {
    private final BufferPool.LocalPool pool = BufferPools.forNetworking().create().recycleWhenFree(false);
    private final EventLoop eventLoop;

    LocalBufferPoolAllocator(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    @Override
    ByteBuffer get(int size) {
        if (!this.eventLoop.inEventLoop()) {
            throw new IllegalStateException("get() called from outside of owning event loop");
        }
        return this.pool.get(size);
    }

    @Override
    ByteBuffer getAtLeast(int size) {
        if (!this.eventLoop.inEventLoop()) {
            throw new IllegalStateException("getAtLeast() called from outside of owning event loop");
        }
        return this.pool.getAtLeast(size);
    }

    @Override
    public void release() {
        this.pool.release();
    }
}

