/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.EndpointsByRange;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.PendingRangeMaps;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.locator.RangesByEndpoint;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;
import org.apache.cassandra.locator.ReplicaLayout;
import org.apache.cassandra.locator.TokenMetadataDiagnostics;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.BiMultiValMap;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.SortedBiMultiValMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenMetadata {
    private static final Logger logger = LoggerFactory.getLogger(TokenMetadata.class);
    private final BiMultiValMap<Token, InetAddressAndPort> tokenToEndpointMap;
    private final BiMap<InetAddressAndPort, UUID> endpointToHostIdMap;
    private final BiMultiValMap<Token, InetAddressAndPort> bootstrapTokens = new BiMultiValMap();
    private final BiMap<InetAddressAndPort, InetAddressAndPort> replacementToOriginal = HashBiMap.create();
    private final Set<InetAddressAndPort> leavingEndpoints = new HashSet<InetAddressAndPort>();
    private final ConcurrentMap<String, PendingRangeMaps> pendingRanges = new ConcurrentHashMap<String, PendingRangeMaps>();
    private final Set<Pair<Token, InetAddressAndPort>> movingEndpoints = new HashSet<Pair<Token, InetAddressAndPort>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private volatile ArrayList<Token> sortedTokens;
    private volatile Topology topology;
    public final IPartitioner partitioner;
    @GuardedBy(value="lock")
    private long ringVersion = 0L;
    private final AtomicReference<TokenMetadata> cachedTokenMap = new AtomicReference();

    public TokenMetadata() {
        this(SortedBiMultiValMap.create(), (BiMap<InetAddressAndPort, UUID>)HashBiMap.create(), Topology.empty(), DatabaseDescriptor.getPartitioner());
    }

    public TokenMetadata(IEndpointSnitch snitch) {
        this(SortedBiMultiValMap.create(), (BiMap<InetAddressAndPort, UUID>)HashBiMap.create(), Topology.builder(() -> snitch).build(), DatabaseDescriptor.getPartitioner());
    }

    private TokenMetadata(BiMultiValMap<Token, InetAddressAndPort> tokenToEndpointMap, BiMap<InetAddressAndPort, UUID> endpointsMap, Topology topology, IPartitioner partitioner) {
        this(tokenToEndpointMap, endpointsMap, topology, partitioner, 0L);
    }

    private TokenMetadata(BiMultiValMap<Token, InetAddressAndPort> tokenToEndpointMap, BiMap<InetAddressAndPort, UUID> endpointsMap, Topology topology, IPartitioner partitioner, long ringVersion) {
        this.tokenToEndpointMap = tokenToEndpointMap;
        this.topology = topology;
        this.partitioner = partitioner;
        this.endpointToHostIdMap = endpointsMap;
        this.sortedTokens = this.sortTokens();
        this.ringVersion = ringVersion;
    }

    @VisibleForTesting
    public TokenMetadata cloneWithNewPartitioner(IPartitioner newPartitioner) {
        return new TokenMetadata(this.tokenToEndpointMap, this.endpointToHostIdMap, this.topology, newPartitioner);
    }

    private ArrayList<Token> sortTokens() {
        return new ArrayList<Token>(this.tokenToEndpointMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pendingRangeChanges(InetAddressAndPort source) {
        int n = 0;
        Collection<Range<Token>> sourceRanges = this.getPrimaryRangesFor(this.getTokens(source));
        this.lock.readLock().lock();
        try {
            for (Token token : this.bootstrapTokens.keySet()) {
                for (Range<Token> range : sourceRanges) {
                    if (!range.contains(token)) continue;
                    ++n;
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return n;
    }

    public void updateNormalToken(Token token, InetAddressAndPort endpoint) {
        this.updateNormalTokens(Collections.singleton(token), endpoint);
    }

    public void updateNormalTokens(Collection<Token> tokens, InetAddressAndPort endpoint) {
        HashMultimap endpointTokens = HashMultimap.create();
        endpointTokens.putAll((Object)endpoint, tokens);
        this.updateNormalTokens((Multimap<InetAddressAndPort, Token>)endpointTokens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNormalTokens(Multimap<InetAddressAndPort, Token> endpointTokens) {
        if (endpointTokens.isEmpty()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            boolean shouldSortTokens = false;
            Topology.Builder topologyBuilder = this.topology.unbuild();
            for (InetAddressAndPort endpoint : endpointTokens.keySet()) {
                Collection tokens = endpointTokens.get((Object)endpoint);
                assert (tokens != null && !tokens.isEmpty());
                this.bootstrapTokens.removeValue(endpoint);
                this.tokenToEndpointMap.removeValue(endpoint);
                topologyBuilder.addEndpoint(endpoint);
                this.leavingEndpoints.remove(endpoint);
                this.replacementToOriginal.remove((Object)endpoint);
                this.removeFromMoving(endpoint);
                for (Token token : tokens) {
                    InetAddressAndPort prev = this.tokenToEndpointMap.put(token, endpoint);
                    if (endpoint.equals(prev)) continue;
                    if (prev != null) {
                        logger.warn("Token {} changing ownership from {} to {}", new Object[]{token, prev, endpoint});
                    }
                    shouldSortTokens = true;
                }
            }
            this.topology = topologyBuilder.build();
            if (shouldSortTokens) {
                this.sortedTokens = this.sortTokens();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void updateHostId(UUID hostId, InetAddressAndPort endpoint) {
        assert (hostId != null);
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.updateEndpointToHostIdMap(hostId, endpoint);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHostIds(Map<UUID, InetAddressAndPort> hostIdToEndpointMap) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<UUID, InetAddressAndPort> entry : hostIdToEndpointMap.entrySet()) {
                this.updateEndpointToHostIdMap(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void updateEndpointToHostIdMap(UUID hostId, InetAddressAndPort endpoint) {
        InetAddressAndPort storedEp = (InetAddressAndPort)this.endpointToHostIdMap.inverse().get((Object)hostId);
        if (storedEp != null && !storedEp.equals(endpoint) && FailureDetector.instance.isAlive(storedEp)) {
            throw new RuntimeException(String.format("Host ID collision between active endpoint %s and %s (id=%s)", storedEp, endpoint, hostId));
        }
        UUID storedId = (UUID)this.endpointToHostIdMap.get((Object)endpoint);
        if (storedId != null && !storedId.equals(hostId)) {
            logger.warn("Changing {}'s host ID from {} to {}", new Object[]{endpoint, storedId, hostId});
        }
        this.endpointToHostIdMap.forcePut((Object)endpoint, (Object)hostId);
    }

    public UUID getHostId(InetAddressAndPort endpoint) {
        this.lock.readLock().lock();
        try {
            UUID uUID = (UUID)this.endpointToHostIdMap.get((Object)endpoint);
            return uUID;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public InetAddressAndPort getEndpointForHostId(UUID hostId) {
        this.lock.readLock().lock();
        try {
            InetAddressAndPort inetAddressAndPort = (InetAddressAndPort)this.endpointToHostIdMap.inverse().get((Object)hostId);
            return inetAddressAndPort;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<InetAddressAndPort, UUID> getEndpointToHostIdMapForReading() {
        this.lock.readLock().lock();
        try {
            HashMap<InetAddressAndPort, UUID> readMap = new HashMap<InetAddressAndPort, UUID>();
            readMap.putAll((Map<InetAddressAndPort, UUID>)this.endpointToHostIdMap);
            HashMap<InetAddressAndPort, UUID> hashMap = readMap;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Deprecated
    public void addBootstrapToken(Token token, InetAddressAndPort endpoint) {
        this.addBootstrapTokens(Collections.singleton(token), endpoint);
    }

    public void addBootstrapTokens(Collection<Token> tokens, InetAddressAndPort endpoint) {
        this.addBootstrapTokens(tokens, endpoint, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBootstrapTokens(Collection<Token> tokens, InetAddressAndPort endpoint, InetAddressAndPort original) {
        assert (tokens != null && !tokens.isEmpty());
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            for (Token token : tokens) {
                InetAddressAndPort oldEndpoint = this.bootstrapTokens.get(token);
                if (oldEndpoint != null && !oldEndpoint.equals(endpoint)) {
                    throw new RuntimeException("Bootstrap Token collision between " + oldEndpoint + " and " + endpoint + " (token " + token);
                }
                oldEndpoint = this.tokenToEndpointMap.get(token);
                if (oldEndpoint == null || oldEndpoint.equals(endpoint) || oldEndpoint.equals(original)) continue;
                throw new RuntimeException("Bootstrap Token collision between " + oldEndpoint + " and " + endpoint + " (token " + token);
            }
            this.bootstrapTokens.removeValue(endpoint);
            for (Token token : tokens) {
                this.bootstrapTokens.put(token, endpoint);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReplaceTokens(Collection<Token> replacingTokens, InetAddressAndPort newNode, InetAddressAndPort oldNode) {
        assert (replacingTokens != null && !replacingTokens.isEmpty());
        assert (newNode != null && oldNode != null);
        this.lock.writeLock().lock();
        try {
            Collection oldNodeTokens = this.tokenToEndpointMap.inverse().get((Object)oldNode);
            if (!replacingTokens.containsAll(oldNodeTokens) || !oldNodeTokens.containsAll(replacingTokens)) {
                throw new RuntimeException(String.format("Node %s is trying to replace node %s with tokens %s with a different set of tokens %s.", newNode, oldNode, oldNodeTokens, replacingTokens));
            }
            logger.debug("Replacing {} with {}", (Object)newNode, (Object)oldNode);
            this.replacementToOriginal.put((Object)newNode, (Object)oldNode);
            this.addBootstrapTokens(replacingTokens, newNode, oldNode);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Optional<InetAddressAndPort> getReplacementNode(InetAddressAndPort endpoint) {
        this.lock.readLock().lock();
        try {
            Optional<InetAddressAndPort> optional = Optional.ofNullable((InetAddressAndPort)this.replacementToOriginal.inverse().get((Object)endpoint));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<InetAddressAndPort> getReplacingNode(InetAddressAndPort endpoint) {
        this.lock.readLock().lock();
        try {
            Optional<InetAddressAndPort> optional = Optional.ofNullable((InetAddressAndPort)this.replacementToOriginal.get((Object)endpoint));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBootstrapTokens(Collection<Token> tokens) {
        assert (tokens != null && !tokens.isEmpty());
        this.lock.writeLock().lock();
        try {
            for (Token token : tokens) {
                this.bootstrapTokens.remove(token);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addLeavingEndpoint(InetAddressAndPort endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.leavingEndpoints.add(endpoint);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addMovingEndpoint(Token token, InetAddressAndPort endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.movingEndpoints.add(Pair.create(token, endpoint));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeEndpoint(InetAddressAndPort endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.bootstrapTokens.removeValue(endpoint);
            this.topology = this.topology.unbuild().removeEndpoint(endpoint).build();
            this.leavingEndpoints.remove(endpoint);
            if (this.replacementToOriginal.remove((Object)endpoint) != null) {
                logger.debug("Node {} failed during replace.", (Object)endpoint);
            }
            this.endpointToHostIdMap.remove((Object)endpoint);
            Collection<Token> removedTokens = this.tokenToEndpointMap.removeValue(endpoint);
            if (removedTokens != null && !removedTokens.isEmpty()) {
                this.sortedTokens = this.sortTokens();
                this.invalidateCachedRingsUnsafe();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Topology updateTopology(InetAddressAndPort endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            logger.info("Updating topology for {}", (Object)endpoint);
            this.topology = this.topology.unbuild().updateEndpoint(endpoint).build();
            this.invalidateCachedRingsUnsafe();
            Topology topology = this.topology;
            return topology;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Topology updateTopology() {
        this.lock.writeLock().lock();
        try {
            logger.info("Updating topology for all endpoints that have changed");
            this.topology = this.topology.unbuild().updateEndpoints().build();
            this.invalidateCachedRingsUnsafe();
            Topology topology = this.topology;
            return topology;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromMoving(InetAddressAndPort endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            for (Pair<Token, InetAddressAndPort> pair : this.movingEndpoints) {
                if (!((InetAddressAndPort)pair.right).equals(endpoint)) continue;
                this.movingEndpoints.remove(pair);
                break;
            }
            this.invalidateCachedRingsUnsafe();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Collection<Token> getTokens(InetAddressAndPort endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            assert (this.isMember(endpoint)) : String.format("Unable to get tokens for %s; it is not a member", endpoint);
            ArrayList<Token> arrayList = new ArrayList<Token>(this.tokenToEndpointMap.inverse().get((Object)endpoint));
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Deprecated
    public Token getToken(InetAddressAndPort endpoint) {
        return this.getTokens(endpoint).iterator().next();
    }

    public boolean isMember(InetAddressAndPort endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            boolean bl = this.tokenToEndpointMap.inverse().containsKey((Object)endpoint);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isLeaving(InetAddressAndPort endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            boolean bl = this.leavingEndpoints.contains(endpoint);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMoving(InetAddressAndPort endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            for (Pair<Token, InetAddressAndPort> pair : this.movingEndpoints) {
                if (!((InetAddressAndPort)pair.right).equals(endpoint)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TokenMetadata cloneOnlyTokenMap() {
        this.lock.readLock().lock();
        try {
            TokenMetadata tokenMetadata = new TokenMetadata(SortedBiMultiValMap.create(this.tokenToEndpointMap), (BiMap<InetAddressAndPort, UUID>)HashBiMap.create(this.endpointToHostIdMap), this.topology, this.partitioner, this.ringVersion);
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenMetadata cachedOnlyTokenMap() {
        TokenMetadata tm = this.cachedTokenMap.get();
        if (tm != null) {
            return tm;
        }
        TokenMetadata tokenMetadata = this;
        synchronized (tokenMetadata) {
            tm = this.cachedTokenMap.get();
            if (tm != null) {
                return tm;
            }
            tm = this.cloneOnlyTokenMap();
            this.cachedTokenMap.set(tm);
            return tm;
        }
    }

    public TokenMetadata cloneAfterAllLeft() {
        this.lock.readLock().lock();
        try {
            TokenMetadata tokenMetadata = TokenMetadata.removeEndpoints(this.cloneOnlyTokenMap(), this.leavingEndpoints);
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static TokenMetadata removeEndpoints(TokenMetadata allLeftMetadata, Set<InetAddressAndPort> leavingEndpoints) {
        for (InetAddressAndPort endpoint : leavingEndpoints) {
            allLeftMetadata.removeEndpoint(endpoint);
        }
        return allLeftMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenMetadata cloneAfterAllSettled() {
        this.lock.readLock().lock();
        try {
            TokenMetadata metadata = this.cloneOnlyTokenMap();
            for (InetAddressAndPort inetAddressAndPort : this.leavingEndpoints) {
                metadata.removeEndpoint(inetAddressAndPort);
            }
            for (Pair pair : this.movingEndpoints) {
                metadata.updateNormalToken((Token)pair.left, (InetAddressAndPort)pair.right);
            }
            TokenMetadata tokenMetadata = metadata;
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public InetAddressAndPort getEndpoint(Token token) {
        this.lock.readLock().lock();
        try {
            InetAddressAndPort inetAddressAndPort = this.tokenToEndpointMap.get(token);
            return inetAddressAndPort;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Range<Token>> getPrimaryRangesFor(Collection<Token> tokens) {
        ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(tokens.size());
        for (Token right : tokens) {
            ranges.add(new Range<Token>(this.getPredecessor(right), right));
        }
        return ranges;
    }

    @Deprecated
    public Range<Token> getPrimaryRangeFor(Token right) {
        return this.getPrimaryRangesFor(Arrays.asList(right)).iterator().next();
    }

    public ArrayList<Token> sortedTokens() {
        return this.sortedTokens;
    }

    public EndpointsByRange getPendingRangesMM(String keyspaceName) {
        EndpointsByRange.Builder byRange = new EndpointsByRange.Builder();
        PendingRangeMaps pendingRangeMaps = (PendingRangeMaps)this.pendingRanges.get(keyspaceName);
        if (pendingRangeMaps != null) {
            for (Map.Entry<Range<Token>, EndpointsForRange.Builder> entry : pendingRangeMaps) {
                byRange.putAll(entry.getKey(), entry.getValue(), ReplicaCollection.Builder.Conflict.ALL);
            }
        }
        return byRange.build();
    }

    public PendingRangeMaps getPendingRanges(String keyspaceName) {
        return (PendingRangeMaps)this.pendingRanges.get(keyspaceName);
    }

    public RangesAtEndpoint getPendingRanges(String keyspaceName, InetAddressAndPort endpoint) {
        RangesAtEndpoint.Builder builder = RangesAtEndpoint.builder(endpoint);
        for (Map.Entry entry : this.getPendingRangesMM(keyspaceName).flattenEntries()) {
            Replica replica = entry.getValue();
            if (!replica.endpoint().equals(endpoint)) continue;
            builder.add(replica, ReplicaCollection.Builder.Conflict.DUPLICATE);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculatePendingRanges(AbstractReplicationStrategy strategy, String keyspaceName) {
        long startedAt = Clock.Global.currentTimeMillis();
        ConcurrentMap<String, PendingRangeMaps> concurrentMap = this.pendingRanges;
        synchronized (concurrentMap) {
            TokenMetadataDiagnostics.pendingRangeCalculationStarted(this, keyspaceName);
            this.unsafeCalculatePendingRanges(strategy, keyspaceName);
            if (logger.isDebugEnabled()) {
                logger.debug("Starting pending range calculation for {}", (Object)keyspaceName);
            }
            long took = Clock.Global.currentTimeMillis() - startedAt;
            if (logger.isDebugEnabled()) {
                logger.debug("Pending range calculation for {} completed (took: {}ms)", (Object)keyspaceName, (Object)took);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Calculated pending ranges for {}:\n{}", (Object)keyspaceName, (Object)(this.pendingRanges.isEmpty() ? "<empty>" : this.printPendingRanges()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsafeCalculatePendingRanges(AbstractReplicationStrategy strategy, String keyspaceName) {
        TokenMetadata metadata;
        HashSet<Pair<Token, InetAddressAndPort>> movingEndpointsClone;
        HashSet<InetAddressAndPort> leavingEndpointsClone;
        BiMultiValMap<Token, InetAddressAndPort> bootstrapTokensClone;
        this.lock.readLock().lock();
        try {
            if (this.bootstrapTokens.isEmpty() && this.leavingEndpoints.isEmpty() && this.movingEndpoints.isEmpty()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("No bootstrapping, leaving or moving nodes -> empty pending ranges for {}", (Object)keyspaceName);
                }
                if (this.bootstrapTokens.isEmpty() && this.leavingEndpoints.isEmpty() && this.movingEndpoints.isEmpty()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("No bootstrapping, leaving or moving nodes -> empty pending ranges for {}", (Object)keyspaceName);
                    }
                    this.pendingRanges.put(keyspaceName, new PendingRangeMaps());
                    return;
                }
            }
            bootstrapTokensClone = new BiMultiValMap<Token, InetAddressAndPort>(this.bootstrapTokens);
            leavingEndpointsClone = new HashSet<InetAddressAndPort>(this.leavingEndpoints);
            movingEndpointsClone = new HashSet<Pair<Token, InetAddressAndPort>>(this.movingEndpoints);
            metadata = this.cloneOnlyTokenMap();
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.pendingRanges.put(keyspaceName, TokenMetadata.calculatePendingRanges(strategy, metadata, bootstrapTokensClone, leavingEndpointsClone, movingEndpointsClone));
    }

    private static PendingRangeMaps calculatePendingRanges(AbstractReplicationStrategy strategy, TokenMetadata metadata, BiMultiValMap<Token, InetAddressAndPort> bootstrapTokens, Set<InetAddressAndPort> leavingEndpoints, Set<Pair<Token, InetAddressAndPort>> movingEndpoints) {
        PendingRangeMaps newPendingRanges = new PendingRangeMaps();
        RangesByEndpoint addressRanges = strategy.getAddressReplicas(metadata);
        TokenMetadata allLeftMetadata = TokenMetadata.removeEndpoints(metadata.cloneOnlyTokenMap(), leavingEndpoints);
        HashSet<Range<Token>> removeAffectedRanges = new HashSet<Range<Token>>();
        for (InetAddressAndPort inetAddressAndPort : leavingEndpoints) {
            removeAffectedRanges.addAll(addressRanges.get(inetAddressAndPort).ranges());
        }
        for (Range range : removeAffectedRanges) {
            EndpointsForRange endpointsForRange = strategy.calculateNaturalReplicas((Token)range.right, metadata);
            EndpointsForRange newReplicas = strategy.calculateNaturalReplicas((Token)range.right, allLeftMetadata);
            for (Replica newReplica : newReplicas) {
                if (endpointsForRange.endpoints().contains(newReplica.endpoint())) continue;
                for (Replica pendingReplica : newReplica.subtractSameReplication(addressRanges.get(newReplica.endpoint()))) {
                    newPendingRanges.addPendingRange(range, pendingReplica);
                }
            }
        }
        Multimap<InetAddressAndPort, Token> bootstrapAddresses = bootstrapTokens.inverse();
        for (InetAddressAndPort inetAddressAndPort : bootstrapAddresses.keySet()) {
            Collection tokens = bootstrapAddresses.get((Object)inetAddressAndPort);
            TokenMetadata cloned = allLeftMetadata.cloneOnlyTokenMap();
            cloned.updateNormalTokens(tokens, inetAddressAndPort);
            for (Replica replica : strategy.getAddressReplicas(cloned, inetAddressAndPort)) {
                newPendingRanges.addPendingRange(replica.range(), replica);
            }
        }
        for (Pair<Token, InetAddressAndPort> pair : movingEndpoints) {
            HashSet<Replica> moveAffectedReplicas = new HashSet<Replica>();
            InetAddressAndPort endpoint = (InetAddressAndPort)pair.right;
            for (Replica replica : strategy.getAddressReplicas(allLeftMetadata, endpoint)) {
                moveAffectedReplicas.add(replica);
            }
            allLeftMetadata.updateNormalToken((Token)pair.left, endpoint);
            for (Replica replica : strategy.getAddressReplicas(allLeftMetadata, endpoint)) {
                moveAffectedReplicas.add(replica);
            }
            for (Replica replica : moveAffectedReplicas) {
                Set<InetAddressAndPort> currentEndpoints = strategy.calculateNaturalReplicas((Token)replica.range().right, metadata).endpoints();
                Set<InetAddressAndPort> newEndpoints = strategy.calculateNaturalReplicas((Token)replica.range().right, allLeftMetadata).endpoints();
                Sets.SetView difference = Sets.difference(newEndpoints, currentEndpoints);
                for (InetAddressAndPort address : difference) {
                    RangesAtEndpoint newReplicas = strategy.getAddressReplicas(allLeftMetadata, address);
                    RangesAtEndpoint oldReplicas = strategy.getAddressReplicas(metadata, address);
                    newReplicas = (RangesAtEndpoint)newReplicas.filter(r -> !oldReplicas.contains((Replica)r));
                    for (Replica newReplica : newReplicas) {
                        for (Replica pendingReplica : newReplica.subtractSameReplication(oldReplicas)) {
                            newPendingRanges.addPendingRange(pendingReplica.range(), pendingReplica);
                        }
                    }
                }
            }
            allLeftMetadata.removeEndpoint(endpoint);
        }
        return newPendingRanges;
    }

    public Token getPredecessor(Token token) {
        ArrayList<Token> tokens = this.sortedTokens();
        int index = Collections.binarySearch(tokens, token);
        assert (index >= 0) : token + " not found in " + this.tokenToEndpointMapKeysAsStrings();
        return index == 0 ? (Token)tokens.get(tokens.size() - 1) : (Token)tokens.get(index - 1);
    }

    public Token getSuccessor(Token token) {
        ArrayList<Token> tokens = this.sortedTokens();
        int index = Collections.binarySearch(tokens, token);
        assert (index >= 0) : token + " not found in " + this.tokenToEndpointMapKeysAsStrings();
        return index == tokens.size() - 1 ? (Token)tokens.get(0) : (Token)tokens.get(index + 1);
    }

    private String tokenToEndpointMapKeysAsStrings() {
        this.lock.readLock().lock();
        try {
            String string = StringUtils.join(this.tokenToEndpointMap.keySet(), (String)", ");
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public BiMultiValMap<Token, InetAddressAndPort> getBootstrapTokens() {
        this.lock.readLock().lock();
        try {
            BiMultiValMap<Token, InetAddressAndPort> biMultiValMap = new BiMultiValMap<Token, InetAddressAndPort>(this.bootstrapTokens);
            return biMultiValMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<InetAddressAndPort> getAllEndpoints() {
        this.lock.readLock().lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.endpointToHostIdMap.keySet());
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getSizeOfAllEndpoints() {
        this.lock.readLock().lock();
        try {
            int n = this.endpointToHostIdMap.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<InetAddressAndPort> getAllMembers() {
        return this.getAllEndpoints().stream().filter(this::isMember).collect(Collectors.toSet());
    }

    public Set<InetAddressAndPort> getLeavingEndpoints() {
        this.lock.readLock().lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.leavingEndpoints);
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getSizeOfLeavingEndpoints() {
        this.lock.readLock().lock();
        try {
            int n = this.leavingEndpoints.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<Pair<Token, InetAddressAndPort>> getMovingEndpoints() {
        this.lock.readLock().lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.movingEndpoints);
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getSizeOfMovingEndpoints() {
        this.lock.readLock().lock();
        try {
            int n = this.movingEndpoints.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static int firstTokenIndex(ArrayList<Token> ring, Token start, boolean insertMin) {
        assert (ring.size() > 0);
        int i = Collections.binarySearch(ring, start);
        if (i < 0 && (i = (i + 1) * -1) >= ring.size()) {
            i = insertMin ? -1 : 0;
        }
        return i;
    }

    public static Token firstToken(ArrayList<Token> ring, Token start) {
        return ring.get(TokenMetadata.firstTokenIndex(ring, start, false));
    }

    public static Iterator<Token> ringIterator(final ArrayList<Token> ring, final Token start, boolean includeMin) {
        if (ring.isEmpty()) {
            return includeMin ? Iterators.singletonIterator((Object)start.getPartitioner().getMinimumToken()) : Collections.emptyIterator();
        }
        final boolean insertMin = includeMin && !ring.get(0).isMinimum();
        final int startIndex = TokenMetadata.firstTokenIndex(ring, start, insertMin);
        return new AbstractIterator<Token>(){
            int j;
            {
                this.j = startIndex;
            }

            protected Token computeNext() {
                Token token;
                block10: {
                    block8: {
                        Token token2;
                        block9: {
                            if (this.j < -1) {
                                return (Token)this.endOfData();
                            }
                            try {
                                if (this.j != -1) break block8;
                                token2 = start.getPartitioner().getMinimumToken();
                                ++this.j;
                                if (this.j != ring.size()) break block9;
                                int n = this.j = insertMin ? -1 : 0;
                            }
                            catch (Throwable throwable) {
                                ++this.j;
                                if (this.j == ring.size()) {
                                    int n = this.j = insertMin ? -1 : 0;
                                }
                                if (this.j == startIndex) {
                                    this.j = -2;
                                }
                                throw throwable;
                            }
                        }
                        if (this.j == startIndex) {
                            this.j = -2;
                        }
                        return token2;
                    }
                    token = (Token)ring.get(this.j);
                    ++this.j;
                    if (this.j != ring.size()) break block10;
                    int n = this.j = insertMin ? -1 : 0;
                }
                if (this.j == startIndex) {
                    this.j = -2;
                }
                return token;
            }
        };
    }

    public void clearUnsafe() {
        this.lock.writeLock().lock();
        try {
            this.tokenToEndpointMap.clear();
            this.endpointToHostIdMap.clear();
            this.bootstrapTokens.clear();
            this.leavingEndpoints.clear();
            this.pendingRanges.clear();
            this.movingEndpoints.clear();
            this.sortedTokens.clear();
            this.topology = Topology.empty();
            this.invalidateCachedRingsUnsafe();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.lock.readLock().lock();
        try {
            Multimap<InetAddressAndPort, Token> endpointToTokenMap = this.tokenToEndpointMap.inverse();
            Set eps = endpointToTokenMap.keySet();
            if (!eps.isEmpty()) {
                sb.append("Normal Tokens:");
                sb.append(CassandraRelevantProperties.LINE_SEPARATOR.getString());
                for (InetAddressAndPort inetAddressAndPort : eps) {
                    sb.append(inetAddressAndPort);
                    sb.append(':');
                    sb.append(endpointToTokenMap.get((Object)inetAddressAndPort));
                    sb.append(CassandraRelevantProperties.LINE_SEPARATOR.getString());
                }
            }
            if (!this.bootstrapTokens.isEmpty()) {
                sb.append("Bootstrapping Tokens:");
                sb.append(CassandraRelevantProperties.LINE_SEPARATOR.getString());
                for (Map.Entry entry : this.bootstrapTokens.entrySet()) {
                    sb.append(entry.getValue()).append(':').append(entry.getKey());
                    sb.append(CassandraRelevantProperties.LINE_SEPARATOR.getString());
                }
            }
            if (!this.leavingEndpoints.isEmpty()) {
                sb.append("Leaving Endpoints:");
                sb.append(CassandraRelevantProperties.LINE_SEPARATOR.getString());
                for (InetAddressAndPort inetAddressAndPort : this.leavingEndpoints) {
                    sb.append(inetAddressAndPort);
                    sb.append(CassandraRelevantProperties.LINE_SEPARATOR.getString());
                }
            }
            if (!this.pendingRanges.isEmpty()) {
                sb.append("Pending Ranges:");
                sb.append(CassandraRelevantProperties.LINE_SEPARATOR.getString());
                sb.append(this.printPendingRanges());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return sb.toString();
    }

    private String printPendingRanges() {
        StringBuilder sb = new StringBuilder();
        for (PendingRangeMaps pendingRangeMaps : this.pendingRanges.values()) {
            sb.append(pendingRangeMaps.printPendingRanges());
        }
        return sb.toString();
    }

    public EndpointsForToken pendingEndpointsForToken(Token token, String keyspaceName) {
        PendingRangeMaps pendingRangeMaps = (PendingRangeMaps)this.pendingRanges.get(keyspaceName);
        if (pendingRangeMaps == null) {
            return EndpointsForToken.empty(token);
        }
        return pendingRangeMaps.pendingEndpointsFor(token);
    }

    @Deprecated
    public EndpointsForToken getWriteEndpoints(Token token, String keyspaceName, EndpointsForToken natural) {
        EndpointsForToken pending = this.pendingEndpointsForToken(token, keyspaceName);
        return (EndpointsForToken)ReplicaLayout.forTokenWrite(Keyspace.open(keyspaceName).getReplicationStrategy(), natural, pending).all();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Multimap<InetAddressAndPort, Token> getEndpointToTokenMapForReading() {
        this.lock.readLock().lock();
        try {
            HashMultimap cloned = HashMultimap.create();
            for (Map.Entry<Token, InetAddressAndPort> entry : this.tokenToEndpointMap.entrySet()) {
                cloned.put((Object)entry.getValue(), (Object)entry.getKey());
            }
            HashMultimap hashMultimap = cloned;
            return hashMultimap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<Token, InetAddressAndPort> getNormalAndBootstrappingTokenToEndpointMap() {
        this.lock.readLock().lock();
        try {
            HashMap<Token, InetAddressAndPort> map = new HashMap<Token, InetAddressAndPort>(this.tokenToEndpointMap.size() + this.bootstrapTokens.size());
            map.putAll(this.tokenToEndpointMap);
            map.putAll(this.bootstrapTokens);
            HashMap<Token, InetAddressAndPort> hashMap = map;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public ImmutableMultimap<String, InetAddressAndPort> getDC2AllEndpoints(IEndpointSnitch snitch) {
        return Multimaps.index(this.getAllEndpoints(), snitch::getDatacenter);
    }

    public Topology getTopology() {
        assert (!DatabaseDescriptor.isDaemonInitialized() || this != StorageService.instance.getTokenMetadata());
        return this.topology;
    }

    public long getRingVersion() {
        this.lock.readLock().lock();
        try {
            long l = this.ringVersion;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void invalidateCachedRings() {
        this.lock.writeLock().lock();
        try {
            this.invalidateCachedRingsUnsafe();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void invalidateCachedRingsUnsafe() {
        ++this.ringVersion;
        this.cachedTokenMap.set(null);
    }

    public DecoratedKey decorateKey(ByteBuffer key) {
        return this.partitioner.decorateKey(key);
    }

    public static class Topology {
        private final ImmutableMultimap<String, InetAddressAndPort> dcEndpoints;
        private final ImmutableMap<String, ImmutableMultimap<String, InetAddressAndPort>> dcRacks;
        private final ImmutableMap<InetAddressAndPort, Pair<String, String>> currentLocations;
        private final Supplier<IEndpointSnitch> snitchSupplier;

        private Topology(Builder builder) {
            this.dcEndpoints = ImmutableMultimap.copyOf(builder.dcEndpoints);
            ImmutableMap.Builder dcRackBuilder = ImmutableMap.builder();
            for (Map.Entry<String, Multimap<String, InetAddressAndPort>> entry : builder.dcRacks.entrySet()) {
                dcRackBuilder.put((Object)entry.getKey(), (Object)ImmutableMultimap.copyOf(entry.getValue()));
            }
            this.dcRacks = dcRackBuilder.build();
            this.currentLocations = ImmutableMap.copyOf(builder.currentLocations);
            this.snitchSupplier = builder.snitchSupplier;
        }

        public Multimap<String, InetAddressAndPort> getDatacenterEndpoints() {
            return this.dcEndpoints;
        }

        public ImmutableMap<String, ImmutableMultimap<String, InetAddressAndPort>> getDatacenterRacks() {
            return this.dcRacks;
        }

        public Pair<String, String> getLocation(InetAddressAndPort addr) {
            return (Pair)this.currentLocations.get((Object)addr);
        }

        Builder unbuild() {
            return new Builder(this);
        }

        static Builder builder(Supplier<IEndpointSnitch> snitchSupplier) {
            return new Builder(snitchSupplier);
        }

        static Topology empty() {
            return Topology.builder(() -> DatabaseDescriptor.getEndpointSnitch()).build();
        }

        private static class Builder {
            private final Multimap<String, InetAddressAndPort> dcEndpoints;
            private final Map<String, Multimap<String, InetAddressAndPort>> dcRacks;
            private final Map<InetAddressAndPort, Pair<String, String>> currentLocations;
            private final Supplier<IEndpointSnitch> snitchSupplier;

            Builder(Supplier<IEndpointSnitch> snitchSupplier) {
                this.dcEndpoints = HashMultimap.create();
                this.dcRacks = new HashMap<String, Multimap<String, InetAddressAndPort>>();
                this.currentLocations = new HashMap<InetAddressAndPort, Pair<String, String>>();
                this.snitchSupplier = snitchSupplier;
            }

            Builder(Topology from) {
                this.dcEndpoints = HashMultimap.create(from.dcEndpoints);
                this.dcRacks = Maps.newHashMapWithExpectedSize((int)from.dcRacks.size());
                for (Map.Entry entry : from.dcRacks.entrySet()) {
                    this.dcRacks.put((String)entry.getKey(), (Multimap<String, InetAddressAndPort>)HashMultimap.create((Multimap)((Multimap)entry.getValue())));
                }
                this.currentLocations = new HashMap<InetAddressAndPort, Pair<String, String>>((Map<InetAddressAndPort, Pair<String, String>>)from.currentLocations);
                this.snitchSupplier = from.snitchSupplier;
            }

            Builder addEndpoint(InetAddressAndPort ep) {
                String dc = this.snitchSupplier.get().getDatacenter(ep);
                String rack = this.snitchSupplier.get().getRack(ep);
                Pair<String, String> current = this.currentLocations.get(ep);
                if (current != null) {
                    if (((String)current.left).equals(dc) && ((String)current.right).equals(rack)) {
                        return this;
                    }
                    this.doRemoveEndpoint(ep, current);
                }
                this.doAddEndpoint(ep, dc, rack);
                return this;
            }

            private void doAddEndpoint(InetAddressAndPort ep, String dc, String rack) {
                this.dcEndpoints.put((Object)dc, (Object)ep);
                if (!this.dcRacks.containsKey(dc)) {
                    this.dcRacks.put(dc, (Multimap<String, InetAddressAndPort>)HashMultimap.create());
                }
                this.dcRacks.get(dc).put((Object)rack, (Object)ep);
                this.currentLocations.put(ep, Pair.create(dc, rack));
            }

            Builder removeEndpoint(InetAddressAndPort ep) {
                if (!this.currentLocations.containsKey(ep)) {
                    return this;
                }
                this.doRemoveEndpoint(ep, this.currentLocations.remove(ep));
                return this;
            }

            private void doRemoveEndpoint(InetAddressAndPort ep, Pair<String, String> current) {
                this.dcRacks.get(current.left).remove(current.right, (Object)ep);
                this.dcEndpoints.remove(current.left, (Object)ep);
            }

            Builder updateEndpoint(InetAddressAndPort ep) {
                IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
                if (snitch == null || !this.currentLocations.containsKey(ep)) {
                    return this;
                }
                this.updateEndpoint(ep, snitch);
                return this;
            }

            Builder updateEndpoints() {
                IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
                if (snitch == null) {
                    return this;
                }
                for (InetAddressAndPort ep : this.currentLocations.keySet()) {
                    this.updateEndpoint(ep, snitch);
                }
                return this;
            }

            private void updateEndpoint(InetAddressAndPort ep, IEndpointSnitch snitch) {
                Pair<String, String> current = this.currentLocations.get(ep);
                String dc = snitch.getDatacenter(ep);
                String rack = snitch.getRack(ep);
                if (dc.equals(current.left) && rack.equals(current.right)) {
                    return;
                }
                this.doRemoveEndpoint(ep, current);
                this.doAddEndpoint(ep, dc, rack);
            }

            Topology build() {
                return new Topology(this);
            }
        }
    }
}

