/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathUtils {
    private static final boolean consistentDirectoryListings = CassandraRelevantProperties.CONSISTENT_DIRECTORY_LISTINGS.getBoolean();
    private static final Set<StandardOpenOption> READ_OPTIONS = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.READ));
    private static final Set<StandardOpenOption> WRITE_OPTIONS = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
    private static final Set<StandardOpenOption> WRITE_APPEND_OPTIONS = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND));
    private static final Set<StandardOpenOption> READ_WRITE_OPTIONS = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE));
    private static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];
    private static final Logger logger = LoggerFactory.getLogger(PathUtils.class);
    private static final NoSpamLogger nospam1m = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    private static Consumer<Path> onDeletion = path -> {
        if (StorageService.instance.isDaemonSetupCompleted()) {
            PathUtils.setDeletionListener(ignore -> {});
        } else {
            logger.trace("Deleting file during startup: {}", path);
        }
    };
    private static final DeleteOnExit ON_EXIT = new DeleteOnExit();

    public static FileChannel newReadChannel(Path path) throws NoSuchFileException {
        return PathUtils.newFileChannel(path, READ_OPTIONS);
    }

    public static FileChannel newReadWriteChannel(Path path) throws NoSuchFileException {
        return PathUtils.newFileChannel(path, READ_WRITE_OPTIONS);
    }

    public static FileChannel newWriteOverwriteChannel(Path path) throws NoSuchFileException {
        return PathUtils.newFileChannel(path, WRITE_OPTIONS);
    }

    public static FileChannel newWriteAppendChannel(Path path) throws NoSuchFileException {
        return PathUtils.newFileChannel(path, WRITE_APPEND_OPTIONS);
    }

    private static FileChannel newFileChannel(Path path, Set<StandardOpenOption> options) throws NoSuchFileException {
        try {
            return FileChannel.open(path, options, NO_ATTRIBUTES);
        }
        catch (IOException e) {
            throw PathUtils.propagateUncheckedOrNoSuchFileException(e, path, options.contains(StandardOpenOption.WRITE));
        }
    }

    public static void setDeletionListener(Consumer<Path> newOnDeletion) {
        onDeletion = newOnDeletion;
    }

    public static String filename(Path path) {
        return path.getFileName().toString();
    }

    public static <T> T[] list(Path path, Function<Stream<Path>, Stream<T>> transform, IntFunction<T[]> arrayFactory) {
        A[] AArray;
        block9: {
            Stream<Path> stream = Files.list(path);
            try {
                AArray = transform.apply(consistentDirectoryListings ? stream.sorted() : stream).toArray(arrayFactory);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return null;
                }
                catch (IOException e) {
                    throw PathUtils.propagateUnchecked(e, path, false);
                }
            }
            stream.close();
        }
        return AArray;
    }

    public static <T extends Throwable, V> V[] tryList(Path path, Function<Stream<Path>, Stream<V>> transform, IntFunction<V[]> arrayFactory, ThrowingFunction<IOException, V[], T> orElse) throws T {
        A[] AArray;
        block8: {
            Stream<Path> stream = Files.list(path);
            try {
                AArray = transform.apply(consistentDirectoryListings ? stream.sorted() : stream).toArray(arrayFactory);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return (Object[])orElse.apply((Object)e);
                }
            }
            stream.close();
        }
        return AArray;
    }

    public static void forEach(Path path, Consumer<Path> forEach) {
        try (Stream<Path> stream = Files.list(path);){
            (consistentDirectoryListings ? stream.sorted() : stream).forEach(forEach);
        }
        catch (IOException e) {
            throw PathUtils.propagateUnchecked(e, path, false);
        }
    }

    public static void forEachRecursive(Path path, final Consumer<Path> forEach) {
        Consumer<Path> forEachRecursive = new Consumer<Path>(){

            @Override
            public void accept(Path child) {
                forEach.accept(child);
                PathUtils.forEach(child, this);
            }
        };
        PathUtils.forEach(path, forEachRecursive);
    }

    public static long tryGetLength(Path path) {
        return PathUtils.tryOnPath(path, Files::size);
    }

    public static long tryGetLastModified(Path path) {
        return PathUtils.tryOnPath(path, p -> Files.getLastModifiedTime(p, new LinkOption[0]).toMillis());
    }

    public static boolean trySetLastModified(Path path, long lastModified) {
        try {
            Files.setLastModifiedTime(path, FileTime.fromMillis(lastModified));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean trySetReadable(Path path, boolean readable) {
        return PathUtils.trySet(path, PosixFilePermission.OWNER_READ, readable);
    }

    public static boolean trySetWritable(Path path, boolean writeable) {
        return PathUtils.trySet(path, PosixFilePermission.OWNER_WRITE, writeable);
    }

    public static boolean trySetExecutable(Path path, boolean executable) {
        return PathUtils.trySet(path, PosixFilePermission.OWNER_EXECUTE, executable);
    }

    public static boolean trySet(Path path, PosixFilePermission permission, boolean set) {
        try {
            PosixFileAttributeView view = path.getFileSystem().provider().getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            PosixFileAttributes attributes = view.readAttributes();
            Set<PosixFilePermission> permissions = attributes.permissions();
            if (set == permissions.contains((Object)permission)) {
                return true;
            }
            if (set) {
                permissions.add(permission);
            } else {
                permissions.remove((Object)permission);
            }
            view.setPermissions(permissions);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Throwable delete(Path file, Throwable accumulate) {
        try {
            PathUtils.delete(file);
        }
        catch (FSError t) {
            accumulate = Throwables.merge(accumulate, t);
        }
        return accumulate;
    }

    public static void delete(Path file) {
        try {
            Files.delete(file);
            onDeletion.accept(file);
        }
        catch (IOException e) {
            throw PathUtils.propagateUnchecked(e, file, true);
        }
    }

    public static void deleteIfExists(Path file) {
        try {
            Files.delete(file);
            onDeletion.accept(file);
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException | e instanceof NoSuchFileException) {
                return;
            }
            throw PathUtils.propagateUnchecked(e, file, true);
        }
    }

    public static boolean tryDelete(Path file) {
        try {
            Files.delete(file);
            onDeletion.accept(file);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void delete(Path file, @Nullable RateLimiter rateLimiter) {
        double throttled;
        if (rateLimiter != null && (throttled = rateLimiter.acquire()) > 0.0) {
            nospam1m.warn("Throttling file deletion: waited {} seconds to delete {}", throttled, file);
        }
        PathUtils.delete(file);
    }

    public static Throwable delete(Path file, Throwable accumulate, @Nullable RateLimiter rateLimiter) {
        try {
            PathUtils.delete(file, rateLimiter);
        }
        catch (Throwable t) {
            accumulate = Throwables.merge(accumulate, t);
        }
        return accumulate;
    }

    private static void deleteRecursiveUsingNixCommand(Path path, boolean quietly) {
        Object[] cmd = new String[]{"rm", quietly ? "-rdf" : "-rd", path.toAbsolutePath().toString()};
        try {
            String err;
            String out;
            if (!quietly && !Files.exists(path, new LinkOption[0])) {
                throw new NoSuchFileException(path.toString());
            }
            Process p = Runtime.getRuntime().exec((String[])cmd);
            int result = p.waitFor();
            try (BufferedReader outReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                 BufferedReader errReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
                out = outReader.lines().collect(Collectors.joining("\n"));
                err = errReader.lines().collect(Collectors.joining("\n"));
            }
            if (result != 0 && Files.exists(path, new LinkOption[0])) {
                logger.error("{} returned:\nstdout:\n{}\n\nstderr:\n{}", new Object[]{Arrays.toString(cmd), out, err});
                throw new IOException(String.format("%s returned non-zero exit code: %d%nstdout:%n%s%n%nstderr:%n%s", Arrays.toString(cmd), result, out, err));
            }
            onDeletion.accept(path);
        }
        catch (IOException e) {
            throw PathUtils.propagateUnchecked(e, path, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FSWriteError((Throwable)e, path);
        }
    }

    public static void deleteRecursive(Path path) {
        if (CassandraRelevantProperties.USE_NIX_RECURSIVE_DELETE.getBoolean() && path.getFileSystem() == FileSystems.getDefault()) {
            PathUtils.deleteRecursiveUsingNixCommand(path, false);
            return;
        }
        if (PathUtils.isDirectory(path)) {
            PathUtils.forEach(path, PathUtils::deleteRecursive);
        }
        PathUtils.delete(path);
    }

    public static void deleteRecursive(Path path, RateLimiter rateLimiter) {
        if (CassandraRelevantProperties.USE_NIX_RECURSIVE_DELETE.getBoolean() && path.getFileSystem() == FileSystems.getDefault()) {
            PathUtils.deleteRecursiveUsingNixCommand(path, false);
            return;
        }
        PathUtils.deleteRecursive(path, rateLimiter, p -> PathUtils.deleteRecursive(p, rateLimiter));
    }

    private static void deleteRecursive(Path path, RateLimiter rateLimiter, Consumer<Path> deleteRecursive) {
        if (PathUtils.isDirectory(path)) {
            PathUtils.forEach(path, deleteRecursive);
        }
        PathUtils.delete(path, rateLimiter);
    }

    public static synchronized void deleteRecursiveOnExit(Path dir) {
        ON_EXIT.add(dir, true);
    }

    public static synchronized void deleteOnExit(Path file) {
        ON_EXIT.add(file, false);
    }

    public static boolean tryRename(Path from, Path to) {
        logger.trace("Renaming {} to {}", (Object)from, (Object)to);
        try {
            PathUtils.atomicMoveWithFallback(from, to);
            return true;
        }
        catch (IOException e) {
            logger.trace("Could not move file {} to {}", new Object[]{from, to, e});
            return false;
        }
    }

    public static void rename(Path from, Path to) {
        logger.trace("Renaming {} to {}", (Object)from, (Object)to);
        try {
            PathUtils.atomicMoveWithFallback(from, to);
        }
        catch (IOException e) {
            logger.trace("Could not move file {} to {}", new Object[]{from, to, e});
            throw PathUtils.propagateUnchecked(String.format("Failed to rename %s to %s", from, to), e, to, true);
        }
    }

    private static void atomicMoveWithFallback(Path from, Path to) throws IOException {
        try {
            Files.move(from, to, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            logger.trace("Could not do an atomic move", (Throwable)e);
            Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean isDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public static boolean isFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    public static boolean createFileIfNotExists(Path path) {
        return PathUtils.ifNotExists(path, x$0 -> Files.createFile(x$0, new FileAttribute[0]));
    }

    public static boolean createDirectoryIfNotExists(Path path) {
        return PathUtils.ifNotExists(path, x$0 -> Files.createDirectory(x$0, new FileAttribute[0]));
    }

    public static boolean createDirectoriesIfNotExists(Path path) {
        return PathUtils.ifNotExists(path, x$0 -> Files.createDirectories(x$0, new FileAttribute[0]));
    }

    public static boolean tryCreateDirectory(Path path) {
        return PathUtils.tryConsume(path, x$0 -> Files.createDirectory(x$0, new FileAttribute[0]));
    }

    public static boolean tryCreateDirectories(Path path) {
        if (PathUtils.exists(path)) {
            return false;
        }
        PathUtils.tryCreateDirectories(path.toAbsolutePath().getParent());
        return PathUtils.tryCreateDirectory(path);
    }

    public static Path findExistingAncestor(Path file) {
        Path parent;
        if (!file.equals(file.normalize())) {
            throw new IllegalArgumentException("Must be invoked on a path without redundant elements");
        }
        for (parent = file; parent != null && !Files.exists(parent, new LinkOption[0]); parent = parent.getParent()) {
        }
        return parent;
    }

    public static Path toCanonicalPath(Path file) {
        Preconditions.checkNotNull((Object)file);
        file = file.toAbsolutePath().normalize();
        Path parent = PathUtils.findExistingAncestor(file);
        if (parent == null) {
            return file;
        }
        if (parent == file) {
            return PathUtils.toRealPath(file);
        }
        return PathUtils.toRealPath(parent).resolve(parent.relativize(file));
    }

    private static Path toRealPath(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw PathUtils.propagateUnchecked(e, path, false);
        }
    }

    public static boolean isContained(Path folder, Path file) {
        Path realFolder = PathUtils.toCanonicalPath(folder);
        Path realFile = PathUtils.toCanonicalPath(file);
        return realFile.startsWith(realFolder);
    }

    @VisibleForTesting
    public static void runOnExitThreadsAndClear() {
        DeleteOnExit.runOnExitThreadsAndClear();
    }

    public static void clearOnExitThreads() {
        DeleteOnExit.clearOnExitThreads();
    }

    private static boolean ifNotExists(Path path, IOConsumer consumer) {
        try {
            consumer.accept(path);
            return true;
        }
        catch (FileAlreadyExistsException fae) {
            return false;
        }
        catch (IOException e) {
            throw PathUtils.propagateUnchecked(e, path, true);
        }
    }

    private static boolean tryConsume(Path path, IOConsumer function) {
        try {
            function.accept(path);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static long tryOnPath(Path path, IOToLongFunction<Path> function) {
        try {
            return function.apply(path);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    private static long tryOnFileStore(Path path, IOToLongFunction<FileStore> function) {
        return PathUtils.tryOnFileStore(path, function, ignore -> {});
    }

    private static long tryOnFileStore(Path path, IOToLongFunction<FileStore> function, Consumer<IOException> orElse) {
        try {
            Path ancestor = PathUtils.findExistingAncestor(path.toAbsolutePath().normalize());
            if (ancestor == null) {
                orElse.accept(new NoSuchFileException(path.toString()));
                return 0L;
            }
            return function.apply(Files.getFileStore(ancestor));
        }
        catch (IOException e) {
            orElse.accept(e);
            return 0L;
        }
    }

    public static long tryGetSpace(Path path, IOToLongFunction<FileStore> getSpace) {
        return PathUtils.handleLargeFileSystem(PathUtils.tryOnFileStore(path, getSpace));
    }

    public static long tryGetSpace(Path path, IOToLongFunction<FileStore> getSpace, Consumer<IOException> orElse) {
        return PathUtils.handleLargeFileSystem(PathUtils.tryOnFileStore(path, getSpace, orElse));
    }

    private static long handleLargeFileSystem(long size) {
        return size < 0L ? Long.MAX_VALUE : size;
    }

    private PathUtils() {
    }

    public static RuntimeException propagateUnchecked(IOException ioe, Path path, boolean write) {
        return PathUtils.propagateUnchecked(null, ioe, path, write);
    }

    public static RuntimeException propagateUnchecked(String message, IOException ioe, Path path, boolean write) {
        if (ioe instanceof FileAlreadyExistsException || ioe instanceof NoSuchFileException || ioe instanceof AtomicMoveNotSupportedException || ioe instanceof DirectoryNotEmptyException || ioe instanceof FileSystemLoopException || ioe instanceof NotDirectoryException || ioe instanceof NotLinkException) {
            throw new UncheckedIOException(message, ioe);
        }
        if (write) {
            throw new FSWriteError(message, (Throwable)ioe, path);
        }
        throw new FSReadError(message, (Throwable)ioe, path);
    }

    public static NoSuchFileException propagateUncheckedOrNoSuchFileException(IOException ioe, Path path, boolean write) throws NoSuchFileException {
        if (ioe instanceof NoSuchFileException) {
            throw (NoSuchFileException)ioe;
        }
        throw PathUtils.propagateUnchecked(ioe, path, write);
    }

    public static <E extends IOException> E propagate(E ioe, Path path, boolean write) throws E {
        if (ioe instanceof FileAlreadyExistsException || ioe instanceof NoSuchFileException || ioe instanceof AtomicMoveNotSupportedException || ioe instanceof DirectoryNotEmptyException || ioe instanceof FileSystemLoopException || ioe instanceof NotDirectoryException || ioe instanceof NotLinkException) {
            throw ioe;
        }
        if (write) {
            throw new FSWriteError(ioe, path);
        }
        throw new FSReadError(ioe, path);
    }

    public static interface IOToLongFunction<V> {
        public long apply(V var1) throws IOException;
    }

    public static interface IOConsumer {
        public void accept(Path var1) throws IOException;
    }

    private static final class DeleteOnExit
    implements Runnable {
        private boolean isRegistered;
        private final Set<Path> deleteRecursivelyOnExit = new HashSet<Path>();
        private final Set<Path> deleteOnExit = new HashSet<Path>();
        private static List<Thread> onExitThreads = new ArrayList<Thread>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void runOnExitThreadsAndClear() {
            ArrayList<Thread> toRun;
            List<Thread> list = onExitThreads;
            synchronized (list) {
                toRun = new ArrayList<Thread>(onExitThreads);
                onExitThreads.clear();
            }
            Runtime runtime = Runtime.getRuntime();
            toRun.forEach(onExitThread -> {
                try {
                    runtime.removeShutdownHook((Thread)onExitThread);
                    onExitThread.run();
                }
                catch (Exception ex) {
                    logger.warn("Exception thrown when cleaning up files to delete on exit, continuing.", (Throwable)ex);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void clearOnExitThreads() {
            List<Thread> list = onExitThreads;
            synchronized (list) {
                Runtime runtime = Runtime.getRuntime();
                onExitThreads.forEach(runtime::removeShutdownHook);
                onExitThreads.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DeleteOnExit() {
            Thread onExitThread = new Thread(this);
            List<Thread> list = onExitThreads;
            synchronized (list) {
                onExitThreads.add(onExitThread);
            }
            Runtime.getRuntime().addShutdownHook(onExitThread);
        }

        synchronized void add(Path path, boolean recursive) {
            if (!this.isRegistered) {
                this.isRegistered = true;
            }
            logger.trace("Scheduling deferred {}deletion of file: {}", (Object)(recursive ? "recursive " : ""), (Object)path);
            (recursive ? this.deleteRecursivelyOnExit : this.deleteOnExit).add(path);
        }

        @Override
        public void run() {
            for (Path path : this.deleteOnExit) {
                try {
                    if (!PathUtils.exists(path)) continue;
                    PathUtils.delete(path);
                }
                catch (Throwable t) {
                    logger.warn("Failed to delete {} on exit", (Object)path, (Object)t);
                }
            }
            for (Path path : this.deleteRecursivelyOnExit) {
                try {
                    if (!PathUtils.exists(path)) continue;
                    PathUtils.deleteRecursive(path);
                }
                catch (Throwable t) {
                    logger.warn("Failed to delete {} on exit", (Object)path, (Object)t);
                }
            }
        }
    }
}

