/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.DataComponent;
import org.apache.cassandra.io.sstable.format.IndexComponent;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.SortedTableWriter;
import org.apache.cassandra.io.sstable.format.bti.BtiFormat;
import org.apache.cassandra.io.sstable.format.bti.BtiFormatPartitionWriter;
import org.apache.cassandra.io.sstable.format.bti.BtiTableReader;
import org.apache.cassandra.io.sstable.format.bti.PartitionIndex;
import org.apache.cassandra.io.sstable.format.bti.PartitionIndexBuilder;
import org.apache.cassandra.io.sstable.format.bti.TrieIndexEntry;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.MmappedRegionsCache;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class BtiTableWriter
extends SortedTableWriter<BtiFormatPartitionWriter> {
    private static final Logger logger = LoggerFactory.getLogger(BtiTableWriter.class);
    private final BtiFormatPartitionWriter partitionWriter;
    private final IndexWriter iwriter;

    public BtiTableWriter(Builder builder, LifecycleNewTracker lifecycleNewTracker, SSTable.Owner owner) {
        super(builder, lifecycleNewTracker, owner);
        this.iwriter = builder.getIndexWriter();
        this.partitionWriter = builder.getPartitionWriter();
    }

    @Override
    public void mark() {
        super.mark();
        this.iwriter.mark();
    }

    @Override
    public void resetAndTruncate() {
        super.resetAndTruncate();
        this.iwriter.resetAndTruncate();
    }

    @Override
    protected TrieIndexEntry createRowIndexEntry(DecoratedKey key, DeletionTime partitionLevelDeletion, long finishResult) throws IOException {
        TrieIndexEntry entry = TrieIndexEntry.create(this.partitionWriter.getInitialPosition(), finishResult, partitionLevelDeletion, this.partitionWriter.getRowIndexBlockCount());
        this.iwriter.append(key, entry);
        return entry;
    }

    private BtiTableReader openInternal(SSTableReader.OpenReason openReason, boolean isFinal, Supplier<PartitionIndex> partitionIndexSupplier) {
        IFilter filter = null;
        FileHandle dataFile = null;
        PartitionIndex partitionIndex = null;
        FileHandle rowIndexFile = null;
        BtiTableReader.Builder builder = (BtiTableReader.Builder)((BtiTableReader.Builder)((BtiTableReader.Builder)this.unbuildTo(new BtiTableReader.Builder(this.descriptor), true).setMaxDataAge(this.maxDataAge)).setSerializationHeader(this.header)).setOpenReason(openReason);
        try {
            builder.setStatsMetadata(this.statsMetadata());
            partitionIndex = partitionIndexSupplier.get();
            rowIndexFile = this.iwriter.rowIndexFHBuilder.complete();
            dataFile = this.openDataFile(isFinal ? -1L : this.dataWriter.getLastFlushOffset(), builder.getStatsMetadata());
            filter = this.iwriter.getFilterCopy();
            return (BtiTableReader)((BtiTableReader.Builder)((BtiTableReader.Builder)((BtiTableReader.Builder)((BtiTableReader.Builder)builder.setPartitionIndex(partitionIndex).setFirst(partitionIndex.firstKey())).setLast(partitionIndex.lastKey())).setRowIndexFile(rowIndexFile).setDataFile(dataFile)).setFilter(filter)).build(this.owner().orElse(null), true, true);
        }
        catch (Error | RuntimeException ex) {
            JVMStabilityInspector.inspectThrowable(ex);
            Throwables.closeNonNullAndAddSuppressed(ex, filter, dataFile, rowIndexFile, partitionIndex);
            throw ex;
        }
    }

    @Override
    public void openEarly(Consumer<SSTableReader> callWhenReady) {
        long dataLength = this.dataWriter.position();
        this.iwriter.buildPartial(dataLength, partitionIndex -> {
            this.iwriter.rowIndexFHBuilder.withLengthOverride(this.iwriter.rowIndexWriter.getLastFlushOffset());
            BtiTableReader reader = this.openInternal(SSTableReader.OpenReason.EARLY, false, () -> partitionIndex);
            callWhenReady.accept(reader);
        });
    }

    @Override
    public SSTableReader openFinalEarly() {
        this.iwriter.complete();
        this.dataWriter.sync();
        this.iwriter.rowIndexWriter.sync();
        return this.openFinal(SSTableReader.OpenReason.EARLY);
    }

    @Override
    protected SSTableReader openFinal(SSTableReader.OpenReason openReason) {
        if (this.maxDataAge < 0L) {
            this.maxDataAge = Clock.Global.currentTimeMillis();
        }
        return this.openInternal(openReason, true, this.iwriter::completedPartitionIndex);
    }

    @Override
    protected TransactionalProxy txnProxy() {
        return new TransactionalProxy(() -> FBUtilities.immutableListWithFilteredNulls(this.iwriter, this.dataWriter));
    }

    public static class Builder
    extends SortedTableWriter.Builder<BtiFormatPartitionWriter, BtiTableWriter, Builder> {
        private SequentialWriter dataWriter;
        private BtiFormatPartitionWriter partitionWriter;
        private IndexWriter indexWriter;
        private MmappedRegionsCache mmappedRegionsCache;

        public Builder(Descriptor descriptor) {
            super(descriptor);
        }

        @Override
        public MmappedRegionsCache getMmappedRegionsCache() {
            return this.ensuringInBuildInternalContext(this.mmappedRegionsCache);
        }

        @Override
        public SequentialWriter getDataWriter() {
            return this.ensuringInBuildInternalContext(this.dataWriter);
        }

        @Override
        public BtiFormatPartitionWriter getPartitionWriter() {
            return this.ensuringInBuildInternalContext(this.partitionWriter);
        }

        public IndexWriter getIndexWriter() {
            return this.ensuringInBuildInternalContext(this.indexWriter);
        }

        private <T> T ensuringInBuildInternalContext(T value) {
            Preconditions.checkState((value != null ? 1 : 0) != 0, (Object)"This getter can be used only during the lifetime of the sstable constructor. Do not use it directly.");
            return value;
        }

        @Override
        public Builder addDefaultComponents(Collection<Index.Group> indexGroups) {
            super.addDefaultComponents((Collection)indexGroups);
            this.addComponents((Collection<Component>)ImmutableSet.of((Object)BtiFormat.Components.PARTITION_INDEX, (Object)BtiFormat.Components.ROW_INDEX));
            return this;
        }

        @Override
        protected BtiTableWriter buildInternal(LifecycleNewTracker lifecycleNewTracker, SSTable.Owner owner) {
            try {
                this.mmappedRegionsCache = new MmappedRegionsCache();
                this.dataWriter = DataComponent.buildWriter(this.descriptor, this.getTableMetadataRef().getLocal(), this.getIOOptions().writerOptions, this.getMetadataCollector(), lifecycleNewTracker.opType(), this.getIOOptions().flushCompression);
                this.indexWriter = new IndexWriter(this);
                this.partitionWriter = new BtiFormatPartitionWriter(this.getSerializationHeader(), this.getTableMetadataRef().getLocal().comparator, this.dataWriter, this.indexWriter.rowIndexWriter, this.descriptor.version);
                BtiTableWriter btiTableWriter = new BtiTableWriter(this, lifecycleNewTracker, owner);
                return btiTableWriter;
            }
            catch (Error | RuntimeException ex) {
                Throwables.closeAndAddSuppressed(ex, this.partitionWriter, this.indexWriter, this.dataWriter, this.mmappedRegionsCache);
                throw ex;
            }
            finally {
                this.partitionWriter = null;
                this.indexWriter = null;
                this.dataWriter = null;
                this.mmappedRegionsCache = null;
            }
        }
    }

    static class IndexWriter
    extends SortedTableWriter.AbstractIndexWriter {
        final SequentialWriter rowIndexWriter;
        private final FileHandle.Builder rowIndexFHBuilder;
        private final SequentialWriter partitionIndexWriter;
        private final FileHandle.Builder partitionIndexFHBuilder;
        private final PartitionIndexBuilder partitionIndex;
        boolean partitionIndexCompleted = false;
        private DataPosition riMark;
        private DataPosition piMark;

        IndexWriter(Builder b) {
            super(b);
            this.rowIndexWriter = new SequentialWriter(this.descriptor.fileFor(BtiFormat.Components.ROW_INDEX), b.getIOOptions().writerOptions);
            this.rowIndexFHBuilder = IndexComponent.fileBuilder(BtiFormat.Components.ROW_INDEX, b).withMmappedRegionsCache(b.getMmappedRegionsCache());
            this.partitionIndexWriter = new SequentialWriter(this.descriptor.fileFor(BtiFormat.Components.PARTITION_INDEX), b.getIOOptions().writerOptions);
            this.partitionIndexFHBuilder = IndexComponent.fileBuilder(BtiFormat.Components.PARTITION_INDEX, b).withMmappedRegionsCache(b.getMmappedRegionsCache());
            this.partitionIndex = new PartitionIndexBuilder(this.partitionIndexWriter, this.partitionIndexFHBuilder);
            this.partitionIndexWriter.setPostFlushListener(() -> this.partitionIndex.markPartitionIndexSynced(this.partitionIndexWriter.getLastFlushOffset()));
            this.rowIndexWriter.setPostFlushListener(() -> this.partitionIndex.markRowIndexSynced(this.rowIndexWriter.getLastFlushOffset()));
            SequentialWriter dataWriter = b.getDataWriter();
            dataWriter.setPostFlushListener(() -> this.partitionIndex.markDataSynced(dataWriter.getLastFlushOffset()));
        }

        public long append(DecoratedKey key, AbstractRowIndexEntry indexEntry) throws IOException {
            long position;
            this.bf.add(key);
            if (indexEntry.isIndexed()) {
                long indexStart = this.rowIndexWriter.position();
                try {
                    ByteBufferUtil.writeWithShortLength(key.getKey(), this.rowIndexWriter);
                    ((TrieIndexEntry)indexEntry).serialize(this.rowIndexWriter, this.rowIndexWriter.position(), this.descriptor.version);
                }
                catch (IOException e) {
                    throw new FSWriteError((Throwable)e, this.rowIndexWriter.getFile());
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("wrote index entry: {} at {}", (Object)indexEntry, (Object)indexStart);
                }
                position = indexStart;
            } else {
                position = indexEntry.position ^ 0xFFFFFFFFFFFFFFFFL;
            }
            this.partitionIndex.addEntry(key, position);
            return position;
        }

        public boolean buildPartial(long dataPosition, Consumer<PartitionIndex> callWhenReady) {
            return this.partitionIndex.buildPartial(callWhenReady, this.rowIndexWriter.position(), dataPosition);
        }

        public void mark() {
            this.riMark = this.rowIndexWriter.mark();
            this.piMark = this.partitionIndexWriter.mark();
        }

        public void resetAndTruncate() {
            this.rowIndexWriter.resetAndTruncate(this.riMark);
            this.partitionIndexWriter.resetAndTruncate(this.piMark);
        }

        @Override
        protected void doPrepare() {
            this.flushBf();
            this.rowIndexWriter.prepareToCommit();
            this.rowIndexFHBuilder.withLengthOverride(this.rowIndexWriter.getLastFlushOffset());
            this.complete();
        }

        void complete() throws FSWriteError {
            if (this.partitionIndexCompleted) {
                return;
            }
            try {
                this.partitionIndex.complete();
                this.partitionIndexCompleted = true;
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.partitionIndexWriter.getFile());
            }
        }

        PartitionIndex completedPartitionIndex() {
            this.complete();
            this.rowIndexFHBuilder.withLengthOverride(0L);
            this.partitionIndexFHBuilder.withLengthOverride(0L);
            try {
                return PartitionIndex.load(this.partitionIndexFHBuilder, this.metadata.getLocal().partitioner, false);
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, this.partitionIndexWriter.getFile());
            }
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            return this.rowIndexWriter.commit(accumulate);
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            return this.rowIndexWriter.abort(accumulate);
        }

        @Override
        protected Throwable doPostCleanup(Throwable accumulate) {
            return Throwables.close(accumulate, this.bf, this.partitionIndex, this.rowIndexWriter, this.partitionIndexWriter);
        }
    }

    private class TransactionalProxy
    extends SSTableWriter.TransactionalProxy {
        public TransactionalProxy(Supplier<ImmutableList<Transactional>> transactionals) {
            super(transactionals);
        }

        @Override
        protected Throwable doPostCleanup(Throwable accumulate) {
            accumulate = Throwables.close(accumulate, BtiTableWriter.this.partitionWriter);
            accumulate = super.doPostCleanup(accumulate);
            return accumulate;
        }
    }
}

