/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.lifecycle.ILifecycleTransaction;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.DataComponent;
import org.apache.cassandra.io.sstable.format.IndexComponent;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.SortedTableWriter;
import org.apache.cassandra.io.sstable.format.big.BigFormat;
import org.apache.cassandra.io.sstable.format.big.BigFormatPartitionWriter;
import org.apache.cassandra.io.sstable.format.big.BigTableReader;
import org.apache.cassandra.io.sstable.format.big.IndexSummaryComponent;
import org.apache.cassandra.io.sstable.format.big.RowIndexEntry;
import org.apache.cassandra.io.sstable.indexsummary.IndexSummary;
import org.apache.cassandra.io.sstable.indexsummary.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.keycache.KeyCache;
import org.apache.cassandra.io.sstable.keycache.KeyCacheSupport;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.MmappedRegionsCache;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigTableWriter
extends SortedTableWriter<BigFormatPartitionWriter> {
    private static final Logger logger = LoggerFactory.getLogger(BigTableWriter.class);
    private final IndexWriter indexWriter;
    private final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
    private final Map<DecoratedKey, AbstractRowIndexEntry> cachedKeys = new HashMap<DecoratedKey, AbstractRowIndexEntry>();
    private final boolean shouldMigrateKeyCache;

    public BigTableWriter(Builder builder, LifecycleNewTracker lifecycleNewTracker, SSTable.Owner owner) {
        super(builder, lifecycleNewTracker, owner);
        Preconditions.checkNotNull((Object)builder.getRowIndexEntrySerializer());
        Preconditions.checkNotNull((Object)builder.getIndexWriter());
        this.rowIndexEntrySerializer = builder.getRowIndexEntrySerializer();
        this.indexWriter = builder.getIndexWriter();
        this.shouldMigrateKeyCache = DatabaseDescriptor.shouldMigrateKeycacheOnCompaction() && lifecycleNewTracker instanceof ILifecycleTransaction && !((ILifecycleTransaction)lifecycleNewTracker).isOffline();
    }

    @Override
    public void mark() {
        super.mark();
        this.indexWriter.mark();
    }

    @Override
    public void resetAndTruncate() {
        super.resetAndTruncate();
        this.indexWriter.resetAndTruncate();
    }

    @Override
    protected void onStartPartition(DecoratedKey key) {
        this.notifyObservers(o -> o.startPartition(key, ((BigFormatPartitionWriter)this.partitionWriter).getInitialPosition(), this.indexWriter.writer.position()));
    }

    @Override
    protected RowIndexEntry createRowIndexEntry(DecoratedKey key, DeletionTime partitionLevelDeletion, long finishResult) throws IOException {
        long indexFilePosition = (long)ByteBufferUtil.serializedSizeWithShortLength(key.getKey()) + this.indexWriter.writer.position();
        RowIndexEntry entry = RowIndexEntry.create(((BigFormatPartitionWriter)this.partitionWriter).getInitialPosition(), indexFilePosition, partitionLevelDeletion, ((BigFormatPartitionWriter)this.partitionWriter).getHeaderLength(), ((BigFormatPartitionWriter)this.partitionWriter).getColumnIndexCount(), ((BigFormatPartitionWriter)this.partitionWriter).indexInfoSerializedSize(), ((BigFormatPartitionWriter)this.partitionWriter).indexSamples(), ((BigFormatPartitionWriter)this.partitionWriter).offsets(), this.rowIndexEntrySerializer.indexInfoSerializer(), this.descriptor.version);
        this.indexWriter.append(key, entry, this.dataWriter.position(), ((BigFormatPartitionWriter)this.partitionWriter).buffer());
        if (this.shouldMigrateKeyCache) {
            for (SSTableReader reader : ((ILifecycleTransaction)this.lifecycleNewTracker).originals()) {
                if (!(reader instanceof KeyCacheSupport) || ((KeyCacheSupport)((Object)reader)).getCachedPosition(key, false) == null) continue;
                this.cachedKeys.put(key, entry);
                break;
            }
        }
        return entry;
    }

    private BigTableReader openInternal(IndexSummaryBuilder.ReadableBoundary boundary, SSTableReader.OpenReason openReason) {
        BigTableReader reader;
        assert (boundary == null || boundary.indexLength > 0L && boundary.dataLength > 0L);
        IFilter filter = null;
        IndexSummary indexSummary = null;
        FileHandle dataFile = null;
        FileHandle indexFile = null;
        BigTableReader.Builder builder = (BigTableReader.Builder)((BigTableReader.Builder)((BigTableReader.Builder)((BigTableReader.Builder)((BigTableReader.Builder)this.unbuildTo(new BigTableReader.Builder(this.descriptor), true).setMaxDataAge(this.maxDataAge)).setSerializationHeader(this.header)).setOpenReason(openReason)).setFirst(this.first)).setLast(boundary != null ? boundary.lastKey : this.last);
        try {
            builder.setStatsMetadata(this.statsMetadata());
            EstimatedHistogram partitionSizeHistogram = builder.getStatsMetadata().estimatedPartitionSize;
            if (boundary != null && partitionSizeHistogram.isOverflowed()) {
                logger.warn("Estimated partition size histogram for '{}' is overflowed ({} values greater than {}). Clearing the overflow bucket to allow for degraded mean and percentile calculations...", new Object[]{this.descriptor, partitionSizeHistogram.overflowCount(), partitionSizeHistogram.getLargestBucketOffset()});
                partitionSizeHistogram.clearOverflow();
            }
            filter = this.indexWriter.getFilterCopy();
            builder.setFilter(filter);
            indexSummary = this.indexWriter.summary.build(this.metadata().partitioner, boundary);
            builder.setIndexSummary(indexSummary);
            long indexFileLength = this.descriptor.fileFor(BigFormat.Components.PRIMARY_INDEX).length();
            int indexBufferSize = this.ioOptions.diskOptimizationStrategy.bufferSize(indexFileLength / (long)builder.getIndexSummary().size());
            FileHandle.Builder indexFileBuilder = this.indexWriter.builder;
            indexFile = indexFileBuilder.bufferSize(indexBufferSize).withLengthOverride(boundary != null ? boundary.indexLength : -1L).complete();
            builder.setIndexFile(indexFile);
            dataFile = this.openDataFile(boundary != null ? boundary.dataLength : -1L, builder.getStatsMetadata());
            builder.setDataFile(dataFile);
            builder.setKeyCache(this.metadata().params.caching.cacheKeys() ? new KeyCache(CacheService.instance.keyCache) : KeyCache.NO_CACHE);
            reader = (BigTableReader)builder.build(this.owner().orElse(null), true, true);
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
            Throwables.closeNonNullAndAddSuppressed(t, dataFile, indexFile, indexSummary, filter);
            throw t;
        }
        try {
            for (Map.Entry<DecoratedKey, AbstractRowIndexEntry> cachedKey : this.cachedKeys.entrySet()) {
                reader.cacheKey(cachedKey.getKey(), cachedKey.getValue());
            }
            this.cachedKeys.clear();
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
        }
        return reader;
    }

    @Override
    public void openEarly(Consumer<SSTableReader> doWhenReady) {
        IndexSummaryBuilder.ReadableBoundary boundary = this.indexWriter.getMaxReadable();
        if (boundary == null) {
            return;
        }
        doWhenReady.accept(this.openInternal(boundary, SSTableReader.OpenReason.EARLY));
    }

    @Override
    public SSTableReader openFinalEarly() {
        this.dataWriter.sync();
        this.indexWriter.writer.sync();
        return this.openFinal(SSTableReader.OpenReason.EARLY);
    }

    @Override
    public SSTableReader openFinal(SSTableReader.OpenReason openReason) {
        if (this.maxDataAge < 0L) {
            this.maxDataAge = Clock.Global.currentTimeMillis();
        }
        return this.openInternal(null, openReason);
    }

    @Override
    protected SSTableWriter.TransactionalProxy txnProxy() {
        return new SSTableWriter.TransactionalProxy(() -> FBUtilities.immutableListWithFilteredNulls(this.indexWriter, this.dataWriter));
    }

    public static class Builder
    extends SortedTableWriter.Builder<BigFormatPartitionWriter, BigTableWriter, Builder> {
        private RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
        private IndexWriter indexWriter;
        private SequentialWriter dataWriter;
        private BigFormatPartitionWriter partitionWriter;
        private MmappedRegionsCache mmappedRegionsCache;

        public Builder(Descriptor descriptor) {
            super(descriptor);
        }

        @Override
        public Builder addDefaultComponents(Collection<Index.Group> indexGroups) {
            super.addDefaultComponents((Collection)indexGroups);
            this.addComponents((Collection<Component>)ImmutableSet.of((Object)BigFormat.Components.PRIMARY_INDEX, (Object)BigFormat.Components.SUMMARY));
            return this;
        }

        @Override
        public MmappedRegionsCache getMmappedRegionsCache() {
            return this.ensuringInBuildInternalContext(this.mmappedRegionsCache);
        }

        @Override
        public SequentialWriter getDataWriter() {
            return this.ensuringInBuildInternalContext(this.dataWriter);
        }

        @Override
        public BigFormatPartitionWriter getPartitionWriter() {
            return this.ensuringInBuildInternalContext(this.partitionWriter);
        }

        public RowIndexEntry.IndexSerializer getRowIndexEntrySerializer() {
            return this.ensuringInBuildInternalContext(this.rowIndexEntrySerializer);
        }

        public IndexWriter getIndexWriter() {
            return this.ensuringInBuildInternalContext(this.indexWriter);
        }

        private <T> T ensuringInBuildInternalContext(T value) {
            Preconditions.checkState((value != null ? 1 : 0) != 0, (Object)"This getter can be used only during the lifetime of the sstable constructor. Do not use it directly.");
            return value;
        }

        @Override
        protected BigTableWriter buildInternal(LifecycleNewTracker lifecycleNewTracker, SSTable.Owner owner) {
            try {
                this.mmappedRegionsCache = new MmappedRegionsCache();
                this.rowIndexEntrySerializer = new RowIndexEntry.Serializer(this.descriptor.version, this.getSerializationHeader(), owner != null ? owner.getMetrics() : null);
                this.dataWriter = DataComponent.buildWriter(this.descriptor, this.getTableMetadataRef().getLocal(), this.getIOOptions().writerOptions, this.getMetadataCollector(), lifecycleNewTracker.opType(), this.getIOOptions().flushCompression);
                this.indexWriter = new IndexWriter(this);
                this.partitionWriter = new BigFormatPartitionWriter(this.getSerializationHeader(), this.dataWriter, this.descriptor.version, this.rowIndexEntrySerializer.indexInfoSerializer());
                BigTableWriter bigTableWriter = new BigTableWriter(this, lifecycleNewTracker, owner);
                return bigTableWriter;
            }
            catch (Error | RuntimeException ex) {
                Throwables.closeAndAddSuppressed(ex, this.partitionWriter, this.indexWriter, this.dataWriter, this.mmappedRegionsCache);
                throw ex;
            }
            finally {
                this.rowIndexEntrySerializer = null;
                this.indexWriter = null;
                this.dataWriter = null;
                this.partitionWriter = null;
                this.mmappedRegionsCache = null;
            }
        }
    }

    static class IndexWriter
    extends SortedTableWriter.AbstractIndexWriter {
        private final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
        final SequentialWriter writer;
        final FileHandle.Builder builder;
        final IndexSummaryBuilder summary;
        private DataPosition mark;
        private DecoratedKey first;
        private DecoratedKey last;

        protected IndexWriter(Builder b) {
            super(b);
            this.rowIndexEntrySerializer = b.getRowIndexEntrySerializer();
            this.writer = new SequentialWriter(b.descriptor.fileFor(BigFormat.Components.PRIMARY_INDEX), b.getIOOptions().writerOptions);
            this.builder = IndexComponent.fileBuilder(BigFormat.Components.PRIMARY_INDEX, b).withMmappedRegionsCache(b.getMmappedRegionsCache());
            this.summary = new IndexSummaryBuilder(b.getKeyCount(), b.getTableMetadataRef().getLocal().params.minIndexInterval, 128);
            this.writer.setPostFlushListener(() -> this.summary.markIndexSynced(this.writer.getLastFlushOffset()));
            SequentialWriter dataWriter = b.getDataWriter();
            dataWriter.setPostFlushListener(() -> this.summary.markDataSynced(dataWriter.getLastFlushOffset()));
        }

        IndexSummaryBuilder.ReadableBoundary getMaxReadable() {
            return this.summary.getLastReadableBoundary();
        }

        public void append(DecoratedKey key, RowIndexEntry indexEntry, long dataEnd, ByteBuffer indexInfo) throws IOException {
            this.bf.add(key);
            if (this.first == null) {
                this.first = key;
            }
            this.last = key;
            long indexStart = this.writer.position();
            try {
                ByteBufferUtil.writeWithShortLength(key.getKey(), this.writer);
                this.rowIndexEntrySerializer.serialize(indexEntry, this.writer, indexInfo);
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.writer.getPath());
            }
            long indexEnd = this.writer.position();
            if (logger.isTraceEnabled()) {
                logger.trace("wrote index entry: {} at {}", (Object)indexEntry, (Object)indexStart);
            }
            this.summary.maybeAddEntry(key, indexStart, indexEnd, dataEnd);
        }

        public void mark() {
            this.mark = this.writer.mark();
        }

        public void resetAndTruncate() {
            this.writer.resetAndTruncate(this.mark);
        }

        @Override
        protected void doPrepare() {
            Preconditions.checkNotNull((Object)this.first);
            Preconditions.checkNotNull((Object)this.last);
            super.doPrepare();
            long position = this.writer.position();
            this.writer.prepareToCommit();
            FileUtils.truncate(this.writer.getPath(), position);
            this.summary.prepareToCommit();
            try (IndexSummary indexSummary = this.summary.build(this.metadata.getLocal().partitioner);){
                new IndexSummaryComponent(indexSummary, this.first, this.last).save(this.descriptor.fileFor(BigFormat.Components.SUMMARY), true);
            }
            catch (IOException ex) {
                logger.warn("Failed to save index summary", (Throwable)ex);
            }
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            return this.writer.commit(accumulate);
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            return this.summary.close(this.writer.abort(accumulate));
        }

        @Override
        protected Throwable doPostCleanup(Throwable accumulate) {
            accumulate = super.doPostCleanup(accumulate);
            accumulate = this.summary.close(accumulate);
            return accumulate;
        }
    }
}

