/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.cassandra.io.sstable.format.SSTableFormat;

public abstract class Version {
    private static final Pattern VALIDATION = Pattern.compile("[a-z]+");
    public final String version;
    public final SSTableFormat<?, ?> format;

    protected Version(SSTableFormat format, String version) {
        this.format = Objects.requireNonNull(format);
        this.version = Objects.requireNonNull(version);
    }

    public abstract boolean isLatestVersion();

    public abstract int correspondingMessagingVersion();

    public abstract boolean hasCommitLogLowerBound();

    public abstract boolean hasCommitLogIntervals();

    public abstract boolean hasMaxCompressedLength();

    public abstract boolean hasPendingRepair();

    public abstract boolean hasIsTransient();

    public abstract boolean hasMetadataChecksum();

    public abstract boolean hasUIntDeletionTime();

    public abstract boolean hasOldBfFormat();

    @Deprecated
    public abstract boolean hasAccurateMinMax();

    @Deprecated
    public abstract boolean hasLegacyMinMax();

    public abstract boolean hasOriginatingHostId();

    public abstract boolean hasImprovedMinMax();

    public abstract boolean hasTokenSpaceCoverage();

    public abstract boolean hasPartitionLevelDeletionsPresenceMarker();

    public abstract boolean hasKeyRange();

    public static boolean validate(String ver) {
        return ver != null && VALIDATION.matcher(ver).matches();
    }

    public abstract boolean isCompatible();

    public abstract boolean isCompatibleForStreaming();

    public String toString() {
        return this.version;
    }

    public String toFormatAndVersionString() {
        return this.format.name() + "-" + this.version;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Version otherVersion = (Version)other;
        return Objects.equals(this.version, otherVersion.version) && Objects.equals(this.format.name(), otherVersion.format.name());
    }

    public int hashCode() {
        return Objects.hash(this.version, this.format.name());
    }
}

