/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.Collection;
import java.util.Collections;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.commitlog.IntervalSet;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.TimeUUID;

public class SimpleSSTableMultiWriter
implements SSTableMultiWriter {
    private final SSTableWriter writer;
    private final LifecycleNewTracker lifecycleNewTracker;

    protected SimpleSSTableMultiWriter(SSTableWriter writer, LifecycleNewTracker lifecycleNewTracker) {
        this.lifecycleNewTracker = lifecycleNewTracker;
        this.writer = writer;
    }

    @Override
    public void append(UnfilteredRowIterator partition) {
        this.writer.append(partition);
    }

    @Override
    public Collection<SSTableReader> finish(boolean openResult) {
        return Collections.singleton(this.writer.finish(openResult));
    }

    @Override
    public Collection<SSTableReader> finished() {
        return Collections.singleton(this.writer.finished());
    }

    @Override
    public SSTableMultiWriter setOpenResult(boolean openResult) {
        this.writer.setOpenResult(openResult);
        return this;
    }

    @Override
    public String getFilename() {
        return this.writer.getFilename();
    }

    @Override
    public long getBytesWritten() {
        return this.writer.getFilePointer();
    }

    @Override
    public long getOnDiskBytesWritten() {
        return this.writer.getEstimatedOnDiskBytesWritten();
    }

    @Override
    public TableId getTableId() {
        return this.writer.metadata().id;
    }

    @Override
    public Throwable commit(Throwable accumulate) {
        return this.writer.commit(accumulate);
    }

    @Override
    public Throwable abort(Throwable accumulate) {
        this.lifecycleNewTracker.untrackNew(this.writer);
        return this.writer.abort(accumulate);
    }

    @Override
    public void prepareToCommit() {
        this.writer.prepareToCommit();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    public static SSTableMultiWriter create(Descriptor descriptor, long keyCount, long repairedAt, TimeUUID pendingRepair, boolean isTransient, TableMetadataRef metadata, IntervalSet<CommitLogPosition> commitLogPositions, int sstableLevel, SerializationHeader header, Collection<Index.Group> indexGroups, LifecycleNewTracker lifecycleNewTracker, SSTable.Owner owner) {
        MetadataCollector metadataCollector = new MetadataCollector(metadata.get().comparator).commitLogIntervals(commitLogPositions != null ? commitLogPositions : IntervalSet.empty()).sstableLevel(sstableLevel);
        Object writer = ((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTable.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)descriptor.getFormat().getWriterFactory().builder(descriptor)).setKeyCount(keyCount)).setRepairedAt(repairedAt)).setPendingRepair(pendingRepair)).setTransientSSTable(isTransient)).setTableMetadataRef(metadata)).setMetadataCollector(metadataCollector)).setSerializationHeader(header)).addDefaultComponents(indexGroups)).addFlushObserversForSecondaryIndexes(indexGroups, lifecycleNewTracker, metadata.get())).build(lifecycleNewTracker, owner);
        return new SimpleSSTableMultiWriter((SSTableWriter)writer, lifecycleNewTracker);
    }
}

