/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Throwables;
import java.io.IOException;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableTxnWriter;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.schema.TableMetadataRef;

class SSTableSimpleWriter
extends AbstractSSTableSimpleWriter {
    protected DecoratedKey currentKey;
    protected PartitionUpdate.Builder update;
    private SSTableTxnWriter writer;

    protected SSTableSimpleWriter(File directory, TableMetadataRef metadata, RegularAndStaticColumns columns) {
        super(directory, metadata, columns);
    }

    private SSTableTxnWriter getOrCreateWriter() throws IOException {
        if (this.writer == null) {
            this.writer = this.createWriter(null);
        }
        return this.writer;
    }

    @Override
    PartitionUpdate.Builder getUpdateFor(DecoratedKey key) throws IOException {
        assert (key != null);
        if (!key.equals(this.currentKey)) {
            if (this.update != null) {
                this.writePartition(this.update.build());
            }
            this.currentKey = key;
            this.update = new PartitionUpdate.Builder(this.metadata.get(), this.currentKey, this.columns, 4);
        }
        assert (this.update != null);
        return this.update;
    }

    @Override
    public void close() {
        try {
            if (this.update != null) {
                this.writePartition(this.update.build());
            }
            if (this.writer != null) {
                this.writer.finish(false);
            }
        }
        catch (Throwable t) {
            Throwable e = this.writer == null ? t : this.writer.abort(t);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void writePartition(PartitionUpdate update) throws IOException {
        this.getOrCreateWriter().append(update.unfilteredIterator());
    }
}

