/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi;

import com.googlecode.concurrenttrees.common.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.statements.schema.IndexTarget;
import org.apache.cassandra.db.CassandraWriteContext;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.index.TargetParser;
import org.apache.cassandra.index.sasi.SASIIndexBuilder;
import org.apache.cassandra.index.sasi.SASIIndexGroup;
import org.apache.cassandra.index.sasi.conf.ColumnIndex;
import org.apache.cassandra.index.sasi.conf.IndexMode;
import org.apache.cassandra.index.sasi.disk.OnDiskIndexBuilder;
import org.apache.cassandra.index.sasi.disk.PerSSTableIndexWriter;
import org.apache.cassandra.index.sasi.plan.SASIIndexSearcher;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.MemtableDiscardedNotification;
import org.apache.cassandra.notifications.MemtableRenewedNotification;
import org.apache.cassandra.notifications.MemtableSwitchedNotification;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableListChangedNotification;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class SASIIndex
implements Index,
INotificationConsumer {
    public static final String USAGE_WARNING = "SASI indexes are experimental and are not recommended for production use.";
    private static final SASIIndexBuildingSupport INDEX_BUILDER_SUPPORT = new SASIIndexBuildingSupport();
    private final ColumnFamilyStore baseCfs;
    private final IndexMetadata config;
    private final ColumnIndex index;

    public SASIIndex(ColumnFamilyStore baseCfs, IndexMetadata config) {
        this.baseCfs = baseCfs;
        this.config = config;
        ColumnMetadata column = (ColumnMetadata)TargetParser.parse((TableMetadata)baseCfs.metadata(), (IndexMetadata)config).left;
        this.index = new ColumnIndex(baseCfs.metadata().partitionKeyType, column, config);
        Tracker tracker = baseCfs.getTracker();
        tracker.subscribe(this);
        TreeMap<SSTableReader, Map<ColumnMetadata, ColumnIndex>> toRebuild = new TreeMap<SSTableReader, Map<ColumnMetadata, ColumnIndex>>(SSTableReader.idComparator);
        for (SSTableReader sstable : this.index.init(tracker.getView().liveSSTables())) {
            HashMap<ColumnMetadata, ColumnIndex> perSSTable = (HashMap<ColumnMetadata, ColumnIndex>)toRebuild.get(sstable);
            if (perSSTable == null) {
                perSSTable = new HashMap<ColumnMetadata, ColumnIndex>();
                toRebuild.put(sstable, perSSTable);
            }
            perSSTable.put(this.index.getDefinition(), this.index);
        }
        CompactionManager.instance.submitIndexBuild(new SASIIndexBuilder(baseCfs, toRebuild));
    }

    public static Map<String, String> validateOptions(Map<String, String> options, TableMetadata metadata) {
        if (!(metadata.partitioner instanceof Murmur3Partitioner)) {
            throw new ConfigurationException("SASI only supports Murmur3Partitioner.");
        }
        String targetColumn = options.get("target");
        if (targetColumn == null) {
            throw new ConfigurationException("unknown target column");
        }
        Pair<ColumnMetadata, IndexTarget.Type> target = TargetParser.parse(metadata, targetColumn);
        if (target == null) {
            throw new ConfigurationException("failed to retrieve target column for: " + targetColumn);
        }
        if (((ColumnMetadata)target.left).isComplex()) {
            throw new ConfigurationException("complex columns are not yet supported by SASI");
        }
        if (((ColumnMetadata)target.left).isPartitionKey()) {
            throw new ConfigurationException("partition key columns are not yet supported by SASI");
        }
        IndexMode.validateAnalyzer(options, (ColumnMetadata)target.left);
        IndexMode mode = IndexMode.getMode((ColumnMetadata)target.left, options);
        if (mode.mode == OnDiskIndexBuilder.Mode.SPARSE) {
            if (mode.isLiteral) {
                throw new ConfigurationException("SPARSE mode is only supported on non-literal columns.");
            }
            if (mode.isAnalyzed) {
                throw new ConfigurationException("SPARSE mode doesn't support analyzers.");
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public void register(IndexRegistry registry) {
        registry.registerIndex(this, this, () -> new SASIIndexGroup(this));
    }

    @Override
    public IndexMetadata getIndexMetadata() {
        return this.config;
    }

    @Override
    public Callable<?> getInitializationTask() {
        return null;
    }

    @Override
    public Callable<?> getMetadataReloadTask(IndexMetadata indexMetadata) {
        return null;
    }

    @Override
    public Callable<?> getBlockingFlushTask() {
        return null;
    }

    @Override
    public Callable<?> getInvalidateTask() {
        return this.getTruncateTask(FBUtilities.timestampMicros());
    }

    @Override
    public Callable<?> getTruncateTask(long truncatedAt) {
        return () -> {
            this.index.dropData(truncatedAt);
            return null;
        };
    }

    @Override
    public boolean shouldBuildBlocking() {
        return true;
    }

    @Override
    public Optional<ColumnFamilyStore> getBackingTable() {
        return Optional.empty();
    }

    public boolean indexes(RegularAndStaticColumns columns) {
        return columns.contains(this.index.getDefinition());
    }

    @Override
    public boolean dependsOn(ColumnMetadata column) {
        return this.index.getDefinition().compareTo(column) == 0;
    }

    @Override
    public boolean supportsExpression(ColumnMetadata column, Operator operator) {
        return this.dependsOn(column) && this.index.supports(operator);
    }

    @Override
    public AbstractType<?> customExpressionValueType() {
        return null;
    }

    @Override
    public RowFilter getPostIndexQueryFilter(RowFilter filter) {
        return filter.withoutExpressions();
    }

    @Override
    public long getEstimatedResultRows() {
        return Long.MIN_VALUE;
    }

    @Override
    public void validate(PartitionUpdate update) throws InvalidRequestException {
    }

    @Override
    public Index.Indexer indexerFor(final DecoratedKey key, RegularAndStaticColumns columns, long nowInSec, final WriteContext context, final IndexTransaction.Type transactionType, Memtable memtable) {
        return new Index.Indexer(){

            @Override
            public void begin() {
            }

            @Override
            public void partitionDelete(DeletionTime deletionTime) {
            }

            @Override
            public void rangeTombstone(RangeTombstone tombstone) {
            }

            @Override
            public void insertRow(Row row) {
                if (this.isNewData()) {
                    this.adjustMemtableSize(SASIIndex.this.index.index(key, row), CassandraWriteContext.fromContext(context).getGroup());
                }
            }

            @Override
            public void updateRow(Row oldRow, Row newRow) {
                this.insertRow(newRow);
            }

            @Override
            public void removeRow(Row row) {
            }

            @Override
            public void finish() {
            }

            private boolean isNewData() {
                return transactionType == IndexTransaction.Type.UPDATE;
            }

            public void adjustMemtableSize(long additionalSpace, OpOrder.Group opGroup) {
                SASIIndex.this.baseCfs.getTracker().getView().getCurrentMemtable().markExtraOnHeapUsed(additionalSpace, opGroup);
            }
        };
    }

    @Override
    public Index.Searcher searcherFor(ReadCommand command) throws InvalidRequestException {
        TableMetadata config = command.metadata();
        ColumnFamilyStore cfs = Schema.instance.getColumnFamilyStoreInstance(config.id);
        return new SASIIndexSearcher(cfs, command, DatabaseDescriptor.getRangeRpcTimeout(TimeUnit.MILLISECONDS));
    }

    @Override
    public SSTableFlushObserver getFlushObserver(Descriptor descriptor, LifecycleNewTracker tracker) {
        return SASIIndex.newWriter(this.baseCfs.metadata().partitionKeyType, descriptor, Collections.singletonMap(this.index.getDefinition(), this.index), tracker.opType());
    }

    @Override
    public Index.IndexBuildingSupport getBuildTaskSupport() {
        return INDEX_BUILDER_SUPPORT;
    }

    @Override
    public void handleNotification(INotification notification, Object sender) {
        if (notification instanceof SSTableAddedNotification) {
            SSTableAddedNotification notice = (SSTableAddedNotification)notification;
            this.index.update(Collections.emptyList(), Iterables.toList(notice.added));
        } else if (notification instanceof SSTableListChangedNotification) {
            SSTableListChangedNotification notice = (SSTableListChangedNotification)notification;
            this.index.update(notice.removed, notice.added);
        } else if (notification instanceof MemtableRenewedNotification) {
            this.index.switchMemtable();
        } else if (notification instanceof MemtableSwitchedNotification) {
            this.index.switchMemtable(((MemtableSwitchedNotification)notification).memtable);
        } else if (notification instanceof MemtableDiscardedNotification) {
            this.index.discardMemtable(((MemtableDiscardedNotification)notification).memtable);
        }
    }

    public ColumnIndex getIndex() {
        return this.index;
    }

    protected static PerSSTableIndexWriter newWriter(AbstractType<?> keyValidator, Descriptor descriptor, Map<ColumnMetadata, ColumnIndex> indexes, OperationType opType) {
        return new PerSSTableIndexWriter(keyValidator, descriptor, opType, indexes);
    }

    private static class SASIIndexBuildingSupport
    implements Index.IndexBuildingSupport {
        private SASIIndexBuildingSupport() {
        }

        @Override
        public SecondaryIndexBuilder getIndexBuildTask(ColumnFamilyStore cfs, Set<Index> indexes, Collection<SSTableReader> sstablesToRebuild, boolean isFullRebuild) {
            TreeMap<SSTableReader, Map<ColumnMetadata, ColumnIndex>> sstables = new TreeMap<SSTableReader, Map<ColumnMetadata, ColumnIndex>>(SSTableReader.idComparator);
            indexes.stream().filter(i -> i instanceof SASIIndex).forEach(i -> {
                SASIIndex sasi = (SASIIndex)i;
                sasi.index.dropData(sstablesToRebuild);
                sstablesToRebuild.stream().filter(sstable -> !sasi.index.hasSSTable((SSTableReader)sstable)).forEach(sstable -> {
                    HashMap<ColumnMetadata, ColumnIndex> toBuild = (HashMap<ColumnMetadata, ColumnIndex>)sstables.get(sstable);
                    if (toBuild == null) {
                        toBuild = new HashMap<ColumnMetadata, ColumnIndex>();
                        sstables.put((SSTableReader)sstable, (Map<ColumnMetadata, ColumnIndex>)toBuild);
                    }
                    toBuild.put(sasi.index.getDefinition(), sasi.index);
                });
            });
            return new SASIIndexBuilder(cfs, sstables);
        }
    }
}

