/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.cassandra.cql3.statements.schema.IndexTarget;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.StringType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FastByteOperations;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;

public class TypeUtil {
    private static final byte[] IPV4_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    public static final int DECIMAL_APPROXIMATION_BYTES = 24;
    public static final int BIG_INTEGER_APPROXIMATION_BYTES = 20;
    public static final int INET_ADDRESS_SIZE = 16;
    public static final int DEFAULT_FIXED_LENGTH = 16;

    private TypeUtil() {
    }

    public static boolean isValid(ByteBuffer term, AbstractType<?> validator) {
        try {
            validator.validate(term);
            return true;
        }
        catch (MarshalException e) {
            return false;
        }
    }

    public static boolean supportsRounding(AbstractType<?> type) {
        return TypeUtil.isBigInteger(type) || TypeUtil.isBigDecimal(type);
    }

    public static ByteBuffer min(ByteBuffer a, ByteBuffer b, AbstractType<?> type) {
        return a == null ? b : (b == null || TypeUtil.compare(b, a, type) > 0 ? a : b);
    }

    public static ByteBuffer max(ByteBuffer a, ByteBuffer b, AbstractType<?> type) {
        return a == null ? b : (b == null || TypeUtil.compare(b, a, type) < 0 ? a : b);
    }

    public static ByteComparable min(ByteComparable a, ByteComparable b) {
        return a == null ? b : (b == null || ByteComparable.compare(b, a, ByteComparable.Version.OSS50) > 0 ? a : b);
    }

    public static ByteComparable max(ByteComparable a, ByteComparable b) {
        return a == null ? b : (b == null || ByteComparable.compare(b, a, ByteComparable.Version.OSS50) < 0 ? a : b);
    }

    public static int fixedSizeOf(AbstractType<?> type) {
        if (type.isValueLengthFixed()) {
            return type.valueLengthIfFixed();
        }
        if (TypeUtil.isInetAddress(type)) {
            return 16;
        }
        if (TypeUtil.isBigInteger(type)) {
            return 20;
        }
        if (TypeUtil.isBigDecimal(type)) {
            return 24;
        }
        return 16;
    }

    public static AbstractType<?> cellValueType(ColumnMetadata columnMetadata, IndexTarget.Type indexType) {
        AbstractType type = columnMetadata.type;
        if (TypeUtil.isNonFrozenCollection(type)) {
            CollectionType collection = (CollectionType)type;
            switch (collection.kind) {
                case LIST: {
                    return collection.valueComparator();
                }
                case SET: {
                    return collection.nameComparator();
                }
                case MAP: {
                    switch (indexType) {
                        case KEYS: {
                            return collection.nameComparator();
                        }
                        case VALUES: {
                            return collection.valueComparator();
                        }
                        case KEYS_AND_VALUES: {
                            return CompositeType.getInstance(collection.nameComparator(), collection.valueComparator());
                        }
                    }
                }
            }
        }
        return type;
    }

    public static String getString(ByteBuffer value, AbstractType<?> type) {
        if (TypeUtil.isComposite(type)) {
            return ByteBufferUtil.bytesToHex(value);
        }
        return type.getString(value);
    }

    public static ByteBuffer fromString(String value, AbstractType<?> type) {
        if (TypeUtil.isComposite(type)) {
            return ByteBufferUtil.hexToBytes(value);
        }
        return type.fromString(value);
    }

    public static ByteSource asComparableBytes(ByteBuffer value, AbstractType<?> type, ByteComparable.Version version) {
        if (type instanceof InetAddressType || type instanceof IntegerType || type instanceof DecimalType) {
            return ByteSource.optionalFixedLength(ByteBufferAccessor.instance, value);
        }
        if (type instanceof LongType) {
            return ByteSource.optionalSignedFixedLengthNumber(ByteBufferAccessor.instance, value);
        }
        return type.asComparableBytes(value, version);
    }

    public static void toComparableBytes(ByteBuffer value, AbstractType<?> type, byte[] bytes) {
        if (TypeUtil.isInetAddress(type)) {
            ByteBufferUtil.copyBytes(value, value.hasArray() ? value.arrayOffset() + value.position() : value.position(), bytes, 0, 16);
        } else if (TypeUtil.isBigInteger(type)) {
            ByteBufferUtil.copyBytes(value, value.hasArray() ? value.arrayOffset() + value.position() : value.position(), bytes, 0, 20);
        } else if (TypeUtil.isBigDecimal(type)) {
            ByteBufferUtil.copyBytes(value, value.hasArray() ? value.arrayOffset() + value.position() : value.position(), bytes, 0, 24);
        } else {
            ByteSourceInverse.copyBytes(TypeUtil.asComparableBytes(value, type, ByteComparable.Version.OSS50), bytes);
        }
    }

    public static ByteBuffer asIndexBytes(ByteBuffer value, AbstractType<?> type) {
        if (value == null) {
            return null;
        }
        if (TypeUtil.isInetAddress(type)) {
            return TypeUtil.encodeInetAddress(value);
        }
        if (TypeUtil.isBigInteger(type)) {
            return TypeUtil.encodeBigInteger(value);
        }
        if (type instanceof DecimalType) {
            return TypeUtil.encodeDecimal(value);
        }
        return value;
    }

    public static int compare(ByteBuffer b1, ByteBuffer b2, AbstractType<?> type) {
        if (TypeUtil.isInetAddress(type)) {
            return TypeUtil.compareInet(b1, b2);
        }
        if (TypeUtil.isBigInteger(type) || TypeUtil.isBigDecimal(type) || TypeUtil.isCompositeOrFrozen(type)) {
            return FastByteOperations.compareUnsigned(b1, b2);
        }
        return type.compare(b1, b2);
    }

    public static int comparePostFilter(Expression.Value requestedValue, Expression.Value columnValue, AbstractType<?> type) {
        if (TypeUtil.isInetAddress(type)) {
            return TypeUtil.compareInet(requestedValue.encoded, columnValue.encoded);
        }
        if (TypeUtil.isCompositeOrFrozen(type)) {
            return FastByteOperations.compareUnsigned(requestedValue.raw, columnValue.raw);
        }
        return type.compare(requestedValue.raw, columnValue.raw);
    }

    public static Iterator<ByteBuffer> collectionIterator(AbstractType<?> validator, ComplexColumnData cellData, ColumnMetadata columnMetadata, IndexTarget.Type indexType, long nowInSecs) {
        if (cellData == null) {
            return null;
        }
        Stream<ByteBuffer> stream = StreamSupport.stream(cellData.spliterator(), false).filter(cell -> cell != null && cell.isLive(nowInSecs)).map(cell -> TypeUtil.cellValue(columnMetadata, indexType, cell));
        if (TypeUtil.isInetAddress(validator)) {
            stream = stream.sorted((c1, c2) -> TypeUtil.compareInet(TypeUtil.encodeInetAddress(c1), TypeUtil.encodeInetAddress(c2)));
        }
        return stream.iterator();
    }

    public static Comparator<ByteBuffer> comparator(AbstractType<?> type) {
        if (TypeUtil.isBigInteger(type) || TypeUtil.isBigDecimal(type) || TypeUtil.isCompositeOrFrozen(type)) {
            return FastByteOperations::compareUnsigned;
        }
        return type;
    }

    private static ByteBuffer cellValue(ColumnMetadata columnMetadata, IndexTarget.Type indexType, Cell<?> cell) {
        if (columnMetadata.type.isCollection() && columnMetadata.type.isMultiCell()) {
            switch (((CollectionType)columnMetadata.type).kind) {
                case LIST: {
                    return cell.buffer();
                }
                case SET: {
                    return cell.path().get(0);
                }
                case MAP: {
                    switch (indexType) {
                        case KEYS: {
                            return cell.path().get(0);
                        }
                        case VALUES: {
                            return cell.buffer();
                        }
                        case KEYS_AND_VALUES: {
                            return CompositeType.build(ByteBufferAccessor.instance, cell.path().get(0), cell.buffer());
                        }
                    }
                }
            }
        }
        return cell.buffer();
    }

    private static int compareInet(ByteBuffer b1, ByteBuffer b2) {
        assert (TypeUtil.isIPv6(b1) && TypeUtil.isIPv6(b2));
        return FastByteOperations.compareUnsigned(b1, b2);
    }

    private static boolean isIPv6(ByteBuffer address) {
        return address.remaining() == 16;
    }

    private static ByteBuffer encodeInetAddress(ByteBuffer value) {
        if (value.remaining() == 4) {
            int position = value.hasArray() ? value.arrayOffset() + value.position() : value.position();
            ByteBuffer mapped = ByteBuffer.allocate(16);
            System.arraycopy(IPV4_PREFIX, 0, mapped.array(), 0, IPV4_PREFIX.length);
            ByteBufferUtil.copyBytes(value, position, mapped, IPV4_PREFIX.length, value.remaining());
            return mapped;
        }
        return value;
    }

    public static ByteBuffer encodeBigInteger(ByteBuffer value) {
        int size = value.remaining();
        int position = value.hasArray() ? value.arrayOffset() + value.position() : value.position();
        byte[] bytes = new byte[20];
        if (size < 16) {
            ByteBufferUtil.copyBytes(value, position, bytes, bytes.length - size, size);
            if ((bytes[bytes.length - size] & 0x80) != 0) {
                Arrays.fill(bytes, 4, bytes.length - size, (byte)-1);
            } else {
                Arrays.fill(bytes, 4, bytes.length - size, (byte)0);
            }
        } else {
            ByteBufferUtil.copyBytes(value, position, bytes, 4, 16);
        }
        if ((bytes[4] & 0x80) != 0) {
            size = -size;
        }
        bytes[0] = (byte)(size >> 24 & 0xFF);
        bytes[1] = (byte)(size >> 16 & 0xFF);
        bytes[2] = (byte)(size >> 8 & 0xFF);
        bytes[3] = (byte)(size & 0xFF);
        bytes[0] = (byte)(bytes[0] ^ 0x80);
        return ByteBuffer.wrap(bytes);
    }

    public static boolean isLiteral(AbstractType<?> type) {
        return TypeUtil.isString(type) || TypeUtil.isCompositeOrFrozen(type) || TypeUtil.baseType(type) instanceof BooleanType;
    }

    public static boolean isString(AbstractType<?> type) {
        type = TypeUtil.baseType(type);
        return type instanceof StringType;
    }

    public static boolean isCompositeOrFrozen(AbstractType<?> type) {
        return (type = TypeUtil.baseType(type)) instanceof CompositeType || TypeUtil.isFrozen(type);
    }

    public static boolean isFrozen(AbstractType<?> type) {
        return !(type = TypeUtil.baseType(type)).subTypes().isEmpty() && !type.isMultiCell();
    }

    public static boolean isFrozenCollection(AbstractType<?> type) {
        return (type = TypeUtil.baseType(type)).isCollection() && !type.isMultiCell();
    }

    public static boolean isNonFrozenCollection(AbstractType<?> type) {
        return (type = TypeUtil.baseType(type)).isCollection() && type.isMultiCell();
    }

    private static boolean isInetAddress(AbstractType<?> type) {
        type = TypeUtil.baseType(type);
        return type instanceof InetAddressType;
    }

    private static boolean isBigInteger(AbstractType<?> type) {
        type = TypeUtil.baseType(type);
        return type instanceof IntegerType;
    }

    private static boolean isBigDecimal(AbstractType<?> type) {
        type = TypeUtil.baseType(type);
        return type instanceof DecimalType;
    }

    public static boolean isComposite(AbstractType<?> type) {
        type = TypeUtil.baseType(type);
        return type instanceof CompositeType;
    }

    private static AbstractType<?> baseType(AbstractType<?> type) {
        return type.isReversed() ? ((ReversedType)type).baseType : type;
    }

    public static ByteBuffer encodeDecimal(ByteBuffer value) {
        ByteSource bs = DecimalType.instance.asComparableBytes(value, ByteComparable.Version.OSS50);
        bs = ByteSource.cutOrRightPad(bs, 24, 0);
        return ByteBuffer.wrap(ByteSourceInverse.readBytes(bs, 24));
    }
}

