/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.AbstractUnfilteredRowIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.RequestTimeoutException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.metrics.TableQueryMetrics;
import org.apache.cassandra.index.sai.plan.FilterTree;
import org.apache.cassandra.index.sai.plan.Operation;
import org.apache.cassandra.index.sai.plan.QueryController;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.AbstractIterator;

public class StorageAttachedIndexSearcher
implements Index.Searcher {
    private final ReadCommand command;
    private final QueryController queryController;
    private final QueryContext queryContext;
    private final PrimaryKey.Factory keyFactory;

    public StorageAttachedIndexSearcher(ColumnFamilyStore cfs, TableQueryMetrics tableQueryMetrics, ReadCommand command, RowFilter filterOperation, long executionQuotaMs) {
        this.command = command;
        this.queryContext = new QueryContext(command, executionQuotaMs);
        this.queryController = new QueryController(cfs, command, filterOperation, this.queryContext, tableQueryMetrics);
        this.keyFactory = new PrimaryKey.Factory(cfs.metadata().comparator);
    }

    @Override
    public ReadCommand command() {
        return this.command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionIterator filterReplicaFilteringProtection(PartitionIterator fullResponse) {
        for (RowFilter.Expression expression : this.queryController.filterOperation()) {
            AbstractAnalyzer analyzer = this.queryController.getContext(expression).getAnalyzerFactory().create();
            try {
                if (!analyzer.transformValue()) continue;
                PartitionIterator partitionIterator = StorageAttachedIndexSearcher.applyIndexFilter(fullResponse, Operation.buildFilter(this.queryController), this.queryContext);
                return partitionIterator;
            }
            finally {
                analyzer.end();
            }
        }
        return Index.Searcher.super.filterReplicaFilteringProtection(fullResponse);
    }

    @Override
    public UnfilteredPartitionIterator search(ReadExecutionController executionController) throws RequestTimeoutException {
        return new ResultRetriever(this.queryController, executionController, this.queryContext, this.keyFactory);
    }

    private static PartitionIterator applyIndexFilter(final PartitionIterator response, final FilterTree tree, final QueryContext queryContext) {
        return new PartitionIterator(){

            @Override
            public void close() {
                response.close();
            }

            @Override
            public boolean hasNext() {
                return response.hasNext();
            }

            @Override
            public RowIterator next() {
                final RowIterator delegate = (RowIterator)response.next();
                final Row staticRow = delegate.staticRow();
                return new RowIterator(){
                    Row next;

                    @Override
                    public TableMetadata metadata() {
                        return delegate.metadata();
                    }

                    @Override
                    public boolean isReverseOrder() {
                        return delegate.isReverseOrder();
                    }

                    @Override
                    public RegularAndStaticColumns columns() {
                        return delegate.columns();
                    }

                    @Override
                    public DecoratedKey partitionKey() {
                        return delegate.partitionKey();
                    }

                    @Override
                    public Row staticRow() {
                        return staticRow;
                    }

                    @Override
                    public void close() {
                        delegate.close();
                    }

                    private Row computeNext() {
                        while (delegate.hasNext()) {
                            Row row = (Row)delegate.next();
                            ++queryContext.rowsFiltered;
                            if (!tree.isSatisfiedBy(delegate.partitionKey(), row, staticRow)) continue;
                            return row;
                        }
                        return null;
                    }

                    private Row loadNext() {
                        if (this.next == null) {
                            this.next = this.computeNext();
                        }
                        return this.next;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.loadNext() != null;
                    }

                    @Override
                    public Row next() {
                        Row result = this.loadNext();
                        this.next = null;
                        if (result == null) {
                            throw new NoSuchElementException();
                        }
                        return result;
                    }
                };
            }
        };
    }

    private static class ResultRetriever
    extends AbstractIterator<UnfilteredRowIterator>
    implements UnfilteredPartitionIterator {
        private final PrimaryKey firstPrimaryKey;
        private final PrimaryKey lastPrimaryKey;
        private final Iterator<DataRange> keyRanges;
        private AbstractBounds<PartitionPosition> currentKeyRange;
        private final KeyRangeIterator resultKeyIterator;
        private final FilterTree filterTree;
        private final QueryController queryController;
        private final ReadExecutionController executionController;
        private final QueryContext queryContext;
        private final PrimaryKey.Factory keyFactory;
        private PrimaryKey lastKey;

        private ResultRetriever(QueryController queryController, ReadExecutionController executionController, QueryContext queryContext, PrimaryKey.Factory keyFactory) {
            this.keyRanges = queryController.dataRanges().iterator();
            this.currentKeyRange = this.keyRanges.next().keyRange();
            this.resultKeyIterator = Operation.buildIterator(queryController);
            this.filterTree = Operation.buildFilter(queryController);
            this.queryController = queryController;
            this.executionController = executionController;
            this.queryContext = queryContext;
            this.keyFactory = keyFactory;
            this.firstPrimaryKey = keyFactory.createTokenOnly(((PartitionPosition)queryController.mergeRange().left).getToken());
            this.lastPrimaryKey = keyFactory.createTokenOnly(((PartitionPosition)queryController.mergeRange().right).getToken());
        }

        @Override
        public UnfilteredRowIterator computeNext() {
            if (this.resultKeyIterator == null) {
                return (UnfilteredRowIterator)this.endOfData();
            }
            if (this.lastKey == null) {
                this.resultKeyIterator.skipTo(this.firstPrimaryKey);
            }
            this.skipToNextPartition();
            UnfilteredRowIterator iterator = this.nextRowIterator(this::nextSelectedKeyInRange);
            return iterator != null ? this.iteratePartition(iterator) : (UnfilteredRowIterator)this.endOfData();
        }

        @Nullable
        private UnfilteredRowIterator nextRowIterator(@Nonnull Supplier<PrimaryKey> keySupplier) {
            UnfilteredRowIterator iterator = null;
            while (iterator == null) {
                PrimaryKey key = keySupplier.get();
                if (key == null) {
                    return null;
                }
                iterator = this.queryStorageAndFilter(key);
            }
            return iterator;
        }

        @Nullable
        private PrimaryKey nextKeyInRange() {
            PrimaryKey key = this.nextKey();
            while (key != null && !this.currentKeyRange.contains(key.partitionKey())) {
                if (!((PartitionPosition)this.currentKeyRange.right).isMinimum() && ((PartitionPosition)this.currentKeyRange.right).compareTo(key.partitionKey()) <= 0) {
                    this.currentKeyRange = this.nextKeyRange();
                    if (this.currentKeyRange != null) continue;
                    return null;
                }
                this.skipTo(((PartitionPosition)this.currentKeyRange.left).getToken());
                key = this.nextKey();
            }
            return key;
        }

        @Nullable
        private PrimaryKey nextSelectedKeyInRange() {
            PrimaryKey key;
            while ((key = this.nextKeyInRange()) != null && this.queryController.doesNotSelect(key)) {
            }
            return key;
        }

        @Nullable
        private PrimaryKey nextSelectedKeyInPartition(DecoratedKey partitionKey) {
            PrimaryKey key;
            do {
                if (!this.resultKeyIterator.hasNext()) {
                    return null;
                }
                if (((PrimaryKey)this.resultKeyIterator.peek()).partitionKey().equals(partitionKey)) continue;
                return null;
            } while ((key = this.nextKey()) != null && this.queryController.doesNotSelect(key));
            return key;
        }

        @Nullable
        private PrimaryKey nextKey() {
            if (!this.resultKeyIterator.hasNext()) {
                return null;
            }
            PrimaryKey key = (PrimaryKey)this.resultKeyIterator.next();
            return this.isWithinUpperBound(key) ? key : null;
        }

        private boolean isWithinUpperBound(PrimaryKey key) {
            return this.lastPrimaryKey.token().isMinimum() || this.lastPrimaryKey.compareTo(key) >= 0;
        }

        @Nullable
        private AbstractBounds<PartitionPosition> nextKeyRange() {
            return this.keyRanges.hasNext() ? this.keyRanges.next().keyRange() : null;
        }

        private void skipTo(@Nonnull Token token) {
            this.resultKeyIterator.skipTo(this.keyFactory.createTokenOnly(token));
        }

        private void skipToNextPartition() {
            if (this.lastKey == null) {
                return;
            }
            DecoratedKey lastPartitionKey = this.lastKey.partitionKey();
            while (this.resultKeyIterator.hasNext() && ((PrimaryKey)this.resultKeyIterator.peek()).partitionKey().equals(lastPartitionKey)) {
                this.resultKeyIterator.next();
            }
        }

        @Nonnull
        private UnfilteredRowIterator iteratePartition(final @Nonnull UnfilteredRowIterator startIter) {
            return new AbstractUnfilteredRowIterator(startIter.metadata(), startIter.partitionKey(), startIter.partitionLevelDeletion(), startIter.columns(), startIter.staticRow(), startIter.isReverseOrder(), startIter.stats()){
                private UnfilteredRowIterator currentIter;
                private final DecoratedKey partitionKey;
                {
                    super(metadata, partitionKey, partitionLevelDeletion, columns, staticRow, isReverseOrder, stats);
                    this.currentIter = startIter;
                    this.partitionKey = startIter.partitionKey();
                }

                @Override
                protected Unfiltered computeNext() {
                    while (!this.currentIter.hasNext()) {
                        this.currentIter.close();
                        this.currentIter = this.nextRowIterator(() -> this.nextSelectedKeyInPartition(this.partitionKey));
                        if (this.currentIter != null) continue;
                        return (Unfiltered)this.endOfData();
                    }
                    return (Unfiltered)this.currentIter.next();
                }

                @Override
                public void close() {
                    FileUtils.closeQuietly(this.currentIter);
                    super.close();
                }
            };
        }

        private UnfilteredRowIterator queryStorageAndFilter(PrimaryKey key) {
            if (key.equals(this.lastKey)) {
                return null;
            }
            this.lastKey = key;
            try (UnfilteredRowIterator partition = this.queryController.queryStorage(key, this.executionController);){
                ++this.queryContext.partitionsRead;
                UnfilteredRowIterator unfilteredRowIterator = ResultRetriever.applyIndexFilter(partition, this.filterTree, this.queryContext);
                return unfilteredRowIterator;
            }
        }

        private static UnfilteredRowIterator applyIndexFilter(UnfilteredRowIterator partition, FilterTree tree, QueryContext queryContext) {
            Row staticRow = partition.staticRow();
            ArrayList<Unfiltered> clusters = new ArrayList<Unfiltered>();
            while (partition.hasNext()) {
                Unfiltered row = (Unfiltered)partition.next();
                ++queryContext.rowsFiltered;
                if (!tree.isSatisfiedBy(partition.partitionKey(), row, staticRow)) continue;
                clusters.add(row);
            }
            if (clusters.isEmpty()) {
                ++queryContext.rowsFiltered;
                if (tree.isSatisfiedBy(partition.partitionKey(), staticRow, staticRow)) {
                    clusters.add(staticRow);
                }
            }
            if (clusters.isEmpty()) {
                return null;
            }
            return new PartitionIterator(partition, staticRow, (Iterator<Unfiltered>)Iterators.filter(clusters.iterator(), u -> !((Row)u).isStatic()));
        }

        @Override
        public TableMetadata metadata() {
            return this.queryController.metadata();
        }

        @Override
        public void close() {
            FileUtils.closeQuietly(this.resultKeyIterator);
            this.queryController.finish();
        }

        private static class PartitionIterator
        extends AbstractUnfilteredRowIterator {
            private final Iterator<Unfiltered> rows;

            public PartitionIterator(UnfilteredRowIterator partition, Row staticRow, Iterator<Unfiltered> content) {
                super(partition.metadata(), partition.partitionKey(), partition.partitionLevelDeletion(), partition.columns(), staticRow, partition.isReverseOrder(), partition.stats());
                this.rows = content;
            }

            @Override
            protected Unfiltered computeNext() {
                return this.rows.hasNext() ? this.rows.next() : (Unfiltered)this.endOfData();
            }
        }
    }
}

