/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.memory;

import io.netty.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.concurrent.atomic.LongAdder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.memtable.TrieMemtable;
import org.apache.cassandra.db.tries.InMemoryTrie;
import org.apache.cassandra.db.tries.Trie;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.memory.FilteringInMemoryKeyRangeIterator;
import org.apache.cassandra.index.sai.memory.InMemoryKeyRangeIterator;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.index.sai.utils.PrimaryKeys;
import org.apache.cassandra.index.sai.utils.TypeUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrieMemoryIndex {
    private static final Logger logger = LoggerFactory.getLogger(TrieMemoryIndex.class);
    private static final int MAX_RECURSIVE_KEY_LENGTH = 128;
    private final IndexContext indexContext;
    private final InMemoryTrie<PrimaryKeys> data;
    private final PrimaryKeysReducer primaryKeysReducer;
    private final AbstractAnalyzer.AnalyzerFactory analyzerFactory;
    private final AbstractType<?> validator;
    private final boolean isLiteral;
    private ByteBuffer minTerm;
    private ByteBuffer maxTerm;

    public TrieMemoryIndex(IndexContext indexContext) {
        this.indexContext = indexContext;
        this.data = new InMemoryTrie(TrieMemtable.BUFFER_TYPE);
        this.primaryKeysReducer = new PrimaryKeysReducer();
        this.analyzerFactory = indexContext.getAnalyzerFactory();
        this.validator = indexContext.getValidator();
        this.isLiteral = TypeUtil.isLiteral(this.validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long add(DecoratedKey key, Clustering<?> clustering, ByteBuffer value) {
        AbstractAnalyzer analyzer = this.analyzerFactory.create();
        try {
            value = TypeUtil.asIndexBytes(value, this.validator);
            analyzer.reset(value);
            PrimaryKey primaryKey = this.indexContext.keyFactory().create(key, clustering);
            long initialSizeOnHeap = this.data.sizeOnHeap();
            long initialSizeOffHeap = this.data.sizeOffHeap();
            long reducerHeapSize = this.primaryKeysReducer.heapAllocations();
            while (analyzer.hasNext()) {
                ByteBuffer term = analyzer.next();
                this.setMinMaxTerm(term.duplicate());
                ByteComparable comparableBytes = this.asComparableBytes(term);
                try {
                    if (term.limit() <= 128) {
                        this.data.putRecursive(comparableBytes, primaryKey, this.primaryKeysReducer);
                        continue;
                    }
                    this.data.apply(Trie.singleton(comparableBytes, primaryKey), this.primaryKeysReducer);
                }
                catch (InMemoryTrie.SpaceExhaustedException e) {
                    throw new RuntimeException(e);
                }
            }
            long onHeap = this.data.sizeOnHeap();
            long offHeap = this.data.sizeOffHeap();
            long heapAllocations = this.primaryKeysReducer.heapAllocations();
            long l = onHeap - initialSizeOnHeap + (offHeap - initialSizeOffHeap) + (heapAllocations - reducerHeapSize);
            return l;
        }
        finally {
            analyzer.end();
        }
    }

    public KeyRangeIterator search(Expression expression, AbstractBounds<PartitionPosition> keyRange) {
        if (logger.isTraceEnabled()) {
            logger.trace("Searching memtable index on expression '{}'...", (Object)expression);
        }
        switch (expression.getOp()) {
            case EQ: 
            case CONTAINS_KEY: 
            case CONTAINS_VALUE: {
                return this.exactMatch(expression, keyRange);
            }
            case RANGE: {
                return this.rangeMatch(expression, keyRange);
            }
        }
        throw new IllegalArgumentException("Unsupported expression: " + expression);
    }

    public Iterator<Pair<ByteComparable, PrimaryKeys>> iterator() {
        final Iterator iterator = this.data.entrySet().iterator();
        return new Iterator<Pair<ByteComparable, PrimaryKeys>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Pair<ByteComparable, PrimaryKeys> next() {
                Map.Entry entry = (Map.Entry)iterator.next();
                return Pair.create(TrieMemoryIndex.this.decode((ByteComparable)entry.getKey()), (PrimaryKeys)entry.getValue());
            }
        };
    }

    public ByteBuffer getMinTerm() {
        return this.minTerm;
    }

    public ByteBuffer getMaxTerm() {
        return this.maxTerm;
    }

    private void setMinMaxTerm(ByteBuffer term) {
        assert (term != null);
        this.minTerm = TypeUtil.min(term, this.minTerm, this.indexContext.getValidator());
        this.maxTerm = TypeUtil.max(term, this.maxTerm, this.indexContext.getValidator());
    }

    private ByteComparable asComparableBytes(ByteBuffer input) {
        return this.isLiteral ? version -> this.terminated(ByteSource.of(input, version)) : version -> TypeUtil.asComparableBytes(input, this.validator, version);
    }

    private ByteComparable decode(ByteComparable term) {
        return this.isLiteral ? version -> ByteSourceInverse.unescape(ByteSource.peekable(term.asComparableBytes(version))) : term;
    }

    private ByteSource terminated(final ByteSource src) {
        return new ByteSource(){
            boolean done = false;

            @Override
            public int next() {
                if (this.done) {
                    return -1;
                }
                int n = src.next();
                if (n != -1) {
                    return n;
                }
                this.done = true;
                return 56;
            }
        };
    }

    private KeyRangeIterator exactMatch(Expression expression, AbstractBounds<PartitionPosition> keyRange) {
        ByteComparable comparableMatch = expression.lower == null ? ByteComparable.EMPTY : this.asComparableBytes(expression.lower.value.encoded);
        PrimaryKeys primaryKeys = (PrimaryKeys)this.data.get(comparableMatch);
        return primaryKeys == null ? KeyRangeIterator.empty() : new FilteringInMemoryKeyRangeIterator(primaryKeys.keys(), keyRange);
    }

    private KeyRangeIterator rangeMatch(Expression expression, AbstractBounds<PartitionPosition> keyRange) {
        boolean upperInclusive;
        ByteComparable upperBound;
        boolean lowerInclusive;
        ByteComparable lowerBound;
        if (expression.lower != null) {
            lowerBound = this.asComparableBytes(expression.lower.value.encoded);
            lowerInclusive = expression.lower.inclusive;
        } else {
            lowerBound = ByteComparable.EMPTY;
            lowerInclusive = false;
        }
        if (expression.upper != null) {
            upperBound = this.asComparableBytes(expression.upper.value.encoded);
            upperInclusive = expression.upper.inclusive;
        } else {
            upperBound = null;
            upperInclusive = false;
        }
        Collector cd = new Collector(keyRange);
        this.data.subtrie(lowerBound, lowerInclusive, upperBound, upperInclusive).values().forEach(cd::processContent);
        if (cd.mergedKeys.isEmpty()) {
            return KeyRangeIterator.empty();
        }
        cd.updateLastQueueSize();
        return new InMemoryKeyRangeIterator(cd.minimumKey, cd.maximumKey, cd.mergedKeys);
    }

    private static class PrimaryKeysReducer
    implements InMemoryTrie.UpsertTransformer<PrimaryKeys, PrimaryKey> {
        private final LongAdder heapAllocations = new LongAdder();

        private PrimaryKeysReducer() {
        }

        @Override
        public PrimaryKeys apply(PrimaryKeys existing, PrimaryKey neww) {
            if (existing == null) {
                existing = new PrimaryKeys();
                this.heapAllocations.add(existing.unsharedHeapSize());
            }
            this.heapAllocations.add(existing.add(neww));
            return existing;
        }

        long heapAllocations() {
            return this.heapAllocations.longValue();
        }
    }

    private static class Collector {
        private static final int MINIMUM_QUEUE_SIZE = 128;
        private static final FastThreadLocal<Integer> lastQueueSize = new FastThreadLocal<Integer>(){

            protected Integer initialValue() {
                return 128;
            }
        };
        PrimaryKey minimumKey = null;
        PrimaryKey maximumKey = null;
        final PriorityQueue<PrimaryKey> mergedKeys = new PriorityQueue((Integer)lastQueueSize.get());
        final AbstractBounds<PartitionPosition> keyRange;

        public Collector(AbstractBounds<PartitionPosition> keyRange) {
            this.keyRange = keyRange;
        }

        public void processContent(PrimaryKeys keys) {
            if (keys.isEmpty()) {
                return;
            }
            SortedSet<PrimaryKey> primaryKeys = keys.keys();
            if (primaryKeys.size() == 1) {
                this.processKey(primaryKeys.first());
                return;
            }
            if (!((PartitionPosition)this.keyRange.right).isMinimum() && primaryKeys.first().partitionKey().compareTo((PartitionPosition)this.keyRange.right) > 0 || primaryKeys.last().partitionKey().compareTo((PartitionPosition)this.keyRange.left) < 0) {
                return;
            }
            primaryKeys.forEach(this::processKey);
        }

        public void updateLastQueueSize() {
            lastQueueSize.set((Object)Math.max(128, this.mergedKeys.size()));
        }

        private void processKey(PrimaryKey key) {
            if (this.keyRange.contains(key.partitionKey())) {
                this.mergedKeys.add(key);
                PrimaryKey primaryKey = this.minimumKey == null ? key : (this.minimumKey = key.compareTo(this.minimumKey) < 0 ? key : this.minimumKey);
                this.maximumKey = this.maximumKey == null ? key : (key.compareTo(this.maximumKey) > 0 ? key : this.maximumKey);
            }
        }
    }
}

