/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.memory;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.atomic.LongAdder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.memory.TrieMemoryIndex;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.PrimaryKeys;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

public class MemtableIndex {
    private final TrieMemoryIndex index;
    private final LongAdder writeCount = new LongAdder();
    private final LongAdder estimatedMemoryUsed = new LongAdder();

    public MemtableIndex(IndexContext indexContext) {
        this.index = new TrieMemoryIndex(indexContext);
    }

    public long writeCount() {
        return this.writeCount.sum();
    }

    public long estimatedMemoryUsed() {
        return this.estimatedMemoryUsed.sum();
    }

    public boolean isEmpty() {
        return this.getMinTerm() == null;
    }

    public ByteBuffer getMinTerm() {
        return this.index.getMinTerm();
    }

    public ByteBuffer getMaxTerm() {
        return this.index.getMaxTerm();
    }

    public long index(DecoratedKey key, Clustering<?> clustering, ByteBuffer value) {
        if (value == null || value.remaining() == 0) {
            return 0L;
        }
        long ram = this.index.add(key, clustering, value);
        this.writeCount.increment();
        this.estimatedMemoryUsed.add(ram);
        return ram;
    }

    public KeyRangeIterator search(Expression expression, AbstractBounds<PartitionPosition> keyRange) {
        return this.index.search(expression, keyRange);
    }

    public Iterator<Pair<ByteComparable, PrimaryKeys>> iterator() {
        return this.index.iterator();
    }
}

