/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.memory;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.ByteBlockPool;

@NotThreadSafe
final class ByteSliceReader
extends DataInput {
    private ByteBlockPool pool;
    private int bufferUpto;
    private byte[] buffer;
    private int upto;
    private int limit;
    private int level;
    private int bufferOffset;
    private int endIndex;

    ByteSliceReader() {
    }

    public void init(ByteBlockPool pool, int startIndex, int endIndex) {
        assert (endIndex - startIndex >= 0) : "startIndex=" + startIndex + " endIndex=" + endIndex;
        assert (startIndex >= 0);
        assert (endIndex >= 0);
        this.pool = pool;
        this.endIndex = endIndex;
        this.level = 0;
        this.bufferUpto = startIndex / 32768;
        this.bufferOffset = this.bufferUpto * 32768;
        this.buffer = pool.buffers[this.bufferUpto];
        this.upto = startIndex & Short.MAX_VALUE;
        int firstSize = ByteBlockPool.LEVEL_SIZE_ARRAY[0];
        this.limit = startIndex + firstSize >= endIndex ? endIndex & Short.MAX_VALUE : this.upto + firstSize - 4;
    }

    public boolean eof() {
        assert (this.upto + this.bufferOffset <= this.endIndex);
        return this.upto + this.bufferOffset == this.endIndex;
    }

    public byte readByte() {
        assert (!this.eof());
        assert (this.upto <= this.limit);
        if (this.upto == this.limit) {
            this.nextSlice();
        }
        return this.buffer[this.upto++];
    }

    public void nextSlice() {
        int nextIndex = BitUtil.VH_LE_INT.get(this.buffer, this.limit);
        this.level = ByteBlockPool.NEXT_LEVEL_ARRAY[this.level];
        int newSize = ByteBlockPool.LEVEL_SIZE_ARRAY[this.level];
        this.bufferUpto = nextIndex / 32768;
        this.bufferOffset = this.bufferUpto * 32768;
        this.buffer = this.pool.buffers[this.bufferUpto];
        this.upto = nextIndex & Short.MAX_VALUE;
        if (nextIndex + newSize >= this.endIndex) {
            assert (this.endIndex - nextIndex > 0);
            this.limit = this.endIndex - this.bufferOffset;
        } else {
            this.limit = this.upto + newSize - 4;
        }
    }

    public void skipBytes(long l) {
        throw new UnsupportedOperationException("skipBytes is not supported by ByteSliceReader");
    }

    public void readBytes(byte[] b, int offset, int len) {
        throw new UnsupportedOperationException("readBytes is not supported by ByteSliceReader");
    }
}

