/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.trie;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.v1.postings.PostingsWriter;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.cassandra.index.sai.disk.v1.trie.TrieTermsDictionaryWriter;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.index.sai.utils.TermsIterator;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.commons.lang3.mutable.MutableLong;

@NotThreadSafe
public class LiteralIndexWriter
implements Closeable {
    private final TrieTermsDictionaryWriter termsDictionaryWriter;
    private final PostingsWriter postingsWriter;
    private long postingsAdded;

    public LiteralIndexWriter(IndexDescriptor indexDescriptor, IndexContext indexContext) throws IOException {
        this.termsDictionaryWriter = new TrieTermsDictionaryWriter(indexDescriptor, indexContext);
        this.postingsWriter = new PostingsWriter(indexDescriptor, indexContext);
    }

    public SegmentMetadata.ComponentMetadataMap writeCompleteSegment(TermsIterator terms) throws IOException {
        long termsOffset = this.termsDictionaryWriter.getStartOffset();
        long postingsOffset = this.postingsWriter.getStartOffset();
        while (terms.hasNext()) {
            ByteComparable term = (ByteComparable)terms.next();
            PostingList postings = terms.postings();
            try {
                long offset = this.postingsWriter.write(postings);
                this.termsDictionaryWriter.add(term, offset);
            }
            finally {
                if (postings == null) continue;
                postings.close();
            }
        }
        this.postingsAdded = this.postingsWriter.getTotalPostings();
        MutableLong footerPointer = new MutableLong();
        long termsRoot = this.termsDictionaryWriter.complete(footerPointer);
        this.postingsWriter.complete();
        long termsLength = this.termsDictionaryWriter.getFilePointer() - termsOffset;
        long postingsLength = this.postingsWriter.getFilePointer() - postingsOffset;
        SegmentMetadata.ComponentMetadataMap components = new SegmentMetadata.ComponentMetadataMap();
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("footerPointer", footerPointer.getValue().toString());
        components.put(IndexComponent.POSTING_LISTS, -1L, postingsOffset, postingsLength);
        components.put(IndexComponent.TERMS_DATA, termsRoot, termsOffset, termsLength, map);
        return components;
    }

    @Override
    public void close() throws IOException {
        this.postingsWriter.close();
        this.termsDictionaryWriter.close();
    }

    public long getPostingsCount() {
        return this.postingsAdded;
    }
}

