/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bbtree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.io.IndexOutputWriter;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeIterator;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreePostingsWriter;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeWalker;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeWriter;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.lucene.util.packed.PackedLongValues;

public class NumericIndexWriter {
    public static final int MAX_POINTS_IN_LEAF_NODE = 1024;
    private static final int DEFAULT_POSTINGS_SIZE = 128;
    private final BlockBalancedTreeWriter writer;
    private final IndexDescriptor indexDescriptor;
    private final IndexContext indexContext;
    private final int bytesPerValue;

    public NumericIndexWriter(IndexDescriptor indexDescriptor, IndexContext indexContext, int bytesPerValue, long maxSegmentRowId) {
        this(indexDescriptor, indexContext, 1024, bytesPerValue, maxSegmentRowId);
    }

    @VisibleForTesting
    public NumericIndexWriter(IndexDescriptor indexDescriptor, IndexContext indexContext, int maxPointsInLeafNode, int bytesPerValue, long maxSegmentRowId) {
        Preconditions.checkArgument((maxSegmentRowId >= 0L ? 1 : 0) != 0, (String)"[%s] maxSegmentRowId must be non-negative value, but got %s", (Object)indexContext.getIndexName(), (long)maxSegmentRowId);
        this.indexDescriptor = indexDescriptor;
        this.indexContext = indexContext;
        this.bytesPerValue = bytesPerValue;
        this.writer = new BlockBalancedTreeWriter(bytesPerValue, maxPointsInLeafNode);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("indexContext", (Object)this.indexContext).add("bytesPerValue", this.bytesPerValue).toString();
    }

    public SegmentMetadata.ComponentMetadataMap writeCompleteSegment(BlockBalancedTreeIterator values) throws IOException {
        long treePosition;
        SegmentMetadata.ComponentMetadataMap components = new SegmentMetadata.ComponentMetadataMap();
        LeafCallback leafCallback = new LeafCallback();
        try (IndexOutputWriter treeOutput = this.indexDescriptor.openPerIndexOutput(IndexComponent.BALANCED_TREE, this.indexContext, true);){
            long treeOffset = treeOutput.getFilePointer();
            treePosition = this.writer.write(treeOutput, values, leafCallback);
            if (treePosition < 0L) {
                SegmentMetadata.ComponentMetadataMap componentMetadataMap = components;
                return componentMetadataMap;
            }
            long treeLength = treeOutput.getFilePointer() - treeOffset;
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            attributes.put("max_points_in_leaf_node", Integer.toString(this.writer.getMaxPointsInLeafNode()));
            attributes.put("num_leaves", Integer.toString(leafCallback.numLeaves()));
            attributes.put("num_values", Long.toString(this.writer.getValueCount()));
            attributes.put("bytes_per_value", Long.toString(this.writer.getBytesPerValue()));
            components.put(IndexComponent.BALANCED_TREE, treePosition, treeOffset, treeLength, attributes);
        }
        try (BlockBalancedTreeWalker reader = new BlockBalancedTreeWalker(this.indexDescriptor.createPerIndexFileHandle(IndexComponent.BALANCED_TREE, this.indexContext, null), treePosition);
             IndexOutputWriter postingsOutput = this.indexDescriptor.openPerIndexOutput(IndexComponent.POSTING_LISTS, this.indexContext, true);){
            long postingsOffset = postingsOutput.getFilePointer();
            BlockBalancedTreePostingsWriter postingsWriter = new BlockBalancedTreePostingsWriter();
            reader.traverse(postingsWriter);
            long postingsPosition = postingsWriter.finish(postingsOutput, leafCallback.leafPostings, this.indexContext);
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            attributes.put("num_leaf_postings", Integer.toString(postingsWriter.numLeafPostings));
            attributes.put("num_non_leaf_postings", Integer.toString(postingsWriter.numNonLeafPostings));
            long postingsLength = postingsOutput.getFilePointer() - postingsOffset;
            components.put(IndexComponent.POSTING_LISTS, postingsPosition, postingsOffset, postingsLength, attributes);
        }
        return components;
    }

    public long getValueCount() {
        return this.writer.getValueCount();
    }

    private static class LeafCallback
    implements BlockBalancedTreeWriter.Callback {
        final List<PackedLongValues> leafPostings = new ArrayList<PackedLongValues>(128);

        private LeafCallback() {
        }

        public int numLeaves() {
            return this.leafPostings.size();
        }

        @Override
        public void writeLeafPostings(BlockBalancedTreeWriter.RowIDAndIndex[] leafPostings, int offset, int count) {
            PackedLongValues.Builder builder = PackedLongValues.monotonicBuilder((float)0.0f);
            for (int i = offset; i < count; ++i) {
                builder.add(leafPostings[i].rowID);
            }
            this.leafPostings.add(builder.build());
        }
    }
}

