/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import java.io.Closeable;
import java.util.EnumMap;
import java.util.Map;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;

public class PerColumnIndexFiles
implements Closeable {
    private final Map<IndexComponent, FileHandle> files = new EnumMap<IndexComponent, FileHandle>(IndexComponent.class);
    private final IndexDescriptor indexDescriptor;
    private final IndexContext indexContext;

    public PerColumnIndexFiles(IndexDescriptor indexDescriptor, IndexContext indexContext) {
        this.indexDescriptor = indexDescriptor;
        this.indexContext = indexContext;
        if (indexContext.isLiteral()) {
            this.files.put(IndexComponent.POSTING_LISTS, indexDescriptor.createPerIndexFileHandle(IndexComponent.POSTING_LISTS, indexContext, this::close));
            this.files.put(IndexComponent.TERMS_DATA, indexDescriptor.createPerIndexFileHandle(IndexComponent.TERMS_DATA, indexContext, this::close));
        } else {
            this.files.put(IndexComponent.BALANCED_TREE, indexDescriptor.createPerIndexFileHandle(IndexComponent.BALANCED_TREE, indexContext, this::close));
            this.files.put(IndexComponent.POSTING_LISTS, indexDescriptor.createPerIndexFileHandle(IndexComponent.POSTING_LISTS, indexContext, this::close));
        }
    }

    public FileHandle termsData() {
        return this.getFile(IndexComponent.TERMS_DATA);
    }

    public FileHandle postingLists() {
        return this.getFile(IndexComponent.POSTING_LISTS);
    }

    public FileHandle balancedTree() {
        return this.getFile(IndexComponent.BALANCED_TREE);
    }

    private FileHandle getFile(IndexComponent indexComponent) {
        FileHandle file = this.files.get((Object)indexComponent);
        if (file == null) {
            throw new IllegalArgumentException(String.format(this.indexContext.logMessage("Component %s not found for SSTable %s"), new Object[]{indexComponent, this.indexDescriptor.sstableDescriptor}));
        }
        return file.sharedCopy();
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.files.values());
    }
}

