/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TemporalType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TimeSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;

public class TimeType
extends TemporalType<Long> {
    public static final TimeType instance = new TimeType();
    private static final ArgumentDeserializer ARGUMENT_DESERIALIZER = new AbstractType.DefaultArgumentDeserializer(instance);
    private static final ByteBuffer DEFAULT_MASKED_VALUE = instance.decompose(0L);

    private TimeType() {
        super(AbstractType.ComparisonType.BYTE_ORDER);
    }

    @Override
    public boolean allowsEmpty() {
        return false;
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        return this.decompose(TimeSerializer.timeStringToLong(source));
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        return ByteSource.optionalFixedLength(accessor, data);
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        return ByteSourceInverse.getOptionalFixedLength(accessor, comparableBytes, 8);
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this == otherType || otherType == LongType.instance;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of a time value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return "\"" + TimeSerializer.instance.toString((Long)TimeSerializer.instance.deserialize(buffer)) + "\"";
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.TIME;
    }

    @Override
    public TypeSerializer<Long> getSerializer() {
        return TimeSerializer.instance;
    }

    @Override
    public ArgumentDeserializer getArgumentDeserializer() {
        return ARGUMENT_DESERIALIZER;
    }

    @Override
    public ByteBuffer now() {
        return this.decompose(LocalTime.now(ZoneOffset.UTC).toNanoOfDay());
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return DEFAULT_MASKED_VALUE;
    }
}

