/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.serializers.UUIDSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;

public class LexicalUUIDType
extends AbstractType<UUID> {
    private static final Serializer SERIALIZER = new Serializer();
    public static final LexicalUUIDType instance = new LexicalUUIDType();
    private static final ArgumentDeserializer ARGUMENT_DESERIALIZER = new AbstractType.DefaultArgumentDeserializer(instance);
    private static final ByteBuffer MASKED_VALUE = instance.decompose(UUID.fromString("00000000-0000-0000-0000-000000000000"));

    LexicalUUIDType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
            return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
        }
        return accessorL.toUUID(left).compareTo(accessorR.toUUID(right));
    }

    @Override
    public <V> ByteSource asComparableBytes(final ValueAccessor<V> accessor, final V data, ByteComparable.Version version) {
        if (data == null || accessor.isEmpty(data)) {
            return null;
        }
        return new ByteSource(){
            int bufpos = 0;

            @Override
            public int next() {
                if (this.bufpos >= accessor.size(data)) {
                    return -1;
                }
                int v = accessor.getByte(data, this.bufpos) & 0xFF;
                if (this.bufpos == 0 || this.bufpos == 8) {
                    v ^= 0x80;
                }
                ++this.bufpos;
                return v;
            }
        };
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        if (comparableBytes == null) {
            return accessor.empty();
        }
        long hiBits = ByteSourceInverse.getSignedLong(comparableBytes);
        long loBits = ByteSourceInverse.getSignedLong(comparableBytes);
        return UUIDType.makeUuidBytes(accessor, hiBits, loBits);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            return this.decompose(UUID.fromString(source));
        }
        catch (IllegalArgumentException e) {
            throw new MarshalException(String.format("unable to make UUID from '%s'", source), e);
        }
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of a uuid, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public TypeSerializer<UUID> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public ArgumentDeserializer getArgumentDeserializer() {
        return ARGUMENT_DESERIALIZER;
    }

    @Override
    public int valueLengthIfFixed() {
        return 16;
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return MASKED_VALUE;
    }

    public static class Serializer
    extends UUIDSerializer {
    }
}

