/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.serializers.EmptySerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyType
extends AbstractType<Void> {
    private static final Logger logger = LoggerFactory.getLogger(EmptyType.class);
    private static final NoSpamLogger NON_EMPTY_WRITE_LOGGER = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    private static final NonEmptyWriteBehavior NON_EMPTY_WRITE_BEHAVIOR = EmptyType.parseNonEmptyWriteBehavior();
    public static final EmptyType instance = new EmptyType();

    private static NonEmptyWriteBehavior parseNonEmptyWriteBehavior() {
        String value = CassandraRelevantProperties.SERIALIZATION_EMPTY_TYPE_NONEMPTY_BEHAVIOR.getString();
        if (value == null) {
            return NonEmptyWriteBehavior.FAIL;
        }
        try {
            return NonEmptyWriteBehavior.valueOf(value.toUpperCase().trim());
        }
        catch (Exception e) {
            logger.warn("Unable to parse property " + CassandraRelevantProperties.SERIALIZATION_EMPTY_TYPE_NONEMPTY_BEHAVIOR.getKey() + ", falling back to FAIL", (Throwable)e);
            return NonEmptyWriteBehavior.FAIL;
        }
    }

    private EmptyType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        return null;
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        return accessor.empty();
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return 0;
    }

    @Override
    public <V> String getString(V value, ValueAccessor<V> accessor) {
        return "";
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (!source.isEmpty()) {
            throw new MarshalException(String.format("'%s' is not empty", source));
        }
        return ByteBufferUtil.EMPTY_BYTE_BUFFER;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (!(parsed instanceof String)) {
            throw new MarshalException(String.format("Expected an empty string, but got: %s", parsed));
        }
        if (!((String)parsed).isEmpty()) {
            throw new MarshalException(String.format("'%s' is not empty", parsed));
        }
        return new Constants.Value(ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.EMPTY;
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return "\"\"";
    }

    @Override
    public TypeSerializer<Void> getSerializer() {
        return EmptySerializer.instance;
    }

    @Override
    public ArgumentDeserializer getArgumentDeserializer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int valueLengthIfFixed() {
        return 0;
    }

    @Override
    public <V> long writtenLength(V value, ValueAccessor<V> accessor) {
        this.validate(value, accessor);
        return 0L;
    }

    @Override
    public ByteBuffer readBuffer(DataInputPlus in) {
        return ByteBufferUtil.EMPTY_BYTE_BUFFER;
    }

    @Override
    public ByteBuffer readBuffer(DataInputPlus in, int maxValueSize) {
        return ByteBufferUtil.EMPTY_BYTE_BUFFER;
    }

    @Override
    public void writeValue(ByteBuffer value, DataOutputPlus out) {
        if (!value.hasRemaining()) {
            return;
        }
        switch (NON_EMPTY_WRITE_BEHAVIOR) {
            case LOG_DATA_LOSS: {
                NON_EMPTY_WRITE_LOGGER.warn("Dropping data...", new NonEmptyWriteException("Attempted to write a non-empty value using EmptyType"));
            }
            case SILENT_DATA_LOSS: {
                return;
            }
        }
        throw new AssertionError((Object)"Attempted to write a non-empty value using EmptyType");
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return ByteBufferUtil.EMPTY_BYTE_BUFFER;
    }

    private static final class NonEmptyWriteException
    extends RuntimeException {
        NonEmptyWriteException(String message) {
            super(message);
        }
    }

    private static enum NonEmptyWriteBehavior {
        FAIL,
        LOG_DATA_LOSS,
        SILENT_DATA_LOSS;

    }
}

