/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public class MajorLeveledCompactionWriter
extends CompactionAwareWriter {
    private final long maxSSTableSize;
    private int currentLevel = 1;
    private long averageEstimatedKeysPerSSTable;
    private long partitionsWritten = 0L;
    private long totalWrittenInLevel = 0L;
    private int sstablesWritten = 0;
    private final long keysPerSSTable;
    private final int levelFanoutSize;

    public MajorLeveledCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long maxSSTableSize) {
        this(cfs, directories, txn, nonExpiredSSTables, maxSSTableSize, false);
    }

    public MajorLeveledCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long maxSSTableSize, boolean keepOriginals) {
        super(cfs, directories, txn, nonExpiredSSTables, keepOriginals);
        this.maxSSTableSize = maxSSTableSize;
        this.levelFanoutSize = cfs.getLevelFanoutSize();
        long estimatedSSTables = Math.max(1L, SSTableReader.getTotalBytes(nonExpiredSSTables) / maxSSTableSize);
        this.keysPerSSTable = this.estimatedTotalKeys / estimatedSSTables;
    }

    @Override
    public boolean realAppend(UnfilteredRowIterator partition) {
        ++this.partitionsWritten;
        return super.realAppend(partition);
    }

    @Override
    protected boolean shouldSwitchWriterInCurrentLocation(DecoratedKey key) {
        long totalWrittenInCurrentWriter = this.sstableWriter.currentWriter().getEstimatedOnDiskBytesWritten();
        if (totalWrittenInCurrentWriter > this.maxSSTableSize) {
            this.totalWrittenInLevel += totalWrittenInCurrentWriter;
            if (this.totalWrittenInLevel > LeveledManifest.maxBytesForLevel(this.currentLevel, this.levelFanoutSize, this.maxSSTableSize)) {
                this.totalWrittenInLevel = 0L;
                ++this.currentLevel;
            }
            return true;
        }
        return false;
    }

    @Override
    public void switchCompactionWriter(Directories.DataDirectory location, DecoratedKey nextKey) {
        this.averageEstimatedKeysPerSSTable = Math.round(((double)this.averageEstimatedKeysPerSSTable * (double)this.sstablesWritten + (double)this.partitionsWritten) / (double)(this.sstablesWritten + 1));
        this.partitionsWritten = 0L;
        this.sstablesWritten = 0;
        super.switchCompactionWriter(location, nextKey);
    }

    @Override
    protected int sstableLevel() {
        return this.currentLevel;
    }

    @Override
    protected long sstableKeyCount() {
        return this.keysPerSSTable;
    }

    @Override
    protected long getExpectedWriteSize() {
        return Math.min(this.maxSSTableSize, super.getExpectedWriteSize());
    }
}

