/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.functions.masking.ColumnMask;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.cql3.statements.schema.TableAttributes;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.AlreadyExistsException;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.reads.repair.ReadRepairStrategy;
import org.apache.cassandra.transport.Event;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateTableStatement
extends AlterSchemaStatement {
    private static final Logger logger = LoggerFactory.getLogger(CreateTableStatement.class);
    private final String tableName;
    private final Map<ColumnIdentifier, ColumnProperties.Raw> rawColumns;
    private final Set<ColumnIdentifier> staticColumns;
    private final List<ColumnIdentifier> partitionKeyColumns;
    private final List<ColumnIdentifier> clusteringColumns;
    private final LinkedHashMap<ColumnIdentifier, Boolean> clusteringOrder;
    private final TableAttributes attrs;
    private final boolean ifNotExists;
    private final boolean useCompactStorage;

    public CreateTableStatement(String keyspaceName, String tableName, Map<ColumnIdentifier, ColumnProperties.Raw> rawColumns, Set<ColumnIdentifier> staticColumns, List<ColumnIdentifier> partitionKeyColumns, List<ColumnIdentifier> clusteringColumns, LinkedHashMap<ColumnIdentifier, Boolean> clusteringOrder, TableAttributes attrs, boolean ifNotExists, boolean useCompactStorage) {
        super(keyspaceName);
        this.tableName = tableName;
        this.rawColumns = rawColumns;
        this.staticColumns = staticColumns;
        this.partitionKeyColumns = partitionKeyColumns;
        this.clusteringColumns = clusteringColumns;
        this.clusteringOrder = clusteringOrder;
        this.attrs = attrs;
        this.ifNotExists = ifNotExists;
        this.useCompactStorage = useCompactStorage;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        if (null == keyspace) {
            throw CreateTableStatement.ire("Keyspace '%s' doesn't exist", this.keyspaceName);
        }
        if (keyspace.hasTable(this.tableName)) {
            if (this.ifNotExists) {
                return schema;
            }
            throw new AlreadyExistsException(this.keyspaceName, this.tableName);
        }
        TableMetadata table = this.builder(keyspace.types).build();
        table.validate();
        if (keyspace.createReplicationStrategy().hasTransientReplicas() && table.params.readRepair != ReadRepairStrategy.NONE) {
            throw CreateTableStatement.ire("read_repair must be set to 'NONE' for transiently replicated keyspaces", new Object[0]);
        }
        if (!table.params.compression.isEnabled()) {
            Guardrails.uncompressedTablesEnabled.ensureEnabled(this.state);
        }
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.tables.with(table)));
    }

    @Override
    public void validate(ClientState state) {
        super.validate(state);
        Guardrails.tableProperties.guard(this.attrs.updatedProperties(), this.attrs::removeProperty, state);
        Guardrails.columnsPerTable.guard(this.rawColumns.size(), this.tableName, false, state);
        if (Guardrails.tables.enabled(state)) {
            int totalUserTables = Schema.instance.getUserKeyspaces().stream().map(ksm -> ksm.name).map(Keyspace::open).mapToInt(keyspace -> keyspace.getColumnFamilyStores().size()).sum();
            Guardrails.tables.guard(totalUserTables + 1, this.tableName, false, state);
        }
        if (this.useCompactStorage) {
            Guardrails.compactTablesEnabled.ensureEnabled(state);
        }
        this.validateDefaultTimeToLive(this.attrs.asNewTableParams());
        this.rawColumns.forEach((name, raw) -> raw.validate(state, (ColumnIdentifier)name));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.TABLE, this.keyspaceName, this.tableName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureAllTablesPermission(this.keyspaceName, Permission.CREATE);
    }

    @Override
    Set<IResource> createdResources(Keyspaces.KeyspacesDiff diff) {
        return ImmutableSet.of((Object)DataResource.table(this.keyspaceName, this.tableName));
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.CREATE_TABLE, this.keyspaceName, this.tableName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.tableName);
    }

    public TableMetadata.Builder builder(Types types) {
        ColumnProperties properties2;
        int i;
        this.attrs.validate();
        TableParams params = this.attrs.asNewTableParams();
        TreeMap<ColumnIdentifier, ColumnProperties> columns = new TreeMap<ColumnIdentifier, ColumnProperties>(Comparator.comparing(o -> o.bytes));
        this.rawColumns.forEach((column, properties) -> columns.put((ColumnIdentifier)column, properties.prepare(this.keyspaceName, this.tableName, (ColumnIdentifier)column, types)));
        columns.forEach((column, properties) -> {
            AbstractType<?> type = properties.type;
            if (type.isUDT() && type.isMultiCell()) {
                ((UserType)type).fieldTypes().forEach(field -> {
                    if (field.isMultiCell()) {
                        throw CreateTableStatement.ire("Non-frozen UDTs with nested non-frozen collections are not supported", new Object[0]);
                    }
                });
            }
        });
        HashSet primaryKeyColumns = new HashSet();
        Iterables.concat(this.partitionKeyColumns, this.clusteringColumns).forEach(column -> {
            ColumnProperties properties = (ColumnProperties)columns.get(column);
            if (null == properties) {
                throw CreateTableStatement.ire("Unknown column '%s' referenced in PRIMARY KEY for table '%s'", column, this.tableName);
            }
            if (!primaryKeyColumns.add(column)) {
                throw CreateTableStatement.ire("Duplicate column '%s' in PRIMARY KEY clause for table '%s'", column, this.tableName);
            }
            AbstractType<?> type = properties.type;
            if (type.isMultiCell()) {
                CQL3Type cqlType = properties.cqlType;
                if (type.isCollection()) {
                    throw CreateTableStatement.ire("Invalid non-frozen collection type %s for PRIMARY KEY column '%s'", cqlType, column);
                }
                throw CreateTableStatement.ire("Invalid non-frozen user-defined type %s for PRIMARY KEY column '%s'", cqlType, column);
            }
            if (type.isCounter()) {
                throw CreateTableStatement.ire("counter type is not supported for PRIMARY KEY column '%s'", column);
            }
            if (type.referencesDuration()) {
                throw CreateTableStatement.ire("duration type is not supported for PRIMARY KEY column '%s'", column);
            }
            if (this.staticColumns.contains(column)) {
                throw CreateTableStatement.ire("Static column '%s' cannot be part of the PRIMARY KEY", column);
            }
        });
        ArrayList partitionKeyColumnProperties = new ArrayList();
        ArrayList<ColumnProperties> clusteringColumnProperties = new ArrayList<ColumnProperties>();
        this.partitionKeyColumns.forEach(column -> {
            ColumnProperties columnProperties = (ColumnProperties)columns.remove(column);
            partitionKeyColumnProperties.add(columnProperties);
        });
        this.clusteringColumns.forEach(column -> {
            ColumnProperties columnProperties = (ColumnProperties)columns.remove(column);
            boolean reverse = this.clusteringOrder.getOrDefault(column, true) == false;
            clusteringColumnProperties.add(reverse ? columnProperties.withReversedType() : columnProperties);
        });
        List nonClusterColumn = this.clusteringOrder.keySet().stream().filter(id -> !this.clusteringColumns.contains(id)).collect(Collectors.toList());
        if (!nonClusterColumn.isEmpty()) {
            throw CreateTableStatement.ire("Only clustering key columns can be defined in CLUSTERING ORDER directive: " + nonClusterColumn + " are not clustering columns", new Object[0]);
        }
        int n = 0;
        for (ColumnIdentifier id2 : this.clusteringOrder.keySet()) {
            ColumnIdentifier c2;
            if (!id2.equals(c2 = this.clusteringColumns.get(n))) {
                if (this.clusteringOrder.containsKey(c2)) {
                    throw CreateTableStatement.ire("The order of columns in the CLUSTERING ORDER directive must match that of the clustering columns (%s must appear before %s)", c2, id2);
                }
                throw CreateTableStatement.ire("Missing CLUSTERING ORDER for column %s", c2);
            }
            ++n;
        }
        if (this.useCompactStorage) {
            this.validateCompactTable(clusteringColumnProperties, columns);
        } else if (this.clusteringColumns.isEmpty() && !this.staticColumns.isEmpty()) {
            throw CreateTableStatement.ire("Static columns are only useful (and thus allowed) if the table has at least one clustering column", new Object[0]);
        }
        boolean hasCounters = this.rawColumns.values().stream().anyMatch(c -> c.rawType.isCounter());
        if (hasCounters) {
            if (columns.values().stream().anyMatch(t -> !t.type.isCounter())) {
                throw CreateTableStatement.ire("Cannot mix counter and non counter columns in the same table", new Object[0]);
            }
            if (params.defaultTimeToLive > 0) {
                throw CreateTableStatement.ire("Cannot set %s on a table with counters", new Object[]{TableParams.Option.DEFAULT_TIME_TO_LIVE});
            }
        }
        TableMetadata.Builder builder = TableMetadata.builder(this.keyspaceName, this.tableName);
        if (this.attrs.hasProperty("id")) {
            builder.id(this.attrs.getId());
        }
        builder.isCounter(hasCounters).params(params);
        for (i = 0; i < this.partitionKeyColumns.size(); ++i) {
            properties2 = (ColumnProperties)partitionKeyColumnProperties.get(i);
            builder.addPartitionKeyColumn(this.partitionKeyColumns.get(i), properties2.type, properties2.mask);
        }
        for (i = 0; i < this.clusteringColumns.size(); ++i) {
            properties2 = (ColumnProperties)clusteringColumnProperties.get(i);
            builder.addClusteringColumn(this.clusteringColumns.get(i), properties2.type, properties2.mask);
        }
        if (this.useCompactStorage) {
            this.fixupCompactTable(clusteringColumnProperties, columns, hasCounters, builder);
        } else {
            columns.forEach((column, properties) -> {
                if (this.staticColumns.contains(column)) {
                    builder.addStaticColumn((ColumnIdentifier)column, properties.type, properties.mask);
                } else {
                    builder.addRegularColumn((ColumnIdentifier)column, properties.type, properties.mask);
                }
            });
        }
        return builder;
    }

    private void validateCompactTable(List<ColumnProperties> clusteringColumnProperties, Map<ColumnIdentifier, ColumnProperties> columns) {
        boolean isDense;
        boolean bl = isDense = !clusteringColumnProperties.isEmpty();
        if (columns.values().stream().anyMatch(c -> c.type.isMultiCell())) {
            throw CreateTableStatement.ire("Non-frozen collections and UDTs are not supported with COMPACT STORAGE", new Object[0]);
        }
        if (!this.staticColumns.isEmpty()) {
            throw CreateTableStatement.ire("Static columns are not supported in COMPACT STORAGE tables", new Object[0]);
        }
        if (clusteringColumnProperties.isEmpty() && columns.isEmpty()) {
            throw CreateTableStatement.ire("No definition found that is not part of the PRIMARY KEY", new Object[0]);
        }
        if (isDense) {
            if (columns.size() > 1) {
                throw CreateTableStatement.ire(String.format("COMPACT STORAGE with composite PRIMARY KEY allows no more than one column not part of the PRIMARY KEY (got: %s)", StringUtils.join(columns.keySet(), (String)", ")), new Object[0]);
            }
        } else if (columns.isEmpty()) {
            throw CreateTableStatement.ire("COMPACT STORAGE with non-composite PRIMARY KEY require one column not part of the PRIMARY KEY, none given", new Object[0]);
        }
    }

    private void fixupCompactTable(List<ColumnProperties> clusteringTypes, Map<ColumnIdentifier, ColumnProperties> columns, boolean hasCounters, TableMetadata.Builder builder) {
        boolean isCompound;
        EnumSet<TableMetadata.Flag> flags = EnumSet.noneOf(TableMetadata.Flag.class);
        boolean isDense = !clusteringTypes.isEmpty();
        boolean bl = isCompound = clusteringTypes.size() > 1;
        if (isDense) {
            flags.add(TableMetadata.Flag.DENSE);
        }
        if (isCompound) {
            flags.add(TableMetadata.Flag.COMPOUND);
        }
        if (hasCounters) {
            flags.add(TableMetadata.Flag.COUNTER);
        }
        boolean isStaticCompact = !isDense && !isCompound;
        builder.flags(flags);
        columns.forEach((name, properties) -> {
            if (this.staticColumns.contains(name) || isStaticCompact) {
                builder.addStaticColumn((ColumnIdentifier)name, properties.type, properties.mask);
            } else {
                builder.addRegularColumn((ColumnIdentifier)name, properties.type, properties.mask);
            }
        });
        DefaultNames names = new DefaultNames(builder.columnNames());
        if (isStaticCompact) {
            builder.addClusteringColumn(names.defaultClusteringName(), UTF8Type.instance);
            builder.addRegularColumn(names.defaultCompactValueName(), hasCounters ? CounterColumnType.instance : BytesType.instance);
        } else if (!builder.hasRegularColumns()) {
            builder.addRegularColumn(names.defaultCompactValueName(), EmptyType.instance);
        }
    }

    public static TableMetadata.Builder parse(String cql, String keyspace) {
        return CQLFragmentParser.parseAny(CqlParser::createTableStatement, cql, "CREATE TABLE").keyspace(keyspace).prepare(null).builder(Types.none());
    }

    private static final class ColumnProperties {
        public final AbstractType<?> type;
        public final CQL3Type cqlType;
        @Nullable
        public final ColumnMask mask;

        public ColumnProperties(AbstractType<?> type, CQL3Type cqlType, @Nullable ColumnMask mask) {
            this.type = type;
            this.cqlType = cqlType;
            this.mask = mask;
        }

        public ColumnProperties withReversedType() {
            return new ColumnProperties(ReversedType.getInstance(this.type), this.cqlType, this.mask == null ? null : this.mask.withReversedType());
        }

        public static final class Raw {
            public final CQL3Type.Raw rawType;
            @Nullable
            public final ColumnMask.Raw rawMask;

            public Raw(CQL3Type.Raw rawType, @Nullable ColumnMask.Raw rawMask) {
                this.rawType = rawType;
                this.rawMask = rawMask;
            }

            public void validate(ClientState state, ColumnIdentifier name) {
                this.rawType.validate(state, "Column " + name);
                if (this.rawMask != null) {
                    ColumnMask.ensureEnabled();
                }
            }

            public ColumnProperties prepare(String keyspace, String table, ColumnIdentifier column, Types udts) {
                CQL3Type cqlType = this.rawType.prepare(keyspace, udts);
                AbstractType<?> type = cqlType.getType();
                ColumnMask mask = this.rawMask == null ? null : this.rawMask.prepare(keyspace, table, column, type);
                return new ColumnProperties(type, cqlType, mask);
            }
        }
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final QualifiedName name;
        private final boolean ifNotExists;
        private boolean useCompactStorage = false;
        private final Map<ColumnIdentifier, ColumnProperties.Raw> rawColumns = new HashMap<ColumnIdentifier, ColumnProperties.Raw>();
        private final Set<ColumnIdentifier> staticColumns = new HashSet<ColumnIdentifier>();
        private final List<ColumnIdentifier> clusteringColumns = new ArrayList<ColumnIdentifier>();
        private List<ColumnIdentifier> partitionKeyColumns;
        private final LinkedHashMap<ColumnIdentifier, Boolean> clusteringOrder = new LinkedHashMap();
        public final TableAttributes attrs = new TableAttributes();

        public Raw(QualifiedName name, boolean ifNotExists) {
            this.name = name;
            this.ifNotExists = ifNotExists;
        }

        @Override
        public CreateTableStatement prepare(ClientState state) {
            String keyspaceName;
            String string = keyspaceName = this.name.hasKeyspace() ? this.name.getKeyspace() : state.getKeyspace();
            if (null == this.partitionKeyColumns) {
                throw AlterSchemaStatement.ire("No PRIMARY KEY specifed for table '%s' (exactly one required)", this.name);
            }
            return new CreateTableStatement(keyspaceName, this.name.getName(), this.rawColumns, this.staticColumns, this.partitionKeyColumns, this.clusteringColumns, this.clusteringOrder, this.attrs, this.ifNotExists, this.useCompactStorage);
        }

        public String keyspace() {
            return this.name.getKeyspace();
        }

        public Raw keyspace(String keyspace) {
            this.name.setKeyspace(keyspace, true);
            return this;
        }

        public String table() {
            return this.name.getName();
        }

        public void addColumn(ColumnIdentifier column, CQL3Type.Raw type, boolean isStatic, ColumnMask.Raw mask) {
            if (null != this.rawColumns.put(column, new ColumnProperties.Raw(type, mask))) {
                throw AlterSchemaStatement.ire("Duplicate column '%s' declaration for table '%s'", column, this.name);
            }
            if (isStatic) {
                this.staticColumns.add(column);
            }
        }

        public void setCompactStorage() {
            this.useCompactStorage = true;
        }

        public void setPartitionKeyColumn(ColumnIdentifier column) {
            this.setPartitionKeyColumns(Collections.singletonList(column));
        }

        public void setPartitionKeyColumns(List<ColumnIdentifier> columns) {
            if (null != this.partitionKeyColumns) {
                throw AlterSchemaStatement.ire("Multiple PRIMARY KEY specified for table '%s' (exactly one required)", this.name);
            }
            this.partitionKeyColumns = columns;
        }

        public void markClusteringColumn(ColumnIdentifier column) {
            this.clusteringColumns.add(column);
        }

        public void extendClusteringOrder(ColumnIdentifier column, boolean ascending) {
            if (null != this.clusteringOrder.put(column, ascending)) {
                throw AlterSchemaStatement.ire("Duplicate column '%s' in CLUSTERING ORDER BY clause for table '%s'", column, this.name);
            }
        }
    }

    private static class DefaultNames {
        private static final String DEFAULT_CLUSTERING_NAME = "column";
        private static final String DEFAULT_COMPACT_VALUE_NAME = "value";
        private final Set<String> usedNames;
        private int clusteringIndex = 1;
        private int compactIndex = 0;

        private DefaultNames(Set<String> usedNames) {
            this.usedNames = usedNames;
        }

        public String defaultClusteringName() {
            String candidate;
            do {
                candidate = DEFAULT_CLUSTERING_NAME + this.clusteringIndex;
                ++this.clusteringIndex;
            } while (!this.usedNames.add(candidate));
            return candidate;
        }

        public String defaultCompactValueName() {
            String candidate;
            do {
                candidate = this.compactIndex == 0 ? DEFAULT_COMPACT_VALUE_NAME : DEFAULT_COMPACT_VALUE_NAME + this.compactIndex;
                ++this.compactIndex;
            } while (!this.usedNames.add(candidate));
            return candidate;
        }
    }
}

