/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.List;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Vectors;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.VectorType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public class ArrayLiteral
extends Term.Raw {
    private final List<Term.Raw> elements;

    public ArrayLiteral(List<Term.Raw> elements) {
        this.elements = elements;
    }

    private Term.Raw forReceiver(ColumnSpecification receiver) {
        AbstractType<?> type = receiver.type.unwrap();
        if (type instanceof VectorType) {
            return new Vectors.Literal(this.elements);
        }
        if (type instanceof ListType) {
            return new Lists.Literal(this.elements);
        }
        throw new InvalidRequestException(String.format("Unexpected receiver type '%s'; only list and vector are expected", type.asCQL3Type()));
    }

    @Override
    public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
        return this.forReceiver(receiver).prepare(keyspace, receiver);
    }

    @Override
    public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
        return this.forReceiver(receiver).testAssignment(keyspace, receiver);
    }

    @Override
    public AbstractType<?> getExactTypeIfKnown(String keyspace) {
        return null;
    }

    @Override
    public String getText() {
        return Lists.listToString(this.elements, Term.Raw::getText);
    }
}

