/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.RateLimiter;
import com.googlecode.concurrenttrees.common.Iterables;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.audit.AuditLogOptions;
import org.apache.cassandra.auth.AllowAllInternodeAuthenticator;
import org.apache.cassandra.auth.AuthConfig;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.ICIDRAuthorizer;
import org.apache.cassandra.auth.IInternodeAuthenticator;
import org.apache.cassandra.auth.INetworkAuthorizer;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationLoader;
import org.apache.cassandra.config.DataRateSpec;
import org.apache.cassandra.config.DataStorageSpec;
import org.apache.cassandra.config.DurationSpec;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.config.GuardrailsOptions;
import org.apache.cassandra.config.InheritingClass;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.config.StartupChecksOptions;
import org.apache.cassandra.config.SubnetGroups;
import org.apache.cassandra.config.YamlConfigurationLoader;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.commitlog.AbstractCommitLogSegmentManager;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegmentManagerCDC;
import org.apache.cassandra.db.commitlog.CommitLogSegmentManagerStandard;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.fql.FullQueryLoggerOptions;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.big.BigFormat;
import org.apache.cassandra.io.util.DiskOptimizationStrategy;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.PathUtils;
import org.apache.cassandra.io.util.SpinningDiskOptimizationStrategy;
import org.apache.cassandra.io.util.SsdDiskOptimizationStrategy;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.locator.EndpointSnitchInfo;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.SeedProvider;
import org.apache.cassandra.security.AbstractCryptoProvider;
import org.apache.cassandra.security.EncryptionContext;
import org.apache.cassandra.security.JREProvider;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.paxos.Paxos;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.StorageCompatibilityMode;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDescriptor {
    private static final Logger logger;
    private static final int MAX_NUM_TOKENS = 1536;
    private static Config conf;
    static final DurationSpec.LongMillisecondsBound LOWEST_ACCEPTED_TIMEOUT;
    private static Supplier<IFailureDetector> newFailureDetector;
    private static IEndpointSnitch snitch;
    private static InetAddress listenAddress;
    private static InetAddress broadcastAddress;
    private static InetAddress rpcAddress;
    private static InetAddress broadcastRpcAddress;
    private static SeedProvider seedProvider;
    private static IInternodeAuthenticator internodeAuthenticator;
    private static IPartitioner partitioner;
    private static String paritionerName;
    private static Config.DiskAccessMode indexAccessMode;
    private static AbstractCryptoProvider cryptoProvider;
    private static IAuthenticator authenticator;
    private static IAuthorizer authorizer;
    private static INetworkAuthorizer networkAuthorizer;
    private static ICIDRAuthorizer cidrAuthorizer;
    private static IRoleManager roleManager;
    private static long preparedStatementsCacheSizeInMiB;
    private static long keyCacheSizeInMiB;
    private static long paxosCacheSizeInMiB;
    private static long counterCacheSizeInMiB;
    private static long indexSummaryCapacityInMiB;
    private static String localDC;
    private static Comparator<Replica> localComparator;
    private static EncryptionContext encryptionContext;
    private static boolean hasLoggedConfig;
    private static DiskOptimizationStrategy diskOptimizationStrategy;
    private static boolean clientInitialized;
    private static boolean toolInitialized;
    private static boolean daemonInitialized;
    private static final int searchConcurrencyFactor;
    private static DurationSpec.IntSecondsBound autoSnapshoTtl;
    private static volatile boolean disableSTCSInL0;
    private static final boolean unsafeSystem;
    private static final boolean strictRuntimeChecks;
    public static volatile boolean allowUnlimitedConcurrentValidations;
    private static GuardrailsOptions guardrails;
    private static StartupChecksOptions startupChecksOptions;
    private static ImmutableMap<String, SSTableFormat<?, ?>> sstableFormats;
    private static volatile SSTableFormat<?, ?> selectedSSTableFormat;
    private static Function<CommitLog, AbstractCommitLogSegmentManager> commitLogSegmentMgrProvider;

    public static void daemonInitialization() throws ConfigurationException {
        DatabaseDescriptor.daemonInitialization(DatabaseDescriptor::loadConfig);
    }

    public static void daemonInitialization(Supplier<Config> config) throws ConfigurationException {
        if (toolInitialized) {
            throw new AssertionError((Object)"toolInitialization() already called");
        }
        if (clientInitialized) {
            throw new AssertionError((Object)"clientInitialization() already called");
        }
        if (daemonInitialized) {
            return;
        }
        daemonInitialized = true;
        DatabaseDescriptor.setConfig(config.get());
        DatabaseDescriptor.applyAll();
        AuthConfig.applyAuth();
    }

    public static void toolInitialization() {
        DatabaseDescriptor.toolInitialization(true);
    }

    public static void toolInitialization(boolean failIfDaemonOrClient) {
        if (!failIfDaemonOrClient && (daemonInitialized || clientInitialized)) {
            return;
        }
        if (daemonInitialized) {
            throw new AssertionError((Object)"daemonInitialization() already called");
        }
        if (clientInitialized) {
            throw new AssertionError((Object)"clientInitialization() already called");
        }
        if (toolInitialized) {
            return;
        }
        toolInitialized = true;
        DatabaseDescriptor.setConfig(DatabaseDescriptor.loadConfig());
        DatabaseDescriptor.applySSTableFormats();
        DatabaseDescriptor.applySimpleConfig();
        DatabaseDescriptor.applyPartitioner();
        DatabaseDescriptor.applySnitch();
        DatabaseDescriptor.applyEncryptionContext();
    }

    public static void clientInitialization() {
        DatabaseDescriptor.clientInitialization(true);
    }

    public static void clientInitialization(boolean failIfDaemonOrTool) {
        DatabaseDescriptor.clientInitialization(failIfDaemonOrTool, Config::new);
    }

    public static void clientInitialization(boolean failIfDaemonOrTool, Supplier<Config> configSupplier) {
        if (!failIfDaemonOrTool && (daemonInitialized || toolInitialized)) {
            return;
        }
        if (daemonInitialized) {
            throw new AssertionError((Object)"daemonInitialization() already called");
        }
        if (toolInitialized) {
            throw new AssertionError((Object)"toolInitialization() already called");
        }
        if (clientInitialized) {
            return;
        }
        clientInitialized = true;
        DatabaseDescriptor.setDefaultFailureDetector();
        Config.setClientMode(true);
        conf = configSupplier.get();
        diskOptimizationStrategy = new SpinningDiskOptimizationStrategy();
        DatabaseDescriptor.applySSTableFormats();
    }

    public static boolean isClientInitialized() {
        return clientInitialized;
    }

    public static boolean isToolInitialized() {
        return toolInitialized;
    }

    public static boolean isClientOrToolInitialized() {
        return clientInitialized || toolInitialized;
    }

    public static boolean isDaemonInitialized() {
        return daemonInitialized;
    }

    public static Config getRawConfig() {
        return conf;
    }

    @VisibleForTesting
    public static Config loadConfig() throws ConfigurationException {
        if (Config.getOverrideLoadConfig() != null) {
            return Config.getOverrideLoadConfig().get();
        }
        String loaderClass = CassandraRelevantProperties.CONFIG_LOADER.getString();
        ConfigurationLoader loader = loaderClass == null ? new YamlConfigurationLoader() : (ConfigurationLoader)FBUtilities.construct(loaderClass, "configuration loading");
        Config config = loader.loadConfig();
        if (!hasLoggedConfig) {
            hasLoggedConfig = true;
            Config.log(config);
        }
        return config;
    }

    private static InetAddress getNetworkInterfaceAddress(String intf, String configName, boolean preferIPv6) throws ConfigurationException {
        try {
            NetworkInterface ni = NetworkInterface.getByName(intf);
            if (ni == null) {
                throw new ConfigurationException("Configured " + configName + " \"" + intf + "\" could not be found", false);
            }
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            if (!addrs.hasMoreElements()) {
                throw new ConfigurationException("Configured " + configName + " \"" + intf + "\" was found, but had no addresses", false);
            }
            InetAddress retval = null;
            while (addrs.hasMoreElements()) {
                InetAddress temp = addrs.nextElement();
                if (preferIPv6 && temp instanceof Inet6Address) {
                    return temp;
                }
                if (!preferIPv6 && temp instanceof Inet4Address) {
                    return temp;
                }
                if (retval != null) continue;
                retval = temp;
            }
            return retval;
        }
        catch (SocketException e) {
            throw new ConfigurationException("Configured " + configName + " \"" + intf + "\" caused an exception", e);
        }
    }

    @VisibleForTesting
    public static void setConfig(Config config) {
        conf = config;
    }

    private static void applyAll() throws ConfigurationException {
        DatabaseDescriptor.applySSTableFormats();
        DatabaseDescriptor.applyCryptoProvider();
        DatabaseDescriptor.applySimpleConfig();
        DatabaseDescriptor.applyPartitioner();
        DatabaseDescriptor.applyAddressConfig();
        DatabaseDescriptor.applySnitch();
        DatabaseDescriptor.applyTokensConfig();
        DatabaseDescriptor.applySeedProvider();
        DatabaseDescriptor.applyEncryptionContext();
        DatabaseDescriptor.applySslContext();
        DatabaseDescriptor.applyGuardrails();
        DatabaseDescriptor.applyStartupChecks();
    }

    private static void applySimpleConfig() {
        int defaultSpaceInMiB;
        long totalSpaceInBytes;
        int preferredSizeInMiB;
        InetAddressAndPort.initializeDefaultPort(DatabaseDescriptor.getStoragePort());
        DatabaseDescriptor.validateUpperBoundStreamingConfig();
        if (DatabaseDescriptor.conf.auto_snapshot_ttl != null) {
            try {
                autoSnapshoTtl = new DurationSpec.IntSecondsBound(DatabaseDescriptor.conf.auto_snapshot_ttl);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Invalid value of auto_snapshot_ttl: " + DatabaseDescriptor.conf.auto_snapshot_ttl, false);
            }
        }
        if (DatabaseDescriptor.conf.commitlog_sync == null) {
            throw new ConfigurationException("Missing required directive CommitLogSync", false);
        }
        if (DatabaseDescriptor.conf.commitlog_sync == Config.CommitLogSync.batch) {
            if (DatabaseDescriptor.conf.commitlog_sync_period.toMilliseconds() != 0) {
                throw new ConfigurationException("Batch sync specified, but commitlog_sync_period found.", false);
            }
            logger.debug("Syncing log with batch mode");
        } else if (DatabaseDescriptor.conf.commitlog_sync == Config.CommitLogSync.group) {
            if (DatabaseDescriptor.conf.commitlog_sync_group_window.toMilliseconds() == 0) {
                throw new ConfigurationException("Missing value for commitlog_sync_group_window.", false);
            }
            if (DatabaseDescriptor.conf.commitlog_sync_period.toMilliseconds() != 0) {
                throw new ConfigurationException("Group sync specified, but commitlog_sync_period found. Only specify commitlog_sync_group_window when using group sync", false);
            }
            logger.debug("Syncing log with a group window of {}", (Object)DatabaseDescriptor.conf.commitlog_sync_period.toString());
        } else {
            if (DatabaseDescriptor.conf.commitlog_sync_period.toMilliseconds() == 0) {
                throw new ConfigurationException("Missing value for commitlog_sync_period.", false);
            }
            logger.debug("Syncing log with a period of {}", (Object)DatabaseDescriptor.conf.commitlog_sync_period.toString());
        }
        if (DatabaseDescriptor.conf.disk_access_mode == Config.DiskAccessMode.auto) {
            indexAccessMode = DatabaseDescriptor.conf.disk_access_mode = DatabaseDescriptor.hasLargeAddressSpace() ? Config.DiskAccessMode.mmap : Config.DiskAccessMode.standard;
            logger.info("DiskAccessMode 'auto' determined to be {}, indexAccessMode is {}", (Object)DatabaseDescriptor.conf.disk_access_mode, (Object)indexAccessMode);
        } else if (DatabaseDescriptor.conf.disk_access_mode == Config.DiskAccessMode.mmap_index_only) {
            DatabaseDescriptor.conf.disk_access_mode = Config.DiskAccessMode.standard;
            indexAccessMode = Config.DiskAccessMode.mmap;
            logger.info("DiskAccessMode is {}, indexAccessMode is {}", (Object)DatabaseDescriptor.conf.disk_access_mode, (Object)indexAccessMode);
        } else {
            indexAccessMode = DatabaseDescriptor.conf.disk_access_mode;
            logger.info("DiskAccessMode is {}, indexAccessMode is {}", (Object)DatabaseDescriptor.conf.disk_access_mode, (Object)indexAccessMode);
        }
        if (DatabaseDescriptor.conf.phi_convict_threshold < 5.0 || DatabaseDescriptor.conf.phi_convict_threshold > 16.0) {
            throw new ConfigurationException("phi_convict_threshold must be between 5 and 16, but was " + DatabaseDescriptor.conf.phi_convict_threshold, false);
        }
        if (DatabaseDescriptor.conf.concurrent_reads < 2) {
            throw new ConfigurationException("concurrent_reads must be at least 2, but was " + DatabaseDescriptor.conf.concurrent_reads, false);
        }
        if (DatabaseDescriptor.conf.concurrent_writes < 2 && CassandraRelevantProperties.TEST_FAIL_MV_LOCKS_COUNT.getString("").isEmpty()) {
            throw new ConfigurationException("concurrent_writes must be at least 2, but was " + DatabaseDescriptor.conf.concurrent_writes, false);
        }
        if (DatabaseDescriptor.conf.concurrent_counter_writes < 2) {
            throw new ConfigurationException("concurrent_counter_writes must be at least 2, but was " + DatabaseDescriptor.conf.concurrent_counter_writes, false);
        }
        if (DatabaseDescriptor.conf.concurrent_replicates != null) {
            logger.warn("concurrent_replicates has been deprecated and should be removed from cassandra.yaml");
        }
        if (DatabaseDescriptor.conf.networking_cache_size == null) {
            DatabaseDescriptor.conf.networking_cache_size = new DataStorageSpec.IntMebibytesBound(Math.min(128, (int)(Runtime.getRuntime().maxMemory() / 0x1000000L)));
        }
        if (DatabaseDescriptor.conf.file_cache_size == null) {
            DatabaseDescriptor.conf.file_cache_size = new DataStorageSpec.IntMebibytesBound(Math.min(512, (int)(Runtime.getRuntime().maxMemory() / 0x400000L)));
        }
        if (DatabaseDescriptor.conf.file_cache_round_up == null) {
            DatabaseDescriptor.conf.file_cache_round_up = DatabaseDescriptor.conf.disk_optimization_strategy == Config.DiskOptimizationStrategy.spinning;
        }
        if (DatabaseDescriptor.conf.memtable_offheap_space == null) {
            DatabaseDescriptor.conf.memtable_offheap_space = new DataStorageSpec.IntMebibytesBound((int)(Runtime.getRuntime().maxMemory() / 0x400000L));
        }
        if (DatabaseDescriptor.conf.memtable_heap_space == null) {
            DatabaseDescriptor.conf.memtable_heap_space = new DataStorageSpec.IntMebibytesBound((int)(Runtime.getRuntime().maxMemory() / 0x400000L));
        }
        if (DatabaseDescriptor.conf.memtable_heap_space.toMebibytes() == 0) {
            throw new ConfigurationException("memtable_heap_space must be positive, but was " + DatabaseDescriptor.conf.memtable_heap_space, false);
        }
        logger.info("Global memtable on-heap threshold is enabled at {}", (Object)DatabaseDescriptor.conf.memtable_heap_space);
        if (DatabaseDescriptor.conf.memtable_offheap_space.toMebibytes() == 0) {
            logger.info("Global memtable off-heap threshold is disabled, HeapAllocator will be used instead");
        } else {
            logger.info("Global memtable off-heap threshold is enabled at {}", (Object)DatabaseDescriptor.conf.memtable_offheap_space);
        }
        if (DatabaseDescriptor.conf.repair_session_max_tree_depth != null) {
            logger.warn("repair_session_max_tree_depth has been deprecated and should be removed from cassandra.yaml. Use repair_session_space instead");
            if (DatabaseDescriptor.conf.repair_session_max_tree_depth < 10) {
                throw new ConfigurationException("repair_session_max_tree_depth should not be < 10, but was " + DatabaseDescriptor.conf.repair_session_max_tree_depth);
            }
            if (DatabaseDescriptor.conf.repair_session_max_tree_depth > 20) {
                logger.warn("repair_session_max_tree_depth of " + DatabaseDescriptor.conf.repair_session_max_tree_depth + " > 20 could lead to excessive memory usage");
            }
        } else {
            DatabaseDescriptor.conf.repair_session_max_tree_depth = 20;
        }
        if (DatabaseDescriptor.conf.repair_session_space == null) {
            DatabaseDescriptor.conf.repair_session_space = new DataStorageSpec.IntMebibytesBound(Math.max(1, (int)(Runtime.getRuntime().maxMemory() / 0x1000000L)));
        }
        if (DatabaseDescriptor.conf.repair_session_space.toMebibytes() < 1) {
            throw new ConfigurationException("repair_session_space must be > 0, but was " + DatabaseDescriptor.conf.repair_session_space);
        }
        if (DatabaseDescriptor.conf.repair_session_space.toMebibytes() > (int)(Runtime.getRuntime().maxMemory() / 0x400000L)) {
            logger.warn("A repair_session_space of " + DatabaseDescriptor.conf.repair_session_space + " mebibytes is likely to cause heap pressure");
        }
        DatabaseDescriptor.checkForLowestAcceptedTimeouts(conf);
        long valueInBytes = DatabaseDescriptor.conf.native_transport_max_frame_size.toBytes();
        if (valueInBytes < 0L || valueInBytes > 0x7FFFFFFEL) {
            throw new ConfigurationException(String.format("native_transport_max_frame_size must be positive value < %dB, but was %dB", Integer.MAX_VALUE, valueInBytes), false);
        }
        if (DatabaseDescriptor.conf.column_index_size != null) {
            DatabaseDescriptor.checkValidForByteConversion(DatabaseDescriptor.conf.column_index_size, "column_index_size");
        }
        DatabaseDescriptor.checkValidForByteConversion(DatabaseDescriptor.conf.column_index_cache_size, "column_index_cache_size");
        DatabaseDescriptor.checkValidForByteConversion(DatabaseDescriptor.conf.batch_size_warn_threshold, "batch_size_warn_threshold");
        if (DatabaseDescriptor.conf.native_transport_max_negotiable_protocol_version != null) {
            logger.warn("The configuration option native_transport_max_negotiable_protocol_version has been deprecated and should be removed from cassandra.yaml as it has no longer has any effect.");
        }
        if (DatabaseDescriptor.conf.commitlog_directory == null) {
            DatabaseDescriptor.conf.commitlog_directory = DatabaseDescriptor.storagedirFor("commitlog");
        }
        if (DatabaseDescriptor.conf.hints_directory == null) {
            DatabaseDescriptor.conf.hints_directory = DatabaseDescriptor.storagedirFor("hints");
        }
        if (DatabaseDescriptor.conf.native_transport_max_request_data_in_flight == null) {
            DatabaseDescriptor.conf.native_transport_max_request_data_in_flight = new DataStorageSpec.LongBytesBound(Runtime.getRuntime().maxMemory() / 10L);
        }
        if (DatabaseDescriptor.conf.native_transport_max_request_data_in_flight_per_ip == null) {
            DatabaseDescriptor.conf.native_transport_max_request_data_in_flight_per_ip = new DataStorageSpec.LongBytesBound(Runtime.getRuntime().maxMemory() / 40L);
        }
        if (DatabaseDescriptor.conf.native_transport_rate_limiting_enabled) {
            logger.info("Native transport rate-limiting enabled at {} requests/second.", (Object)DatabaseDescriptor.conf.native_transport_max_requests_per_second);
        } else {
            logger.info("Native transport rate-limiting disabled.");
        }
        if (DatabaseDescriptor.conf.commitlog_total_space == null) {
            preferredSizeInMiB = 8192;
            totalSpaceInBytes = DatabaseDescriptor.tryGetSpace(DatabaseDescriptor.conf.commitlog_directory, FileStore::getTotalSpace);
            defaultSpaceInMiB = DatabaseDescriptor.calculateDefaultSpaceInMiB("commitlog", DatabaseDescriptor.conf.commitlog_directory, "commitlog_total_space", 8192, totalSpaceInBytes, 1L, 4L);
            DatabaseDescriptor.conf.commitlog_total_space = new DataStorageSpec.IntMebibytesBound(defaultSpaceInMiB);
        }
        if (DatabaseDescriptor.conf.cdc_enabled) {
            if (DatabaseDescriptor.conf.cdc_raw_directory == null) {
                DatabaseDescriptor.conf.cdc_raw_directory = DatabaseDescriptor.storagedirFor("cdc_raw");
            }
            if (DatabaseDescriptor.conf.cdc_total_space.toMebibytes() == 0) {
                preferredSizeInMiB = 4096;
                totalSpaceInBytes = DatabaseDescriptor.tryGetSpace(DatabaseDescriptor.conf.cdc_raw_directory, FileStore::getTotalSpace);
                defaultSpaceInMiB = DatabaseDescriptor.calculateDefaultSpaceInMiB("cdc", DatabaseDescriptor.conf.cdc_raw_directory, "cdc_total_space", 4096, totalSpaceInBytes, 1L, 8L);
                DatabaseDescriptor.conf.cdc_total_space = new DataStorageSpec.IntMebibytesBound(defaultSpaceInMiB);
            }
            logger.info("cdc_enabled is true. Starting casssandra node with Change-Data-Capture enabled.");
        }
        if (DatabaseDescriptor.conf.saved_caches_directory == null) {
            DatabaseDescriptor.conf.saved_caches_directory = DatabaseDescriptor.storagedirFor("saved_caches");
        }
        if (DatabaseDescriptor.conf.data_file_directories == null || DatabaseDescriptor.conf.data_file_directories.length == 0) {
            DatabaseDescriptor.conf.data_file_directories = new String[]{DatabaseDescriptor.storagedir("data_file_directories") + File.pathSeparator() + "data"};
        }
        long dataFreeBytes = 0L;
        for (String datadir : DatabaseDescriptor.conf.data_file_directories) {
            if (datadir == null) {
                throw new ConfigurationException("data_file_directories must not contain empty entry", false);
            }
            if (datadir.equals(DatabaseDescriptor.conf.local_system_data_file_directory)) {
                throw new ConfigurationException("local_system_data_file_directory must not be the same as any data_file_directories", false);
            }
            if (datadir.equals(DatabaseDescriptor.conf.commitlog_directory)) {
                throw new ConfigurationException("commitlog_directory must not be the same as any data_file_directories", false);
            }
            if (datadir.equals(DatabaseDescriptor.conf.hints_directory)) {
                throw new ConfigurationException("hints_directory must not be the same as any data_file_directories", false);
            }
            if (datadir.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
                throw new ConfigurationException("saved_caches_directory must not be the same as any data_file_directories", false);
            }
            dataFreeBytes = DatabaseDescriptor.saturatedSum(dataFreeBytes, DatabaseDescriptor.tryGetSpace(datadir, FileStore::getUnallocatedSpace));
        }
        if (dataFreeBytes < 0x1000000000L) {
            logger.warn("Only {} free across all data volumes. Consider adding more capacity to your cluster or removing obsolete snapshots", (Object)FBUtilities.prettyPrintMemory(dataFreeBytes));
        }
        if (DatabaseDescriptor.conf.local_system_data_file_directory != null) {
            if (DatabaseDescriptor.conf.local_system_data_file_directory.equals(DatabaseDescriptor.conf.commitlog_directory)) {
                throw new ConfigurationException("local_system_data_file_directory must not be the same as the commitlog_directory", false);
            }
            if (DatabaseDescriptor.conf.local_system_data_file_directory.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
                throw new ConfigurationException("local_system_data_file_directory must not be the same as the saved_caches_directory", false);
            }
            if (DatabaseDescriptor.conf.local_system_data_file_directory.equals(DatabaseDescriptor.conf.hints_directory)) {
                throw new ConfigurationException("local_system_data_file_directory must not be the same as the hints_directory", false);
            }
            long freeBytes = DatabaseDescriptor.tryGetSpace(DatabaseDescriptor.conf.local_system_data_file_directory, FileStore::getUnallocatedSpace);
            if (freeBytes < 0x40000000L) {
                logger.warn("Only {} free in the system data volume. Consider adding more capacity or removing obsolete snapshots", (Object)FBUtilities.prettyPrintMemory(freeBytes));
            }
        }
        if (DatabaseDescriptor.conf.commitlog_directory.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
            throw new ConfigurationException("saved_caches_directory must not be the same as the commitlog_directory", false);
        }
        if (DatabaseDescriptor.conf.commitlog_directory.equals(DatabaseDescriptor.conf.hints_directory)) {
            throw new ConfigurationException("hints_directory must not be the same as the commitlog_directory", false);
        }
        if (DatabaseDescriptor.conf.hints_directory.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
            throw new ConfigurationException("saved_caches_directory must not be the same as the hints_directory", false);
        }
        if (DatabaseDescriptor.conf.memtable_flush_writers == 0) {
            int n = DatabaseDescriptor.conf.memtable_flush_writers = DatabaseDescriptor.conf.data_file_directories.length == 1 ? 2 : 1;
        }
        if (DatabaseDescriptor.conf.memtable_flush_writers < 1) {
            throw new ConfigurationException("memtable_flush_writers must be at least 1, but was " + DatabaseDescriptor.conf.memtable_flush_writers, false);
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold == null) {
            DatabaseDescriptor.conf.memtable_cleanup_threshold = Float.valueOf((float)(1.0 / (double)(1 + DatabaseDescriptor.conf.memtable_flush_writers)));
        } else {
            logger.warn("memtable_cleanup_threshold has been deprecated and should be removed from cassandra.yaml");
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue() < 0.01f) {
            throw new ConfigurationException("memtable_cleanup_threshold must be >= 0.01, but was " + DatabaseDescriptor.conf.memtable_cleanup_threshold, false);
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue() > 0.99f) {
            throw new ConfigurationException("memtable_cleanup_threshold must be <= 0.99, but was " + DatabaseDescriptor.conf.memtable_cleanup_threshold, false);
        }
        if (DatabaseDescriptor.conf.memtable_cleanup_threshold.floatValue() < 0.1f) {
            logger.warn("memtable_cleanup_threshold is set very low [{}], which may cause performance degradation", (Object)DatabaseDescriptor.conf.memtable_cleanup_threshold);
        }
        if (DatabaseDescriptor.conf.concurrent_compactors == null) {
            DatabaseDescriptor.conf.concurrent_compactors = Math.min(8, Math.max(2, Math.min(FBUtilities.getAvailableProcessors(), DatabaseDescriptor.conf.data_file_directories.length)));
        }
        if (DatabaseDescriptor.conf.concurrent_compactors <= 0) {
            throw new ConfigurationException("concurrent_compactors should be strictly greater than 0, but was " + DatabaseDescriptor.conf.concurrent_compactors, false);
        }
        DatabaseDescriptor.applyConcurrentValidations(conf);
        DatabaseDescriptor.applyRepairCommandPoolSize(conf);
        DatabaseDescriptor.applyReadThresholdsValidations(conf);
        if (DatabaseDescriptor.conf.concurrent_materialized_view_builders <= 0) {
            throw new ConfigurationException("concurrent_materialized_view_builders should be strictly greater than 0, but was " + DatabaseDescriptor.conf.concurrent_materialized_view_builders, false);
        }
        if (DatabaseDescriptor.conf.num_tokens != null && DatabaseDescriptor.conf.num_tokens > 1536) {
            throw new ConfigurationException(String.format("A maximum number of %d tokens per node is supported", 1536), false);
        }
        try {
            long l = preparedStatementsCacheSizeInMiB = DatabaseDescriptor.conf.prepared_statements_cache_size == null ? (long)Math.max(10, (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L / 256L)) : DatabaseDescriptor.conf.prepared_statements_cache_size.toMebibytes();
            if (preparedStatementsCacheSizeInMiB == 0L) {
                throw new NumberFormatException();
            }
            DatabaseDescriptor.conf.prepared_statements_cache_size = new DataStorageSpec.LongMebibytesBound(preparedStatementsCacheSizeInMiB);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("prepared_statements_cache_size option was set incorrectly to '" + (DatabaseDescriptor.conf.prepared_statements_cache_size != null ? DatabaseDescriptor.conf.prepared_statements_cache_size.toString() : null) + "', supported values are <integer> >= 0.", false);
        }
        try {
            long l = keyCacheSizeInMiB = DatabaseDescriptor.conf.key_cache_size == null ? (long)Math.min(Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.05 / 1024.0 / 1024.0)), 100) : DatabaseDescriptor.conf.key_cache_size.toMebibytes();
            if (keyCacheSizeInMiB < 0L) {
                throw new NumberFormatException();
            }
            DatabaseDescriptor.conf.key_cache_size = new DataStorageSpec.LongMebibytesBound(keyCacheSizeInMiB);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("key_cache_size option was set incorrectly to '" + (DatabaseDescriptor.conf.key_cache_size != null ? DatabaseDescriptor.conf.key_cache_size.toString() : null) + "', supported values are <integer> >= 0.", false);
        }
        try {
            long l = counterCacheSizeInMiB = DatabaseDescriptor.conf.counter_cache_size == null ? (long)Math.min(Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.025 / 1024.0 / 1024.0)), 50) : DatabaseDescriptor.conf.counter_cache_size.toMebibytes();
            if (counterCacheSizeInMiB < 0L) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("counter_cache_size option was set incorrectly to '" + (DatabaseDescriptor.conf.counter_cache_size != null ? DatabaseDescriptor.conf.counter_cache_size.toString() : null) + "', supported values are <integer> >= 0.", false);
        }
        try {
            long l = paxosCacheSizeInMiB = DatabaseDescriptor.conf.paxos_cache_size == null ? (long)Math.min(Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.01 / 1024.0 / 1024.0)), 50) : DatabaseDescriptor.conf.paxos_cache_size.toMebibytes();
            if (paxosCacheSizeInMiB < 0L) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("paxos_cache_size option was set incorrectly to '" + DatabaseDescriptor.conf.paxos_cache_size + "', supported values are <integer> >= 0.", false);
        }
        DatabaseDescriptor.conf.counter_cache_size = new DataStorageSpec.LongMebibytesBound(counterCacheSizeInMiB);
        long l = indexSummaryCapacityInMiB = DatabaseDescriptor.conf.index_summary_capacity == null ? (long)Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.05 / 1024.0 / 1024.0)) : DatabaseDescriptor.conf.index_summary_capacity.toMebibytes();
        if (indexSummaryCapacityInMiB < 0L) {
            throw new ConfigurationException("index_summary_capacity option was set incorrectly to '" + DatabaseDescriptor.conf.index_summary_capacity.toString() + "', it should be a non-negative integer.", false);
        }
        DatabaseDescriptor.conf.index_summary_capacity = new DataStorageSpec.LongMebibytesBound(indexSummaryCapacityInMiB);
        if (DatabaseDescriptor.conf.user_defined_functions_fail_timeout.toMilliseconds() < DatabaseDescriptor.conf.user_defined_functions_warn_timeout.toMilliseconds()) {
            throw new ConfigurationException("user_defined_functions_warn_timeout must less than user_defined_function_fail_timeout", false);
        }
        if (!DatabaseDescriptor.conf.allow_insecure_udfs && !DatabaseDescriptor.conf.user_defined_functions_threads_enabled) {
            throw new ConfigurationException("To be able to set enable_user_defined_functions_threads: false you need to set allow_insecure_udfs: true - this is an unsafe configuration and is not recommended.");
        }
        if (DatabaseDescriptor.conf.allow_extra_insecure_udfs) {
            logger.warn("Allowing java.lang.System.* access in UDFs is dangerous and not recommended. Set allow_extra_insecure_udfs: false to disable.");
        }
        if (DatabaseDescriptor.conf.scripted_user_defined_functions_enabled) {
            throw new ConfigurationException("JavaScript user-defined functions were removed in CASSANDRA-18252. Hooks are planned to be introduced as part of CASSANDRA-17280");
        }
        if (DatabaseDescriptor.conf.commitlog_segment_size.toMebibytes() == 0) {
            throw new ConfigurationException("commitlog_segment_size must be positive, but was " + DatabaseDescriptor.conf.commitlog_segment_size.toString(), false);
        }
        if (DatabaseDescriptor.conf.commitlog_segment_size.toMebibytes() >= 2048) {
            throw new ConfigurationException("commitlog_segment_size must be smaller than 2048, but was " + DatabaseDescriptor.conf.commitlog_segment_size.toString(), false);
        }
        if (DatabaseDescriptor.conf.max_mutation_size == null) {
            DatabaseDescriptor.conf.max_mutation_size = new DataStorageSpec.IntKibibytesBound(DatabaseDescriptor.conf.commitlog_segment_size.toKibibytes() / 2);
        } else if (DatabaseDescriptor.conf.commitlog_segment_size.toKibibytes() < 2 * DatabaseDescriptor.conf.max_mutation_size.toKibibytes()) {
            throw new ConfigurationException("commitlog_segment_size must be at least twice the size of max_mutation_size / 1024", false);
        }
        if (DatabaseDescriptor.conf.client_encryption_options != null) {
            DatabaseDescriptor.conf.client_encryption_options.applyConfig();
            if (DatabaseDescriptor.conf.native_transport_port_ssl != null && DatabaseDescriptor.conf.native_transport_port_ssl != DatabaseDescriptor.conf.native_transport_port && DatabaseDescriptor.conf.client_encryption_options.tlsEncryptionPolicy() == EncryptionOptions.TlsEncryptionPolicy.UNENCRYPTED) {
                throw new ConfigurationException("Encryption must be enabled in client_encryption_options for native_transport_port_ssl", false);
            }
        }
        if (DatabaseDescriptor.conf.snapshot_links_per_second < 0L) {
            throw new ConfigurationException("snapshot_links_per_second must be >= 0");
        }
        if (DatabaseDescriptor.conf.max_value_size.toMebibytes() == 0) {
            throw new ConfigurationException("max_value_size must be positive", false);
        }
        if (DatabaseDescriptor.conf.max_value_size.toMebibytes() >= 2048) {
            throw new ConfigurationException("max_value_size must be smaller than 2048, but was " + DatabaseDescriptor.conf.max_value_size.toString(), false);
        }
        switch (DatabaseDescriptor.conf.disk_optimization_strategy) {
            case ssd: {
                diskOptimizationStrategy = new SsdDiskOptimizationStrategy(DatabaseDescriptor.conf.disk_optimization_page_cross_chance);
                break;
            }
            case spinning: {
                diskOptimizationStrategy = new SpinningDiskOptimizationStrategy();
            }
        }
        if (DatabaseDescriptor.conf.server_encryption_options != null) {
            DatabaseDescriptor.conf.server_encryption_options.applyConfig();
            if (DatabaseDescriptor.conf.server_encryption_options.legacy_ssl_storage_port_enabled && DatabaseDescriptor.conf.server_encryption_options.tlsEncryptionPolicy() == EncryptionOptions.TlsEncryptionPolicy.UNENCRYPTED) {
                throw new ConfigurationException("legacy_ssl_storage_port_enabled is true (enabled) with internode encryption disabled (none). Enable encryption or disable the legacy ssl storage port.");
            }
        }
        if (DatabaseDescriptor.conf.internode_max_message_size != null) {
            long maxMessageSize = DatabaseDescriptor.conf.internode_max_message_size.toBytes();
            if (maxMessageSize > (long)DatabaseDescriptor.conf.internode_application_receive_queue_reserve_endpoint_capacity.toBytes()) {
                throw new ConfigurationException("internode_max_message_size must no exceed internode_application_receive_queue_reserve_endpoint_capacity", false);
            }
            if (maxMessageSize > (long)DatabaseDescriptor.conf.internode_application_receive_queue_reserve_global_capacity.toBytes()) {
                throw new ConfigurationException("internode_max_message_size must no exceed internode_application_receive_queue_reserve_global_capacity", false);
            }
            if (maxMessageSize > (long)DatabaseDescriptor.conf.internode_application_send_queue_reserve_endpoint_capacity.toBytes()) {
                throw new ConfigurationException("internode_max_message_size must no exceed internode_application_send_queue_reserve_endpoint_capacity", false);
            }
            if (maxMessageSize > (long)DatabaseDescriptor.conf.internode_application_send_queue_reserve_global_capacity.toBytes()) {
                throw new ConfigurationException("internode_max_message_size must no exceed internode_application_send_queue_reserve_global_capacity", false);
            }
        } else {
            long maxMessageSizeInBytes = Math.min(DatabaseDescriptor.conf.internode_application_receive_queue_reserve_endpoint_capacity.toBytes(), DatabaseDescriptor.conf.internode_application_send_queue_reserve_endpoint_capacity.toBytes());
            DatabaseDescriptor.conf.internode_max_message_size = new DataStorageSpec.IntBytesBound(maxMessageSizeInBytes);
        }
        DatabaseDescriptor.validateMaxConcurrentAutoUpgradeTasksConf(DatabaseDescriptor.conf.max_concurrent_automatic_sstable_upgrades);
        if (DatabaseDescriptor.conf.default_keyspace_rf < DatabaseDescriptor.conf.minimum_replication_factor_fail_threshold) {
            throw new ConfigurationException(String.format("default_keyspace_rf (%d) cannot be less than minimum_replication_factor_fail_threshold (%d)", DatabaseDescriptor.conf.default_keyspace_rf, DatabaseDescriptor.conf.minimum_replication_factor_fail_threshold));
        }
        if (DatabaseDescriptor.conf.paxos_repair_parallelism <= 0) {
            DatabaseDescriptor.conf.paxos_repair_parallelism = Math.max(1, DatabaseDescriptor.conf.concurrent_writes / 8);
        }
        Paxos.setPaxosVariant(DatabaseDescriptor.conf.paxos_variant);
        if (DatabaseDescriptor.conf.paxos_state_purging == null) {
            DatabaseDescriptor.conf.paxos_state_purging = Config.PaxosStatePurging.legacy;
        }
        Clock.Global.logInitializationOutcome(logger);
        if (DatabaseDescriptor.conf.max_space_usable_for_compactions_in_percentage < 0.0 || DatabaseDescriptor.conf.max_space_usable_for_compactions_in_percentage > 1.0) {
            throw new ConfigurationException("max_space_usable_for_compactions_in_percentage must be between 0 and 1", false);
        }
        if (DatabaseDescriptor.conf.dump_heap_on_uncaught_exception && DatabaseDescriptor.getHeapDumpPath() == null) {
            throw new ConfigurationException(String.format("Invalid configuration. Heap dump is enabled but cannot create heap dump output path: %s.", DatabaseDescriptor.conf.heap_dump_path != null ? DatabaseDescriptor.conf.heap_dump_path : "null"));
        }
        DatabaseDescriptor.conf.sai_options.validate();
    }

    @VisibleForTesting
    static void validateUpperBoundStreamingConfig() throws ConfigurationException {
        if (DatabaseDescriptor.conf.stream_throughput_outbound.toMegabitsPerSecond() >= 2.147483647E9) {
            throw new ConfigurationException("Invalid value of stream_throughput_outbound: " + DatabaseDescriptor.conf.stream_throughput_outbound.toString(), false);
        }
        if (DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound.toMegabitsPerSecond() >= 2.147483647E9) {
            throw new ConfigurationException("Invalid value of inter_dc_stream_throughput_outbound: " + DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound.toString(), false);
        }
        if (DatabaseDescriptor.conf.entire_sstable_stream_throughput_outbound.toMebibytesPerSecond() >= 2.147483647E9) {
            throw new ConfigurationException("Invalid value of entire_sstable_stream_throughput_outbound: " + DatabaseDescriptor.conf.entire_sstable_stream_throughput_outbound.toString(), false);
        }
        if (DatabaseDescriptor.conf.entire_sstable_inter_dc_stream_throughput_outbound.toMebibytesPerSecond() >= 2.147483647E9) {
            throw new ConfigurationException("Invalid value of entire_sstable_inter_dc_stream_throughput_outbound: " + DatabaseDescriptor.conf.entire_sstable_inter_dc_stream_throughput_outbound.toString(), false);
        }
        if (DatabaseDescriptor.conf.compaction_throughput.toMebibytesPerSecond() >= 2.147483647E9) {
            throw new ConfigurationException("Invalid value of compaction_throughput: " + DatabaseDescriptor.conf.compaction_throughput.toString(), false);
        }
    }

    @VisibleForTesting
    static void applyConcurrentValidations(Config config) {
        if (config.concurrent_validations < 1) {
            config.concurrent_validations = config.concurrent_compactors;
        } else if (config.concurrent_validations > config.concurrent_compactors && !allowUnlimitedConcurrentValidations) {
            throw new ConfigurationException("To set concurrent_validations > concurrent_compactors, set the system property -D" + CassandraRelevantProperties.ALLOW_UNLIMITED_CONCURRENT_VALIDATIONS.getKey() + "=true");
        }
    }

    @VisibleForTesting
    static void applyRepairCommandPoolSize(Config config) {
        if (config.repair_command_pool_size < 1) {
            config.repair_command_pool_size = config.concurrent_validations;
        }
    }

    @VisibleForTesting
    static void applyReadThresholdsValidations(Config config) {
        DatabaseDescriptor.validateReadThresholds("coordinator_read_size", config.coordinator_read_size_warn_threshold, config.coordinator_read_size_fail_threshold);
        DatabaseDescriptor.validateReadThresholds("local_read_size", config.local_read_size_warn_threshold, config.local_read_size_fail_threshold);
        DatabaseDescriptor.validateReadThresholds("row_index_read_size", config.row_index_read_size_warn_threshold, config.row_index_read_size_fail_threshold);
    }

    private static void validateReadThresholds(String name, DataStorageSpec.LongBytesBound warn, DataStorageSpec.LongBytesBound fail) {
        if (fail != null && warn != null && fail.toBytes() < warn.toBytes()) {
            throw new ConfigurationException(String.format("%s (%s) must be greater than or equal to %s (%s)", name + "_fail_threshold", fail, name + "_warn_threshold", warn));
        }
    }

    public static GuardrailsOptions getGuardrailsConfig() {
        return guardrails;
    }

    private static void applyGuardrails() {
        try {
            guardrails = new GuardrailsOptions(conf);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Invalid guardrails configuration: " + e.getMessage(), e);
        }
    }

    public static StartupChecksOptions getStartupChecksOptions() {
        return startupChecksOptions;
    }

    private static void applyStartupChecks() {
        startupChecksOptions = new StartupChecksOptions(DatabaseDescriptor.conf.startup_checks);
    }

    private static String storagedirFor(String type) {
        return DatabaseDescriptor.storagedir(type + "_directory") + File.pathSeparator() + type;
    }

    private static String storagedir(String errMsgType) {
        String storagedir = CassandraRelevantProperties.STORAGE_DIR.getString();
        if (storagedir == null) {
            throw new ConfigurationException(errMsgType + " is missing and " + CassandraRelevantProperties.STORAGE_DIR.getKey() + " system property is not set", false);
        }
        return storagedir;
    }

    static int calculateDefaultSpaceInMiB(String type, String path, String setting, int preferredSizeInMiB, long totalSpaceInBytes, long totalSpaceNumerator, long totalSpaceDenominator) {
        long totalSizeInMiB = totalSpaceInBytes / 0x100000L;
        int minSizeInMiB = Ints.saturatedCast((long)(totalSpaceNumerator * totalSizeInMiB / totalSpaceDenominator));
        if (minSizeInMiB < preferredSizeInMiB) {
            logger.warn("Small {} volume detected at '{}'; setting {} to {}.  You can override this in cassandra.yaml", new Object[]{type, path, setting, minSizeInMiB});
            return minSizeInMiB;
        }
        return preferredSizeInMiB;
    }

    public static void applyAddressConfig() throws ConfigurationException {
        DatabaseDescriptor.applyAddressConfig(conf);
    }

    public static void applyAddressConfig(Config config) throws ConfigurationException {
        listenAddress = null;
        rpcAddress = null;
        broadcastAddress = null;
        broadcastRpcAddress = null;
        if (config.listen_address != null && config.listen_interface != null) {
            throw new ConfigurationException("Set listen_address OR listen_interface, not both", false);
        }
        if (config.listen_address != null) {
            try {
                listenAddress = InetAddress.getByName(config.listen_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown listen_address '" + config.listen_address + "'", false);
            }
            if (listenAddress.isAnyLocalAddress()) {
                throw new ConfigurationException("listen_address cannot be a wildcard address (" + config.listen_address + ")!", false);
            }
        } else if (config.listen_interface != null) {
            listenAddress = DatabaseDescriptor.getNetworkInterfaceAddress(config.listen_interface, "listen_interface", config.listen_interface_prefer_ipv6);
        }
        if (config.broadcast_address != null) {
            try {
                broadcastAddress = InetAddress.getByName(config.broadcast_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown broadcast_address '" + config.broadcast_address + "'", false);
            }
            if (broadcastAddress.isAnyLocalAddress()) {
                throw new ConfigurationException("broadcast_address cannot be a wildcard address (" + config.broadcast_address + ")!", false);
            }
        }
        if (config.rpc_address != null && config.rpc_interface != null) {
            throw new ConfigurationException("Set rpc_address OR rpc_interface, not both", false);
        }
        if (config.rpc_address != null) {
            try {
                rpcAddress = InetAddress.getByName(config.rpc_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown host in rpc_address " + config.rpc_address, false);
            }
        } else {
            rpcAddress = config.rpc_interface != null ? DatabaseDescriptor.getNetworkInterfaceAddress(config.rpc_interface, "rpc_interface", config.rpc_interface_prefer_ipv6) : FBUtilities.getJustLocalAddress();
        }
        if (config.broadcast_rpc_address != null) {
            try {
                broadcastRpcAddress = InetAddress.getByName(config.broadcast_rpc_address);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown broadcast_rpc_address '" + config.broadcast_rpc_address + "'", false);
            }
            if (broadcastRpcAddress.isAnyLocalAddress()) {
                throw new ConfigurationException("broadcast_rpc_address cannot be a wildcard address (" + config.broadcast_rpc_address + ")!", false);
            }
        } else if (rpcAddress.isAnyLocalAddress()) {
            throw new ConfigurationException("If rpc_address is set to a wildcard address (" + config.rpc_address + "), then you must set broadcast_rpc_address to a value other than " + config.rpc_address, false);
        }
    }

    public static void applyEncryptionContext() {
        encryptionContext = new EncryptionContext(DatabaseDescriptor.conf.transparent_data_encryption_options);
    }

    public static void applySslContext() {
        if (CassandraRelevantProperties.TEST_JVM_DTEST_DISABLE_SSL.getBoolean()) {
            return;
        }
        try {
            SSLFactory.validateSslContext("Internode messaging", DatabaseDescriptor.conf.server_encryption_options, true, true);
            SSLFactory.validateSslContext("Native transport", DatabaseDescriptor.conf.client_encryption_options, DatabaseDescriptor.conf.client_encryption_options.require_client_auth, true);
            SSLFactory.initHotReloading(DatabaseDescriptor.conf.server_encryption_options, DatabaseDescriptor.conf.client_encryption_options, false);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to initialize SSL", e);
        }
    }

    public static void applyCryptoProvider() {
        String classNameFromSystemProperties;
        if (CassandraRelevantProperties.TEST_SKIP_CRYPTO_PROVIDER_INSTALLATION.getBoolean()) {
            return;
        }
        if (DatabaseDescriptor.conf.crypto_provider == null) {
            DatabaseDescriptor.conf.crypto_provider = new ParameterizedClass(JREProvider.class.getName(), null);
        }
        if ((classNameFromSystemProperties = CassandraRelevantProperties.CRYPTO_PROVIDER_CLASS_NAME.getString()) != null) {
            DatabaseDescriptor.conf.crypto_provider.class_name = classNameFromSystemProperties;
        }
        if (DatabaseDescriptor.conf.crypto_provider.class_name == null) {
            throw new ConfigurationException("Failed to initialize crypto provider, class_name cannot be null");
        }
        if (DatabaseDescriptor.conf.crypto_provider.parameters == null) {
            DatabaseDescriptor.conf.crypto_provider.parameters = new HashMap<String, String>();
        }
        HashMap<String, String> cryptoProviderParameters = new HashMap<String, String>(DatabaseDescriptor.conf.crypto_provider.parameters);
        cryptoProviderParameters.putIfAbsent("fail_on_missing_provider", "false");
        try {
            cryptoProvider = FBUtilities.newCryptoProvider(DatabaseDescriptor.conf.crypto_provider.class_name, cryptoProviderParameters);
            cryptoProvider.install();
        }
        catch (Exception e) {
            if (e instanceof ConfigurationException) {
                throw (ConfigurationException)e;
            }
            throw new ConfigurationException(String.format("Failed to initialize crypto provider %s", DatabaseDescriptor.conf.crypto_provider.class_name), e);
        }
    }

    public static void applySeedProvider() {
        if (DatabaseDescriptor.conf.seed_provider == null) {
            throw new ConfigurationException("seeds configuration is missing; a minimum of one seed is required.", false);
        }
        try {
            Class<?> seedProviderClass = Class.forName(DatabaseDescriptor.conf.seed_provider.class_name);
            seedProvider = (SeedProvider)seedProviderClass.getConstructor(Map.class).newInstance(DatabaseDescriptor.conf.seed_provider.parameters);
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.", true);
        }
        if (seedProvider.getSeeds().size() == 0) {
            throw new ConfigurationException("The seed provider lists no seeds.", false);
        }
    }

    @VisibleForTesting
    static void checkForLowestAcceptedTimeouts(Config conf) {
        if (conf.read_request_timeout.toMilliseconds() < LOWEST_ACCEPTED_TIMEOUT.toMilliseconds()) {
            DatabaseDescriptor.logInfo("read_request_timeout", conf.read_request_timeout, LOWEST_ACCEPTED_TIMEOUT);
            conf.read_request_timeout = new DurationSpec.LongMillisecondsBound("10ms");
        }
        if (conf.range_request_timeout.toMilliseconds() < LOWEST_ACCEPTED_TIMEOUT.toMilliseconds()) {
            DatabaseDescriptor.logInfo("range_request_timeout", conf.range_request_timeout, LOWEST_ACCEPTED_TIMEOUT);
            conf.range_request_timeout = new DurationSpec.LongMillisecondsBound("10ms");
        }
        if (conf.request_timeout.toMilliseconds() < LOWEST_ACCEPTED_TIMEOUT.toMilliseconds()) {
            DatabaseDescriptor.logInfo("request_timeout", conf.request_timeout, LOWEST_ACCEPTED_TIMEOUT);
            conf.request_timeout = new DurationSpec.LongMillisecondsBound("10ms");
        }
        if (conf.write_request_timeout.toMilliseconds() < LOWEST_ACCEPTED_TIMEOUT.toMilliseconds()) {
            DatabaseDescriptor.logInfo("write_request_timeout", conf.write_request_timeout, LOWEST_ACCEPTED_TIMEOUT);
            conf.write_request_timeout = new DurationSpec.LongMillisecondsBound("10ms");
        }
        if (conf.cas_contention_timeout.toMilliseconds() < LOWEST_ACCEPTED_TIMEOUT.toMilliseconds()) {
            DatabaseDescriptor.logInfo("cas_contention_timeout", conf.cas_contention_timeout, LOWEST_ACCEPTED_TIMEOUT);
            conf.cas_contention_timeout = new DurationSpec.LongMillisecondsBound("10ms");
        }
        if (conf.counter_write_request_timeout.toMilliseconds() < LOWEST_ACCEPTED_TIMEOUT.toMilliseconds()) {
            DatabaseDescriptor.logInfo("counter_write_request_timeout", conf.counter_write_request_timeout, LOWEST_ACCEPTED_TIMEOUT);
            conf.counter_write_request_timeout = new DurationSpec.LongMillisecondsBound("10ms");
        }
        if (conf.truncate_request_timeout.toMilliseconds() < LOWEST_ACCEPTED_TIMEOUT.toMilliseconds()) {
            DatabaseDescriptor.logInfo("truncate_request_timeout", conf.truncate_request_timeout, LOWEST_ACCEPTED_TIMEOUT);
            conf.truncate_request_timeout = LOWEST_ACCEPTED_TIMEOUT;
        }
    }

    private static void logInfo(String property, DurationSpec.LongMillisecondsBound actualValue, DurationSpec.LongMillisecondsBound lowestAcceptedValue) {
        logger.info("found {}::{} less than lowest acceptable value {}, continuing with {}", new Object[]{property, actualValue.toString(), lowestAcceptedValue.toString(), lowestAcceptedValue});
    }

    public static void applyTokensConfig() {
        DatabaseDescriptor.applyTokensConfig(conf);
    }

    static void applyTokensConfig(Config conf) {
        if (conf.initial_token != null) {
            Collection<String> tokens = DatabaseDescriptor.tokensFromString(conf.initial_token);
            if (conf.num_tokens == null) {
                if (tokens.size() == 1) {
                    conf.num_tokens = 1;
                } else {
                    throw new ConfigurationException("initial_token was set but num_tokens is not!", false);
                }
            }
            if (tokens.size() != conf.num_tokens.intValue()) {
                throw new ConfigurationException(String.format("The number of initial tokens (by initial_token) specified (%s) is different from num_tokens value (%s)", tokens.size(), conf.num_tokens), false);
            }
            for (String token : tokens) {
                partitioner.getTokenFactory().validate(token);
            }
        } else if (conf.num_tokens == null) {
            conf.num_tokens = 1;
        }
    }

    public static void applySnitch() {
        if (DatabaseDescriptor.conf.endpoint_snitch == null) {
            throw new ConfigurationException("Missing endpoint_snitch directive", false);
        }
        snitch = DatabaseDescriptor.createEndpointSnitch(DatabaseDescriptor.conf.dynamic_snitch, DatabaseDescriptor.conf.endpoint_snitch);
        EndpointSnitchInfo.create();
        localDC = snitch.getLocalDatacenter();
        localComparator = (replica1, replica2) -> {
            boolean local1 = localDC.equals(snitch.getDatacenter((Replica)replica1));
            boolean local2 = localDC.equals(snitch.getDatacenter((Replica)replica2));
            if (local1 && !local2) {
                return -1;
            }
            if (local2 && !local1) {
                return 1;
            }
            return 0;
        };
        newFailureDetector = () -> DatabaseDescriptor.createFailureDetector(DatabaseDescriptor.conf.failure_detector);
    }

    public static void applyPartitioner() {
        DatabaseDescriptor.applyPartitioner(conf);
    }

    public static void applyPartitioner(Config conf) {
        if (conf.partitioner == null) {
            throw new ConfigurationException("Missing directive: partitioner", false);
        }
        String name = conf.partitioner;
        try {
            name = CassandraRelevantProperties.PARTITIONER.getString(conf.partitioner);
            partitioner = FBUtilities.newPartitioner(name);
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid partitioner class " + name, e);
        }
        paritionerName = partitioner.getClass().getCanonicalName();
    }

    private static void validateSSTableFormatFactories(Iterable<SSTableFormat.Factory> factories) {
        HashMap<String, SSTableFormat.Factory> factoryByName = new HashMap<String, SSTableFormat.Factory>();
        for (SSTableFormat.Factory factory : factories) {
            if (factory.name() == null) {
                throw new ConfigurationException(String.format("SSTable format name in %s cannot be null", factory.getClass().getCanonicalName()));
            }
            if (!factory.name().matches("^[a-z]+$")) {
                throw new ConfigurationException(String.format("SSTable format name for %s must be non-empty, lower-case letters only string", factory.getClass().getCanonicalName()));
            }
            SSTableFormat.Factory prev = factoryByName.put(factory.name(), factory);
            if (prev == null) continue;
            throw new ConfigurationException(String.format("Multiple sstable format implementations with the same name %s: %s and %s", factory.name(), factory.getClass().getCanonicalName(), prev.getClass().getCanonicalName()));
        }
    }

    private static ImmutableMap<String, Supplier<SSTableFormat<?, ?>>> validateAndMatchSSTableFormatOptions(Iterable<SSTableFormat.Factory> factories, Map<String, Map<String, String>> options) {
        Sets.SetView unknownFormatNames;
        ImmutableMap.Builder providersBuilder = ImmutableMap.builder();
        if (options == null) {
            options = ImmutableMap.of();
        }
        for (SSTableFormat.Factory factory : factories) {
            Map formatOptions = (Map)options.getOrDefault(factory.name(), ImmutableMap.of());
            providersBuilder.put((Object)factory.name(), () -> factory.getInstance((Map<String, String>)ImmutableMap.copyOf((Map)formatOptions)));
        }
        ImmutableMap providers = providersBuilder.build();
        if (options != null && !(unknownFormatNames = Sets.difference(options.keySet(), (Set)providers.keySet())).isEmpty()) {
            throw new ConfigurationException(String.format("Configuration contains options of unknown sstable formats: %s", unknownFormatNames));
        }
        return providers;
    }

    private static SSTableFormat<?, ?> getAndValidateWriteFormat(Map<String, SSTableFormat<?, ?>> sstableFormats, String selectedFormatName) {
        SSTableFormat<?, ?> selectedFormat;
        if (StringUtils.isBlank((CharSequence)selectedFormatName)) {
            selectedFormatName = "big";
        }
        if ((selectedFormat = sstableFormats.get(selectedFormatName)) == null) {
            throw new ConfigurationException(String.format("Selected sstable format '%s' is not available.", selectedFormatName));
        }
        DatabaseDescriptor.getStorageCompatibilityMode().validateSstableFormat(selectedFormat);
        return selectedFormat;
    }

    private static void applySSTableFormats() {
        ServiceLoader<SSTableFormat.Factory> loader = ServiceLoader.load(SSTableFormat.Factory.class, DatabaseDescriptor.class.getClassLoader());
        List factories = Iterables.toList(loader);
        if (factories.isEmpty()) {
            factories = ImmutableList.of((Object)new BigFormat.BigFormatFactory());
        }
        DatabaseDescriptor.applySSTableFormats(factories, DatabaseDescriptor.conf.sstable);
    }

    private static void applySSTableFormats(Iterable<SSTableFormat.Factory> factories, Config.SSTableConfig sstableFormatsConfig) {
        if (sstableFormats != null) {
            return;
        }
        DatabaseDescriptor.validateSSTableFormatFactories(factories);
        ImmutableMap<String, Supplier<SSTableFormat<?, ?>>> providers = DatabaseDescriptor.validateAndMatchSSTableFormatOptions(factories, sstableFormatsConfig.format);
        ImmutableMap.Builder sstableFormatsBuilder = ImmutableMap.builder();
        providers.forEach((name, provider) -> {
            try {
                sstableFormatsBuilder.put(name, (Object)((SSTableFormat)provider.get()));
            }
            catch (Error | RuntimeException ex) {
                throw new ConfigurationException(String.format("Failed to instantiate sstable format '%s'", name), ex);
            }
        });
        sstableFormats = sstableFormatsBuilder.build();
        selectedSSTableFormat = DatabaseDescriptor.getAndValidateWriteFormat(sstableFormats, sstableFormatsConfig.selected_format);
        sstableFormats.values().forEach(SSTableFormat::allComponents);
        logger.info("Supported sstable formats are: {}", (Object)sstableFormats.values().stream().map(f -> f.name() + " -> " + f.getClass().getName() + " with singleton components: " + f.allComponents()).collect(Collectors.joining(", ")));
    }

    private static long saturatedSum(long left, long right) {
        assert (left >= 0L && right >= 0L);
        long sum = left + right;
        return sum < 0L ? Long.MAX_VALUE : sum;
    }

    private static long tryGetSpace(String dir, PathUtils.IOToLongFunction<FileStore> getSpace) {
        return PathUtils.tryGetSpace(new File(dir).toPath(), getSpace, e -> {
            throw new ConfigurationException("Unable check disk space in '" + dir + "'. Perhaps the Cassandra user does not have the necessary permissions");
        });
    }

    public static IEndpointSnitch createEndpointSnitch(boolean dynamic, String snitchClassName) throws ConfigurationException {
        if (!((String)snitchClassName).contains(".")) {
            snitchClassName = "org.apache.cassandra.locator." + (String)snitchClassName;
        }
        IEndpointSnitch snitch = (IEndpointSnitch)FBUtilities.construct((String)snitchClassName, "snitch");
        return dynamic ? new DynamicEndpointSnitch(snitch) : snitch;
    }

    private static IFailureDetector createFailureDetector(String detectorClassName) throws ConfigurationException {
        if (!((String)detectorClassName).contains(".")) {
            detectorClassName = "org.apache.cassandra.gms." + (String)detectorClassName;
        }
        IFailureDetector detector = (IFailureDetector)FBUtilities.construct((String)detectorClassName, "failure detector");
        return detector;
    }

    public static AbstractCryptoProvider getCryptoProvider() {
        return cryptoProvider;
    }

    public static void setCryptoProvider(AbstractCryptoProvider cryptoProvider) {
        DatabaseDescriptor.cryptoProvider = cryptoProvider;
    }

    public static IAuthenticator getAuthenticator() {
        return authenticator;
    }

    public static void setAuthenticator(IAuthenticator authenticator) {
        DatabaseDescriptor.authenticator = authenticator;
    }

    public static IAuthorizer getAuthorizer() {
        return authorizer;
    }

    public static void setAuthorizer(IAuthorizer authorizer) {
        DatabaseDescriptor.authorizer = authorizer;
    }

    public static INetworkAuthorizer getNetworkAuthorizer() {
        return networkAuthorizer;
    }

    public static void setNetworkAuthorizer(INetworkAuthorizer networkAuthorizer) {
        DatabaseDescriptor.networkAuthorizer = networkAuthorizer;
    }

    public static ICIDRAuthorizer getCIDRAuthorizer() {
        return cidrAuthorizer;
    }

    public static void setCIDRAuthorizer(ICIDRAuthorizer cidrAuthorizer) {
        DatabaseDescriptor.cidrAuthorizer = cidrAuthorizer;
    }

    public static boolean getCidrChecksForSuperusers() {
        boolean defaultCidrChecksForSuperusers = false;
        if (DatabaseDescriptor.conf.cidr_authorizer == null || DatabaseDescriptor.conf.cidr_authorizer.parameters == null) {
            return defaultCidrChecksForSuperusers;
        }
        String value = DatabaseDescriptor.conf.cidr_authorizer.parameters.get("cidr_checks_for_superusers");
        if (value == null || value.isEmpty()) {
            return defaultCidrChecksForSuperusers;
        }
        return Boolean.parseBoolean(value);
    }

    public static ICIDRAuthorizer.CIDRAuthorizerMode getCidrAuthorizerMode() {
        ICIDRAuthorizer.CIDRAuthorizerMode defaultCidrAuthorizerMode = ICIDRAuthorizer.CIDRAuthorizerMode.MONITOR;
        if (DatabaseDescriptor.conf.cidr_authorizer == null || DatabaseDescriptor.conf.cidr_authorizer.parameters == null) {
            return defaultCidrAuthorizerMode;
        }
        String cidrAuthorizerMode = DatabaseDescriptor.conf.cidr_authorizer.parameters.get("cidr_authorizer_mode");
        if (cidrAuthorizerMode == null || cidrAuthorizerMode.isEmpty()) {
            return defaultCidrAuthorizerMode;
        }
        return ICIDRAuthorizer.CIDRAuthorizerMode.valueOf(cidrAuthorizerMode.toUpperCase());
    }

    public static int getCidrGroupsCacheRefreshInterval() {
        int defaultCidrGroupsCacheRefreshInterval = 5;
        if (DatabaseDescriptor.conf.cidr_authorizer == null || DatabaseDescriptor.conf.cidr_authorizer.parameters == null) {
            return defaultCidrGroupsCacheRefreshInterval;
        }
        String cidrGroupsCacheRefreshInterval = DatabaseDescriptor.conf.cidr_authorizer.parameters.get("cidr_groups_cache_refresh_interval");
        if (cidrGroupsCacheRefreshInterval == null || cidrGroupsCacheRefreshInterval.isEmpty()) {
            return defaultCidrGroupsCacheRefreshInterval;
        }
        return Integer.parseInt(cidrGroupsCacheRefreshInterval);
    }

    public static int getIpCacheMaxSize() {
        int defaultIpCacheMaxSize = 100;
        if (DatabaseDescriptor.conf.cidr_authorizer == null || DatabaseDescriptor.conf.cidr_authorizer.parameters == null) {
            return defaultIpCacheMaxSize;
        }
        String ipCacheMaxSize = DatabaseDescriptor.conf.cidr_authorizer.parameters.get("ip_cache_max_size");
        if (ipCacheMaxSize == null || ipCacheMaxSize.isEmpty()) {
            return defaultIpCacheMaxSize;
        }
        return Integer.parseInt(ipCacheMaxSize);
    }

    public static void setAuthFromRoot(boolean fromRoot) {
        DatabaseDescriptor.conf.traverse_auth_from_root = fromRoot;
    }

    public static boolean getAuthFromRoot() {
        return DatabaseDescriptor.conf.traverse_auth_from_root;
    }

    public static IRoleManager getRoleManager() {
        return roleManager;
    }

    public static void setRoleManager(IRoleManager roleManager) {
        DatabaseDescriptor.roleManager = roleManager;
    }

    public static int getPermissionsValidity() {
        return DatabaseDescriptor.conf.permissions_validity.toMilliseconds();
    }

    public static void setPermissionsValidity(int timeout) {
        DatabaseDescriptor.conf.permissions_validity = new DurationSpec.IntMillisecondsBound(timeout);
    }

    public static int getPermissionsUpdateInterval() {
        return DatabaseDescriptor.conf.permissions_update_interval == null ? DatabaseDescriptor.conf.permissions_validity.toMilliseconds() : DatabaseDescriptor.conf.permissions_update_interval.toMilliseconds();
    }

    public static void setPermissionsUpdateInterval(int updateInterval) {
        DatabaseDescriptor.conf.permissions_update_interval = updateInterval == -1 ? null : new DurationSpec.IntMillisecondsBound(updateInterval);
    }

    public static int getPermissionsCacheMaxEntries() {
        return DatabaseDescriptor.conf.permissions_cache_max_entries;
    }

    public static int setPermissionsCacheMaxEntries(int maxEntries) {
        DatabaseDescriptor.conf.permissions_cache_max_entries = maxEntries;
        return DatabaseDescriptor.conf.permissions_cache_max_entries;
    }

    public static boolean getPermissionsCacheActiveUpdate() {
        return DatabaseDescriptor.conf.permissions_cache_active_update;
    }

    public static void setPermissionsCacheActiveUpdate(boolean update) {
        DatabaseDescriptor.conf.permissions_cache_active_update = update;
    }

    public static int getRolesValidity() {
        return DatabaseDescriptor.conf.roles_validity.toMilliseconds();
    }

    public static void setRolesValidity(int validity) {
        DatabaseDescriptor.conf.roles_validity = new DurationSpec.IntMillisecondsBound(validity);
    }

    public static int getRolesUpdateInterval() {
        return DatabaseDescriptor.conf.roles_update_interval == null ? DatabaseDescriptor.conf.roles_validity.toMilliseconds() : DatabaseDescriptor.conf.roles_update_interval.toMilliseconds();
    }

    public static void setRolesCacheActiveUpdate(boolean update) {
        DatabaseDescriptor.conf.roles_cache_active_update = update;
    }

    public static boolean getRolesCacheActiveUpdate() {
        return DatabaseDescriptor.conf.roles_cache_active_update;
    }

    public static void setRolesUpdateInterval(int interval) {
        DatabaseDescriptor.conf.roles_update_interval = interval == -1 ? null : new DurationSpec.IntMillisecondsBound(interval);
    }

    public static int getRolesCacheMaxEntries() {
        return DatabaseDescriptor.conf.roles_cache_max_entries;
    }

    public static int setRolesCacheMaxEntries(int maxEntries) {
        DatabaseDescriptor.conf.roles_cache_max_entries = maxEntries;
        return DatabaseDescriptor.conf.roles_cache_max_entries;
    }

    public static int getCredentialsValidity() {
        return DatabaseDescriptor.conf.credentials_validity.toMilliseconds();
    }

    public static void setCredentialsValidity(int timeout) {
        DatabaseDescriptor.conf.credentials_validity = new DurationSpec.IntMillisecondsBound(timeout);
    }

    public static int getCredentialsUpdateInterval() {
        return DatabaseDescriptor.conf.credentials_update_interval == null ? DatabaseDescriptor.conf.credentials_validity.toMilliseconds() : DatabaseDescriptor.conf.credentials_update_interval.toMilliseconds();
    }

    public static void setCredentialsUpdateInterval(int updateInterval) {
        DatabaseDescriptor.conf.credentials_update_interval = updateInterval == -1 ? null : new DurationSpec.IntMillisecondsBound(updateInterval);
    }

    public static int getCredentialsCacheMaxEntries() {
        return DatabaseDescriptor.conf.credentials_cache_max_entries;
    }

    public static int setCredentialsCacheMaxEntries(int maxEntries) {
        DatabaseDescriptor.conf.credentials_cache_max_entries = maxEntries;
        return DatabaseDescriptor.conf.credentials_cache_max_entries;
    }

    public static boolean getCredentialsCacheActiveUpdate() {
        return DatabaseDescriptor.conf.credentials_cache_active_update;
    }

    public static void setCredentialsCacheActiveUpdate(boolean update) {
        DatabaseDescriptor.conf.credentials_cache_active_update = update;
    }

    public static int getMaxValueSize() {
        return Ints.saturatedCast((long)((long)DatabaseDescriptor.conf.max_value_size.toMebibytes() * 1024L * 1024L));
    }

    public static void setMaxValueSize(int maxValueSizeInBytes) {
        DatabaseDescriptor.conf.max_value_size = new DataStorageSpec.IntMebibytesBound((long)maxValueSizeInBytes / 0x100000L, DataStorageSpec.DataStorageUnit.MEBIBYTES);
    }

    public static void createAllDirectories() {
        try {
            boolean created;
            if (DatabaseDescriptor.conf.data_file_directories.length == 0) {
                throw new ConfigurationException("At least one DataFileDirectory must be specified", false);
            }
            for (String dataFileDirectory : DatabaseDescriptor.conf.data_file_directories) {
                FileUtils.createDirectory(dataFileDirectory);
            }
            if (DatabaseDescriptor.conf.local_system_data_file_directory != null) {
                FileUtils.createDirectory(DatabaseDescriptor.conf.local_system_data_file_directory);
            }
            if (DatabaseDescriptor.conf.commitlog_directory == null) {
                throw new ConfigurationException("commitlog_directory must be specified", false);
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.commitlog_directory);
            if (DatabaseDescriptor.conf.hints_directory == null) {
                throw new ConfigurationException("hints_directory must be specified", false);
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.hints_directory);
            if (DatabaseDescriptor.conf.saved_caches_directory == null) {
                throw new ConfigurationException("saved_caches_directory must be specified", false);
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.saved_caches_directory);
            if (DatabaseDescriptor.conf.cdc_enabled) {
                if (DatabaseDescriptor.conf.cdc_raw_directory == null) {
                    throw new ConfigurationException("cdc_raw_directory must be specified", false);
                }
                FileUtils.createDirectory(DatabaseDescriptor.conf.cdc_raw_directory);
            }
            if (!(created = DatabaseDescriptor.maybeCreateHeapDumpPath()) && DatabaseDescriptor.conf.dump_heap_on_uncaught_exception) {
                logger.error(String.format("cassandra.yaml:dump_heap_on_uncaught_exception is enabled but unable to create heap dump path %s. Disabling.", DatabaseDescriptor.conf.heap_dump_path != null ? DatabaseDescriptor.conf.heap_dump_path : "null"));
                DatabaseDescriptor.conf.dump_heap_on_uncaught_exception = false;
            }
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Bad configuration; unable to start server: " + e.getMessage());
        }
        catch (FSWriteError e) {
            throw new IllegalStateException(e.getCause().getMessage() + "; unable to start server");
        }
    }

    public static IPartitioner getPartitioner() {
        return partitioner;
    }

    public static String getPartitionerName() {
        return paritionerName;
    }

    public static IPartitioner setPartitionerUnsafe(IPartitioner newPartitioner) {
        IPartitioner old = partitioner;
        partitioner = newPartitioner;
        return old;
    }

    public static IEndpointSnitch getEndpointSnitch() {
        return snitch;
    }

    public static void setEndpointSnitch(IEndpointSnitch eps) {
        snitch = eps;
    }

    public static IFailureDetector newFailureDetector() {
        return newFailureDetector.get();
    }

    public static void setDefaultFailureDetector() {
        newFailureDetector = () -> DatabaseDescriptor.createFailureDetector("FailureDetector");
    }

    public static int getColumnIndexSize(int defaultValue) {
        return DatabaseDescriptor.conf.column_index_size != null ? DatabaseDescriptor.conf.column_index_size.toBytes() : defaultValue;
    }

    public static int getColumnIndexSizeInKiB() {
        return DatabaseDescriptor.conf.column_index_size != null ? DatabaseDescriptor.conf.column_index_size.toKibibytes() : -1;
    }

    public static void setColumnIndexSizeInKiB(int val) {
        DatabaseDescriptor.conf.column_index_size = val != -1 ? DatabaseDescriptor.createIntKibibyteBoundAndEnsureItIsValidForByteConversion(val, "column_index_size") : null;
    }

    public static int getColumnIndexCacheSize() {
        return DatabaseDescriptor.conf.column_index_cache_size.toBytes();
    }

    public static int getColumnIndexCacheSizeInKiB() {
        return DatabaseDescriptor.conf.column_index_cache_size.toKibibytes();
    }

    public static void setColumnIndexCacheSize(int val) {
        DatabaseDescriptor.conf.column_index_cache_size = DatabaseDescriptor.createIntKibibyteBoundAndEnsureItIsValidForByteConversion(val, "column_index_cache_size");
    }

    public static int getBatchSizeWarnThreshold() {
        return DatabaseDescriptor.conf.batch_size_warn_threshold.toBytes();
    }

    public static int getBatchSizeWarnThresholdInKiB() {
        return DatabaseDescriptor.conf.batch_size_warn_threshold.toKibibytes();
    }

    public static long getBatchSizeFailThreshold() {
        return DatabaseDescriptor.conf.batch_size_fail_threshold.toBytesInLong();
    }

    public static int getBatchSizeFailThresholdInKiB() {
        return DatabaseDescriptor.conf.batch_size_fail_threshold.toKibibytes();
    }

    public static int getUnloggedBatchAcrossPartitionsWarnThreshold() {
        return DatabaseDescriptor.conf.unlogged_batch_across_partitions_warn_threshold;
    }

    public static void setBatchSizeWarnThresholdInKiB(int threshold) {
        DatabaseDescriptor.conf.batch_size_warn_threshold = DatabaseDescriptor.createIntKibibyteBoundAndEnsureItIsValidForByteConversion(threshold, "batch_size_warn_threshold");
    }

    public static void setBatchSizeFailThresholdInKiB(int threshold) {
        DatabaseDescriptor.conf.batch_size_fail_threshold = new DataStorageSpec.IntKibibytesBound(threshold);
    }

    public static Collection<String> getInitialTokens() {
        return DatabaseDescriptor.tokensFromString(CassandraRelevantProperties.INITIAL_TOKEN.getString(DatabaseDescriptor.conf.initial_token));
    }

    public static String getAllocateTokensForKeyspace() {
        return CassandraRelevantProperties.ALLOCATE_TOKENS_FOR_KEYSPACE.getString(DatabaseDescriptor.conf.allocate_tokens_for_keyspace);
    }

    public static Integer getAllocateTokensForLocalRf() {
        return DatabaseDescriptor.conf.allocate_tokens_for_local_replication_factor;
    }

    public static Collection<String> tokensFromString(String tokenString) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (tokenString != null) {
            for (String token : StringUtils.split((String)tokenString, (char)',')) {
                tokens.add(token.trim());
            }
        }
        return tokens;
    }

    public static int getNumTokens() {
        return DatabaseDescriptor.conf.num_tokens;
    }

    public static InetAddressAndPort getReplaceAddress() {
        try {
            String replaceAddress = CassandraRelevantProperties.REPLACE_ADDRESS.getString();
            if (replaceAddress != null) {
                return InetAddressAndPort.getByName(replaceAddress);
            }
            String replaceAddressFirsstBoot = CassandraRelevantProperties.REPLACE_ADDRESS_FIRST_BOOT.getString();
            if (replaceAddressFirsstBoot != null) {
                return InetAddressAndPort.getByName(replaceAddressFirsstBoot);
            }
            return null;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Replacement host name could not be resolved or scope_id was specified for a global IPv6 address", e);
        }
    }

    public static Collection<String> getReplaceTokens() {
        return DatabaseDescriptor.tokensFromString(CassandraRelevantProperties.REPLACE_TOKEN.getString());
    }

    public static UUID getReplaceNode() {
        try {
            return UUID.fromString(CassandraRelevantProperties.REPLACE_NODE.getString());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static String getClusterName() {
        return DatabaseDescriptor.conf.cluster_name;
    }

    public static int getStoragePort() {
        return CassandraRelevantProperties.STORAGE_PORT.getInt(DatabaseDescriptor.conf.storage_port);
    }

    public static int getSSLStoragePort() {
        return CassandraRelevantProperties.SSL_STORAGE_PORT.getInt(DatabaseDescriptor.conf.ssl_storage_port);
    }

    public static long nativeTransportIdleTimeout() {
        return DatabaseDescriptor.conf.native_transport_idle_timeout.toMilliseconds();
    }

    public static void setNativeTransportIdleTimeout(long nativeTransportTimeout) {
        DatabaseDescriptor.conf.native_transport_idle_timeout = new DurationSpec.LongMillisecondsBound(nativeTransportTimeout);
    }

    public static long getRpcTimeout(TimeUnit unit) {
        return DatabaseDescriptor.conf.request_timeout.to(unit);
    }

    public static void setRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.request_timeout = new DurationSpec.LongMillisecondsBound(timeOutInMillis);
    }

    public static long getReadRpcTimeout(TimeUnit unit) {
        return DatabaseDescriptor.conf.read_request_timeout.to(unit);
    }

    public static void setReadRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.read_request_timeout = new DurationSpec.LongMillisecondsBound(timeOutInMillis);
    }

    public static long getRangeRpcTimeout(TimeUnit unit) {
        return DatabaseDescriptor.conf.range_request_timeout.to(unit);
    }

    public static void setRangeRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.range_request_timeout = new DurationSpec.LongMillisecondsBound(timeOutInMillis);
    }

    public static long getWriteRpcTimeout(TimeUnit unit) {
        return DatabaseDescriptor.conf.write_request_timeout.to(unit);
    }

    public static void setWriteRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.write_request_timeout = new DurationSpec.LongMillisecondsBound(timeOutInMillis);
    }

    public static long getCounterWriteRpcTimeout(TimeUnit unit) {
        return DatabaseDescriptor.conf.counter_write_request_timeout.to(unit);
    }

    public static void setCounterWriteRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.counter_write_request_timeout = new DurationSpec.LongMillisecondsBound(timeOutInMillis);
    }

    public static long getCasContentionTimeout(TimeUnit unit) {
        return DatabaseDescriptor.conf.cas_contention_timeout.to(unit);
    }

    public static void setCasContentionTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.cas_contention_timeout = new DurationSpec.LongMillisecondsBound(timeOutInMillis);
    }

    public static long getTruncateRpcTimeout(TimeUnit unit) {
        return DatabaseDescriptor.conf.truncate_request_timeout.to(unit);
    }

    public static void setTruncateRpcTimeout(long timeOutInMillis) {
        DatabaseDescriptor.conf.truncate_request_timeout = new DurationSpec.LongMillisecondsBound(timeOutInMillis);
    }

    public static long getRepairRpcTimeout(TimeUnit unit) {
        return DatabaseDescriptor.conf.repair_request_timeout.to(unit);
    }

    public static void setRepairRpcTimeout(Long timeOutInMillis) {
        DatabaseDescriptor.conf.repair_request_timeout = new DurationSpec.LongMillisecondsBound(timeOutInMillis);
    }

    public static boolean hasCrossNodeTimeout() {
        return DatabaseDescriptor.conf.internode_timeout;
    }

    public static void setCrossNodeTimeout(boolean crossNodeTimeout) {
        DatabaseDescriptor.conf.internode_timeout = crossNodeTimeout;
    }

    public static long getSlowQueryTimeout(TimeUnit unit) {
        return DatabaseDescriptor.conf.slow_query_log_timeout.to(unit);
    }

    public static long getMinRpcTimeout(TimeUnit unit) {
        return Longs.min((long[])new long[]{DatabaseDescriptor.getRpcTimeout(unit), DatabaseDescriptor.getReadRpcTimeout(unit), DatabaseDescriptor.getRangeRpcTimeout(unit), DatabaseDescriptor.getWriteRpcTimeout(unit), DatabaseDescriptor.getCounterWriteRpcTimeout(unit), DatabaseDescriptor.getTruncateRpcTimeout(unit)});
    }

    public static long getPingTimeout(TimeUnit unit) {
        return unit.convert(DatabaseDescriptor.getBlockForPeersTimeoutInSeconds(), TimeUnit.SECONDS);
    }

    public static double getPhiConvictThreshold() {
        return DatabaseDescriptor.conf.phi_convict_threshold;
    }

    public static void setPhiConvictThreshold(double phiConvictThreshold) {
        DatabaseDescriptor.conf.phi_convict_threshold = phiConvictThreshold;
    }

    public static int getConcurrentReaders() {
        return DatabaseDescriptor.conf.concurrent_reads;
    }

    public static void setConcurrentReaders(int concurrent_reads) {
        if (concurrent_reads < 0) {
            throw new IllegalArgumentException("Concurrent reads must be non-negative");
        }
        DatabaseDescriptor.conf.concurrent_reads = concurrent_reads;
    }

    public static int getConcurrentWriters() {
        return DatabaseDescriptor.conf.concurrent_writes;
    }

    public static void setConcurrentWriters(int concurrent_writers) {
        if (concurrent_writers < 0) {
            throw new IllegalArgumentException("Concurrent reads must be non-negative");
        }
        DatabaseDescriptor.conf.concurrent_writes = concurrent_writers;
    }

    public static int getConcurrentCounterWriters() {
        return DatabaseDescriptor.conf.concurrent_counter_writes;
    }

    public static void setConcurrentCounterWriters(int concurrent_counter_writes) {
        if (concurrent_counter_writes < 0) {
            throw new IllegalArgumentException("Concurrent reads must be non-negative");
        }
        DatabaseDescriptor.conf.concurrent_counter_writes = concurrent_counter_writes;
    }

    public static int getConcurrentViewWriters() {
        return DatabaseDescriptor.conf.concurrent_materialized_view_writes;
    }

    public static void setConcurrentViewWriters(int concurrent_materialized_view_writes) {
        if (concurrent_materialized_view_writes < 0) {
            throw new IllegalArgumentException("Concurrent reads must be non-negative");
        }
        DatabaseDescriptor.conf.concurrent_materialized_view_writes = concurrent_materialized_view_writes;
    }

    public static int getFlushWriters() {
        return DatabaseDescriptor.conf.memtable_flush_writers;
    }

    public static int getAvailableProcessors() {
        return conf == null ? -1 : DatabaseDescriptor.conf.available_processors;
    }

    public static int getConcurrentCompactors() {
        return DatabaseDescriptor.conf.concurrent_compactors;
    }

    public static void setConcurrentCompactors(int value) {
        DatabaseDescriptor.conf.concurrent_compactors = value;
    }

    public static int getCompactionThroughputMebibytesPerSecAsInt() {
        return DatabaseDescriptor.conf.compaction_throughput.toMebibytesPerSecondAsInt();
    }

    public static double getCompactionThroughputBytesPerSec() {
        return DatabaseDescriptor.conf.compaction_throughput.toBytesPerSecond();
    }

    public static double getCompactionThroughputMebibytesPerSec() {
        return DatabaseDescriptor.conf.compaction_throughput.toMebibytesPerSecond();
    }

    @VisibleForTesting
    public static void setCompactionThroughputBytesPerSec(int value) {
        if (DataRateSpec.DataRateUnit.BYTES_PER_SECOND.toMebibytesPerSecond(value) >= 2.147483647E9) {
            throw new IllegalArgumentException("compaction_throughput: " + value + " is too large; it should be less than 2147483647 in MiB/s");
        }
        DatabaseDescriptor.conf.compaction_throughput = new DataRateSpec.LongBytesPerSecondBound(value);
    }

    public static void setCompactionThroughputMebibytesPerSec(int value) {
        if (value == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("compaction_throughput: " + value + " is too large; it should be less than 2147483647 in MiB/s");
        }
        DatabaseDescriptor.conf.compaction_throughput = new DataRateSpec.LongBytesPerSecondBound(value, DataRateSpec.DataRateUnit.MEBIBYTES_PER_SECOND);
    }

    public static int getConcurrentValidations() {
        return DatabaseDescriptor.conf.concurrent_validations;
    }

    public static int getConcurrentIndexBuilders() {
        return DatabaseDescriptor.conf.concurrent_index_builders;
    }

    public static void setConcurrentValidations(int value) {
        DatabaseDescriptor.conf.concurrent_validations = value = value > 0 ? value : Integer.MAX_VALUE;
    }

    public static int getConcurrentViewBuilders() {
        return DatabaseDescriptor.conf.concurrent_materialized_view_builders;
    }

    public static void setConcurrentViewBuilders(int value) {
        DatabaseDescriptor.conf.concurrent_materialized_view_builders = value;
    }

    public static long getMinFreeSpacePerDriveInMebibytes() {
        return DatabaseDescriptor.conf.min_free_space_per_drive.toMebibytes();
    }

    public static long getMinFreeSpacePerDriveInBytes() {
        return DatabaseDescriptor.conf.min_free_space_per_drive.toBytesInLong();
    }

    @VisibleForTesting
    public static long setMinFreeSpacePerDriveInMebibytes(long mebiBytes) {
        DatabaseDescriptor.conf.min_free_space_per_drive = new DataStorageSpec.IntMebibytesBound(mebiBytes);
        return DatabaseDescriptor.getMinFreeSpacePerDriveInBytes();
    }

    public static double getMaxSpaceForCompactionsPerDrive() {
        return DatabaseDescriptor.conf.max_space_usable_for_compactions_in_percentage;
    }

    public static void setMaxSpaceForCompactionsPerDrive(double percentage) {
        DatabaseDescriptor.conf.max_space_usable_for_compactions_in_percentage = percentage;
    }

    public static boolean getDisableSTCSInL0() {
        return disableSTCSInL0;
    }

    public static void setDisableSTCSInL0(boolean disabled) {
        disableSTCSInL0 = disabled;
    }

    public static int getStreamThroughputOutboundMegabitsPerSec() {
        return DatabaseDescriptor.conf.stream_throughput_outbound.toMegabitsPerSecondAsInt();
    }

    public static double getStreamThroughputOutboundMegabitsPerSecAsDouble() {
        return DatabaseDescriptor.conf.stream_throughput_outbound.toMegabitsPerSecond();
    }

    public static double getStreamThroughputOutboundMebibytesPerSec() {
        return DatabaseDescriptor.conf.stream_throughput_outbound.toMebibytesPerSecond();
    }

    public static double getStreamThroughputOutboundBytesPerSec() {
        return DatabaseDescriptor.conf.stream_throughput_outbound.toBytesPerSecond();
    }

    public static int getStreamThroughputOutboundMebibytesPerSecAsInt() {
        return DatabaseDescriptor.conf.stream_throughput_outbound.toMebibytesPerSecondAsInt();
    }

    public static void setStreamThroughputOutboundMebibytesPerSecAsInt(int value) {
        if (DataRateSpec.DataRateUnit.MEBIBYTES_PER_SECOND.toMegabitsPerSecond(value) >= 2.147483647E9) {
            throw new IllegalArgumentException("stream_throughput_outbound: " + value + " is too large; it should be less than 2147483647 in megabits/s");
        }
        DatabaseDescriptor.conf.stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound(value, DataRateSpec.DataRateUnit.MEBIBYTES_PER_SECOND);
    }

    public static void setStreamThroughputOutboundBytesPerSec(long value) {
        DatabaseDescriptor.conf.stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound(value, DataRateSpec.DataRateUnit.BYTES_PER_SECOND);
    }

    public static void setStreamThroughputOutboundMegabitsPerSec(int value) {
        DatabaseDescriptor.conf.stream_throughput_outbound = DataRateSpec.LongBytesPerSecondBound.megabitsPerSecondInBytesPerSecond(value);
    }

    public static double getEntireSSTableStreamThroughputOutboundMebibytesPerSec() {
        return DatabaseDescriptor.conf.entire_sstable_stream_throughput_outbound.toMebibytesPerSecond();
    }

    public static double getEntireSSTableStreamThroughputOutboundBytesPerSec() {
        return DatabaseDescriptor.conf.entire_sstable_stream_throughput_outbound.toBytesPerSecond();
    }

    public static void setEntireSSTableStreamThroughputOutboundMebibytesPerSec(int value) {
        if (value == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("entire_sstable_stream_throughput_outbound: " + value + " is too large; it should be less than 2147483647 in MiB/s");
        }
        DatabaseDescriptor.conf.entire_sstable_stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound(value, DataRateSpec.DataRateUnit.MEBIBYTES_PER_SECOND);
    }

    public static int getInterDCStreamThroughputOutboundMegabitsPerSec() {
        return DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound.toMegabitsPerSecondAsInt();
    }

    public static double getInterDCStreamThroughputOutboundMegabitsPerSecAsDouble() {
        return DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound.toMegabitsPerSecond();
    }

    public static double getInterDCStreamThroughputOutboundMebibytesPerSec() {
        return DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound.toMebibytesPerSecond();
    }

    public static double getInterDCStreamThroughputOutboundBytesPerSec() {
        return DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound.toBytesPerSecond();
    }

    public static int getInterDCStreamThroughputOutboundMebibytesPerSecAsInt() {
        return DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound.toMebibytesPerSecondAsInt();
    }

    public static void setInterDCStreamThroughputOutboundMebibytesPerSecAsInt(int value) {
        if (DataRateSpec.DataRateUnit.MEBIBYTES_PER_SECOND.toMegabitsPerSecond(value) >= 2.147483647E9) {
            throw new IllegalArgumentException("inter_dc_stream_throughput_outbound: " + value + " is too large; it should be less than 2147483647 in megabits/s");
        }
        DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound(value, DataRateSpec.DataRateUnit.MEBIBYTES_PER_SECOND);
    }

    public static void setInterDCStreamThroughputOutboundBytesPerSec(long value) {
        DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound(value, DataRateSpec.DataRateUnit.BYTES_PER_SECOND);
    }

    public static void setInterDCStreamThroughputOutboundMegabitsPerSec(int value) {
        DatabaseDescriptor.conf.inter_dc_stream_throughput_outbound = DataRateSpec.LongBytesPerSecondBound.megabitsPerSecondInBytesPerSecond(value);
    }

    public static double getEntireSSTableInterDCStreamThroughputOutboundBytesPerSec() {
        return DatabaseDescriptor.conf.entire_sstable_inter_dc_stream_throughput_outbound.toBytesPerSecond();
    }

    public static double getEntireSSTableInterDCStreamThroughputOutboundMebibytesPerSec() {
        return DatabaseDescriptor.conf.entire_sstable_inter_dc_stream_throughput_outbound.toMebibytesPerSecond();
    }

    public static void setEntireSSTableInterDCStreamThroughputOutboundMebibytesPerSec(int value) {
        if (value == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("entire_sstable_inter_dc_stream_throughput_outbound: " + value + " is too large; it should be less than 2147483647 in MiB/s");
        }
        DatabaseDescriptor.conf.entire_sstable_inter_dc_stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound(value, DataRateSpec.DataRateUnit.MEBIBYTES_PER_SECOND);
    }

    public static boolean useSpecificLocationForLocalSystemData() {
        return DatabaseDescriptor.conf.local_system_data_file_directory != null;
    }

    public static String[] getLocalSystemKeyspacesDataFileLocations() {
        String[] stringArray;
        if (DatabaseDescriptor.useSpecificLocationForLocalSystemData()) {
            return new String[]{DatabaseDescriptor.conf.local_system_data_file_directory};
        }
        if (DatabaseDescriptor.conf.data_file_directories.length == 0) {
            stringArray = DatabaseDescriptor.conf.data_file_directories;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = DatabaseDescriptor.conf.data_file_directories[0];
        }
        return stringArray;
    }

    public static String[] getNonLocalSystemKeyspacesDataFileLocations() {
        return DatabaseDescriptor.conf.data_file_directories;
    }

    public static String[] getAllDataFileLocations() {
        if (DatabaseDescriptor.conf.local_system_data_file_directory == null) {
            return DatabaseDescriptor.conf.data_file_directories;
        }
        return (String[])ArrayUtils.addFirst((Object[])DatabaseDescriptor.conf.data_file_directories, (Object)DatabaseDescriptor.conf.local_system_data_file_directory);
    }

    public static String getCommitLogLocation() {
        return DatabaseDescriptor.conf.commitlog_directory;
    }

    @VisibleForTesting
    public static void setCommitLogLocation(String value) {
        DatabaseDescriptor.conf.commitlog_directory = value;
    }

    public static ParameterizedClass getCommitLogCompression() {
        return DatabaseDescriptor.conf.commitlog_compression;
    }

    public static void setCommitLogCompression(ParameterizedClass compressor) {
        DatabaseDescriptor.conf.commitlog_compression = compressor;
    }

    public static Config.FlushCompression getFlushCompression() {
        return DatabaseDescriptor.conf.flush_compression;
    }

    public static void setFlushCompression(Config.FlushCompression compression) {
        DatabaseDescriptor.conf.flush_compression = compression;
    }

    public static int getCommitLogMaxCompressionBuffersInPool() {
        return DatabaseDescriptor.conf.commitlog_max_compression_buffers_in_pool;
    }

    public static void setCommitLogMaxCompressionBuffersPerPool(int buffers) {
        DatabaseDescriptor.conf.commitlog_max_compression_buffers_in_pool = buffers;
    }

    public static int getMaxMutationSize() {
        return DatabaseDescriptor.conf.max_mutation_size.toBytes();
    }

    public static int getTombstoneWarnThreshold() {
        return DatabaseDescriptor.conf.tombstone_warn_threshold;
    }

    public static void setTombstoneWarnThreshold(int threshold) {
        DatabaseDescriptor.conf.tombstone_warn_threshold = threshold;
    }

    public static int getTombstoneFailureThreshold() {
        return DatabaseDescriptor.conf.tombstone_failure_threshold;
    }

    public static void setTombstoneFailureThreshold(int threshold) {
        DatabaseDescriptor.conf.tombstone_failure_threshold = threshold;
    }

    public static int getCachedReplicaRowsWarnThreshold() {
        return DatabaseDescriptor.conf.replica_filtering_protection.cached_rows_warn_threshold;
    }

    public static void setCachedReplicaRowsWarnThreshold(int threshold) {
        DatabaseDescriptor.conf.replica_filtering_protection.cached_rows_warn_threshold = threshold;
    }

    public static int getCachedReplicaRowsFailThreshold() {
        return DatabaseDescriptor.conf.replica_filtering_protection.cached_rows_fail_threshold;
    }

    public static void setCachedReplicaRowsFailThreshold(int threshold) {
        DatabaseDescriptor.conf.replica_filtering_protection.cached_rows_fail_threshold = threshold;
    }

    public static int getCommitLogSegmentSize() {
        return DatabaseDescriptor.conf.commitlog_segment_size.toBytes();
    }

    @VisibleForTesting
    public static void setCommitLogSegmentSize(int sizeMebibytes) {
        DatabaseDescriptor.conf.commitlog_segment_size = new DataStorageSpec.IntMebibytesBound(sizeMebibytes);
    }

    public static String getSavedCachesLocation() {
        return DatabaseDescriptor.conf.saved_caches_directory;
    }

    public static Set<InetAddressAndPort> getSeeds() {
        return ImmutableSet.builder().addAll(seedProvider.getSeeds()).build();
    }

    public static SeedProvider getSeedProvider() {
        return seedProvider;
    }

    public static void setSeedProvider(SeedProvider newSeedProvider) {
        seedProvider = newSeedProvider;
    }

    public static InetAddress getListenAddress() {
        return listenAddress;
    }

    public static void setListenAddress(InetAddress newlistenAddress) {
        listenAddress = newlistenAddress;
    }

    public static InetAddress getBroadcastAddress() {
        return broadcastAddress;
    }

    public static boolean shouldListenOnBroadcastAddress() {
        return DatabaseDescriptor.conf.listen_on_broadcast_address;
    }

    public static void setShouldListenOnBroadcastAddress(boolean shouldListenOnBroadcastAddress) {
        DatabaseDescriptor.conf.listen_on_broadcast_address = shouldListenOnBroadcastAddress;
    }

    public static void setListenOnBroadcastAddress(boolean listen_on_broadcast_address) {
        DatabaseDescriptor.conf.listen_on_broadcast_address = listen_on_broadcast_address;
    }

    public static IInternodeAuthenticator getInternodeAuthenticator() {
        return internodeAuthenticator;
    }

    public static void setInternodeAuthenticator(IInternodeAuthenticator internodeAuthenticator) {
        Preconditions.checkNotNull((Object)internodeAuthenticator);
        DatabaseDescriptor.internodeAuthenticator = internodeAuthenticator;
    }

    public static void setBroadcastAddress(InetAddress broadcastAdd) {
        broadcastAddress = broadcastAdd;
    }

    public static InetAddress getRpcAddress() {
        return rpcAddress;
    }

    public static void setBroadcastRpcAddress(InetAddress broadcastRPCAddr) {
        broadcastRpcAddress = broadcastRPCAddr;
    }

    public static InetAddress getBroadcastRpcAddress() {
        return broadcastRpcAddress;
    }

    public static boolean getRpcKeepAlive() {
        return DatabaseDescriptor.conf.rpc_keepalive;
    }

    public static int getInternodeSocketSendBufferSizeInBytes() {
        return DatabaseDescriptor.conf.internode_socket_send_buffer_size.toBytes();
    }

    public static int getInternodeSocketReceiveBufferSizeInBytes() {
        return DatabaseDescriptor.conf.internode_socket_receive_buffer_size.toBytes();
    }

    public static int getInternodeApplicationSendQueueCapacityInBytes() {
        return DatabaseDescriptor.conf.internode_application_send_queue_capacity.toBytes();
    }

    public static int getInternodeApplicationSendQueueReserveEndpointCapacityInBytes() {
        return DatabaseDescriptor.conf.internode_application_send_queue_reserve_endpoint_capacity.toBytes();
    }

    public static int getInternodeApplicationSendQueueReserveGlobalCapacityInBytes() {
        return DatabaseDescriptor.conf.internode_application_send_queue_reserve_global_capacity.toBytes();
    }

    public static int getInternodeApplicationReceiveQueueCapacityInBytes() {
        return DatabaseDescriptor.conf.internode_application_receive_queue_capacity.toBytes();
    }

    public static int getInternodeApplicationReceiveQueueReserveEndpointCapacityInBytes() {
        return DatabaseDescriptor.conf.internode_application_receive_queue_reserve_endpoint_capacity.toBytes();
    }

    public static int getInternodeApplicationReceiveQueueReserveGlobalCapacityInBytes() {
        return DatabaseDescriptor.conf.internode_application_receive_queue_reserve_global_capacity.toBytes();
    }

    public static int getInternodeTcpConnectTimeoutInMS() {
        return DatabaseDescriptor.conf.internode_tcp_connect_timeout.toMilliseconds();
    }

    public static void setInternodeTcpConnectTimeoutInMS(int value) {
        DatabaseDescriptor.conf.internode_tcp_connect_timeout = new DurationSpec.IntMillisecondsBound(value);
    }

    public static int getInternodeTcpUserTimeoutInMS() {
        return DatabaseDescriptor.conf.internode_tcp_user_timeout.toMilliseconds();
    }

    public static void setInternodeTcpUserTimeoutInMS(int value) {
        DatabaseDescriptor.conf.internode_tcp_user_timeout = new DurationSpec.IntMillisecondsBound(value);
    }

    public static int getInternodeStreamingTcpUserTimeoutInMS() {
        return DatabaseDescriptor.conf.internode_streaming_tcp_user_timeout.toMilliseconds();
    }

    public static void setInternodeStreamingTcpUserTimeoutInMS(int value) {
        DatabaseDescriptor.conf.internode_streaming_tcp_user_timeout = new DurationSpec.IntMillisecondsBound(value);
    }

    public static int getInternodeMaxMessageSizeInBytes() {
        return DatabaseDescriptor.conf.internode_max_message_size.toBytes();
    }

    @VisibleForTesting
    public static void setInternodeMaxMessageSizeInBytes(int value) {
        DatabaseDescriptor.conf.internode_max_message_size = new DataStorageSpec.IntBytesBound(value);
    }

    public static boolean startNativeTransport() {
        return DatabaseDescriptor.conf.start_native_transport;
    }

    public static int getNativeTransportPort() {
        return CassandraRelevantProperties.NATIVE_TRANSPORT_PORT.getInt(DatabaseDescriptor.conf.native_transport_port);
    }

    @VisibleForTesting
    public static void setNativeTransportPort(int port) {
        DatabaseDescriptor.conf.native_transport_port = port;
    }

    public static int getNativeTransportPortSSL() {
        return DatabaseDescriptor.conf.native_transport_port_ssl == null ? DatabaseDescriptor.getNativeTransportPort() : DatabaseDescriptor.conf.native_transport_port_ssl;
    }

    @VisibleForTesting
    public static void setNativeTransportPortSSL(Integer port) {
        DatabaseDescriptor.conf.native_transport_port_ssl = port;
    }

    public static int getNativeTransportMaxThreads() {
        return DatabaseDescriptor.conf.native_transport_max_threads;
    }

    public static void setNativeTransportMaxThreads(int max_threads) {
        DatabaseDescriptor.conf.native_transport_max_threads = max_threads;
    }

    public static Integer getNativeTransportMaxAuthThreads() {
        return DatabaseDescriptor.conf.native_transport_max_auth_threads;
    }

    public static void setNativeTransportMaxAuthThreads(int threads) {
        DatabaseDescriptor.conf.native_transport_max_auth_threads = threads;
    }

    public static int getNativeTransportMaxFrameSize() {
        return DatabaseDescriptor.conf.native_transport_max_frame_size.toBytes();
    }

    public static void setNativeTransportMaxFrameSize(int bytes) {
        DatabaseDescriptor.conf.native_transport_max_frame_size = new DataStorageSpec.IntMebibytesBound(bytes);
    }

    public static long getNativeTransportMaxConcurrentConnections() {
        return DatabaseDescriptor.conf.native_transport_max_concurrent_connections;
    }

    public static void setNativeTransportMaxConcurrentConnections(long nativeTransportMaxConcurrentConnections) {
        DatabaseDescriptor.conf.native_transport_max_concurrent_connections = nativeTransportMaxConcurrentConnections;
    }

    public static long getNativeTransportMaxConcurrentConnectionsPerIp() {
        return DatabaseDescriptor.conf.native_transport_max_concurrent_connections_per_ip;
    }

    public static void setNativeTransportMaxConcurrentConnectionsPerIp(long native_transport_max_concurrent_connections_per_ip) {
        DatabaseDescriptor.conf.native_transport_max_concurrent_connections_per_ip = native_transport_max_concurrent_connections_per_ip;
    }

    public static boolean useNativeTransportLegacyFlusher() {
        return DatabaseDescriptor.conf.native_transport_flush_in_batches_legacy;
    }

    public static boolean getNativeTransportAllowOlderProtocols() {
        return DatabaseDescriptor.conf.native_transport_allow_older_protocols;
    }

    public static void setNativeTransportAllowOlderProtocols(boolean isEnabled) {
        DatabaseDescriptor.conf.native_transport_allow_older_protocols = isEnabled;
    }

    public static long getCommitLogSyncGroupWindow() {
        return DatabaseDescriptor.conf.commitlog_sync_group_window.toMilliseconds();
    }

    public static void setCommitLogSyncGroupWindow(long windowMillis) {
        DatabaseDescriptor.conf.commitlog_sync_group_window = new DurationSpec.IntMillisecondsBound(windowMillis);
    }

    public static int getNativeTransportReceiveQueueCapacityInBytes() {
        return DatabaseDescriptor.conf.native_transport_receive_queue_capacity.toBytes();
    }

    public static void setNativeTransportReceiveQueueCapacityInBytes(int queueSize) {
        DatabaseDescriptor.conf.native_transport_receive_queue_capacity = new DataStorageSpec.IntBytesBound(queueSize);
    }

    public static long getNativeTransportMaxRequestDataInFlightPerIpInBytes() {
        return DatabaseDescriptor.conf.native_transport_max_request_data_in_flight_per_ip.toBytes();
    }

    public static Config.PaxosVariant getPaxosVariant() {
        return DatabaseDescriptor.conf.paxos_variant;
    }

    public static void setPaxosVariant(Config.PaxosVariant variant) {
        DatabaseDescriptor.conf.paxos_variant = variant;
    }

    public static String getPaxosContentionWaitRandomizer() {
        return DatabaseDescriptor.conf.paxos_contention_wait_randomizer;
    }

    public static String getPaxosContentionMinWait() {
        return DatabaseDescriptor.conf.paxos_contention_min_wait;
    }

    public static String getPaxosContentionMaxWait() {
        return DatabaseDescriptor.conf.paxos_contention_max_wait;
    }

    public static String getPaxosContentionMinDelta() {
        return DatabaseDescriptor.conf.paxos_contention_min_delta;
    }

    public static void setPaxosContentionWaitRandomizer(String waitRandomizer) {
        DatabaseDescriptor.conf.paxos_contention_wait_randomizer = waitRandomizer;
    }

    public static void setPaxosContentionMinWait(String minWait) {
        DatabaseDescriptor.conf.paxos_contention_min_wait = minWait;
    }

    public static void setPaxosContentionMaxWait(String maxWait) {
        DatabaseDescriptor.conf.paxos_contention_max_wait = maxWait;
    }

    public static void setPaxosContentionMinDelta(String minDelta) {
        DatabaseDescriptor.conf.paxos_contention_min_delta = minDelta;
    }

    public static boolean skipPaxosRepairOnTopologyChange() {
        return DatabaseDescriptor.conf.skip_paxos_repair_on_topology_change;
    }

    public static void setSkipPaxosRepairOnTopologyChange(boolean value) {
        DatabaseDescriptor.conf.skip_paxos_repair_on_topology_change = value;
    }

    public static long getPaxosPurgeGrace(TimeUnit units) {
        return DatabaseDescriptor.conf.paxos_purge_grace_period.to(units);
    }

    public static void setPaxosPurgeGrace(long seconds) {
        DatabaseDescriptor.conf.paxos_purge_grace_period = new DurationSpec.LongSecondsBound(seconds);
    }

    public static Config.PaxosOnLinearizabilityViolation paxosOnLinearizabilityViolations() {
        return DatabaseDescriptor.conf.paxos_on_linearizability_violations;
    }

    public static void setPaxosOnLinearizabilityViolations(Config.PaxosOnLinearizabilityViolation v) {
        DatabaseDescriptor.conf.paxos_on_linearizability_violations = v;
    }

    public static Config.PaxosStatePurging paxosStatePurging() {
        return DatabaseDescriptor.conf.paxos_state_purging;
    }

    public static void setPaxosStatePurging(Config.PaxosStatePurging v) {
        DatabaseDescriptor.conf.paxos_state_purging = v;
    }

    public static boolean paxosRepairEnabled() {
        return DatabaseDescriptor.conf.paxos_repair_enabled;
    }

    public static void setPaxosRepairEnabled(boolean v) {
        DatabaseDescriptor.conf.paxos_repair_enabled = v;
    }

    public static Set<String> skipPaxosRepairOnTopologyChangeKeyspaces() {
        return DatabaseDescriptor.conf.skip_paxos_repair_on_topology_change_keyspaces;
    }

    public static void setSkipPaxosRepairOnTopologyChangeKeyspaces(String keyspaces) {
        DatabaseDescriptor.conf.skip_paxos_repair_on_topology_change_keyspaces = Config.splitCommaDelimited(keyspaces);
    }

    public static boolean paxoTopologyRepairNoDcChecks() {
        return DatabaseDescriptor.conf.paxos_topology_repair_no_dc_checks;
    }

    public static boolean paxoTopologyRepairStrictEachQuorum() {
        return DatabaseDescriptor.conf.paxos_topology_repair_strict_each_quorum;
    }

    public static void setNativeTransportMaxRequestDataInFlightPerIpInBytes(long maxRequestDataInFlightInBytes) {
        if (maxRequestDataInFlightInBytes == -1L) {
            maxRequestDataInFlightInBytes = Runtime.getRuntime().maxMemory() / 40L;
        }
        DatabaseDescriptor.conf.native_transport_max_request_data_in_flight_per_ip = new DataStorageSpec.LongBytesBound(maxRequestDataInFlightInBytes);
    }

    public static long getNativeTransportMaxRequestDataInFlightInBytes() {
        return DatabaseDescriptor.conf.native_transport_max_request_data_in_flight.toBytes();
    }

    public static void setNativeTransportConcurrentRequestDataInFlightInBytes(long maxRequestDataInFlightInBytes) {
        if (maxRequestDataInFlightInBytes == -1L) {
            maxRequestDataInFlightInBytes = Runtime.getRuntime().maxMemory() / 10L;
        }
        DatabaseDescriptor.conf.native_transport_max_request_data_in_flight = new DataStorageSpec.LongBytesBound(maxRequestDataInFlightInBytes);
    }

    public static int getNativeTransportMaxRequestsPerSecond() {
        return DatabaseDescriptor.conf.native_transport_max_requests_per_second;
    }

    public static void setNativeTransportMaxRequestsPerSecond(int perSecond) {
        Preconditions.checkArgument((perSecond > 0 ? 1 : 0) != 0, (Object)"native_transport_max_requests_per_second must be greater than zero");
        DatabaseDescriptor.conf.native_transport_max_requests_per_second = perSecond;
    }

    public static void setNativeTransportRateLimitingEnabled(boolean enabled) {
        logger.info("native_transport_rate_limiting_enabled set to {}", (Object)enabled);
        DatabaseDescriptor.conf.native_transport_rate_limiting_enabled = enabled;
    }

    public static boolean getNativeTransportRateLimitingEnabled() {
        return DatabaseDescriptor.conf.native_transport_rate_limiting_enabled;
    }

    public static int getCommitLogSyncPeriod() {
        return DatabaseDescriptor.conf.commitlog_sync_period.toMilliseconds();
    }

    public static long getPeriodicCommitLogSyncBlock() {
        DurationSpec.IntMillisecondsBound blockMillis = DatabaseDescriptor.conf.periodic_commitlog_sync_lag_block;
        return blockMillis == null ? (long)((double)DatabaseDescriptor.getCommitLogSyncPeriod() * 1.5) : (long)blockMillis.toMilliseconds();
    }

    public static void setCommitLogSyncPeriod(int periodMillis) {
        DatabaseDescriptor.conf.commitlog_sync_period = new DurationSpec.IntMillisecondsBound(periodMillis);
    }

    public static Config.CommitLogSync getCommitLogSync() {
        return DatabaseDescriptor.conf.commitlog_sync;
    }

    public static void setCommitLogSync(Config.CommitLogSync sync) {
        DatabaseDescriptor.conf.commitlog_sync = sync;
    }

    public static Config.DiskAccessMode getDiskAccessMode() {
        return DatabaseDescriptor.conf.disk_access_mode;
    }

    @VisibleForTesting
    public static void setDiskAccessMode(Config.DiskAccessMode mode) {
        DatabaseDescriptor.conf.disk_access_mode = mode;
    }

    public static Config.DiskAccessMode getIndexAccessMode() {
        return indexAccessMode;
    }

    @VisibleForTesting
    public static void setIndexAccessMode(Config.DiskAccessMode mode) {
        indexAccessMode = mode;
    }

    public static void setDiskFailurePolicy(Config.DiskFailurePolicy policy) {
        DatabaseDescriptor.conf.disk_failure_policy = policy;
    }

    public static Config.DiskFailurePolicy getDiskFailurePolicy() {
        return DatabaseDescriptor.conf.disk_failure_policy;
    }

    public static void setCommitFailurePolicy(Config.CommitFailurePolicy policy) {
        DatabaseDescriptor.conf.commit_failure_policy = policy;
    }

    public static Config.CommitFailurePolicy getCommitFailurePolicy() {
        return DatabaseDescriptor.conf.commit_failure_policy;
    }

    public static boolean isSnapshotBeforeCompaction() {
        return DatabaseDescriptor.conf.snapshot_before_compaction;
    }

    public static boolean isAutoSnapshot() {
        return DatabaseDescriptor.conf.auto_snapshot;
    }

    public static DurationSpec.IntSecondsBound getAutoSnapshotTtl() {
        return autoSnapshoTtl;
    }

    @VisibleForTesting
    public static void setAutoSnapshotTtl(DurationSpec.IntSecondsBound newTtl) {
        autoSnapshoTtl = newTtl;
    }

    @VisibleForTesting
    public static void setAutoSnapshot(boolean autoSnapshot) {
        DatabaseDescriptor.conf.auto_snapshot = autoSnapshot;
    }

    @VisibleForTesting
    public static boolean getAutoSnapshot() {
        return DatabaseDescriptor.conf.auto_snapshot;
    }

    public static long getSnapshotLinksPerSecond() {
        return DatabaseDescriptor.conf.snapshot_links_per_second == 0L ? Long.MAX_VALUE : DatabaseDescriptor.conf.snapshot_links_per_second;
    }

    public static void setSnapshotLinksPerSecond(long throttle) {
        if (throttle < 0L) {
            throw new IllegalArgumentException("Invalid throttle for snapshot_links_per_second: must be positive");
        }
        DatabaseDescriptor.conf.snapshot_links_per_second = throttle;
    }

    public static RateLimiter getSnapshotRateLimiter() {
        return RateLimiter.create((double)DatabaseDescriptor.getSnapshotLinksPerSecond());
    }

    public static boolean isAutoBootstrap() {
        return CassandraRelevantProperties.AUTO_BOOTSTRAP.getBoolean(DatabaseDescriptor.conf.auto_bootstrap);
    }

    public static void setHintedHandoffEnabled(boolean hintedHandoffEnabled) {
        DatabaseDescriptor.conf.hinted_handoff_enabled = hintedHandoffEnabled;
    }

    public static boolean hintedHandoffEnabled() {
        return DatabaseDescriptor.conf.hinted_handoff_enabled;
    }

    public static Set<String> hintedHandoffDisabledDCs() {
        return DatabaseDescriptor.conf.hinted_handoff_disabled_datacenters;
    }

    public static boolean useDeterministicTableID() {
        return conf != null && DatabaseDescriptor.conf.use_deterministic_table_id;
    }

    public static void useDeterministicTableID(boolean value) {
        DatabaseDescriptor.conf.use_deterministic_table_id = value;
    }

    public static void enableHintsForDC(String dc) {
        DatabaseDescriptor.conf.hinted_handoff_disabled_datacenters.remove(dc);
    }

    public static void disableHintsForDC(String dc) {
        DatabaseDescriptor.conf.hinted_handoff_disabled_datacenters.add(dc);
    }

    public static void setMaxHintWindow(int ms) {
        DatabaseDescriptor.conf.max_hint_window = new DurationSpec.IntMillisecondsBound(ms);
    }

    public static int getMaxHintWindow() {
        return DatabaseDescriptor.conf.max_hint_window.toMilliseconds();
    }

    public static void setMaxHintsSizePerHostInMiB(int value) {
        DatabaseDescriptor.conf.max_hints_size_per_host = new DataStorageSpec.LongBytesBound(value, DataStorageSpec.DataStorageUnit.MEBIBYTES);
    }

    public static int getMaxHintsSizePerHostInMiB() {
        return Ints.saturatedCast((long)DatabaseDescriptor.conf.max_hints_size_per_host.unit().toMebibytes(DatabaseDescriptor.conf.max_hints_size_per_host.quantity()));
    }

    public static long getMaxHintsSizePerHost() {
        return DatabaseDescriptor.conf.max_hints_size_per_host.toBytes();
    }

    public static File getHintsDirectory() {
        return new File(DatabaseDescriptor.conf.hints_directory);
    }

    public static boolean hintWindowPersistentEnabled() {
        return DatabaseDescriptor.conf.hint_window_persistent_enabled;
    }

    public static File getSerializedCachePath(CacheService.CacheType cacheType, String version, String extension) {
        String name = cacheType.toString() + (String)(version == null ? "" : "-" + version + "." + extension);
        return new File(DatabaseDescriptor.conf.saved_caches_directory, name);
    }

    public static int getDynamicUpdateInterval() {
        return DatabaseDescriptor.conf.dynamic_snitch_update_interval.toMilliseconds();
    }

    public static void setDynamicUpdateInterval(int dynamicUpdateInterval) {
        DatabaseDescriptor.conf.dynamic_snitch_update_interval = new DurationSpec.IntMillisecondsBound(dynamicUpdateInterval);
    }

    public static int getDynamicResetInterval() {
        return DatabaseDescriptor.conf.dynamic_snitch_reset_interval.toMilliseconds();
    }

    public static void setDynamicResetInterval(int dynamicResetInterval) {
        DatabaseDescriptor.conf.dynamic_snitch_reset_interval = new DurationSpec.IntMillisecondsBound(dynamicResetInterval);
    }

    public static double getDynamicBadnessThreshold() {
        return DatabaseDescriptor.conf.dynamic_snitch_badness_threshold;
    }

    public static void setDynamicBadnessThreshold(double dynamicBadnessThreshold) {
        DatabaseDescriptor.conf.dynamic_snitch_badness_threshold = dynamicBadnessThreshold;
    }

    public static EncryptionOptions.ServerEncryptionOptions getInternodeMessagingEncyptionOptions() {
        return DatabaseDescriptor.conf.server_encryption_options;
    }

    public static void setInternodeMessagingEncyptionOptions(EncryptionOptions.ServerEncryptionOptions encryptionOptions) {
        DatabaseDescriptor.conf.server_encryption_options = encryptionOptions;
    }

    public static EncryptionOptions getNativeProtocolEncryptionOptions() {
        return DatabaseDescriptor.conf.client_encryption_options;
    }

    @VisibleForTesting
    public static void updateNativeProtocolEncryptionOptions(Function<EncryptionOptions, EncryptionOptions> update) {
        DatabaseDescriptor.conf.client_encryption_options = update.apply(DatabaseDescriptor.conf.client_encryption_options);
    }

    public static int getHintedHandoffThrottleInKiB() {
        return DatabaseDescriptor.conf.hinted_handoff_throttle.toKibibytes();
    }

    public static void setHintedHandoffThrottleInKiB(int throttleInKiB) {
        DatabaseDescriptor.conf.hinted_handoff_throttle = new DataStorageSpec.IntKibibytesBound(throttleInKiB);
    }

    public static int getBatchlogReplayThrottleInKiB() {
        return DatabaseDescriptor.conf.batchlog_replay_throttle.toKibibytes();
    }

    public static void setBatchlogReplayThrottleInKiB(int throttleInKiB) {
        DatabaseDescriptor.conf.batchlog_replay_throttle = new DataStorageSpec.IntKibibytesBound(throttleInKiB);
    }

    public static int getMaxHintsDeliveryThreads() {
        return DatabaseDescriptor.conf.max_hints_delivery_threads;
    }

    public static int getHintsFlushPeriodInMS() {
        return DatabaseDescriptor.conf.hints_flush_period.toMilliseconds();
    }

    public static long getMaxHintsFileSize() {
        return DatabaseDescriptor.conf.max_hints_file_size.toBytesInLong();
    }

    public static ParameterizedClass getHintsCompression() {
        return DatabaseDescriptor.conf.hints_compression;
    }

    public static void setHintsCompression(ParameterizedClass parameterizedClass) {
        DatabaseDescriptor.conf.hints_compression = parameterizedClass;
    }

    public static boolean isAutoHintsCleanupEnabled() {
        return DatabaseDescriptor.conf.auto_hints_cleanup_enabled;
    }

    public static void setAutoHintsCleanupEnabled(boolean value) {
        DatabaseDescriptor.conf.auto_hints_cleanup_enabled = value;
    }

    public static boolean getTransferHintsOnDecommission() {
        return DatabaseDescriptor.conf.transfer_hints_on_decommission;
    }

    public static void setTransferHintsOnDecommission(boolean enabled) {
        DatabaseDescriptor.conf.transfer_hints_on_decommission = enabled;
    }

    public static boolean isIncrementalBackupsEnabled() {
        return DatabaseDescriptor.conf.incremental_backups;
    }

    public static void setIncrementalBackupsEnabled(boolean value) {
        DatabaseDescriptor.conf.incremental_backups = value;
    }

    public static boolean getFileCacheEnabled() {
        return DatabaseDescriptor.conf.file_cache_enabled;
    }

    @VisibleForTesting
    public static void setFileCacheEnabled(boolean enabled) {
        DatabaseDescriptor.conf.file_cache_enabled = enabled;
    }

    public static int getFileCacheSizeInMiB() {
        if (DatabaseDescriptor.conf.file_cache_size == null) {
            assert (DatabaseDescriptor.isClientInitialized());
            return 0;
        }
        return DatabaseDescriptor.conf.file_cache_size.toMebibytes();
    }

    public static int getNetworkingCacheSizeInMiB() {
        if (DatabaseDescriptor.conf.networking_cache_size == null) {
            assert (DatabaseDescriptor.isClientInitialized());
            return 0;
        }
        return DatabaseDescriptor.conf.networking_cache_size.toMebibytes();
    }

    public static boolean getFileCacheRoundUp() {
        if (DatabaseDescriptor.conf.file_cache_round_up == null) {
            assert (DatabaseDescriptor.isClientInitialized());
            return false;
        }
        return DatabaseDescriptor.conf.file_cache_round_up;
    }

    public static DiskOptimizationStrategy getDiskOptimizationStrategy() {
        return diskOptimizationStrategy;
    }

    public static double getDiskOptimizationEstimatePercentile() {
        return DatabaseDescriptor.conf.disk_optimization_estimate_percentile;
    }

    public static long getTotalCommitlogSpaceInMiB() {
        return DatabaseDescriptor.conf.commitlog_total_space.toMebibytes();
    }

    public static boolean shouldMigrateKeycacheOnCompaction() {
        return DatabaseDescriptor.conf.key_cache_migrate_during_compaction;
    }

    public static void setMigrateKeycacheOnCompaction(boolean migrateCacheEntry) {
        DatabaseDescriptor.conf.key_cache_migrate_during_compaction = migrateCacheEntry;
    }

    public static int getSSTablePreemptiveOpenIntervalInMiB() {
        if (DatabaseDescriptor.conf.sstable_preemptive_open_interval == null) {
            return -1;
        }
        return DatabaseDescriptor.conf.sstable_preemptive_open_interval.toMebibytes();
    }

    public static void setSSTablePreemptiveOpenIntervalInMiB(int mib) {
        DatabaseDescriptor.conf.sstable_preemptive_open_interval = mib < 0 ? null : new DataStorageSpec.IntMebibytesBound(mib);
    }

    public static boolean getTrickleFsync() {
        return DatabaseDescriptor.conf.trickle_fsync;
    }

    public static int getTrickleFsyncIntervalInKiB() {
        return DatabaseDescriptor.conf.trickle_fsync_interval.toKibibytes();
    }

    public static long getKeyCacheSizeInMiB() {
        return keyCacheSizeInMiB;
    }

    public static long getIndexSummaryCapacityInMiB() {
        return indexSummaryCapacityInMiB;
    }

    public static int getKeyCacheSavePeriod() {
        return DatabaseDescriptor.conf.key_cache_save_period.toSeconds();
    }

    public static void setKeyCacheSavePeriod(int keyCacheSavePeriod) {
        DatabaseDescriptor.conf.key_cache_save_period = new DurationSpec.IntSecondsBound(keyCacheSavePeriod);
    }

    public static int getKeyCacheKeysToSave() {
        return DatabaseDescriptor.conf.key_cache_keys_to_save;
    }

    public static void setKeyCacheKeysToSave(int keyCacheKeysToSave) {
        DatabaseDescriptor.conf.key_cache_keys_to_save = keyCacheKeysToSave;
    }

    public static String getRowCacheClassName() {
        return DatabaseDescriptor.conf.row_cache_class_name;
    }

    public static long getRowCacheSizeInMiB() {
        return DatabaseDescriptor.conf.row_cache_size.toMebibytes();
    }

    @VisibleForTesting
    public static void setRowCacheSizeInMiB(long val) {
        DatabaseDescriptor.conf.row_cache_size = new DataStorageSpec.LongMebibytesBound(val);
    }

    public static int getRowCacheSavePeriod() {
        return DatabaseDescriptor.conf.row_cache_save_period.toSeconds();
    }

    public static void setRowCacheSavePeriod(int rowCacheSavePeriod) {
        DatabaseDescriptor.conf.row_cache_save_period = new DurationSpec.IntSecondsBound(rowCacheSavePeriod);
    }

    public static int getRowCacheKeysToSave() {
        return DatabaseDescriptor.conf.row_cache_keys_to_save;
    }

    public static long getPaxosCacheSizeInMiB() {
        return paxosCacheSizeInMiB;
    }

    public static long getCounterCacheSizeInMiB() {
        return counterCacheSizeInMiB;
    }

    public static void setRowCacheKeysToSave(int rowCacheKeysToSave) {
        DatabaseDescriptor.conf.row_cache_keys_to_save = rowCacheKeysToSave;
    }

    public static int getCounterCacheSavePeriod() {
        return DatabaseDescriptor.conf.counter_cache_save_period.toSeconds();
    }

    public static void setCounterCacheSavePeriod(int counterCacheSavePeriod) {
        DatabaseDescriptor.conf.counter_cache_save_period = new DurationSpec.IntSecondsBound(counterCacheSavePeriod);
    }

    public static int getCacheLoadTimeout() {
        return DatabaseDescriptor.conf.cache_load_timeout.toSeconds();
    }

    @VisibleForTesting
    public static void setCacheLoadTimeout(int seconds) {
        DatabaseDescriptor.conf.cache_load_timeout = new DurationSpec.IntSecondsBound(seconds);
    }

    public static int getCounterCacheKeysToSave() {
        return DatabaseDescriptor.conf.counter_cache_keys_to_save;
    }

    public static void setCounterCacheKeysToSave(int counterCacheKeysToSave) {
        DatabaseDescriptor.conf.counter_cache_keys_to_save = counterCacheKeysToSave;
    }

    public static int getStreamingKeepAlivePeriod() {
        return DatabaseDescriptor.conf.streaming_keep_alive_period.toSeconds();
    }

    public static int getStreamingConnectionsPerHost() {
        return DatabaseDescriptor.conf.streaming_connections_per_host;
    }

    public static boolean streamEntireSSTables() {
        return DatabaseDescriptor.conf.stream_entire_sstables;
    }

    @VisibleForTesting
    public static boolean setStreamEntireSSTables(boolean value) {
        DatabaseDescriptor.conf.stream_entire_sstables = value;
        return DatabaseDescriptor.conf.stream_entire_sstables;
    }

    public static DurationSpec.LongMillisecondsBound getStreamTransferTaskTimeout() {
        return DatabaseDescriptor.conf.stream_transfer_task_timeout;
    }

    public static boolean getSkipStreamDiskSpaceCheck() {
        return DatabaseDescriptor.conf.skip_stream_disk_space_check;
    }

    public static void setSkipStreamDiskSpaceCheck(boolean value) {
        DatabaseDescriptor.conf.skip_stream_disk_space_check = value;
    }

    public static String getLocalDataCenter() {
        return localDC;
    }

    public static Comparator<Replica> getLocalComparator() {
        return localComparator;
    }

    public static Config.InternodeCompression internodeCompression() {
        return DatabaseDescriptor.conf.internode_compression;
    }

    public static void setInternodeCompression(Config.InternodeCompression compression) {
        DatabaseDescriptor.conf.internode_compression = compression;
    }

    public static boolean getInterDCTcpNoDelay() {
        return DatabaseDescriptor.conf.inter_dc_tcp_nodelay;
    }

    public static long getMemtableHeapSpaceInMiB() {
        return DatabaseDescriptor.conf.memtable_heap_space.toMebibytes();
    }

    public static long getMemtableOffheapSpaceInMiB() {
        return DatabaseDescriptor.conf.memtable_offheap_space.toMebibytes();
    }

    public static Config.MemtableAllocationType getMemtableAllocationType() {
        return DatabaseDescriptor.conf.memtable_allocation_type;
    }

    public static int getRepairSessionMaxTreeDepth() {
        return DatabaseDescriptor.conf.repair_session_max_tree_depth;
    }

    public static void setRepairSessionMaxTreeDepth(int depth) {
        if (depth < 10) {
            throw new ConfigurationException("Cannot set repair_session_max_tree_depth to " + depth + " which is < 10, doing nothing");
        }
        if (depth > 20) {
            logger.warn("repair_session_max_tree_depth of " + depth + " > 20 could lead to excessive memory usage");
        }
        DatabaseDescriptor.conf.repair_session_max_tree_depth = depth;
    }

    public static int getRepairSessionSpaceInMiB() {
        return DatabaseDescriptor.conf.repair_session_space.toMebibytes();
    }

    public static void setRepairSessionSpaceInMiB(int sizeInMiB) {
        if (sizeInMiB < 1) {
            throw new ConfigurationException("Cannot set repair_session_space to " + sizeInMiB + " < 1 mebibyte");
        }
        if (sizeInMiB > (int)(Runtime.getRuntime().maxMemory() / 0x400000L)) {
            logger.warn("A repair_session_space of " + DatabaseDescriptor.conf.repair_session_space + " is likely to cause heap pressure.");
        }
        DatabaseDescriptor.conf.repair_session_space = new DataStorageSpec.IntMebibytesBound(sizeInMiB);
    }

    public static int getPaxosRepairParallelism() {
        return DatabaseDescriptor.conf.paxos_repair_parallelism;
    }

    public static void setPaxosRepairParallelism(int v) {
        Preconditions.checkArgument((v > 0 ? 1 : 0) != 0);
        DatabaseDescriptor.conf.paxos_repair_parallelism = v;
    }

    public static Float getMemtableCleanupThreshold() {
        return DatabaseDescriptor.conf.memtable_cleanup_threshold;
    }

    public static Map<String, InheritingClass> getMemtableConfigurations() {
        if (conf == null || DatabaseDescriptor.conf.memtable == null) {
            return null;
        }
        return DatabaseDescriptor.conf.memtable.configurations;
    }

    public static int getIndexSummaryResizeIntervalInMinutes() {
        if (DatabaseDescriptor.conf.index_summary_resize_interval == null) {
            return -1;
        }
        return DatabaseDescriptor.conf.index_summary_resize_interval.toMinutes();
    }

    public static void setIndexSummaryResizeIntervalInMinutes(int value) {
        DatabaseDescriptor.conf.index_summary_resize_interval = value == -1 ? null : new DurationSpec.IntMinutesBound(value);
    }

    public static boolean hasLargeAddressSpace() {
        String arch;
        String datamodel = CassandraRelevantProperties.SUN_ARCH_DATA_MODEL.getString();
        if (datamodel != null) {
            switch (datamodel) {
                case "64": {
                    return true;
                }
                case "32": {
                    return false;
                }
            }
        }
        return (arch = CassandraRelevantProperties.OS_ARCH.getString()).contains("64") || arch.contains("sparcv9");
    }

    public static int getTracetypeRepairTTL() {
        return DatabaseDescriptor.conf.trace_type_repair_ttl.toSeconds();
    }

    public static int getTracetypeQueryTTL() {
        return DatabaseDescriptor.conf.trace_type_query_ttl.toSeconds();
    }

    public static long getPreparedStatementsCacheSizeMiB() {
        return preparedStatementsCacheSizeInMiB;
    }

    public static boolean enableUserDefinedFunctions() {
        return DatabaseDescriptor.conf.user_defined_functions_enabled;
    }

    public static boolean enableScriptedUserDefinedFunctions() {
        return DatabaseDescriptor.conf.scripted_user_defined_functions_enabled;
    }

    public static boolean enableUserDefinedFunctionsThreads() {
        return DatabaseDescriptor.conf.user_defined_functions_threads_enabled;
    }

    public static long getUserDefinedFunctionWarnTimeout() {
        return DatabaseDescriptor.conf.user_defined_functions_warn_timeout.toMilliseconds();
    }

    public static void setUserDefinedFunctionWarnTimeout(long userDefinedFunctionWarnTimeout) {
        DatabaseDescriptor.conf.user_defined_functions_warn_timeout = new DurationSpec.LongMillisecondsBound(userDefinedFunctionWarnTimeout);
    }

    public static boolean allowInsecureUDFs() {
        return DatabaseDescriptor.conf.allow_insecure_udfs;
    }

    public static boolean allowExtraInsecureUDFs() {
        return DatabaseDescriptor.conf.allow_extra_insecure_udfs;
    }

    public static boolean getMaterializedViewsEnabled() {
        return DatabaseDescriptor.conf.materialized_views_enabled;
    }

    public static void setMaterializedViewsEnabled(boolean enableMaterializedViews) {
        DatabaseDescriptor.conf.materialized_views_enabled = enableMaterializedViews;
    }

    public static boolean getSASIIndexesEnabled() {
        return DatabaseDescriptor.conf.sasi_indexes_enabled;
    }

    public static void setSASIIndexesEnabled(boolean enableSASIIndexes) {
        DatabaseDescriptor.conf.sasi_indexes_enabled = enableSASIIndexes;
    }

    public static String getDefaultSecondaryIndex() {
        return DatabaseDescriptor.conf.default_secondary_index;
    }

    public static void setDefaultSecondaryIndex(String name) {
        DatabaseDescriptor.conf.default_secondary_index = name;
    }

    public static boolean getDefaultSecondaryIndexEnabled() {
        return DatabaseDescriptor.conf.default_secondary_index_enabled;
    }

    public static void setDefaultSecondaryIndexEnabled(boolean enabled) {
        DatabaseDescriptor.conf.default_secondary_index_enabled = enabled;
    }

    public static boolean isTransientReplicationEnabled() {
        return DatabaseDescriptor.conf.transient_replication_enabled;
    }

    public static void setTransientReplicationEnabledUnsafe(boolean enabled) {
        DatabaseDescriptor.conf.transient_replication_enabled = enabled;
    }

    public static boolean enableDropCompactStorage() {
        return DatabaseDescriptor.conf.drop_compact_storage_enabled;
    }

    @VisibleForTesting
    public static void setEnableDropCompactStorage(boolean enableDropCompactStorage) {
        DatabaseDescriptor.conf.drop_compact_storage_enabled = enableDropCompactStorage;
    }

    public static long getUserDefinedFunctionFailTimeout() {
        return DatabaseDescriptor.conf.user_defined_functions_fail_timeout.toMilliseconds();
    }

    public static void setUserDefinedFunctionFailTimeout(long userDefinedFunctionFailTimeout) {
        DatabaseDescriptor.conf.user_defined_functions_fail_timeout = new DurationSpec.LongMillisecondsBound(userDefinedFunctionFailTimeout);
    }

    public static Config.UserFunctionTimeoutPolicy getUserFunctionTimeoutPolicy() {
        return DatabaseDescriptor.conf.user_function_timeout_policy;
    }

    public static void setUserFunctionTimeoutPolicy(Config.UserFunctionTimeoutPolicy userFunctionTimeoutPolicy) {
        DatabaseDescriptor.conf.user_function_timeout_policy = userFunctionTimeoutPolicy;
    }

    public static long getGCLogThreshold() {
        return DatabaseDescriptor.conf.gc_log_threshold.toMilliseconds();
    }

    public static void setGCLogThreshold(int gcLogThreshold) {
        DatabaseDescriptor.conf.gc_log_threshold = new DurationSpec.IntMillisecondsBound(gcLogThreshold);
    }

    public static EncryptionContext getEncryptionContext() {
        return encryptionContext;
    }

    public static long getGCWarnThreshold() {
        return DatabaseDescriptor.conf.gc_warn_threshold.toMilliseconds();
    }

    public static void setGCWarnThreshold(int threshold) {
        DatabaseDescriptor.conf.gc_warn_threshold = new DurationSpec.IntMillisecondsBound(threshold);
    }

    public static boolean isCDCEnabled() {
        return DatabaseDescriptor.conf.cdc_enabled;
    }

    @VisibleForTesting
    public static void setCDCEnabled(boolean cdc_enabled) {
        DatabaseDescriptor.conf.cdc_enabled = cdc_enabled;
    }

    public static boolean getCDCBlockWrites() {
        return DatabaseDescriptor.conf.cdc_block_writes;
    }

    public static void setCDCBlockWrites(boolean val) {
        DatabaseDescriptor.conf.cdc_block_writes = val;
    }

    public static boolean isCDCOnRepairEnabled() {
        return DatabaseDescriptor.conf.cdc_on_repair_enabled;
    }

    public static void setCDCOnRepairEnabled(boolean val) {
        DatabaseDescriptor.conf.cdc_on_repair_enabled = val;
    }

    public static String getCDCLogLocation() {
        return DatabaseDescriptor.conf.cdc_raw_directory;
    }

    public static long getCDCTotalSpace() {
        return DatabaseDescriptor.conf.cdc_total_space.toBytesInLong();
    }

    @VisibleForTesting
    public static void setCDCTotalSpaceInMiB(int mibs) {
        DatabaseDescriptor.conf.cdc_total_space = new DataStorageSpec.IntMebibytesBound(mibs);
    }

    public static int getCDCDiskCheckInterval() {
        return DatabaseDescriptor.conf.cdc_free_space_check_interval.toMilliseconds();
    }

    @VisibleForTesting
    public static void setEncryptionContext(EncryptionContext ec) {
        encryptionContext = ec;
    }

    public static int searchConcurrencyFactor() {
        return searchConcurrencyFactor;
    }

    public static boolean isUnsafeSystem() {
        return unsafeSystem;
    }

    public static boolean diagnosticEventsEnabled() {
        return DatabaseDescriptor.conf.diagnostic_events_enabled;
    }

    public static void setDiagnosticEventsEnabled(boolean enabled) {
        DatabaseDescriptor.conf.diagnostic_events_enabled = enabled;
    }

    public static ConsistencyLevel getIdealConsistencyLevel() {
        return DatabaseDescriptor.conf.ideal_consistency_level;
    }

    public static void setIdealConsistencyLevel(ConsistencyLevel cl) {
        DatabaseDescriptor.conf.ideal_consistency_level = cl;
    }

    public static int getRepairCommandPoolSize() {
        return DatabaseDescriptor.conf.repair_command_pool_size;
    }

    public static Config.RepairCommandPoolFullStrategy getRepairCommandPoolFullStrategy() {
        return DatabaseDescriptor.conf.repair_command_pool_full_strategy;
    }

    public static FullQueryLoggerOptions getFullQueryLogOptions() {
        return DatabaseDescriptor.conf.full_query_logging_options;
    }

    public static void setFullQueryLogOptions(FullQueryLoggerOptions options) {
        DatabaseDescriptor.conf.full_query_logging_options = options;
    }

    public static boolean getBlockForPeersInRemoteDatacenters() {
        return DatabaseDescriptor.conf.block_for_peers_in_remote_dcs;
    }

    public static int getBlockForPeersTimeoutInSeconds() {
        return DatabaseDescriptor.conf.block_for_peers_timeout_in_secs;
    }

    public static boolean automaticSSTableUpgrade() {
        return DatabaseDescriptor.conf.automatic_sstable_upgrade;
    }

    public static void setAutomaticSSTableUpgradeEnabled(boolean enabled) {
        if (DatabaseDescriptor.conf.automatic_sstable_upgrade != enabled) {
            logger.debug("Changing automatic_sstable_upgrade to {}", (Object)enabled);
        }
        DatabaseDescriptor.conf.automatic_sstable_upgrade = enabled;
    }

    public static int maxConcurrentAutoUpgradeTasks() {
        return DatabaseDescriptor.conf.max_concurrent_automatic_sstable_upgrades;
    }

    public static void setMaxConcurrentAutoUpgradeTasks(int value) {
        if (DatabaseDescriptor.conf.max_concurrent_automatic_sstable_upgrades != value) {
            logger.debug("Changing max_concurrent_automatic_sstable_upgrades to {}", (Object)value);
        }
        DatabaseDescriptor.validateMaxConcurrentAutoUpgradeTasksConf(value);
        DatabaseDescriptor.conf.max_concurrent_automatic_sstable_upgrades = value;
    }

    private static void validateMaxConcurrentAutoUpgradeTasksConf(int value) {
        if (value < 0) {
            throw new ConfigurationException("max_concurrent_automatic_sstable_upgrades can't be negative");
        }
        if (value > DatabaseDescriptor.getConcurrentCompactors()) {
            logger.warn("max_concurrent_automatic_sstable_upgrades ({}) is larger than concurrent_compactors ({})", (Object)value, (Object)DatabaseDescriptor.getConcurrentCompactors());
        }
    }

    public static AuditLogOptions getAuditLoggingOptions() {
        return DatabaseDescriptor.conf.audit_logging_options;
    }

    public static void setAuditLoggingOptions(AuditLogOptions auditLoggingOptions) {
        DatabaseDescriptor.conf.audit_logging_options = new AuditLogOptions.Builder(auditLoggingOptions).build();
    }

    public static Config.CorruptedTombstoneStrategy getCorruptedTombstoneStrategy() {
        return DatabaseDescriptor.conf.corrupted_tombstone_strategy;
    }

    public static void setCorruptedTombstoneStrategy(Config.CorruptedTombstoneStrategy strategy) {
        DatabaseDescriptor.conf.corrupted_tombstone_strategy = strategy;
    }

    public static boolean getRepairedDataTrackingForRangeReadsEnabled() {
        return DatabaseDescriptor.conf.repaired_data_tracking_for_range_reads_enabled;
    }

    public static void setRepairedDataTrackingForRangeReadsEnabled(boolean enabled) {
        DatabaseDescriptor.conf.repaired_data_tracking_for_range_reads_enabled = enabled;
    }

    public static boolean getRepairedDataTrackingForPartitionReadsEnabled() {
        return DatabaseDescriptor.conf.repaired_data_tracking_for_partition_reads_enabled;
    }

    public static void setRepairedDataTrackingForPartitionReadsEnabled(boolean enabled) {
        DatabaseDescriptor.conf.repaired_data_tracking_for_partition_reads_enabled = enabled;
    }

    public static boolean snapshotOnRepairedDataMismatch() {
        return DatabaseDescriptor.conf.snapshot_on_repaired_data_mismatch;
    }

    public static void setSnapshotOnRepairedDataMismatch(boolean enabled) {
        DatabaseDescriptor.conf.snapshot_on_repaired_data_mismatch = enabled;
    }

    public static boolean snapshotOnDuplicateRowDetection() {
        return DatabaseDescriptor.conf.snapshot_on_duplicate_row_detection;
    }

    public static void setSnapshotOnDuplicateRowDetection(boolean enabled) {
        DatabaseDescriptor.conf.snapshot_on_duplicate_row_detection = enabled;
    }

    public static boolean reportUnconfirmedRepairedDataMismatches() {
        return DatabaseDescriptor.conf.report_unconfirmed_repaired_data_mismatches;
    }

    public static void reportUnconfirmedRepairedDataMismatches(boolean enabled) {
        DatabaseDescriptor.conf.report_unconfirmed_repaired_data_mismatches = enabled;
    }

    public static boolean strictRuntimeChecks() {
        return strictRuntimeChecks;
    }

    public static boolean useOffheapMerkleTrees() {
        return DatabaseDescriptor.conf.use_offheap_merkle_trees;
    }

    public static void useOffheapMerkleTrees(boolean value) {
        logger.info("Setting use_offheap_merkle_trees to {}", (Object)value);
        DatabaseDescriptor.conf.use_offheap_merkle_trees = value;
    }

    public static Function<CommitLog, AbstractCommitLogSegmentManager> getCommitLogSegmentMgrProvider() {
        return commitLogSegmentMgrProvider;
    }

    public static void setCommitLogSegmentMgrProvider(Function<CommitLog, AbstractCommitLogSegmentManager> provider) {
        commitLogSegmentMgrProvider = provider;
    }

    private static DataStorageSpec.IntKibibytesBound createIntKibibyteBoundAndEnsureItIsValidForByteConversion(int kibibytes, String propertyName) {
        DataStorageSpec.IntKibibytesBound intKibibytesBound = new DataStorageSpec.IntKibibytesBound(kibibytes);
        DatabaseDescriptor.checkValidForByteConversion(intKibibytesBound, propertyName);
        return intKibibytesBound;
    }

    private static void checkValidForByteConversion(DataStorageSpec.IntKibibytesBound value, String name) {
        long valueInBytes = value.toBytesInLong();
        if (valueInBytes < 0L || valueInBytes > 0x7FFFFFFEL) {
            throw new ConfigurationException(String.format("%s must be positive value <= %dB, but was %dB", name, 0x7FFFFFFE, valueInBytes), false);
        }
    }

    public static int getValidationPreviewPurgeHeadStartInSec() {
        return DatabaseDescriptor.conf.validation_preview_purge_head_start.toSeconds();
    }

    public static boolean checkForDuplicateRowsDuringReads() {
        return DatabaseDescriptor.conf.check_for_duplicate_rows_during_reads;
    }

    public static void setCheckForDuplicateRowsDuringReads(boolean enabled) {
        DatabaseDescriptor.conf.check_for_duplicate_rows_during_reads = enabled;
    }

    public static boolean checkForDuplicateRowsDuringCompaction() {
        return DatabaseDescriptor.conf.check_for_duplicate_rows_during_compaction;
    }

    public static void setCheckForDuplicateRowsDuringCompaction(boolean enabled) {
        DatabaseDescriptor.conf.check_for_duplicate_rows_during_compaction = enabled;
    }

    public static int getRepairPendingCompactionRejectThreshold() {
        return DatabaseDescriptor.conf.reject_repair_compaction_threshold;
    }

    public static void setRepairPendingCompactionRejectThreshold(int value) {
        DatabaseDescriptor.conf.reject_repair_compaction_threshold = value;
    }

    public static int getInitialRangeTombstoneListAllocationSize() {
        return DatabaseDescriptor.conf.initial_range_tombstone_list_allocation_size;
    }

    public static void setInitialRangeTombstoneListAllocationSize(int size) {
        DatabaseDescriptor.conf.initial_range_tombstone_list_allocation_size = size;
    }

    public static double getRangeTombstoneListGrowthFactor() {
        return DatabaseDescriptor.conf.range_tombstone_list_growth_factor;
    }

    public static void setRangeTombstoneListGrowthFactor(double resizeFactor) {
        DatabaseDescriptor.conf.range_tombstone_list_growth_factor = resizeFactor;
    }

    public static boolean getAutocompactionOnStartupEnabled() {
        return DatabaseDescriptor.conf.autocompaction_on_startup_enabled;
    }

    public static boolean autoOptimiseIncRepairStreams() {
        return DatabaseDescriptor.conf.auto_optimise_inc_repair_streams;
    }

    public static void setAutoOptimiseIncRepairStreams(boolean enabled) {
        if (enabled != DatabaseDescriptor.conf.auto_optimise_inc_repair_streams) {
            logger.info("Changing auto_optimise_inc_repair_streams from {} to {}", (Object)DatabaseDescriptor.conf.auto_optimise_inc_repair_streams, (Object)enabled);
        }
        DatabaseDescriptor.conf.auto_optimise_inc_repair_streams = enabled;
    }

    public static boolean autoOptimiseFullRepairStreams() {
        return DatabaseDescriptor.conf.auto_optimise_full_repair_streams;
    }

    public static void setAutoOptimiseFullRepairStreams(boolean enabled) {
        if (enabled != DatabaseDescriptor.conf.auto_optimise_full_repair_streams) {
            logger.info("Changing auto_optimise_full_repair_streams from {} to {}", (Object)DatabaseDescriptor.conf.auto_optimise_full_repair_streams, (Object)enabled);
        }
        DatabaseDescriptor.conf.auto_optimise_full_repair_streams = enabled;
    }

    public static boolean autoOptimisePreviewRepairStreams() {
        return DatabaseDescriptor.conf.auto_optimise_preview_repair_streams;
    }

    public static void setAutoOptimisePreviewRepairStreams(boolean enabled) {
        if (enabled != DatabaseDescriptor.conf.auto_optimise_preview_repair_streams) {
            logger.info("Changing auto_optimise_preview_repair_streams from {} to {}", (Object)DatabaseDescriptor.conf.auto_optimise_preview_repair_streams, (Object)enabled);
        }
        DatabaseDescriptor.conf.auto_optimise_preview_repair_streams = enabled;
    }

    @Deprecated
    public static ConsistencyLevel getAuthWriteConsistencyLevel() {
        return ConsistencyLevel.valueOf(DatabaseDescriptor.conf.auth_write_consistency_level);
    }

    public static ConsistencyLevel getAuthReadConsistencyLevel() {
        return ConsistencyLevel.valueOf(DatabaseDescriptor.conf.auth_read_consistency_level);
    }

    public static void setAuthWriteConsistencyLevel(ConsistencyLevel cl) {
        DatabaseDescriptor.conf.auth_write_consistency_level = cl.toString();
    }

    public static void setAuthReadConsistencyLevel(ConsistencyLevel cl) {
        DatabaseDescriptor.conf.auth_read_consistency_level = cl.toString();
    }

    public static int getConsecutiveMessageErrorsThreshold() {
        return DatabaseDescriptor.conf.consecutive_message_errors_threshold;
    }

    public static void setConsecutiveMessageErrorsThreshold(int value) {
        DatabaseDescriptor.conf.consecutive_message_errors_threshold = value;
    }

    public static boolean getPartitionDenylistEnabled() {
        return DatabaseDescriptor.conf.partition_denylist_enabled;
    }

    public static void setPartitionDenylistEnabled(boolean enabled) {
        DatabaseDescriptor.conf.partition_denylist_enabled = enabled;
    }

    public static boolean getDenylistWritesEnabled() {
        return DatabaseDescriptor.conf.denylist_writes_enabled;
    }

    public static void setDenylistWritesEnabled(boolean enabled) {
        DatabaseDescriptor.conf.denylist_writes_enabled = enabled;
    }

    public static boolean getDenylistReadsEnabled() {
        return DatabaseDescriptor.conf.denylist_reads_enabled;
    }

    public static void setDenylistReadsEnabled(boolean enabled) {
        DatabaseDescriptor.conf.denylist_reads_enabled = enabled;
    }

    public static boolean getDenylistRangeReadsEnabled() {
        return DatabaseDescriptor.conf.denylist_range_reads_enabled;
    }

    public static void setDenylistRangeReadsEnabled(boolean enabled) {
        DatabaseDescriptor.conf.denylist_range_reads_enabled = enabled;
    }

    public static int getDenylistRefreshSeconds() {
        return DatabaseDescriptor.conf.denylist_refresh.toSeconds();
    }

    public static void setDenylistRefreshSeconds(int seconds) {
        if (seconds <= 0) {
            throw new IllegalArgumentException("denylist_refresh must be a positive integer.");
        }
        DatabaseDescriptor.conf.denylist_refresh = new DurationSpec.IntSecondsBound(seconds);
    }

    public static int getDenylistInitialLoadRetrySeconds() {
        return DatabaseDescriptor.conf.denylist_initial_load_retry.toSeconds();
    }

    public static void setDenylistInitialLoadRetrySeconds(int seconds) {
        if (seconds <= 0) {
            throw new IllegalArgumentException("denylist_initial_load_retry must be a positive integer.");
        }
        DatabaseDescriptor.conf.denylist_initial_load_retry = new DurationSpec.IntSecondsBound(seconds);
    }

    public static ConsistencyLevel getDenylistConsistencyLevel() {
        return DatabaseDescriptor.conf.denylist_consistency_level;
    }

    public static void setDenylistConsistencyLevel(ConsistencyLevel cl) {
        DatabaseDescriptor.conf.denylist_consistency_level = cl;
    }

    public static int getDenylistMaxKeysPerTable() {
        return DatabaseDescriptor.conf.denylist_max_keys_per_table;
    }

    public static void setDenylistMaxKeysPerTable(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("denylist_max_keys_per_table must be a positive integer.");
        }
        DatabaseDescriptor.conf.denylist_max_keys_per_table = value;
    }

    public static int getDenylistMaxKeysTotal() {
        return DatabaseDescriptor.conf.denylist_max_keys_total;
    }

    public static void setDenylistMaxKeysTotal(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("denylist_max_keys_total must be a positive integer.");
        }
        DatabaseDescriptor.conf.denylist_max_keys_total = value;
    }

    public static boolean getAuthCacheWarmingEnabled() {
        return DatabaseDescriptor.conf.auth_cache_warming_enabled;
    }

    public static SubnetGroups getClientErrorReportingExclusions() {
        return DatabaseDescriptor.conf.client_error_reporting_exclusions;
    }

    public static SubnetGroups getInternodeErrorReportingExclusions() {
        return DatabaseDescriptor.conf.internode_error_reporting_exclusions;
    }

    public static boolean getReadThresholdsEnabled() {
        return DatabaseDescriptor.conf.read_thresholds_enabled;
    }

    public static void setReadThresholdsEnabled(boolean value) {
        if (DatabaseDescriptor.conf.read_thresholds_enabled != value) {
            DatabaseDescriptor.conf.read_thresholds_enabled = value;
            logger.info("updated read_thresholds_enabled to {}", (Object)value);
        }
    }

    @Nullable
    public static DataStorageSpec.LongBytesBound getCoordinatorReadSizeWarnThreshold() {
        return DatabaseDescriptor.conf.coordinator_read_size_warn_threshold;
    }

    public static void setCoordinatorReadSizeWarnThreshold(@Nullable DataStorageSpec.LongBytesBound value) {
        logger.info("updating  coordinator_read_size_warn_threshold to {}", (Object)value);
        DatabaseDescriptor.conf.coordinator_read_size_warn_threshold = value;
    }

    @Nullable
    public static DataStorageSpec.LongBytesBound getCoordinatorReadSizeFailThreshold() {
        return DatabaseDescriptor.conf.coordinator_read_size_fail_threshold;
    }

    public static void setCoordinatorReadSizeFailThreshold(@Nullable DataStorageSpec.LongBytesBound value) {
        logger.info("updating  coordinator_read_size_fail_threshold to {}", (Object)value);
        DatabaseDescriptor.conf.coordinator_read_size_fail_threshold = value;
    }

    @Nullable
    public static DataStorageSpec.LongBytesBound getLocalReadSizeWarnThreshold() {
        return DatabaseDescriptor.conf.local_read_size_warn_threshold;
    }

    public static void setLocalReadSizeWarnThreshold(@Nullable DataStorageSpec.LongBytesBound value) {
        logger.info("updating  local_read_size_warn_threshold to {}", (Object)value);
        DatabaseDescriptor.conf.local_read_size_warn_threshold = value;
    }

    @Nullable
    public static DataStorageSpec.LongBytesBound getLocalReadSizeFailThreshold() {
        return DatabaseDescriptor.conf.local_read_size_fail_threshold;
    }

    public static void setLocalReadSizeFailThreshold(@Nullable DataStorageSpec.LongBytesBound value) {
        logger.info("updating  local_read_size_fail_threshold to {}", (Object)value);
        DatabaseDescriptor.conf.local_read_size_fail_threshold = value;
    }

    @Nullable
    public static DataStorageSpec.LongBytesBound getRowIndexReadSizeWarnThreshold() {
        return DatabaseDescriptor.conf.row_index_read_size_warn_threshold;
    }

    public static void setRowIndexReadSizeWarnThreshold(@Nullable DataStorageSpec.LongBytesBound value) {
        logger.info("updating  row_index_size_warn_threshold to {}", (Object)value);
        DatabaseDescriptor.conf.row_index_read_size_warn_threshold = value;
    }

    @Nullable
    public static DataStorageSpec.LongBytesBound getRowIndexReadSizeFailThreshold() {
        return DatabaseDescriptor.conf.row_index_read_size_fail_threshold;
    }

    public static void setRowIndexReadSizeFailThreshold(@Nullable DataStorageSpec.LongBytesBound value) {
        logger.info("updating  row_index_read_size_fail_threshold to {}", (Object)value);
        DatabaseDescriptor.conf.row_index_read_size_fail_threshold = value;
    }

    public static int getDefaultKeyspaceRF() {
        return DatabaseDescriptor.conf.default_keyspace_rf;
    }

    public static void setDefaultKeyspaceRF(int value) throws IllegalArgumentException {
        if (value < 1) {
            throw new IllegalArgumentException("default_keyspace_rf cannot be less than 1");
        }
        if (value < guardrails.getMinimumReplicationFactorFailThreshold()) {
            throw new IllegalArgumentException(String.format("default_keyspace_rf to be set (%d) cannot be less than minimum_replication_factor_fail_threshold (%d)", value, guardrails.getMinimumReplicationFactorFailThreshold()));
        }
        if (guardrails.getMaximumReplicationFactorFailThreshold() != -1 && value > guardrails.getMaximumReplicationFactorFailThreshold()) {
            throw new IllegalArgumentException(String.format("default_keyspace_rf to be set (%d) cannot be greater than maximum_replication_factor_fail_threshold (%d)", value, guardrails.getMaximumReplicationFactorFailThreshold()));
        }
        DatabaseDescriptor.conf.default_keyspace_rf = value;
    }

    public static boolean getUseStatementsEnabled() {
        return DatabaseDescriptor.conf.use_statements_enabled;
    }

    public static void setUseStatementsEnabled(boolean enabled) {
        if (enabled != DatabaseDescriptor.conf.use_statements_enabled) {
            logger.info("Setting use_statements_enabled to {}", (Object)enabled);
            DatabaseDescriptor.conf.use_statements_enabled = enabled;
        }
    }

    public static boolean getForceNewPreparedStatementBehaviour() {
        return DatabaseDescriptor.conf.force_new_prepared_statement_behaviour;
    }

    public static void setForceNewPreparedStatementBehaviour(boolean value) {
        if (value != DatabaseDescriptor.conf.force_new_prepared_statement_behaviour) {
            logger.info("Setting force_new_prepared_statement_behaviour to {}", (Object)value);
            DatabaseDescriptor.conf.force_new_prepared_statement_behaviour = value;
        }
    }

    public static DurationSpec.LongNanosecondsBound getStreamingStateExpires() {
        return DatabaseDescriptor.conf.streaming_state_expires;
    }

    public static void setStreamingStateExpires(DurationSpec.LongNanosecondsBound duration) {
        if (!DatabaseDescriptor.conf.streaming_state_expires.equals(Objects.requireNonNull(duration, "duration"))) {
            logger.info("Setting streaming_state_expires to {}", (Object)duration);
            DatabaseDescriptor.conf.streaming_state_expires = duration;
        }
    }

    public static DataStorageSpec.LongBytesBound getStreamingStateSize() {
        return DatabaseDescriptor.conf.streaming_state_size;
    }

    public static void setStreamingStateSize(DataStorageSpec.LongBytesBound duration) {
        if (!DatabaseDescriptor.conf.streaming_state_size.equals(Objects.requireNonNull(duration, "duration"))) {
            logger.info("Setting streaming_state_size to {}", (Object)duration);
            DatabaseDescriptor.conf.streaming_state_size = duration;
        }
    }

    public static boolean getStreamingStatsEnabled() {
        return DatabaseDescriptor.conf.streaming_stats_enabled;
    }

    public static void setStreamingStatsEnabled(boolean streamingStatsEnabled) {
        if (DatabaseDescriptor.conf.streaming_stats_enabled != streamingStatsEnabled) {
            logger.info("Setting streaming_stats_enabled to {}", (Object)streamingStatsEnabled);
            DatabaseDescriptor.conf.streaming_stats_enabled = streamingStatsEnabled;
        }
    }

    public static DurationSpec.IntSecondsBound getStreamingSlowEventsLogTimeout() {
        return DatabaseDescriptor.conf.streaming_slow_events_log_timeout;
    }

    public static void setStreamingSlowEventsLogTimeout(String value) {
        DurationSpec.IntSecondsBound next = new DurationSpec.IntSecondsBound(value);
        if (!DatabaseDescriptor.conf.streaming_slow_events_log_timeout.equals(next)) {
            logger.info("Setting streaming_slow_events_log to " + value);
            DatabaseDescriptor.conf.streaming_slow_events_log_timeout = next;
        }
    }

    public static boolean isUUIDSSTableIdentifiersEnabled() {
        return DatabaseDescriptor.conf.uuid_sstable_identifiers_enabled;
    }

    public static DurationSpec.LongNanosecondsBound getRepairStateExpires() {
        return DatabaseDescriptor.conf.repair_state_expires;
    }

    public static void setRepairStateExpires(DurationSpec.LongNanosecondsBound duration) {
        if (!DatabaseDescriptor.conf.repair_state_expires.equals(Objects.requireNonNull(duration, "duration"))) {
            logger.info("Setting repair_state_expires to {}", (Object)duration);
            DatabaseDescriptor.conf.repair_state_expires = duration;
        }
    }

    public static int getRepairStateSize() {
        return DatabaseDescriptor.conf.repair_state_size;
    }

    public static void setRepairStateSize(int size) {
        if (DatabaseDescriptor.conf.repair_state_size != size) {
            logger.info("Setting repair_state_size to {}", (Object)size);
            DatabaseDescriptor.conf.repair_state_size = size;
        }
    }

    public static boolean topPartitionsEnabled() {
        return DatabaseDescriptor.conf.top_partitions_enabled;
    }

    public static int getMaxTopSizePartitionCount() {
        return DatabaseDescriptor.conf.max_top_size_partition_count;
    }

    public static void setMaxTopSizePartitionCount(int value) {
        DatabaseDescriptor.conf.max_top_size_partition_count = value;
    }

    public static int getMaxTopTombstonePartitionCount() {
        return DatabaseDescriptor.conf.max_top_tombstone_partition_count;
    }

    public static void setMaxTopTombstonePartitionCount(int value) {
        DatabaseDescriptor.conf.max_top_tombstone_partition_count = value;
    }

    public static DataStorageSpec.LongBytesBound getMinTrackedPartitionSizeInBytes() {
        return DatabaseDescriptor.conf.min_tracked_partition_size;
    }

    public static void setMinTrackedPartitionSizeInBytes(DataStorageSpec.LongBytesBound spec) {
        DatabaseDescriptor.conf.min_tracked_partition_size = spec;
    }

    public static long getMinTrackedPartitionTombstoneCount() {
        return DatabaseDescriptor.conf.min_tracked_partition_tombstone_count;
    }

    public static void setMinTrackedPartitionTombstoneCount(long value) {
        DatabaseDescriptor.conf.min_tracked_partition_tombstone_count = value;
    }

    public static boolean getDumpHeapOnUncaughtException() {
        return DatabaseDescriptor.conf.dump_heap_on_uncaught_exception;
    }

    private static boolean maybeCreateHeapDumpPath() {
        if (!DatabaseDescriptor.conf.dump_heap_on_uncaught_exception) {
            return false;
        }
        Path heap_dump_path = DatabaseDescriptor.getHeapDumpPath();
        if (heap_dump_path == null) {
            logger.warn("Neither -XX:HeapDumpPath nor cassandra.yaml:heap_dump_path are set; unable to create a directory to hold the output.");
            return false;
        }
        if (PathUtils.exists(File.getPath(DatabaseDescriptor.conf.heap_dump_path, new String[0]))) {
            return true;
        }
        return PathUtils.createDirectoryIfNotExists(File.getPath(DatabaseDescriptor.conf.heap_dump_path, new String[0]));
    }

    public static Path getHeapDumpPath() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        Optional<String> pathArg = runtimeMxBean.getInputArguments().stream().filter(s -> s.startsWith("-XX:HeapDumpPath=")).findFirst();
        if (pathArg.isPresent()) {
            Pattern HEAP_DUMP_PATH_SPLITTER = Pattern.compile("HeapDumpPath=");
            String fullHeapPathString = HEAP_DUMP_PATH_SPLITTER.split(pathArg.get())[1];
            Path absolutePath = File.getPath(fullHeapPathString, new String[0]).toAbsolutePath();
            Path basePath = fullHeapPathString.endsWith(".hprof") ? absolutePath.subpath(0, absolutePath.getNameCount() - 1) : absolutePath;
            return File.getPath("/", new String[0]).resolve(basePath);
        }
        if (DatabaseDescriptor.conf.heap_dump_path == null) {
            throw new ConfigurationException("Attempted to get heap dump path without -XX:HeapDumpPath or cassandra.yaml:heap_dump_path set.");
        }
        return File.getPath(DatabaseDescriptor.conf.heap_dump_path, new String[0]);
    }

    public static void setDumpHeapOnUncaughtException(boolean enabled) {
        DatabaseDescriptor.conf.dump_heap_on_uncaught_exception = enabled;
        boolean pathExists = DatabaseDescriptor.maybeCreateHeapDumpPath();
        if (enabled && !pathExists) {
            logger.error("Attempted to enable heap dump but cannot create the requested path. Disabling.");
            DatabaseDescriptor.conf.dump_heap_on_uncaught_exception = false;
        } else {
            logger.info("Setting dump_heap_on_uncaught_exception to {}", (Object)enabled);
        }
    }

    public static boolean getSStableReadRatePersistenceEnabled() {
        return DatabaseDescriptor.conf.sstable_read_rate_persistence_enabled;
    }

    public static void setSStableReadRatePersistenceEnabled(boolean enabled) {
        if (enabled != DatabaseDescriptor.conf.sstable_read_rate_persistence_enabled) {
            logger.info("Setting sstable_read_rate_persistence_enabled to {}", (Object)enabled);
            DatabaseDescriptor.conf.sstable_read_rate_persistence_enabled = enabled;
        }
    }

    public static boolean getClientRequestSizeMetricsEnabled() {
        return DatabaseDescriptor.conf.client_request_size_metrics_enabled;
    }

    public static void setClientRequestSizeMetricsEnabled(boolean enabled) {
        DatabaseDescriptor.conf.client_request_size_metrics_enabled = enabled;
    }

    @VisibleForTesting
    public static void resetSSTableFormats(Iterable<SSTableFormat.Factory> factories, Config.SSTableConfig config) {
        sstableFormats = null;
        selectedSSTableFormat = null;
        DatabaseDescriptor.applySSTableFormats(factories, config);
    }

    public static ImmutableMap<String, SSTableFormat<?, ?>> getSSTableFormats() {
        return Objects.requireNonNull(sstableFormats, "Forgot to initialize DatabaseDescriptor?");
    }

    public static SSTableFormat<?, ?> getSelectedSSTableFormat() {
        return Objects.requireNonNull(selectedSSTableFormat, "Forgot to initialize DatabaseDescriptor?");
    }

    @VisibleForTesting
    public static void setSelectedSSTableFormat(SSTableFormat<?, ?> format) {
        selectedSSTableFormat = Objects.requireNonNull(format);
    }

    public static boolean getDynamicDataMaskingEnabled() {
        return DatabaseDescriptor.conf.dynamic_data_masking_enabled;
    }

    public static void setDynamicDataMaskingEnabled(boolean enabled) {
        if (enabled != DatabaseDescriptor.conf.dynamic_data_masking_enabled) {
            logger.info("Setting dynamic_data_masking_enabled to {}", (Object)enabled);
            DatabaseDescriptor.conf.dynamic_data_masking_enabled = enabled;
        }
    }

    public static OptionalDouble getSeverityDuringDecommission() {
        return DatabaseDescriptor.conf.severity_during_decommission > 0.0 ? OptionalDouble.of(DatabaseDescriptor.conf.severity_during_decommission) : OptionalDouble.empty();
    }

    public static StorageCompatibilityMode getStorageCompatibilityMode() {
        if (conf == null) {
            return CassandraRelevantProperties.JUNIT_STORAGE_COMPATIBILITY_MODE.getEnum(StorageCompatibilityMode.CASSANDRA_4);
        }
        return DatabaseDescriptor.conf.storage_compatibility_mode;
    }

    public static ParameterizedClass getDefaultCompaction() {
        return conf != null ? DatabaseDescriptor.conf.default_compaction : null;
    }

    public static DataStorageSpec.IntMebibytesBound getSAISegmentWriteBufferSpace() {
        return DatabaseDescriptor.conf.sai_options.segment_write_buffer_size;
    }

    static {
        FBUtilities.preventIllegalAccessWarnings();
        CassandraRelevantProperties.IO_NETTY_TRANSPORT_ESTIMATE_SIZE_ON_SUBMIT.setBoolean(false);
        logger = LoggerFactory.getLogger(DatabaseDescriptor.class);
        LOWEST_ACCEPTED_TIMEOUT = new DurationSpec.LongMillisecondsBound(10L);
        internodeAuthenticator = new AllowAllInternodeAuthenticator();
        searchConcurrencyFactor = CassandraRelevantProperties.SEARCH_CONCURRENCY_FACTOR.getInt();
        disableSTCSInL0 = CassandraRelevantProperties.DISABLE_STCS_IN_L0.getBoolean();
        unsafeSystem = CassandraRelevantProperties.UNSAFE_SYSTEM.getBoolean();
        strictRuntimeChecks = CassandraRelevantProperties.TEST_STRICT_RUNTIME_CHECKS.getBoolean();
        allowUnlimitedConcurrentValidations = CassandraRelevantProperties.ALLOW_UNLIMITED_CONCURRENT_VALIDATIONS.getBoolean();
        commitLogSegmentMgrProvider = c -> DatabaseDescriptor.isCDCEnabled() ? new CommitLogSegmentManagerCDC((CommitLog)c, DatabaseDescriptor.getCommitLogLocation()) : new CommitLogSegmentManagerStandard((CommitLog)c, DatabaseDescriptor.getCommitLogLocation());
    }
}

