/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.cassandra.tools.nodetool.stats.StatsHolder;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public interface StatsPrinter<T extends StatsHolder> {
    public void print(T var1, PrintStream var2);

    public static class YamlPrinter<T extends StatsHolder>
    implements StatsPrinter<T> {
        @Override
        public void print(T data, PrintStream out) {
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(options);
            out.println(yaml.dump(data.convert2Map()));
        }
    }

    public static class JsonPrinter<T extends StatsHolder>
    implements StatsPrinter<T> {
        @Override
        public void print(T data, PrintStream out) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(data.convert2Map());
                out.println(json);
            }
            catch (IOException e) {
                out.println(e);
            }
        }
    }
}

