/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.compress.CorruptBlockException;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.AbstractReaderFileProxy;
import org.apache.cassandra.io.util.BufferManagingRebufferer;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.ChunkReader;
import org.apache.cassandra.io.util.MmappedRegions;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.ThreadLocalByteBufferHolder;
import org.apache.cassandra.utils.ChecksumType;

public abstract class CompressedChunkReader
extends AbstractReaderFileProxy
implements ChunkReader {
    final CompressionMetadata metadata;
    final int maxCompressedLength;

    protected CompressedChunkReader(ChannelProxy channel, CompressionMetadata metadata) {
        super(channel, metadata.dataLength);
        this.metadata = metadata;
        this.maxCompressedLength = metadata.maxCompressedLength();
        assert (Integer.bitCount(metadata.chunkLength()) == 1);
    }

    @Override
    @VisibleForTesting
    public double getCrcCheckChance() {
        return this.metadata.parameters.getCrcCheckChance();
    }

    boolean shouldCheckCrc() {
        return this.metadata.parameters.shouldCheckCrc();
    }

    @Override
    public String toString() {
        return String.format("CompressedChunkReader.%s(%s - %s, chunk length %d, data length %d)", this.getClass().getSimpleName(), this.channel.filePath(), this.metadata.compressor().getClass().getSimpleName(), this.metadata.chunkLength(), this.metadata.dataLength);
    }

    @Override
    public int chunkSize() {
        return this.metadata.chunkLength();
    }

    @Override
    public BufferType preferredBufferType() {
        return this.metadata.compressor().preferredBufferType();
    }

    @Override
    public Rebufferer instantiateRebufferer() {
        return new BufferManagingRebufferer.Aligned(this);
    }

    public static class Mmap
    extends CompressedChunkReader {
        protected final MmappedRegions regions;

        public Mmap(ChannelProxy channel, CompressionMetadata metadata, MmappedRegions regions) {
            super(channel, metadata);
            this.regions = regions;
        }

        @Override
        public void readChunk(long position, ByteBuffer uncompressed) {
            try {
                assert ((position & (long)(-uncompressed.capacity())) == position);
                assert (position <= this.fileLength);
                CompressionMetadata.Chunk chunk = this.metadata.chunkFor(position);
                MmappedRegions.Region region = this.regions.floor(chunk.offset);
                long segmentOffset = region.offset();
                int chunkOffset = Ints.checkedCast((long)(chunk.offset - segmentOffset));
                ByteBuffer compressedChunk = region.buffer();
                compressedChunk.position(chunkOffset).limit(chunkOffset + chunk.length);
                uncompressed.clear();
                try {
                    if (this.shouldCheckCrc()) {
                        int checksum = (int)ChecksumType.CRC32.of(compressedChunk);
                        compressedChunk.limit(compressedChunk.capacity());
                        if (compressedChunk.getInt() != checksum) {
                            throw new CorruptBlockException(this.channel.filePath(), chunk);
                        }
                        compressedChunk.position(chunkOffset).limit(chunkOffset + chunk.length);
                    }
                    if (chunk.length < this.maxCompressedLength) {
                        this.metadata.compressor().uncompress(compressedChunk, uncompressed);
                    } else {
                        uncompressed.put(compressedChunk);
                    }
                }
                catch (IOException e) {
                    throw new CorruptBlockException(this.channel.filePath(), chunk, e);
                }
                uncompressed.flip();
            }
            catch (CorruptBlockException e) {
                uncompressed.position(0).limit(0);
                throw new CorruptSSTableException((Throwable)e, this.channel.filePath());
            }
        }

        @Override
        public void close() {
            this.regions.closeQuietly();
            super.close();
        }
    }

    public static class Standard
    extends CompressedChunkReader {
        private final ThreadLocalByteBufferHolder bufferHolder;

        public Standard(ChannelProxy channel, CompressionMetadata metadata) {
            super(channel, metadata);
            this.bufferHolder = new ThreadLocalByteBufferHolder(metadata.compressor().preferredBufferType());
        }

        @Override
        public void readChunk(long position, ByteBuffer uncompressed) {
            try {
                int length;
                assert ((position & (long)(-uncompressed.capacity())) == position);
                assert (position <= this.fileLength);
                CompressionMetadata.Chunk chunk = this.metadata.chunkFor(position);
                boolean shouldCheckCrc = this.shouldCheckCrc();
                int n = length = shouldCheckCrc ? chunk.length + 4 : chunk.length;
                if (chunk.length < this.maxCompressedLength) {
                    ByteBuffer compressed = this.bufferHolder.getBuffer(length);
                    if (this.channel.read(compressed, chunk.offset) != length) {
                        throw new CorruptBlockException(this.channel.filePath(), chunk);
                    }
                    compressed.flip();
                    compressed.limit(chunk.length);
                    uncompressed.clear();
                    if (shouldCheckCrc) {
                        int checksum = (int)ChecksumType.CRC32.of(compressed);
                        compressed.limit(length);
                        if (compressed.getInt() != checksum) {
                            throw new CorruptBlockException(this.channel.filePath(), chunk);
                        }
                        compressed.position(0).limit(chunk.length);
                    }
                    try {
                        this.metadata.compressor().uncompress(compressed, uncompressed);
                    }
                    catch (IOException e) {
                        throw new CorruptBlockException(this.channel.filePath(), chunk, e);
                    }
                } else {
                    uncompressed.position(0).limit(chunk.length);
                    if (this.channel.read(uncompressed, chunk.offset) != chunk.length) {
                        throw new CorruptBlockException(this.channel.filePath(), chunk);
                    }
                    if (shouldCheckCrc) {
                        uncompressed.flip();
                        int checksum = (int)ChecksumType.CRC32.of(uncompressed);
                        ByteBuffer scratch = this.bufferHolder.getBuffer(4);
                        if (this.channel.read(scratch, chunk.offset + (long)chunk.length) != 4 || scratch.getInt(0) != checksum) {
                            throw new CorruptBlockException(this.channel.filePath(), chunk);
                        }
                    }
                }
                uncompressed.flip();
            }
            catch (CorruptBlockException e) {
                uncompressed.position(0).limit(0);
                throw new CorruptSSTableException((Throwable)e, this.channel.filePath());
            }
        }
    }
}

