/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.LongSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class LongType
extends NumberType<Long> {
    public static final LongType instance = new LongType();

    LongType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return LongType.compareLongs(left, accessorL, right, accessorR);
    }

    public static <VL, VR> int compareLongs(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
            return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
        }
        int diff = accessorL.getByte(left, 0) - accessorR.getByte(right, 0);
        if (diff != 0) {
            return diff;
        }
        return ValueAccessor.compare(left, accessorL, right, accessorR);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        long longType;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            longType = Long.parseLong(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("Unable to make long from '%s'", source), e);
        }
        return this.decompose(longType);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            if (parsed instanceof String) {
                return new Constants.Value(this.fromString((String)parsed));
            }
            Number parsedNumber = (Number)parsed;
            if (!(parsedNumber instanceof Integer) && !(parsedNumber instanceof Long)) {
                throw new MarshalException(String.format("Expected a bigint value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
            }
            return new Constants.Value(this.getSerializer().serialize(parsedNumber.longValue()));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a bigint value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return Objects.toString(this.getSerializer().deserialize(buffer), "\"\"");
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this == otherType || otherType == DateType.instance || otherType == TimestampType.instance;
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.BIGINT;
    }

    @Override
    public TypeSerializer<Long> getSerializer() {
        return LongSerializer.instance;
    }

    @Override
    public int valueLengthIfFixed() {
        return 8;
    }

    @Override
    protected int toInt(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected float toFloat(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected long toLong(ByteBuffer value) {
        return ByteBufferUtil.toLong(value);
    }

    @Override
    public ByteBuffer add(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toLong(left) + rightType.toLong(right));
    }

    @Override
    public ByteBuffer substract(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toLong(left) - rightType.toLong(right));
    }

    @Override
    public ByteBuffer multiply(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toLong(left) * rightType.toLong(right));
    }

    @Override
    public ByteBuffer divide(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toLong(left) / rightType.toLong(right));
    }

    @Override
    public ByteBuffer mod(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toLong(left) % rightType.toLong(right));
    }

    @Override
    public ByteBuffer negate(ByteBuffer input) {
        return ByteBufferUtil.bytes(-this.toLong(input));
    }
}

