/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.MonotonicClock;

public abstract class Sampler<T> {
    @VisibleForTesting
    MonotonicClock clock = MonotonicClock.Global.approxTime;
    @VisibleForTesting
    static final ExecutorPlus samplerExecutor = (ExecutorPlus)ExecutorFactory.Global.executorFactory().withJmxInternal().configureSequential("Sampler").withQueueLimit(1000).withRejectedExecutionHandler((runnable, executor) -> MessagingService.instance().metrics.recordSelfDroppedMessage(Verb._SAMPLE)).build();

    public void addSample(T item, int value) {
        if (this.isEnabled()) {
            samplerExecutor.submit(() -> this.insert(item, value));
        }
    }

    protected abstract void insert(T var1, long var2);

    public abstract boolean isEnabled();

    public abstract void beginSampling(int var1, int var2);

    public abstract List<Sample<T>> finishSampling(int var1);

    public abstract String toString(T var1);

    public static void shutdownNowAndWait(long time, TimeUnit units) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdownNowAndWait(time, units, samplerExecutor);
    }

    public static class Sample<S>
    implements Serializable {
        public final S value;
        public final long count;
        public final long error;

        public Sample(S value, long count, long error) {
            this.value = value;
            this.count = count;
            this.error = error;
        }

        public String toString() {
            return "Sample [value=" + this.value + ", count=" + this.count + ", error=" + this.error + "]";
        }
    }

    public static enum SamplerType {
        READS,
        WRITES,
        LOCAL_READ_TIME,
        WRITE_SIZE,
        CAS_CONTENTIONS;

    }
}

