/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.aggregation;

import java.io.IOException;
import java.util.List;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.aggregation.GroupMaker;
import org.apache.cassandra.db.aggregation.GroupingState;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadata;

public abstract class AggregationSpecification {
    public static final Serializer serializer = new Serializer();
    public static final AggregationSpecification AGGREGATE_EVERYTHING = new AggregationSpecification(Kind.AGGREGATE_EVERYTHING){

        @Override
        public GroupMaker newGroupMaker(GroupingState state) {
            return GroupMaker.GROUP_EVERYTHING;
        }
    };
    public static final Factory AGGREGATE_EVERYTHING_FACTORY = options -> AGGREGATE_EVERYTHING;
    private final Kind kind;

    public Kind kind() {
        return this.kind;
    }

    private AggregationSpecification(Kind kind) {
        this.kind = kind;
    }

    public final GroupMaker newGroupMaker() {
        return this.newGroupMaker(GroupingState.EMPTY_STATE);
    }

    public abstract GroupMaker newGroupMaker(GroupingState var1);

    public static Factory aggregatePkPrefixFactory(ClusteringComparator comparator, int clusteringPrefixSize) {
        return options -> new AggregateByPkPrefix(comparator, clusteringPrefixSize);
    }

    public static Factory aggregatePkPrefixFactoryWithSelector(final ClusteringComparator comparator, final int clusteringPrefixSize, final Selector.Factory factory) {
        return new Factory(){

            @Override
            public void addFunctionsTo(List<Function> functions) {
                factory.addFunctionsTo(functions);
            }

            @Override
            public AggregationSpecification newInstance(QueryOptions options) {
                Selector selector = factory.newInstance(options);
                selector.validateForGroupBy();
                return new AggregateByPkPrefixWithSelector(comparator, clusteringPrefixSize, selector);
            }
        };
    }

    public static class Serializer {
        public void serialize(AggregationSpecification aggregationSpec, DataOutputPlus out, int version) throws IOException {
            out.writeByte(aggregationSpec.kind().ordinal());
            switch (aggregationSpec.kind()) {
                case AGGREGATE_EVERYTHING: {
                    break;
                }
                case AGGREGATE_BY_PK_PREFIX: {
                    out.writeUnsignedVInt(((AggregateByPkPrefix)aggregationSpec).clusteringPrefixSize);
                    break;
                }
                case AGGREGATE_BY_PK_PREFIX_WITH_SELECTOR: {
                    AggregateByPkPrefixWithSelector spec = (AggregateByPkPrefixWithSelector)aggregationSpec;
                    out.writeUnsignedVInt(spec.clusteringPrefixSize);
                    Selector.serializer.serialize(spec.selector, out, version);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknow aggregation kind: " + (Object)((Object)aggregationSpec.kind())));
                }
            }
        }

        public AggregationSpecification deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            Kind kind = Kind.values()[in.readUnsignedByte()];
            switch (kind) {
                case AGGREGATE_EVERYTHING: {
                    return AGGREGATE_EVERYTHING;
                }
                case AGGREGATE_BY_PK_PREFIX: {
                    return new AggregateByPkPrefix(metadata.comparator, (int)in.readUnsignedVInt());
                }
                case AGGREGATE_BY_PK_PREFIX_WITH_SELECTOR: {
                    int clusteringPrefixSize = (int)in.readUnsignedVInt();
                    Selector selector = Selector.serializer.deserialize(in, version, metadata);
                    return new AggregateByPkPrefixWithSelector(metadata.comparator, clusteringPrefixSize, selector);
                }
            }
            throw new AssertionError((Object)("Unknow aggregation kind: " + (Object)((Object)kind)));
        }

        public long serializedSize(AggregationSpecification aggregationSpec, int version) {
            long size = TypeSizes.sizeof((byte)aggregationSpec.kind().ordinal());
            switch (aggregationSpec.kind()) {
                case AGGREGATE_EVERYTHING: {
                    break;
                }
                case AGGREGATE_BY_PK_PREFIX: {
                    size += (long)TypeSizes.sizeofUnsignedVInt(((AggregateByPkPrefix)aggregationSpec).clusteringPrefixSize);
                    break;
                }
                case AGGREGATE_BY_PK_PREFIX_WITH_SELECTOR: {
                    AggregateByPkPrefixWithSelector spec = (AggregateByPkPrefixWithSelector)aggregationSpec;
                    size += (long)TypeSizes.sizeofUnsignedVInt(spec.clusteringPrefixSize);
                    size += (long)Selector.serializer.serializedSize(spec.selector, version);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknow aggregation kind: " + (Object)((Object)aggregationSpec.kind())));
                }
            }
            return size;
        }
    }

    private static final class AggregateByPkPrefixWithSelector
    extends AggregateByPkPrefix {
        private final Selector selector;

        public AggregateByPkPrefixWithSelector(ClusteringComparator comparator, int clusteringPrefixSize, Selector selector) {
            super(Kind.AGGREGATE_BY_PK_PREFIX_WITH_SELECTOR, comparator, clusteringPrefixSize);
            this.selector = selector;
        }

        @Override
        public GroupMaker newGroupMaker(GroupingState state) {
            return GroupMaker.newSelectorGroupMaker(this.comparator, this.clusteringPrefixSize, this.selector, state);
        }
    }

    private static class AggregateByPkPrefix
    extends AggregationSpecification {
        protected final int clusteringPrefixSize;
        protected final ClusteringComparator comparator;

        public AggregateByPkPrefix(ClusteringComparator comparator, int clusteringPrefixSize) {
            this(Kind.AGGREGATE_BY_PK_PREFIX, comparator, clusteringPrefixSize);
        }

        protected AggregateByPkPrefix(Kind kind, ClusteringComparator comparator, int clusteringPrefixSize) {
            super(kind);
            this.comparator = comparator;
            this.clusteringPrefixSize = clusteringPrefixSize;
        }

        @Override
        public GroupMaker newGroupMaker(GroupingState state) {
            return GroupMaker.newPkPrefixGroupMaker(this.comparator, this.clusteringPrefixSize, state);
        }
    }

    public static interface Factory {
        public AggregationSpecification newInstance(QueryOptions var1);

        default public void addFunctionsTo(List<Function> functions) {
        }
    }

    public static enum Kind {
        AGGREGATE_EVERYTHING,
        AGGREGATE_BY_PK_PREFIX,
        AGGREGATE_BY_PK_PREFIX_WITH_SELECTOR;

    }
}

