/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class EmptySerializer
extends TypeSerializer<Void> {
    public static final EmptySerializer instance = new EmptySerializer();

    @Override
    public <V> Void deserialize(V value, ValueAccessor<V> accessor) {
        this.validate(value, accessor);
        return null;
    }

    @Override
    public ByteBuffer serialize(Void value) {
        return ByteBufferUtil.EMPTY_BYTE_BUFFER;
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (!accessor.isEmpty(value)) {
            throw new MarshalException("EmptyType only accept empty values");
        }
    }

    @Override
    public String toString(Void value) {
        return "";
    }

    @Override
    public Class<Void> getType() {
        return Void.class;
    }
}

