/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.consistent.admin;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.repair.consistent.RepairedState;

public class RepairStats {
    private static final String[] COMPOSITE_NAMES = new String[]{"keyspace", "table", "minRepaired", "maxRepaired", "sections"};
    private static final OpenType<?>[] COMPOSITE_TYPES;
    private static final CompositeType COMPOSITE_TYPE;
    public final String keyspace;
    public final String table;
    public final long minRepaired;
    public final long maxRepaired;
    public final List<Section> sections;

    private RepairStats(String keyspace, String table, long minRepaired, long maxRepaired, List<Section> sections) {
        this.keyspace = keyspace;
        this.table = table;
        this.minRepaired = minRepaired;
        this.maxRepaired = maxRepaired;
        this.sections = sections;
    }

    public static List<Section> convertSections(List<RepairedState.Section> from) {
        ArrayList<Section> to = new ArrayList<Section>(from.size());
        for (RepairedState.Section section : from) {
            to.add(new Section(((Token)section.range.left).toString(), ((Token)section.range.right).toString(), section.repairedAt));
        }
        return to;
    }

    public static RepairStats fromRepairState(String keyspace, String table, RepairedState.Stats stats) {
        return new RepairStats(keyspace, table, stats.minRepaired, stats.maxRepaired, RepairStats.convertSections(stats.sections));
    }

    public CompositeData toComposite() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(COMPOSITE_NAMES[0], this.keyspace);
        values.put(COMPOSITE_NAMES[1], this.table);
        values.put(COMPOSITE_NAMES[2], this.minRepaired);
        values.put(COMPOSITE_NAMES[3], this.maxRepaired);
        CompositeData[] compositeSections = new CompositeData[this.sections.size()];
        for (int i = 0; i < this.sections.size(); ++i) {
            compositeSections[i] = this.sections.get(i).toComposite();
        }
        values.put(COMPOSITE_NAMES[4], compositeSections);
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, values);
        }
        catch (OpenDataException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static RepairStats fromComposite(CompositeData cd) {
        Preconditions.checkArgument((boolean)cd.getCompositeType().equals(COMPOSITE_TYPE));
        Object[] values = cd.getAll(COMPOSITE_NAMES);
        String keyspace = (String)values[0];
        String table = (String)values[1];
        long minRepaired = (Long)values[2];
        long maxRepaired = (Long)values[3];
        CompositeData[] sectionData = (CompositeData[])values[4];
        ArrayList<Section> sections = new ArrayList<Section>(sectionData.length);
        for (CompositeData scd : sectionData) {
            sections.add(Section.fromComposite(scd));
        }
        return new RepairStats(keyspace, table, minRepaired, maxRepaired, sections);
    }

    static {
        try {
            COMPOSITE_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, ArrayType.getArrayType(Section.COMPOSITE_TYPE)};
            COMPOSITE_TYPE = new CompositeType(RepairStats.class.getName(), RepairStats.class.getSimpleName(), COMPOSITE_NAMES, COMPOSITE_NAMES, COMPOSITE_TYPES);
        }
        catch (OpenDataException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static class Section {
        private static final String[] COMPOSITE_NAMES = new String[]{"start", "end", "repairedAt"};
        private static final OpenType<?>[] COMPOSITE_TYPES;
        private static final CompositeType COMPOSITE_TYPE;
        public final String start;
        public final String end;
        public final long time;

        public Section(String start, String end, long time) {
            this.start = start;
            this.end = end;
            this.time = time;
        }

        private CompositeData toComposite() {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put(COMPOSITE_NAMES[0], this.start);
            values.put(COMPOSITE_NAMES[1], this.end);
            values.put(COMPOSITE_NAMES[2], this.time);
            try {
                return new CompositeDataSupport(COMPOSITE_TYPE, values);
            }
            catch (OpenDataException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        private static Section fromComposite(CompositeData cd) {
            Preconditions.checkArgument((boolean)cd.getCompositeType().equals(COMPOSITE_TYPE));
            Object[] values = cd.getAll(COMPOSITE_NAMES);
            String start = (String)values[0];
            String end = (String)values[1];
            long time = (Long)values[2];
            return new Section(start, end, time);
        }

        public String toString() {
            return String.format("(%s,%s]=%s", this.start, this.end, this.time);
        }

        static {
            try {
                COMPOSITE_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.LONG};
                COMPOSITE_TYPE = new CompositeType(Section.class.getName(), "Section", COMPOSITE_NAMES, COMPOSITE_NAMES, COMPOSITE_TYPES);
            }
            catch (OpenDataException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

