/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.metadata;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.commitlog.IntervalSet;
import org.apache.cassandra.db.partitions.PartitionStatisticsCollector;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.CompactionMetadata;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MurmurHash;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.streamhist.StreamingTombstoneHistogramBuilder;
import org.apache.cassandra.utils.streamhist.TombstoneHistogram;

public class MetadataCollector
implements PartitionStatisticsCollector {
    public static final double NO_COMPRESSION_RATIO = -1.0;
    private static final ByteBuffer[] EMPTY_CLUSTERING = new ByteBuffer[0];
    protected EstimatedHistogram estimatedPartitionSize = MetadataCollector.defaultPartitionSizeHistogram();
    protected EstimatedHistogram estimatedCellPerPartitionCount = MetadataCollector.defaultCellPerPartitionCountHistogram();
    protected IntervalSet<CommitLogPosition> commitLogIntervals = IntervalSet.empty();
    protected final MinMaxLongTracker timestampTracker = new MinMaxLongTracker();
    protected final MinMaxIntTracker localDeletionTimeTracker = new MinMaxIntTracker(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected final MinMaxIntTracker ttlTracker = new MinMaxIntTracker(0, 0);
    protected double compressionRatio = -1.0;
    protected StreamingTombstoneHistogramBuilder estimatedTombstoneDropTime = new StreamingTombstoneHistogramBuilder(100, 100000, SSTable.TOMBSTONE_HISTOGRAM_TTL_ROUND_SECONDS);
    protected int sstableLevel;
    private ClusteringPrefix<?> minClustering = null;
    private ClusteringPrefix<?> maxClustering = null;
    protected boolean hasLegacyCounterShards = false;
    protected long totalColumnsSet;
    protected long totalRows;
    public int totalTombstones;
    protected ICardinality cardinality = new HyperLogLogPlus(13, 25);
    private final ClusteringComparator comparator;
    private final int nowInSec = FBUtilities.nowInSeconds();
    private final UUID originatingHostId;

    static EstimatedHistogram defaultCellPerPartitionCountHistogram() {
        return new EstimatedHistogram(118);
    }

    static EstimatedHistogram defaultPartitionSizeHistogram() {
        return new EstimatedHistogram(150);
    }

    static TombstoneHistogram defaultTombstoneDropTimeHistogram() {
        return TombstoneHistogram.createDefault();
    }

    public static StatsMetadata defaultStatsMetadata() {
        return new StatsMetadata(MetadataCollector.defaultPartitionSizeHistogram(), MetadataCollector.defaultCellPerPartitionCountHistogram(), IntervalSet.empty(), Long.MIN_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, -1.0, MetadataCollector.defaultTombstoneDropTimeHistogram(), 0, Collections.emptyList(), Collections.emptyList(), true, 0L, -1L, -1L, null, null, false);
    }

    public MetadataCollector(ClusteringComparator comparator) {
        this(comparator, StorageService.instance.getLocalHostUUID());
    }

    public MetadataCollector(ClusteringComparator comparator, UUID originatingHostId) {
        this.comparator = comparator;
        this.originatingHostId = originatingHostId;
    }

    public MetadataCollector(Iterable<SSTableReader> sstables, ClusteringComparator comparator, int level) {
        this(comparator);
        IntervalSet.Builder<CommitLogPosition> intervals = new IntervalSet.Builder<CommitLogPosition>();
        if (this.originatingHostId != null) {
            for (SSTableReader sstable : sstables) {
                if (!this.originatingHostId.equals(sstable.getSSTableMetadata().originatingHostId)) continue;
                intervals.addAll(sstable.getSSTableMetadata().commitLogIntervals);
            }
        }
        this.commitLogIntervals(intervals.build());
        this.sstableLevel(level);
    }

    public MetadataCollector addKey(ByteBuffer key) {
        long hashed = MurmurHash.hash2_64(key, key.position(), key.remaining(), 0L);
        this.cardinality.offerHashed(hashed);
        this.totalTombstones = 0;
        return this;
    }

    public MetadataCollector addPartitionSizeInBytes(long partitionSize) {
        this.estimatedPartitionSize.add(partitionSize);
        return this;
    }

    public MetadataCollector addCellPerPartitionCount(long cellCount) {
        this.estimatedCellPerPartitionCount.add(cellCount);
        return this;
    }

    public MetadataCollector addCompressionRatio(long compressed, long uncompressed) {
        this.compressionRatio = (double)compressed / (double)uncompressed;
        return this;
    }

    @Override
    public void update(LivenessInfo newInfo) {
        if (newInfo.isEmpty()) {
            return;
        }
        this.updateTimestamp(newInfo.timestamp());
        this.updateTTL(newInfo.ttl());
        this.updateLocalDeletionTime(newInfo.localExpirationTime());
        if (!newInfo.isLive(this.nowInSec)) {
            this.updateTombstoneCount();
        }
    }

    @Override
    public void update(Cell<?> cell) {
        this.updateTimestamp(cell.timestamp());
        this.updateTTL(cell.ttl());
        this.updateLocalDeletionTime(cell.localDeletionTime());
        if (!cell.isLive(this.nowInSec)) {
            this.updateTombstoneCount();
        }
    }

    @Override
    public void update(DeletionTime dt) {
        if (!dt.isLive()) {
            this.updateTimestamp(dt.markedForDeleteAt());
            this.updateLocalDeletionTime(dt.localDeletionTime());
            this.updateTombstoneCount();
        }
    }

    @Override
    public void updateColumnSetPerRow(long columnSetInRow) {
        this.totalColumnsSet += columnSetInRow;
        ++this.totalRows;
    }

    private void updateTimestamp(long newTimestamp) {
        this.timestampTracker.update(newTimestamp);
    }

    private void updateLocalDeletionTime(int newLocalDeletionTime) {
        this.localDeletionTimeTracker.update(newLocalDeletionTime);
        if (newLocalDeletionTime != Integer.MAX_VALUE) {
            this.estimatedTombstoneDropTime.update(newLocalDeletionTime);
        }
    }

    private void updateTombstoneCount() {
        ++this.totalTombstones;
    }

    private void updateTTL(int newTTL) {
        this.ttlTracker.update(newTTL);
    }

    public MetadataCollector commitLogIntervals(IntervalSet<CommitLogPosition> commitLogIntervals) {
        this.commitLogIntervals = commitLogIntervals;
        return this;
    }

    public MetadataCollector sstableLevel(int sstableLevel) {
        this.sstableLevel = sstableLevel;
        return this;
    }

    public MetadataCollector updateClusteringValues(ClusteringPrefix<?> clustering) {
        this.minClustering = this.minClustering == null || this.comparator.compare(clustering, this.minClustering) < 0 ? clustering.minimize() : this.minClustering;
        this.maxClustering = this.maxClustering == null || this.comparator.compare(clustering, this.maxClustering) > 0 ? clustering.minimize() : this.maxClustering;
        return this;
    }

    @Override
    public void updateHasLegacyCounterShards(boolean hasLegacyCounterShards) {
        this.hasLegacyCounterShards = this.hasLegacyCounterShards || hasLegacyCounterShards;
    }

    public Map<MetadataType, MetadataComponent> finalizeMetadata(String partitioner, double bloomFilterFPChance, long repairedAt, TimeUUID pendingRepair, boolean isTransient, SerializationHeader header) {
        Preconditions.checkState((this.minClustering == null && this.maxClustering == null || this.comparator.compare(this.maxClustering, this.minClustering) >= 0 ? 1 : 0) != 0);
        ByteBuffer[] minValues = this.minClustering != null ? this.minClustering.getBufferArray() : EMPTY_CLUSTERING;
        ByteBuffer[] maxValues = this.maxClustering != null ? this.maxClustering.getBufferArray() : EMPTY_CLUSTERING;
        EnumMap<MetadataType, MetadataComponent> components = new EnumMap<MetadataType, MetadataComponent>(MetadataType.class);
        components.put(MetadataType.VALIDATION, new ValidationMetadata(partitioner, bloomFilterFPChance));
        components.put(MetadataType.STATS, new StatsMetadata(this.estimatedPartitionSize, this.estimatedCellPerPartitionCount, this.commitLogIntervals, this.timestampTracker.min(), this.timestampTracker.max(), this.localDeletionTimeTracker.min(), this.localDeletionTimeTracker.max(), this.ttlTracker.min(), this.ttlTracker.max(), this.compressionRatio, this.estimatedTombstoneDropTime.build(), this.sstableLevel, MetadataCollector.makeList(minValues), MetadataCollector.makeList(maxValues), this.hasLegacyCounterShards, repairedAt, this.totalColumnsSet, this.totalRows, this.originatingHostId, pendingRepair, isTransient));
        components.put(MetadataType.COMPACTION, new CompactionMetadata(this.cardinality));
        components.put(MetadataType.HEADER, header.toComponent());
        return components;
    }

    public void release() {
        this.estimatedTombstoneDropTime.releaseBuffers();
    }

    private static List<ByteBuffer> makeList(ByteBuffer[] values) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>(values.length);
        for (int i = 0; i < values.length && values[i] != null; ++i) {
            l.add(values[i]);
        }
        return l;
    }

    public static class MinMaxIntTracker {
        private final int defaultMin;
        private final int defaultMax;
        private boolean isSet = false;
        private int min;
        private int max;

        public MinMaxIntTracker() {
            this(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        public MinMaxIntTracker(int defaultMin, int defaultMax) {
            this.defaultMin = defaultMin;
            this.defaultMax = defaultMax;
        }

        public void update(int value) {
            if (!this.isSet) {
                this.min = this.max = value;
                this.isSet = true;
            } else {
                if (value < this.min) {
                    this.min = value;
                }
                if (value > this.max) {
                    this.max = value;
                }
            }
        }

        public int min() {
            return this.isSet ? this.min : this.defaultMin;
        }

        public int max() {
            return this.isSet ? this.max : this.defaultMax;
        }
    }

    public static class MinMaxLongTracker {
        private final long defaultMin;
        private final long defaultMax;
        private boolean isSet = false;
        private long min;
        private long max;

        public MinMaxLongTracker() {
            this(Long.MIN_VALUE, Long.MAX_VALUE);
        }

        public MinMaxLongTracker(long defaultMin, long defaultMax) {
            this.defaultMin = defaultMin;
            this.defaultMax = defaultMax;
        }

        public void update(long value) {
            if (!this.isSet) {
                this.min = this.max = value;
                this.isSet = true;
            } else {
                if (value < this.min) {
                    this.min = value;
                }
                if (value > this.max) {
                    this.max = value;
                }
            }
        }

        public long min() {
            return this.isSet ? this.min : this.defaultMin;
        }

        public long max() {
            return this.isSet ? this.max : this.defaultMax;
        }
    }
}

