/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.btree.BTreeSearchIterator;

public class SerializationHelper {
    public final SerializationHeader header;
    private BTreeSearchIterator<ColumnMetadata, ColumnMetadata> statics = null;
    private BTreeSearchIterator<ColumnMetadata, ColumnMetadata> regulars = null;

    public SerializationHelper(SerializationHeader header) {
        this.header = header;
    }

    private BTreeSearchIterator<ColumnMetadata, ColumnMetadata> statics() {
        if (this.statics == null) {
            this.statics = this.header.columns().statics.iterator();
        }
        return this.statics;
    }

    private BTreeSearchIterator<ColumnMetadata, ColumnMetadata> regulars() {
        if (this.regulars == null) {
            this.regulars = this.header.columns().regulars.iterator();
        }
        return this.regulars;
    }

    public SearchIterator<ColumnMetadata, ColumnMetadata> iterator(boolean isStatic) {
        BTreeSearchIterator<ColumnMetadata, ColumnMetadata> iterator = isStatic ? this.statics() : this.regulars();
        iterator.rewind();
        return iterator;
    }
}

