/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class InetAddressSerializer
extends TypeSerializer<InetAddress> {
    public static final InetAddressSerializer instance = new InetAddressSerializer();

    @Override
    public <V> InetAddress deserialize(V value, ValueAccessor<V> accessor) {
        if (accessor.isEmpty(value)) {
            return null;
        }
        try {
            return InetAddress.getByAddress(accessor.toArray(value));
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ByteBuffer serialize(InetAddress value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBuffer.wrap(value.getAddress());
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (accessor.isEmpty(value)) {
            return;
        }
        try {
            InetAddress.getByAddress(accessor.toArray(value));
        }
        catch (UnknownHostException e) {
            throw new MarshalException(String.format("Expected 4 or 16 byte inetaddress; got %s", accessor.toHex(value)));
        }
    }

    @Override
    public String toString(InetAddress value) {
        return value == null ? "" : value.getHostAddress();
    }

    @Override
    public Class<InetAddress> getType() {
        return InetAddress.class;
    }
}

