/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.concurrent.FutureTask;
import org.apache.cassandra.concurrent.WrappedExecutorPlus;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.DiskBoundaries;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.ActiveCompactions;
import org.apache.cassandra.db.compaction.ActiveCompactionsTracker;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.CompactionIterator;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.db.compaction.CompactionStrategyManager;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.compaction.CompactionTasks;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.Scrubber;
import org.apache.cassandra.db.compaction.Verifier;
import org.apache.cassandra.db.lifecycle.ILifecycleTransaction;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.lifecycle.SSTableIntervalTree;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.view.ViewBuilderTask;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.IndexSummaryRedistribution;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.metrics.CompactionMetrics;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.repair.NoSuchRepairSessionException;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.ImmediateFuture;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionManager
implements CompactionManagerMBean {
    public static final String MBEAN_OBJECT_NAME = "org.apache.cassandra.db:type=CompactionManager";
    private static final Logger logger = LoggerFactory.getLogger(CompactionManager.class);
    public static final CompactionManager instance = new CompactionManager();
    @VisibleForTesting
    public final AtomicInteger currentlyBackgroundUpgrading = new AtomicInteger(0);
    public static final int NO_GC = Integer.MIN_VALUE;
    public static final int GC_ALL = Integer.MAX_VALUE;
    private final CompactionExecutor executor = new CompactionExecutor();
    private final ValidationExecutor validationExecutor = new ValidationExecutor();
    private final CompactionExecutor cacheCleanupExecutor = new CacheCleanupExecutor();
    private final CompactionExecutor viewBuildExecutor = new ViewBuildExecutor();
    private final CompactionMetrics metrics = new CompactionMetrics(this.executor, this.validationExecutor, this.viewBuildExecutor);
    @VisibleForTesting
    final Multiset<ColumnFamilyStore> compactingCF = ConcurrentHashMultiset.create();
    public final ActiveCompactions active = new ActiveCompactions();
    private final AtomicInteger globalCompactionPauseCount = new AtomicInteger(0);
    private final RateLimiter compactionRateLimiter = RateLimiter.create((double)Double.MAX_VALUE);

    public CompactionMetrics getMetrics() {
        return this.metrics;
    }

    public RateLimiter getRateLimiter() {
        this.setRateInBytes(DatabaseDescriptor.getCompactionThroughputBytesPerSec());
        return this.compactionRateLimiter;
    }

    @Deprecated
    public void setRate(double throughputMbPerSec) {
        this.setRateInBytes(throughputMbPerSec * 1024.0 * 1024.0);
    }

    public void setRateInBytes(double throughputBytesPerSec) {
        double throughput = throughputBytesPerSec;
        if (throughput == 0.0 || StorageService.instance.isBootstrapMode()) {
            throughput = Double.MAX_VALUE;
        }
        if (this.compactionRateLimiter.getRate() != throughput) {
            this.compactionRateLimiter.setRate(throughput);
        }
    }

    public List<Future<?>> submitBackground(ColumnFamilyStore cfs) {
        if (cfs.isAutoCompactionDisabled()) {
            logger.trace("Autocompaction is disabled");
            return Collections.emptyList();
        }
        int count = this.compactingCF.count((Object)cfs);
        if (count > 0 && this.executor.getActiveTaskCount() >= this.executor.getMaximumPoolSize()) {
            logger.trace("Background compaction is still running for {}.{} ({} remaining). Skipping", new Object[]{cfs.keyspace.getName(), cfs.name, count});
            return Collections.emptyList();
        }
        logger.trace("Scheduling a background task check for {}.{} with {}", new Object[]{cfs.keyspace.getName(), cfs.name, cfs.getCompactionStrategyManager().getName()});
        ArrayList futures = new ArrayList(1);
        Future<Void> fut = this.executor.submitIfRunning(new BackgroundCompactionCandidate(cfs), "background task");
        if (!fut.isCancelled()) {
            futures.add(fut);
        } else {
            this.compactingCF.remove((Object)cfs);
        }
        return futures;
    }

    public boolean isCompacting(Iterable<ColumnFamilyStore> cfses, Predicate<SSTableReader> sstablePredicate) {
        for (ColumnFamilyStore cfs : cfses) {
            if (!cfs.getTracker().getCompacting().stream().anyMatch(sstablePredicate)) continue;
            return true;
        }
        return false;
    }

    public void forceShutdown() {
        this.executor.shutdown();
        this.validationExecutor.shutdown();
        this.viewBuildExecutor.shutdown();
        this.cacheCleanupExecutor.shutdown();
        for (CompactionInfo.Holder holder : this.active.getCompactions()) {
            holder.stop();
        }
        for (ExecutorService executorService : Arrays.asList(this.executor, this.validationExecutor, this.viewBuildExecutor, this.cacheCleanupExecutor)) {
            try {
                if (executorService.awaitTermination(1L, TimeUnit.MINUTES)) continue;
                logger.warn("Failed to wait for compaction executors shutdown");
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting for tasks to be terminated", (Throwable)e);
            }
        }
    }

    public void finishCompactionsAndShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(timeout, unit);
    }

    @VisibleForTesting
    public BackgroundCompactionCandidate getBackgroundCompactionCandidate(ColumnFamilyStore cfs) {
        return new BackgroundCompactionCandidate(cfs);
    }

    /*
     * Exception decompiling
     */
    private AllSSTableOpStatus parallelAllSSTableOperation(ColumnFamilyStore cfs, OneSSTableOperation operation, int jobs, OperationType operationType) throws ExecutionException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 33[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public AllSSTableOpStatus performScrub(ColumnFamilyStore cfs, boolean skipCorrupted, boolean checkData, int jobs) throws InterruptedException, ExecutionException {
        return this.performScrub(cfs, skipCorrupted, checkData, false, jobs);
    }

    public AllSSTableOpStatus performScrub(final ColumnFamilyStore cfs, final boolean skipCorrupted, final boolean checkData, final boolean reinsertOverflowedTTL, int jobs) throws InterruptedException, ExecutionException {
        return this.parallelAllSSTableOperation(cfs, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction input) {
                return input.originals();
            }

            @Override
            public void execute(LifecycleTransaction input) {
                CompactionManager.this.scrubOne(cfs, input, skipCorrupted, checkData, reinsertOverflowedTTL, CompactionManager.this.active);
            }
        }, jobs, OperationType.SCRUB);
    }

    public AllSSTableOpStatus performVerify(final ColumnFamilyStore cfs, final Verifier.Options options) throws InterruptedException, ExecutionException {
        assert (!cfs.isIndex());
        return this.parallelAllSSTableOperation(cfs, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction input) {
                return input.originals();
            }

            @Override
            public void execute(LifecycleTransaction input) {
                CompactionManager.this.verifyOne(cfs, input.onlyOne(), options, CompactionManager.this.active);
            }
        }, 0, OperationType.VERIFY);
    }

    public AllSSTableOpStatus performSSTableRewrite(ColumnFamilyStore cfs, boolean skipIfCurrentVersion, long skipIfOlderThanTimestamp, boolean skipIfCompressionMatches, int jobs) throws InterruptedException, ExecutionException {
        return this.performSSTableRewrite(cfs, sstable -> {
            if (skipIfCurrentVersion && sstable.descriptor.version.equals(sstable.descriptor.getFormat().getLatestVersion())) {
                return false;
            }
            if (sstable.getCreationTimeFor(Component.DATA) > skipIfOlderThanTimestamp) {
                return false;
            }
            TableMetadata metadata = cfs.metadata.get();
            return !skipIfCompressionMatches || (sstable.compression || metadata.params.compression.isEnabled()) && (!sstable.compression || !metadata.params.compression.equals(sstable.getCompressionMetadata().parameters));
        }, jobs);
    }

    public AllSSTableOpStatus performSSTableRewrite(final ColumnFamilyStore cfs, final Predicate<SSTableReader> sstableFilter, int jobs) throws InterruptedException, ExecutionException {
        return this.parallelAllSSTableOperation(cfs, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction transaction) {
                ArrayList sortedSSTables = Lists.newArrayList(transaction.originals());
                Collections.sort(sortedSSTables, SSTableReader.sizeComparator.reversed());
                Iterator iter = sortedSSTables.iterator();
                while (iter.hasNext()) {
                    SSTableReader sstable = (SSTableReader)iter.next();
                    if (sstableFilter.test(sstable)) continue;
                    transaction.cancel(sstable);
                    iter.remove();
                }
                return sortedSSTables;
            }

            @Override
            public void execute(LifecycleTransaction txn) {
                AbstractCompactionTask task = cfs.getCompactionStrategyManager().getCompactionTask(txn, Integer.MIN_VALUE, Long.MAX_VALUE);
                task.setUserDefined(true);
                task.setCompactionType(OperationType.UPGRADE_SSTABLES);
                task.execute(CompactionManager.this.active);
            }
        }, jobs, OperationType.UPGRADE_SSTABLES);
    }

    public AllSSTableOpStatus performCleanup(final ColumnFamilyStore cfStore, int jobs) throws InterruptedException, ExecutionException {
        assert (!cfStore.isIndex());
        Keyspace keyspace = cfStore.keyspace;
        if (!StorageService.instance.isJoined()) {
            logger.info("Cleanup cannot run before a node has joined the ring");
            return AllSSTableOpStatus.ABORTED;
        }
        final RangesAtEndpoint replicas = StorageService.instance.getLocalReplicas(keyspace.getName());
        final Set<Range<Token>> allRanges = replicas.ranges();
        final Set<Range<Token>> transientRanges = replicas.onlyTransient().ranges();
        final Set<Range<Token>> fullRanges = replicas.onlyFull().ranges();
        final boolean hasIndexes = cfStore.indexManager.hasIndexes();
        return this.parallelAllSSTableOperation(cfStore, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction transaction) {
                ArrayList sortedSSTables = Lists.newArrayList(transaction.originals());
                Iterator sstableIter = sortedSSTables.iterator();
                int totalSSTables = 0;
                int skippedSStables = 0;
                while (sstableIter.hasNext()) {
                    SSTableReader sstable = (SSTableReader)sstableIter.next();
                    boolean needsCleanupFull = CompactionManager.needsCleanup(sstable, fullRanges);
                    boolean needsCleanupTransient = !transientRanges.isEmpty() && sstable.isRepaired() && CompactionManager.needsCleanup(sstable, transientRanges);
                    ++totalSSTables;
                    if (needsCleanupFull || needsCleanupTransient) continue;
                    logger.debug("Skipping {} ([{}, {}]) for cleanup; all rows should be kept. Needs cleanup full ranges: {} Needs cleanup transient ranges: {} Repaired: {}", new Object[]{sstable, sstable.first.getToken(), sstable.last.getToken(), needsCleanupFull, needsCleanupTransient, sstable.isRepaired()});
                    sstableIter.remove();
                    transaction.cancel(sstable);
                    ++skippedSStables;
                }
                logger.info("Skipping cleanup for {}/{} sstables for {}.{} since they are fully contained in owned ranges (full ranges: {}, transient ranges: {})", new Object[]{skippedSStables, totalSSTables, cfStore.keyspace.getName(), cfStore.getTableName(), fullRanges, transientRanges});
                sortedSSTables.sort(SSTableReader.sizeComparator);
                return sortedSSTables;
            }

            @Override
            public void execute(LifecycleTransaction txn) throws IOException {
                CleanupStrategy cleanupStrategy = CleanupStrategy.get(cfStore, allRanges, transientRanges, txn.onlyOne().isRepaired(), FBUtilities.nowInSeconds());
                CompactionManager.this.doCleanupOne(cfStore, txn, cleanupStrategy, replicas.ranges(), hasIndexes);
            }
        }, jobs, OperationType.CLEANUP);
    }

    public AllSSTableOpStatus performGarbageCollection(final ColumnFamilyStore cfStore, final CompactionParams.TombstoneOption tombstoneOption, int jobs) throws InterruptedException, ExecutionException {
        assert (!cfStore.isIndex());
        return this.parallelAllSSTableOperation(cfStore, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction transaction) {
                Iterable<SSTableReader> originals = transaction.originals();
                if (cfStore.getCompactionStrategyManager().onlyPurgeRepairedTombstones()) {
                    originals = Iterables.filter(originals, SSTableReader::isRepaired);
                }
                ArrayList sortedSSTables = Lists.newArrayList(originals);
                Collections.sort(sortedSSTables, SSTableReader.maxTimestampAscending);
                return sortedSSTables;
            }

            @Override
            public void execute(final LifecycleTransaction txn) throws IOException {
                logger.debug("Garbage collecting {}", txn.originals());
                CompactionTask task = new CompactionTask(cfStore, txn, CompactionManager.getDefaultGcBefore(cfStore, FBUtilities.nowInSeconds())){

                    @Override
                    protected CompactionController getCompactionController(Set<SSTableReader> toCompact) {
                        return new CompactionController(cfStore, toCompact, this.gcBefore, null, tombstoneOption);
                    }

                    @Override
                    protected int getLevel() {
                        return txn.onlyOne().getSSTableLevel();
                    }
                };
                task.setUserDefined(true);
                task.setCompactionType(OperationType.GARBAGE_COLLECT);
                task.execute(CompactionManager.this.active);
            }
        }, jobs, OperationType.GARBAGE_COLLECT);
    }

    public AllSSTableOpStatus relocateSSTables(final ColumnFamilyStore cfs, int jobs) throws ExecutionException, InterruptedException {
        if (!cfs.getPartitioner().splitter().isPresent()) {
            logger.info("Partitioner does not support splitting");
            return AllSSTableOpStatus.ABORTED;
        }
        if (StorageService.instance.getLocalReplicas(cfs.keyspace.getName()).isEmpty()) {
            logger.info("Relocate cannot run before a node has joined the ring");
            return AllSSTableOpStatus.ABORTED;
        }
        final DiskBoundaries diskBoundaries = cfs.getDiskBoundaries();
        return this.parallelAllSSTableOperation(cfs, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction transaction) {
                HashSet originals = Sets.newHashSet(transaction.originals());
                Set<SSTableReader> needsRelocation = originals.stream().filter(s -> !this.inCorrectLocation((SSTableReader)s)).collect(Collectors.toSet());
                transaction.cancel((Iterable<SSTableReader>)Sets.difference((Set)originals, needsRelocation));
                Map<Integer, List<SSTableReader>> groupedByDisk = this.groupByDiskIndex(needsRelocation);
                int maxSize = 0;
                for (List<SSTableReader> diskSSTables : groupedByDisk.values()) {
                    maxSize = Math.max(maxSize, diskSSTables.size());
                }
                ArrayList<SSTableReader> mixedSSTables = new ArrayList<SSTableReader>();
                for (int i = 0; i < maxSize; ++i) {
                    for (List<SSTableReader> diskSSTables : groupedByDisk.values()) {
                        if (i >= diskSSTables.size()) continue;
                        mixedSSTables.add(diskSSTables.get(i));
                    }
                }
                return mixedSSTables;
            }

            public Map<Integer, List<SSTableReader>> groupByDiskIndex(Set<SSTableReader> needsRelocation) {
                return needsRelocation.stream().collect(Collectors.groupingBy(s -> diskBoundaries.getDiskIndex((SSTableReader)s)));
            }

            private boolean inCorrectLocation(SSTableReader sstable) {
                if (!cfs.getPartitioner().splitter().isPresent()) {
                    return true;
                }
                Directories.DataDirectory currentDirectory = cfs.getDirectories().getDataDirectoryForFile(sstable.descriptor);
                return diskBoundaries.isInCorrectLocation(sstable, currentDirectory);
            }

            @Override
            public void execute(LifecycleTransaction txn) {
                logger.debug("Relocating {}", txn.originals());
                AbstractCompactionTask task = cfs.getCompactionStrategyManager().getCompactionTask(txn, Integer.MIN_VALUE, Long.MAX_VALUE);
                task.setUserDefined(true);
                task.setCompactionType(OperationType.RELOCATE);
                task.execute(CompactionManager.this.active);
            }
        }, jobs, OperationType.RELOCATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> submitPendingAntiCompaction(final ColumnFamilyStore cfs, final RangesAtEndpoint tokenRanges, final Refs<SSTableReader> sstables, final LifecycleTransaction txn, final TimeUUID sessionId, final BooleanSupplier isCancelled) {
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws Exception {
                try (TableMetrics.TableTimer.Context ctx = cfs.metric.anticompactionTime.time();){
                    CompactionManager.this.performAnticompaction(cfs, tokenRanges, sstables, txn, sessionId, isCancelled);
                }
            }
        };
        Future<Void> task = null;
        try {
            Future<Void> future = task = this.executor.submitIfRunning(runnable, "pending anticompaction");
            return future;
        }
        finally {
            if (task == null || task.isCancelled()) {
                sstables.release();
                txn.abort();
            }
        }
    }

    private static void mutateFullyContainedSSTables(ColumnFamilyStore cfs, Refs<SSTableReader> refs, Iterator<SSTableReader> sstableIterator, Collection<Range<Token>> ranges, LifecycleTransaction txn, TimeUUID sessionID, boolean isTransient) throws IOException {
        if (ranges.isEmpty()) {
            return;
        }
        List<Range<Token>> normalizedRanges = Range.normalize(ranges);
        Set<SSTableReader> fullyContainedSSTables = CompactionManager.findSSTablesToAnticompact(sstableIterator, normalizedRanges, sessionID);
        cfs.metric.bytesMutatedAnticompaction.inc(SSTableReader.getTotalBytes(fullyContainedSSTables));
        cfs.getCompactionStrategyManager().mutateRepaired(fullyContainedSSTables, 0L, sessionID, isTransient);
        txn.cancel(fullyContainedSSTables);
        refs.release(fullyContainedSSTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAnticompaction(ColumnFamilyStore cfs, RangesAtEndpoint replicas, Refs<SSTableReader> validatedForRepair, LifecycleTransaction txn, TimeUUID sessionID, BooleanSupplier isCancelled) throws IOException {
        try {
            ActiveRepairService.ParentRepairSession prs;
            try {
                prs = ActiveRepairService.instance.getParentRepairSession(sessionID);
            }
            catch (NoSuchRepairSessionException e) {
                throw new CompactionInterruptedException((Object)e.getMessage());
            }
            Preconditions.checkArgument((!prs.isPreview() ? 1 : 0) != 0, (Object)"Cannot anticompact for previews");
            Preconditions.checkArgument((!replicas.isEmpty() ? 1 : 0) != 0, (Object)"No ranges to anti-compact");
            if (logger.isInfoEnabled()) {
                logger.info("{} Starting anticompaction for {}.{} on {}/{} sstables", new Object[]{PreviewKind.NONE.logPrefix(sessionID), cfs.keyspace.getName(), cfs.getTableName(), validatedForRepair.size(), cfs.getLiveSSTables().size()});
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{} Starting anticompaction for ranges {}", (Object)PreviewKind.NONE.logPrefix(sessionID), (Object)replicas);
            }
            HashSet<SSTableReader> sstables = new HashSet<SSTableReader>(validatedForRepair);
            CompactionManager.validateSSTableBoundsForAnticompaction(sessionID, sstables, replicas);
            CompactionManager.mutateFullyContainedSSTables(cfs, validatedForRepair, sstables.iterator(), replicas.onlyFull().ranges(), txn, sessionID, false);
            CompactionManager.mutateFullyContainedSSTables(cfs, validatedForRepair, sstables.iterator(), replicas.onlyTransient().ranges(), txn, sessionID, true);
            assert (txn.originals().equals(sstables));
            if (!sstables.isEmpty()) {
                this.doAntiCompaction(cfs, replicas, txn, sessionID, isCancelled);
            }
            txn.finish();
        }
        finally {
            validatedForRepair.release();
            txn.close();
        }
        logger.info("{} Completed anticompaction successfully", (Object)PreviewKind.NONE.logPrefix(sessionID));
    }

    static void validateSSTableBoundsForAnticompaction(TimeUUID sessionID, Collection<SSTableReader> sstables, RangesAtEndpoint ranges) {
        List normalizedRanges = Range.normalize(ranges.ranges());
        for (SSTableReader sstable : sstables) {
            Bounds<Token> bounds = new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken());
            if (Iterables.any(normalizedRanges, r -> r.contains(bounds.left) && r.contains(bounds.right) || r.intersects(bounds))) continue;
            String message = String.format("%s SSTable %s (%s) does not intersect repaired ranges %s, this sstable should not have been included.", PreviewKind.NONE.logPrefix(sessionID), sstable, bounds, normalizedRanges);
            logger.error(message);
            throw new IllegalStateException(message);
        }
    }

    @VisibleForTesting
    static Set<SSTableReader> findSSTablesToAnticompact(Iterator<SSTableReader> sstableIterator, List<Range<Token>> normalizedRanges, TimeUUID parentRepairSession) {
        HashSet<SSTableReader> fullyContainedSSTables = new HashSet<SSTableReader>();
        block0: while (sstableIterator.hasNext()) {
            SSTableReader sstable = sstableIterator.next();
            Bounds<Token> sstableBounds = new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken());
            for (Range<Token> r : normalizedRanges) {
                if (r.contains(sstable.first.getToken()) && r.contains(sstable.last.getToken())) {
                    logger.info("{} SSTable {} fully contained in range {}, mutating repairedAt instead of anticompacting", new Object[]{PreviewKind.NONE.logPrefix(parentRepairSession), sstable, r});
                    fullyContainedSSTables.add(sstable);
                    sstableIterator.remove();
                    continue block0;
                }
                if (!r.intersects(sstableBounds)) continue;
                logger.info("{} SSTable {} ({}) will be anticompacted on range {}", new Object[]{PreviewKind.NONE.logPrefix(parentRepairSession), sstable, sstableBounds, r});
            }
        }
        return fullyContainedSSTables;
    }

    public void performMaximal(ColumnFamilyStore cfStore, boolean splitOutput) {
        FBUtilities.waitOnFutures(this.submitMaximal(cfStore, CompactionManager.getDefaultGcBefore(cfStore, FBUtilities.nowInSeconds()), splitOutput));
    }

    public List<Future<?>> submitMaximal(ColumnFamilyStore cfStore, int gcBefore, boolean splitOutput) {
        CompactionTasks tasks = cfStore.getCompactionStrategyManager().getMaximalTasks(gcBefore, splitOutput);
        if (tasks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList futures = new ArrayList();
        int nonEmptyTasks = 0;
        for (final AbstractCompactionTask task : tasks) {
            WrappedRunnable runnable;
            Future<Void> fut;
            if (task.transaction.originals().size() > 0) {
                ++nonEmptyTasks;
            }
            if ((fut = this.executor.submitIfRunning(runnable = new WrappedRunnable(){

                @Override
                protected void runMayThrow() {
                    task.execute(CompactionManager.this.active);
                }
            }, "maximal task")).isCancelled()) continue;
            futures.add(fut);
        }
        if (nonEmptyTasks > 1) {
            logger.info("Major compaction will not result in a single sstable - repaired and unrepaired data is kept separate and compaction runs per data_file_directory.");
        }
        return futures;
    }

    public void forceCompaction(ColumnFamilyStore cfStore, Supplier<Collection<SSTableReader>> sstablesFn, com.google.common.base.Predicate<SSTableReader> sstablesPredicate) {
        Callable<CompactionTasks> taskCreator = () -> {
            Collection sstables = (Collection)sstablesFn.get();
            if (sstables == null || sstables.isEmpty()) {
                logger.debug("No sstables found for the provided token range");
                return CompactionTasks.empty();
            }
            return cfStore.getCompactionStrategyManager().getUserDefinedTasks(sstables, CompactionManager.getDefaultGcBefore(cfStore, FBUtilities.nowInSeconds()));
        };
        try (final CompactionTasks tasks = cfStore.runWithCompactionsDisabled(taskCreator, sstablesPredicate, false, false, false);){
            if (tasks.isEmpty()) {
                return;
            }
            WrappedRunnable runnable = new WrappedRunnable(){

                @Override
                protected void runMayThrow() {
                    for (AbstractCompactionTask task : tasks) {
                        if (task == null) continue;
                        task.execute(CompactionManager.this.active);
                    }
                }
            };
            FBUtilities.waitOnFuture(this.executor.submitIfRunning(runnable, "force compaction for token range"));
        }
    }

    public void forceCompactionForTokenRange(ColumnFamilyStore cfStore, Collection<Range<Token>> ranges) {
        this.forceCompaction(cfStore, () -> CompactionManager.sstablesInBounds(cfStore, ranges), (com.google.common.base.Predicate<SSTableReader>)((com.google.common.base.Predicate)sstable -> ((AbstractBounds)new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken())).intersects(ranges)));
    }

    private static Collection<SSTableReader> sstablesInBounds(ColumnFamilyStore cfs, Collection<Range<Token>> tokenRangeCollection) {
        HashSet<SSTableReader> sstables = new HashSet<SSTableReader>();
        Iterable<SSTableReader> liveTables = cfs.getTracker().getView().select(SSTableSet.LIVE);
        SSTableIntervalTree tree = SSTableIntervalTree.build(liveTables);
        for (Range<Token> tokenRange : tokenRangeCollection) {
            if (!AbstractBounds.strictlyWrapsAround(tokenRange.left, tokenRange.right)) {
                List<SSTableReader> ssTableReaders = View.sstablesInBounds(((Token)tokenRange.left).minKeyBound(), ((Token)tokenRange.right).maxKeyBound(), tree);
                Iterables.addAll(sstables, ssTableReaders);
                continue;
            }
            for (Range<Token> unwrappedRange : tokenRange.unwrap()) {
                List<SSTableReader> ssTableReaders = View.sstablesInBounds(((Token)unwrappedRange.left).minKeyBound(), ((Token)unwrappedRange.right).maxKeyBound(), tree);
                Iterables.addAll(sstables, ssTableReaders);
            }
        }
        return sstables;
    }

    public void forceCompactionForKey(ColumnFamilyStore cfStore, DecoratedKey key) {
        this.forceCompaction(cfStore, () -> CompactionManager.sstablesWithKey(cfStore, key), (com.google.common.base.Predicate<SSTableReader>)((com.google.common.base.Predicate)sstable -> sstable.maybePresent(key)));
    }

    private static Collection<SSTableReader> sstablesWithKey(ColumnFamilyStore cfs, DecoratedKey key) {
        HashSet<SSTableReader> sstables = new HashSet<SSTableReader>();
        Iterable<SSTableReader> liveTables = cfs.getTracker().getView().liveSSTablesInBounds(key.getToken().minKeyBound(), key.getToken().maxKeyBound());
        for (SSTableReader sstable : liveTables) {
            if (!sstable.maybePresent(key)) continue;
            sstables.add(sstable);
        }
        return sstables.isEmpty() ? Collections.emptyList() : sstables;
    }

    @Override
    public void forceUserDefinedCompaction(String dataFiles) {
        String[] filenames = dataFiles.split(",");
        ArrayListMultimap descriptors = ArrayListMultimap.create();
        for (String filename : filenames) {
            Descriptor desc = Descriptor.fromFilename(filename.trim());
            if (Schema.instance.getTableMetadataRef(desc) == null) {
                logger.warn("Schema does not exist for file {}. Skipping.", (Object)filename);
                continue;
            }
            ColumnFamilyStore cfs = Keyspace.open(desc.ksname).getColumnFamilyStore(desc.cfname);
            descriptors.put((Object)cfs, (Object)cfs.getDirectories().find(new File(filename.trim()).name()));
        }
        ArrayList futures = new ArrayList(descriptors.size());
        int nowInSec = FBUtilities.nowInSeconds();
        for (ColumnFamilyStore cfs : descriptors.keySet()) {
            futures.add(this.submitUserDefined(cfs, descriptors.get((Object)cfs), CompactionManager.getDefaultGcBefore(cfs, nowInSec)));
        }
        FBUtilities.waitOnFutures(futures);
    }

    @Override
    public void forceUserDefinedCleanup(String dataFiles) {
        String[] filenames = dataFiles.split(",");
        HashMap descriptors = Maps.newHashMap();
        for (String filename : filenames) {
            Descriptor desc = Descriptor.fromFilename(filename.trim());
            if (Schema.instance.getTableMetadataRef(desc) == null) {
                logger.warn("Schema does not exist for file {}. Skipping.", (Object)filename);
                continue;
            }
            ColumnFamilyStore cfs = Keyspace.open(desc.ksname).getColumnFamilyStore(desc.cfname);
            desc = cfs.getDirectories().find(new File(filename.trim()).name());
            if (desc == null) continue;
            descriptors.put(cfs, desc);
        }
        if (!StorageService.instance.isJoined()) {
            logger.error("Cleanup cannot run before a node has joined the ring");
            return;
        }
        for (Map.Entry entry : descriptors.entrySet()) {
            ColumnFamilyStore cfs = (ColumnFamilyStore)entry.getKey();
            Keyspace keyspace = cfs.keyspace;
            RangesAtEndpoint replicas = StorageService.instance.getLocalReplicas(keyspace.getName());
            Set<Range<Token>> allRanges = replicas.ranges();
            Set<Range<Token>> transientRanges = replicas.onlyTransient().ranges();
            boolean hasIndexes = cfs.indexManager.hasIndexes();
            SSTableReader sstable = this.lookupSSTable(cfs, (Descriptor)entry.getValue());
            if (sstable == null) {
                logger.warn("Will not clean {}, it is not an active sstable", entry.getValue());
                continue;
            }
            CleanupStrategy cleanupStrategy = CleanupStrategy.get(cfs, allRanges, transientRanges, sstable.isRepaired(), FBUtilities.nowInSeconds());
            try {
                LifecycleTransaction txn = cfs.getTracker().tryModify(sstable, OperationType.CLEANUP);
                Throwable throwable = null;
                try {
                    this.doCleanupOne(cfs, txn, cleanupStrategy, allRanges, hasIndexes);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (txn == null) continue;
                    if (throwable != null) {
                        try {
                            txn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    txn.close();
                }
            }
            catch (IOException e) {
                logger.error("forceUserDefinedCleanup failed: {}", (Object)e.getLocalizedMessage());
            }
        }
    }

    public Future<?> submitUserDefined(final ColumnFamilyStore cfs, final Collection<Descriptor> dataFiles, final int gcBefore) {
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws Exception {
                ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>(dataFiles.size());
                for (Descriptor desc : dataFiles) {
                    SSTableReader sstable = CompactionManager.this.lookupSSTable(cfs, desc);
                    if (sstable == null) {
                        logger.info("Will not compact {}: it is not an active sstable", (Object)desc);
                        continue;
                    }
                    sstables.add(sstable);
                }
                if (sstables.isEmpty()) {
                    logger.info("No files to compact for user defined compaction");
                } else {
                    try (CompactionTasks tasks = cfs.getCompactionStrategyManager().getUserDefinedTasks(sstables, gcBefore);){
                        for (AbstractCompactionTask task : tasks) {
                            if (task == null) continue;
                            task.execute(CompactionManager.this.active);
                        }
                    }
                }
            }
        };
        return this.executor.submitIfRunning(runnable, "user defined task");
    }

    private SSTableReader lookupSSTable(ColumnFamilyStore cfs, Descriptor descriptor) {
        for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
            if (!sstable.descriptor.equals(descriptor)) continue;
            return sstable;
        }
        return null;
    }

    public Future<?> submitValidation(Callable<Object> validation) {
        return this.validationExecutor.submitIfRunning(validation, "validation");
    }

    public void disableAutoCompaction() {
        for (String ksname : Schema.instance.getNonSystemKeyspaces().names()) {
            for (ColumnFamilyStore cfs : Keyspace.open(ksname).getColumnFamilyStores()) {
                cfs.disableAutoCompaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void scrubOne(ColumnFamilyStore cfs, LifecycleTransaction modifier, boolean skipCorrupted, boolean checkData, boolean reinsertOverflowedTTL, ActiveCompactionsTracker activeCompactions) {
        CompactionInfo.Holder scrubInfo = null;
        try {
            try (Scrubber scrubber = new Scrubber(cfs, modifier, skipCorrupted, checkData, reinsertOverflowedTTL);){
                scrubInfo = scrubber.getScrubInfo();
                activeCompactions.beginCompaction(scrubInfo);
                scrubber.scrub();
            }
            if (scrubInfo != null) {
                activeCompactions.finishCompaction(scrubInfo);
            }
        }
        catch (Throwable throwable) {
            if (scrubInfo != null) {
                activeCompactions.finishCompaction(scrubInfo);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void verifyOne(ColumnFamilyStore cfs, SSTableReader sstable, Verifier.Options options, ActiveCompactionsTracker activeCompactions) {
        CompactionInfo.Holder verifyInfo = null;
        try {
            try (Verifier verifier = new Verifier(cfs, sstable, false, options);){
                verifyInfo = verifier.getVerifyInfo();
                activeCompactions.beginCompaction(verifyInfo);
                verifier.verify();
            }
            if (verifyInfo != null) {
                activeCompactions.finishCompaction(verifyInfo);
            }
        }
        catch (Throwable throwable) {
            if (verifyInfo != null) {
                activeCompactions.finishCompaction(verifyInfo);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    public static boolean needsCleanup(SSTableReader sstable, Collection<Range<Token>> ownedRanges) {
        if (ownedRanges.isEmpty()) {
            return true;
        }
        List sortedRanges = Range.normalize(ownedRanges);
        Range firstRange = sortedRanges.get(0);
        if (sstable.first.getToken().compareTo(firstRange.left) <= 0) {
            return true;
        }
        for (int i = 0; i < sortedRanges.size(); ++i) {
            Range range = sortedRanges.get(i);
            if (((Token)range.right).isMinimum()) {
                return false;
            }
            DecoratedKey firstBeyondRange = sstable.firstKeyBeyond(((Token)range.right).maxKeyBound());
            if (firstBeyondRange == null) {
                return false;
            }
            if (i == sortedRanges.size() - 1) {
                return true;
            }
            Range nextRange = sortedRanges.get(i + 1);
            if (firstBeyondRange.getToken().compareTo(nextRange.left) > 0) continue;
            return true;
        }
        return false;
    }

    private void doCleanupOne(ColumnFamilyStore cfs, LifecycleTransaction txn, CleanupStrategy cleanupStrategy, Collection<Range<Token>> allRanges, boolean hasIndexes) throws IOException {
        Object finished;
        Object object;
        assert (!cfs.isIndex());
        SSTableReader sstable = txn.onlyOne();
        if (!hasIndexes && !((AbstractBounds)new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken())).intersects(allRanges)) {
            txn.obsoleteOriginals();
            txn.finish();
            logger.info("SSTable {} ([{}, {}]) does not intersect the owned ranges ({}), dropping it", new Object[]{sstable, sstable.first.getToken(), sstable.last.getToken(), allRanges});
            return;
        }
        long start = Clock.Global.nanoTime();
        long totalkeysWritten = 0L;
        long expectedBloomFilterSize = Math.max((long)cfs.metadata().params.minIndexInterval, SSTableReader.getApproximateKeyCount(txn.originals()));
        if (logger.isTraceEnabled()) {
            logger.trace("Expected bloom filter size : {}", (Object)expectedBloomFilterSize);
        }
        logger.info("Cleaning up {}", (Object)sstable);
        File compactionFileLocation = sstable.descriptor.directory;
        RateLimiter limiter = this.getRateLimiter();
        double compressionRatio = sstable.getCompressionRatio();
        if (compressionRatio == -1.0) {
            compressionRatio = 1.0;
        }
        int nowInSec = FBUtilities.nowInSeconds();
        try (SSTableRewriter writer = SSTableRewriter.construct(cfs, txn, false, sstable.maxDataAge);
             ISSTableScanner scanner = cleanupStrategy.getScanner(sstable);
             CompactionController controller = new CompactionController(cfs, txn.originals(), CompactionManager.getDefaultGcBefore(cfs, nowInSec));){
            Refs<SSTableReader> refs = Refs.ref(Collections.singleton(sstable));
            object = null;
            try (CompactionIterator ci2 = new CompactionIterator(OperationType.CLEANUP, Collections.singletonList(scanner), controller, nowInSec, TimeUUID.Generator.nextTimeUUID(), this.active, null);){
                StatsMetadata metadata = sstable.getSSTableMetadata();
                writer.switchWriter(CompactionManager.createWriter(cfs, compactionFileLocation, expectedBloomFilterSize, metadata.repairedAt, metadata.pendingRepair, metadata.isTransient, sstable, txn));
                long lastBytesScanned = 0L;
                while (ci2.hasNext()) {
                    UnfilteredRowIterator partition = ci2.next();
                    Throwable throwable = null;
                    try {
                        UnfilteredRowIterator notCleaned = cleanupStrategy.cleanup(partition);
                        Throwable throwable2 = null;
                        try {
                            if (notCleaned == null) continue;
                            if (writer.append(notCleaned) != null) {
                                ++totalkeysWritten;
                            }
                            long bytesScanned = scanner.getBytesScanned();
                            CompactionManager.compactionRateLimiterAcquire(limiter, bytesScanned, lastBytesScanned, compressionRatio);
                            lastBytesScanned = bytesScanned;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (notCleaned == null) continue;
                            if (throwable2 != null) {
                                try {
                                    notCleaned.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            notCleaned.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (partition == null) continue;
                        if (throwable != null) {
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        partition.close();
                    }
                }
                cfs.indexManager.flushAllIndexesBlocking();
                finished = writer.finish();
            }
            catch (Throwable ci2) {
                object = ci2;
                throw ci2;
            }
            finally {
                if (refs != null) {
                    if (object != null) {
                        try {
                            refs.close();
                        }
                        catch (Throwable ci2) {
                            ((Throwable)object).addSuppressed(ci2);
                        }
                    } else {
                        refs.close();
                    }
                }
            }
        }
        if (!finished.isEmpty()) {
            String format = "Cleaned up to %s.  %s to %s (~%d%% of original) for %,d keys.  Time: %,dms.";
            long dTime = TimeUnit.NANOSECONDS.toMillis(Clock.Global.nanoTime() - start);
            long startsize = sstable.onDiskLength();
            long endsize = 0L;
            object = finished.iterator();
            while (object.hasNext()) {
                SSTableReader newSstable = (SSTableReader)object.next();
                endsize += newSstable.onDiskLength();
            }
            double ratio = (double)endsize / (double)startsize;
            logger.info(String.format(format, ((SSTableReader)finished.get(0)).getFilename(), FBUtilities.prettyPrintMemory(startsize), FBUtilities.prettyPrintMemory(endsize), (int)(ratio * 100.0), totalkeysWritten, dTime));
        }
    }

    static void compactionRateLimiterAcquire(RateLimiter limiter, long bytesScanned, long lastBytesScanned, double compressionRatio) {
        long lengthRead;
        for (lengthRead = (long)((double)(bytesScanned - lastBytesScanned) * compressionRatio) + 1L; lengthRead >= Integer.MAX_VALUE; lengthRead -= Integer.MAX_VALUE) {
            limiter.acquire(Integer.MAX_VALUE);
        }
        if (lengthRead > 0L) {
            limiter.acquire((int)lengthRead);
        }
    }

    public static SSTableWriter createWriter(ColumnFamilyStore cfs, File compactionFileLocation, long expectedBloomFilterSize, long repairedAt, TimeUUID pendingRepair, boolean isTransient, SSTableReader sstable, LifecycleTransaction txn) {
        FileUtils.createDirectory(compactionFileLocation);
        return SSTableWriter.create(cfs.metadata, cfs.newSSTableDescriptor(compactionFileLocation), expectedBloomFilterSize, repairedAt, pendingRepair, isTransient, sstable.getSSTableLevel(), sstable.header, cfs.indexManager.listIndexes(), (LifecycleNewTracker)txn);
    }

    public static SSTableWriter createWriterForAntiCompaction(ColumnFamilyStore cfs, File compactionFileLocation, int expectedBloomFilterSize, long repairedAt, TimeUUID pendingRepair, boolean isTransient, Collection<SSTableReader> sstables, ILifecycleTransaction txn) {
        FileUtils.createDirectory(compactionFileLocation);
        int minLevel = Integer.MAX_VALUE;
        for (SSTableReader sstable : sstables) {
            if (minLevel == Integer.MAX_VALUE) {
                minLevel = sstable.getSSTableLevel();
            }
            if (minLevel == sstable.getSSTableLevel()) continue;
            minLevel = 0;
            break;
        }
        return SSTableWriter.create(cfs.newSSTableDescriptor(compactionFileLocation), Long.valueOf(expectedBloomFilterSize), (Long)repairedAt, pendingRepair, isTransient, cfs.metadata, new MetadataCollector(sstables, cfs.metadata().comparator, minLevel), SerializationHeader.make(cfs.metadata(), sstables), cfs.indexManager.listIndexes(), (LifecycleNewTracker)txn);
    }

    private void doAntiCompaction(ColumnFamilyStore cfs, RangesAtEndpoint ranges, LifecycleTransaction txn, TimeUUID pendingRepair, BooleanSupplier isCancelled) {
        int originalCount = txn.originals().size();
        logger.info("Performing anticompaction on {} sstables for {}", (Object)originalCount, (Object)pendingRepair);
        Set<SSTableReader> sstables = txn.originals();
        Set<SSTableReader> unrepairedSSTables = sstables.stream().filter(s -> !s.isRepaired()).collect(Collectors.toSet());
        cfs.metric.bytesAnticompacted.inc(SSTableReader.getTotalBytes(unrepairedSSTables));
        Collection<Collection<SSTableReader>> groupedSSTables = cfs.getCompactionStrategyManager().groupSSTablesForAntiCompaction(unrepairedSSTables);
        int antiCompactedSSTableCount = 0;
        for (Collection<SSTableReader> sstableGroup : groupedSSTables) {
            LifecycleTransaction groupTxn = txn.split(sstableGroup);
            Throwable throwable = null;
            try {
                int antiCompacted = this.antiCompactGroup(cfs, ranges, groupTxn, pendingRepair, isCancelled);
                antiCompactedSSTableCount += antiCompacted;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (groupTxn == null) continue;
                if (throwable != null) {
                    try {
                        groupTxn.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                groupTxn.close();
            }
        }
        String format = "Anticompaction completed successfully, anticompacted from {} to {} sstable(s) for {}.";
        logger.info(format, new Object[]{originalCount, antiCompactedSSTableCount, pendingRepair});
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    int antiCompactGroup(ColumnFamilyStore cfs, RangesAtEndpoint ranges, LifecycleTransaction txn, TimeUUID pendingRepair, BooleanSupplier isCancelled) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 13 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    public static CompactionIterator getAntiCompactionIterator(List<ISSTableScanner> scanners, CompactionController controller, int nowInSec, TimeUUID timeUUID, ActiveCompactionsTracker activeCompactions, final BooleanSupplier isCancelled) {
        return new CompactionIterator(OperationType.ANTICOMPACTION, scanners, controller, nowInSec, timeUUID, activeCompactions, null){

            @Override
            public boolean isStopRequested() {
                return super.isStopRequested() || isCancelled.getAsBoolean();
            }
        };
    }

    @VisibleForTesting
    Future<?> submitIndexBuild(final SecondaryIndexBuilder builder, final ActiveCompactionsTracker activeCompactions) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                activeCompactions.beginCompaction(builder);
                try {
                    builder.build();
                }
                finally {
                    activeCompactions.finishCompaction(builder);
                }
            }
        };
        return this.executor.submitIfRunning(runnable, "index build");
    }

    public Future<?> submitIndexBuild(SecondaryIndexBuilder builder) {
        return this.submitIndexBuild(builder, this.active);
    }

    public Future<?> submitCacheWrite(AutoSavingCache.Writer writer) {
        return this.submitCacheWrite(writer, this.active);
    }

    Future<?> submitCacheWrite(final AutoSavingCache.Writer writer, final ActiveCompactionsTracker activeCompactions) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!AutoSavingCache.flushInProgress.add(writer.cacheType())) {
                    logger.trace("Cache flushing was already in progress: skipping {}", (Object)writer.getCompactionInfo());
                    return;
                }
                try {
                    activeCompactions.beginCompaction(writer);
                    try {
                        writer.saveCache();
                    }
                    finally {
                        activeCompactions.finishCompaction(writer);
                    }
                }
                finally {
                    AutoSavingCache.flushInProgress.remove((Object)writer.cacheType());
                }
            }
        };
        return this.executor.submitIfRunning(runnable, "cache write");
    }

    public List<SSTableReader> runIndexSummaryRedistribution(IndexSummaryRedistribution redistribution) throws IOException {
        return this.runIndexSummaryRedistribution(redistribution, this.active);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<SSTableReader> runIndexSummaryRedistribution(IndexSummaryRedistribution redistribution, ActiveCompactionsTracker activeCompactions) throws IOException {
        activeCompactions.beginCompaction(redistribution);
        try {
            List<SSTableReader> list = redistribution.redistributeSummaries();
            return list;
        }
        finally {
            activeCompactions.finishCompaction(redistribution);
        }
    }

    public static int getDefaultGcBefore(ColumnFamilyStore cfs, int nowInSec) {
        return cfs.isIndex() ? nowInSec : cfs.gcBefore(nowInSec);
    }

    public Future<Long> submitViewBuilder(ViewBuilderTask task) {
        return this.submitViewBuilder(task, this.active);
    }

    @VisibleForTesting
    Future<Long> submitViewBuilder(ViewBuilderTask task, ActiveCompactionsTracker activeCompactions) {
        return this.viewBuildExecutor.submitIfRunning(() -> {
            activeCompactions.beginCompaction(task);
            try {
                Long l = task.call();
                return l;
            }
            finally {
                activeCompactions.finishCompaction(task);
            }
        }, "view build");
    }

    public int getActiveCompactions() {
        return this.active.getCompactions().size();
    }

    public static boolean isCompactor(Thread thread) {
        return thread.getThreadGroup().getParent() == CompactionExecutor.compactionThreadGroup;
    }

    public void incrementAborted() {
        this.metrics.compactionsAborted.inc();
    }

    public void incrementCompactionsReduced() {
        this.metrics.compactionsReduced.inc();
    }

    public void incrementSstablesDropppedFromCompactions(long num) {
        this.metrics.sstablesDropppedFromCompactions.inc(num);
    }

    @Override
    public List<Map<String, String>> getCompactions() {
        List<CompactionInfo.Holder> compactionHolders = this.active.getCompactions();
        ArrayList<Map<String, String>> out = new ArrayList<Map<String, String>>(compactionHolders.size());
        for (CompactionInfo.Holder ci : compactionHolders) {
            out.add(ci.getCompactionInfo().asMap());
        }
        return out;
    }

    @Override
    public List<String> getCompactionSummary() {
        List<CompactionInfo.Holder> compactionHolders = this.active.getCompactions();
        ArrayList<String> out = new ArrayList<String>(compactionHolders.size());
        for (CompactionInfo.Holder ci : compactionHolders) {
            out.add(ci.getCompactionInfo().toString());
        }
        return out;
    }

    @Override
    public TabularData getCompactionHistory() {
        try {
            return SystemKeyspace.getCompactionHistory();
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public long getTotalBytesCompacted() {
        return this.metrics.bytesCompacted.getCount();
    }

    public long getTotalCompactionsCompleted() {
        return this.metrics.totalCompactionsCompleted.getCount();
    }

    public int getPendingTasks() {
        return (Integer)this.metrics.pendingTasks.getValue();
    }

    public long getCompletedTasks() {
        return (Long)this.metrics.completedTasks.getValue();
    }

    @Override
    public void stopCompaction(String type) {
        OperationType operation = OperationType.valueOf(type);
        for (CompactionInfo.Holder holder : this.active.getCompactions()) {
            if (holder.getCompactionInfo().getTaskType() != operation) continue;
            holder.stop();
        }
    }

    @Override
    public void stopCompactionById(String compactionId) {
        for (CompactionInfo.Holder holder : this.active.getCompactions()) {
            TimeUUID holderId = holder.getCompactionInfo().getTaskId();
            if (holderId == null || !holderId.equals(TimeUUID.fromString(compactionId))) continue;
            holder.stop();
        }
    }

    public void setConcurrentCompactors(int value) {
        if (value > this.executor.getCorePoolSize()) {
            this.executor.setMaximumPoolSize(value);
            this.executor.setCorePoolSize(value);
        } else if (value < this.executor.getCorePoolSize()) {
            this.executor.setCorePoolSize(value);
            this.executor.setMaximumPoolSize(value);
        }
    }

    public void setConcurrentValidations() {
        this.validationExecutor.adjustPoolSize();
    }

    public void setConcurrentViewBuilders(int value) {
        if (value > this.viewBuildExecutor.getCorePoolSize()) {
            this.viewBuildExecutor.setMaximumPoolSize(value);
            this.viewBuildExecutor.setCorePoolSize(value);
        } else if (value < this.viewBuildExecutor.getCorePoolSize()) {
            this.viewBuildExecutor.setCorePoolSize(value);
            this.viewBuildExecutor.setMaximumPoolSize(value);
        }
    }

    @Override
    public int getCoreCompactorThreads() {
        return this.executor.getCorePoolSize();
    }

    @Override
    public void setCoreCompactorThreads(int number) {
        this.executor.setCorePoolSize(number);
    }

    @Override
    public int getMaximumCompactorThreads() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public void setMaximumCompactorThreads(int number) {
        this.executor.setMaximumPoolSize(number);
    }

    @Override
    public int getCoreValidationThreads() {
        return this.validationExecutor.getCorePoolSize();
    }

    @Override
    public void setCoreValidationThreads(int number) {
        this.validationExecutor.setCorePoolSize(number);
    }

    @Override
    public int getMaximumValidatorThreads() {
        return this.validationExecutor.getMaximumPoolSize();
    }

    @Override
    public void setMaximumValidatorThreads(int number) {
        this.validationExecutor.setMaximumPoolSize(number);
    }

    @Override
    public boolean getDisableSTCSInL0() {
        return DatabaseDescriptor.getDisableSTCSInL0();
    }

    @Override
    public void setDisableSTCSInL0(boolean disabled) {
        if (disabled != DatabaseDescriptor.getDisableSTCSInL0()) {
            logger.info("Changing STCS in L0 disabled from {} to {}", (Object)DatabaseDescriptor.getDisableSTCSInL0(), (Object)disabled);
        }
        DatabaseDescriptor.setDisableSTCSInL0(disabled);
    }

    @Override
    public int getCoreViewBuildThreads() {
        return this.viewBuildExecutor.getCorePoolSize();
    }

    @Override
    public void setCoreViewBuildThreads(int number) {
        this.viewBuildExecutor.setCorePoolSize(number);
    }

    @Override
    public int getMaximumViewBuildThreads() {
        return this.viewBuildExecutor.getMaximumPoolSize();
    }

    @Override
    public void setMaximumViewBuildThreads(int number) {
        this.viewBuildExecutor.setMaximumPoolSize(number);
    }

    @Override
    public boolean getAutomaticSSTableUpgradeEnabled() {
        return DatabaseDescriptor.automaticSSTableUpgrade();
    }

    @Override
    public void setAutomaticSSTableUpgradeEnabled(boolean enabled) {
        DatabaseDescriptor.setAutomaticSSTableUpgradeEnabled(enabled);
    }

    @Override
    public int getMaxConcurrentAutoUpgradeTasks() {
        return DatabaseDescriptor.maxConcurrentAutoUpgradeTasks();
    }

    @Override
    public void setMaxConcurrentAutoUpgradeTasks(int value) {
        try {
            DatabaseDescriptor.setMaxConcurrentAutoUpgradeTasks(value);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void interruptCompactionFor(Iterable<TableMetadata> columnFamilies, Predicate<SSTableReader> sstablePredicate, boolean interruptValidation) {
        assert (columnFamilies != null);
        for (CompactionInfo.Holder compactionHolder : this.active.getCompactions()) {
            CompactionInfo info = compactionHolder.getCompactionInfo();
            if (info.getTaskType() == OperationType.VALIDATION && !interruptValidation || info.getTableMetadata() != null && !Iterables.contains(columnFamilies, (Object)info.getTableMetadata()) || !info.shouldStop(sstablePredicate)) continue;
            compactionHolder.stop();
        }
    }

    public void interruptCompactionForCFs(Iterable<ColumnFamilyStore> cfss, Predicate<SSTableReader> sstablePredicate, boolean interruptValidation) {
        ArrayList<TableMetadata> metadata = new ArrayList<TableMetadata>();
        for (ColumnFamilyStore cfs : cfss) {
            metadata.add(cfs.metadata());
        }
        this.interruptCompactionFor(metadata, sstablePredicate, interruptValidation);
    }

    public void waitForCessation(Iterable<ColumnFamilyStore> cfss, Predicate<SSTableReader> sstablePredicate) {
        long start = Clock.Global.nanoTime();
        long delay = TimeUnit.MINUTES.toNanos(1L);
        while (Clock.Global.nanoTime() - start < delay && instance.isCompacting(cfss, sstablePredicate)) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public List<CompactionInfo> getSSTableTasks() {
        return this.active.getCompactions().stream().map(CompactionInfo.Holder::getCompactionInfo).filter(task -> task.getTaskType() != OperationType.COUNTER_CACHE_SAVE && task.getTaskType() != OperationType.KEY_CACHE_SAVE && task.getTaskType() != OperationType.ROW_CACHE_SAVE).collect(Collectors.toList());
    }

    public boolean isGlobalCompactionPaused() {
        return this.globalCompactionPauseCount.get() > 0;
    }

    public CompactionPauser pauseGlobalCompaction() {
        CompactionPauser pauser = this.globalCompactionPauseCount::decrementAndGet;
        this.globalCompactionPauseCount.incrementAndGet();
        return pauser;
    }

    private static /* synthetic */ boolean lambda$antiCompactGroup$9(Token t) {
        return false;
    }

    private static /* synthetic */ boolean lambda$antiCompactGroup$8(Token t) {
        return false;
    }

    static {
        MBeanWrapper.instance.registerMBean((Object)instance, MBEAN_OBJECT_NAME);
    }

    public static interface CompactionPauser
    extends AutoCloseable {
        @Override
        public void close();
    }

    private static class CacheCleanupExecutor
    extends CompactionExecutor {
        public CacheCleanupExecutor() {
            super(1, "CacheCleanupExecutor", Integer.MAX_VALUE);
        }
    }

    private static class ViewBuildExecutor
    extends CompactionExecutor {
        public ViewBuildExecutor() {
            super(DatabaseDescriptor.getConcurrentViewBuilders(), "ViewBuildExecutor", Integer.MAX_VALUE);
        }
    }

    public static class ValidationExecutor
    extends CompactionExecutor {
        public ValidationExecutor() {
            super(DatabaseDescriptor.getConcurrentValidations(), "ValidationExecutor", Integer.MAX_VALUE);
        }

        public void adjustPoolSize() {
            this.setMaximumPoolSize(DatabaseDescriptor.getConcurrentValidations());
            this.setCorePoolSize(DatabaseDescriptor.getConcurrentValidations());
        }
    }

    static class CompactionExecutor
    extends WrappedExecutorPlus {
        static final ThreadGroup compactionThreadGroup = ExecutorFactory.Global.executorFactory().newThreadGroup("compaction");

        public CompactionExecutor() {
            this(ExecutorFactory.Global.executorFactory(), DatabaseDescriptor.getConcurrentCompactors(), "CompactionExecutor", Integer.MAX_VALUE);
        }

        public CompactionExecutor(int threads, String name, int queueSize) {
            this(ExecutorFactory.Global.executorFactory(), threads, name, queueSize);
        }

        protected CompactionExecutor(ExecutorFactory executorFactory, int threads, String name, int queueSize) {
            super((ExecutorPlus)executorFactory.withJmxInternal().configurePooled(name, threads).withThreadGroup(compactionThreadGroup).withQueueLimit(queueSize).build());
        }

        public Future<Void> submitIfRunning(Runnable task, String name) {
            return this.submitIfRunning(FutureTask.callable(name, task), name);
        }

        public <T> Future<T> submitIfRunning(Callable<T> task, String name) {
            try {
                return this.submit(task);
            }
            catch (RejectedExecutionException ex) {
                if (this.isShutdown()) {
                    logger.info("Executor has shut down, could not submit {}", (Object)name);
                } else {
                    logger.error("Failed to submit {}", (Object)name, (Object)ex);
                }
                return ImmediateFuture.cancelled();
            }
        }

        @Override
        public void execute(Runnable command) {
            this.executor.execute(command);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.executor.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.submit(FutureTask.callable(task, result));
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.submit(task, (T)null);
        }
    }

    private static abstract class CleanupStrategy {
        protected final Collection<Range<Token>> ranges;
        protected final int nowInSec;

        protected CleanupStrategy(Collection<Range<Token>> ranges, int nowInSec) {
            this.ranges = ranges;
            this.nowInSec = nowInSec;
        }

        public static CleanupStrategy get(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, Collection<Range<Token>> transientRanges, boolean isRepaired, int nowInSec) {
            if (cfs.indexManager.hasIndexes()) {
                if (!transientRanges.isEmpty()) {
                    throw new AssertionError((Object)"Can't have indexes and transient ranges");
                }
                return new Full(cfs, ranges, nowInSec);
            }
            return new Bounded(cfs, ranges, transientRanges, isRepaired, nowInSec);
        }

        public abstract ISSTableScanner getScanner(SSTableReader var1);

        public abstract UnfilteredRowIterator cleanup(UnfilteredRowIterator var1);

        private static final class Full
        extends CleanupStrategy {
            private final ColumnFamilyStore cfs;

            public Full(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, int nowInSec) {
                super(ranges, nowInSec);
                this.cfs = cfs;
            }

            @Override
            public ISSTableScanner getScanner(SSTableReader sstable) {
                return sstable.getScanner();
            }

            @Override
            public UnfilteredRowIterator cleanup(UnfilteredRowIterator partition) {
                if (Range.isInRanges(partition.partitionKey().getToken(), this.ranges)) {
                    return partition;
                }
                this.cfs.invalidateCachedPartition(partition.partitionKey());
                this.cfs.indexManager.deletePartition(partition, this.nowInSec);
                return null;
            }
        }

        private static final class Bounded
        extends CleanupStrategy {
            private final Collection<Range<Token>> transientRanges;
            private final boolean isRepaired;

            public Bounded(final ColumnFamilyStore cfs, Collection<Range<Token>> ranges, Collection<Range<Token>> transientRanges, boolean isRepaired, int nowInSec) {
                super(ranges, nowInSec);
                instance.cacheCleanupExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        cfs.cleanupCache();
                    }
                });
                this.transientRanges = transientRanges;
                this.isRepaired = isRepaired;
            }

            @Override
            public ISSTableScanner getScanner(SSTableReader sstable) {
                Collection rangesToScan = this.ranges;
                if (this.isRepaired) {
                    rangesToScan = Collections2.filter((Collection)this.ranges, range -> !this.transientRanges.contains(range));
                }
                return sstable.getScanner(rangesToScan);
            }

            @Override
            public UnfilteredRowIterator cleanup(UnfilteredRowIterator partition) {
                return partition;
            }
        }
    }

    public static enum AllSSTableOpStatus {
        SUCCESSFUL(0),
        ABORTED(1),
        UNABLE_TO_CANCEL(2);

        public final int statusCode;

        private AllSSTableOpStatus(int statusCode) {
            this.statusCode = statusCode;
        }
    }

    private static interface OneSSTableOperation {
        public Iterable<SSTableReader> filterSSTables(LifecycleTransaction var1);

        public void execute(LifecycleTransaction var1) throws IOException;
    }

    @VisibleForTesting
    class BackgroundCompactionCandidate
    implements Runnable {
        private final ColumnFamilyStore cfs;

        BackgroundCompactionCandidate(ColumnFamilyStore cfs) {
            CompactionManager.this.compactingCF.add((Object)cfs);
            this.cfs = cfs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean ranCompaction = false;
            try {
                logger.trace("Checking {}.{}", (Object)this.cfs.keyspace.getName(), (Object)this.cfs.name);
                if (!this.cfs.isValid()) {
                    logger.trace("Aborting compaction for dropped CF");
                    return;
                }
                CompactionStrategyManager strategy = this.cfs.getCompactionStrategyManager();
                AbstractCompactionTask task = strategy.getNextBackgroundTask(CompactionManager.getDefaultGcBefore(this.cfs, FBUtilities.nowInSeconds()));
                if (task == null) {
                    if (DatabaseDescriptor.automaticSSTableUpgrade()) {
                        ranCompaction = this.maybeRunUpgradeTask(strategy);
                    }
                } else {
                    task.execute(CompactionManager.this.active);
                    ranCompaction = true;
                }
            }
            finally {
                CompactionManager.this.compactingCF.remove((Object)this.cfs);
            }
            if (ranCompaction) {
                CompactionManager.this.submitBackground(this.cfs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean maybeRunUpgradeTask(CompactionStrategyManager strategy) {
            logger.debug("Checking for upgrade tasks {}.{}", (Object)this.cfs.keyspace.getName(), (Object)this.cfs.getTableName());
            try {
                AbstractCompactionTask upgradeTask;
                if (CompactionManager.this.currentlyBackgroundUpgrading.incrementAndGet() <= DatabaseDescriptor.maxConcurrentAutoUpgradeTasks() && (upgradeTask = strategy.findUpgradeSSTableTask()) != null) {
                    upgradeTask.execute(CompactionManager.this.active);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                CompactionManager.this.currentlyBackgroundUpgrading.decrementAndGet();
            }
            logger.trace("No tasks available");
            return false;
        }
    }
}

