/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CloseableIterator;

public class KeyIterator
extends AbstractIterator<DecoratedKey>
implements CloseableIterator<DecoratedKey> {
    private final Descriptor desc;
    private final In in;
    private final IPartitioner partitioner;
    private final ReadWriteLock fileAccessLock;
    private long keyPosition;

    public KeyIterator(Descriptor desc, TableMetadata metadata) {
        this.desc = desc;
        this.in = new In(new File(desc.filenameFor(Component.PRIMARY_INDEX)));
        this.partitioner = metadata.partitioner;
        this.fileAccessLock = new ReentrantReadWriteLock();
    }

    @Override
    protected DecoratedKey computeNext() {
        this.fileAccessLock.readLock().lock();
        try {
            if (this.in.isEOF()) {
                DecoratedKey decoratedKey = (DecoratedKey)this.endOfData();
                return decoratedKey;
            }
            this.keyPosition = this.in.getFilePointer();
            DecoratedKey key = this.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(this.in.get()));
            RowIndexEntry.Serializer.skip(this.in.get(), this.desc.version);
            DecoratedKey decoratedKey = key;
            return decoratedKey;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.fileAccessLock.readLock().unlock();
        }
    }

    @Override
    public void close() {
        this.fileAccessLock.writeLock().lock();
        try {
            this.in.close();
        }
        finally {
            this.fileAccessLock.writeLock().unlock();
        }
    }

    public long getBytesRead() {
        this.fileAccessLock.readLock().lock();
        try {
            long l = this.in.getFilePointer();
            return l;
        }
        finally {
            this.fileAccessLock.readLock().unlock();
        }
    }

    public long getTotalBytes() {
        return this.in.length();
    }

    public long getKeyPosition() {
        return this.keyPosition;
    }

    private static final class In {
        private final File path;
        private volatile RandomAccessReader in;

        public In(File path) {
            this.path = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeInit() {
            if (this.in != null) {
                return;
            }
            In in = this;
            synchronized (in) {
                if (this.in == null) {
                    this.in = RandomAccessReader.open(this.path);
                }
            }
        }

        public DataInputPlus get() {
            this.maybeInit();
            return this.in;
        }

        public boolean isEOF() {
            this.maybeInit();
            return this.in.isEOF();
        }

        public void close() {
            if (this.in != null) {
                this.in.close();
            }
        }

        public long getFilePointer() {
            this.maybeInit();
            return this.in.getFilePointer();
        }

        public long length() {
            this.maybeInit();
            return this.in.length();
        }
    }
}

