/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;

public final class CreateFunctionStatement
extends AlterSchemaStatement {
    private final String functionName;
    private final List<ColumnIdentifier> argumentNames;
    private final List<CQL3Type.Raw> rawArgumentTypes;
    private final CQL3Type.Raw rawReturnType;
    private final boolean calledOnNullInput;
    private final String language;
    private final String body;
    private final boolean orReplace;
    private final boolean ifNotExists;

    public CreateFunctionStatement(String keyspaceName, String functionName, List<ColumnIdentifier> argumentNames, List<CQL3Type.Raw> rawArgumentTypes, CQL3Type.Raw rawReturnType, boolean calledOnNullInput, String language, String body, boolean orReplace, boolean ifNotExists) {
        super(keyspaceName);
        this.functionName = functionName;
        this.argumentNames = argumentNames;
        this.rawArgumentTypes = rawArgumentTypes;
        this.rawReturnType = rawReturnType;
        this.calledOnNullInput = calledOnNullInput;
        this.language = language;
        this.body = body;
        this.orReplace = orReplace;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        AbstractType<?> returnType;
        if (this.ifNotExists && this.orReplace) {
            throw CreateFunctionStatement.ire("Cannot use both 'OR REPLACE' and 'IF NOT EXISTS' directives", new Object[0]);
        }
        UDFunction.assertUdfsEnabled(this.language);
        if (new HashSet<ColumnIdentifier>(this.argumentNames).size() != this.argumentNames.size()) {
            throw CreateFunctionStatement.ire("Duplicate argument names for given function %s with argument names %s", this.functionName, this.argumentNames);
        }
        this.rawArgumentTypes.stream().filter(raw -> !raw.isTuple() && raw.isFrozen()).findFirst().ifPresent(t -> {
            throw CreateFunctionStatement.ire("Argument '%s' cannot be frozen; remove frozen<> modifier from '%s'", t, t);
        });
        if (!this.rawReturnType.isTuple() && this.rawReturnType.isFrozen()) {
            throw CreateFunctionStatement.ire("Return type '%s' cannot be frozen; remove frozen<> modifier from '%s'", this.rawReturnType, this.rawReturnType);
        }
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        if (null == keyspace) {
            throw CreateFunctionStatement.ire("Keyspace '%s' doesn't exist", this.keyspaceName);
        }
        List<AbstractType<?>> argumentTypes = this.rawArgumentTypes.stream().map(t -> t.prepare(this.keyspaceName, keyspace.types).getType().udfType()).collect(Collectors.toList());
        UDFunction function = UDFunction.create(new FunctionName(this.keyspaceName, this.functionName), this.argumentNames, argumentTypes, returnType = this.rawReturnType.prepare(this.keyspaceName, keyspace.types).getType().udfType(), this.calledOnNullInput, this.language, this.body);
        Function existingFunction = keyspace.functions.find(function.name(), argumentTypes).orElse(null);
        if (null != existingFunction) {
            if (existingFunction.isAggregate()) {
                throw CreateFunctionStatement.ire("Function '%s' cannot replace an aggregate", this.functionName);
            }
            if (this.ifNotExists) {
                return schema;
            }
            if (!this.orReplace) {
                throw CreateFunctionStatement.ire("Function '%s' already exists", this.functionName);
            }
            if (this.calledOnNullInput != ((UDFunction)existingFunction).isCalledOnNullInput()) {
                throw CreateFunctionStatement.ire("Function '%s' must have %s directive", this.functionName, this.calledOnNullInput ? "CALLED ON NULL INPUT" : "RETURNS NULL ON NULL INPUT");
            }
            if (!returnType.isCompatibleWith(existingFunction.returnType())) {
                throw CreateFunctionStatement.ire("Cannot replace function '%s', the new return type %s is not compatible with the return type %s of existing function", this.functionName, returnType.asCQL3Type(), existingFunction.returnType().asCQL3Type());
            }
        }
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.functions.withAddedOrUpdated(function)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        assert (diff.altered.size() == 1);
        Functions.FunctionsDiff<UDFunction> udfsDiff = ((KeyspaceMetadata.KeyspaceDiff)diff.altered.get((int)0)).udfs;
        assert (((Functions)udfsDiff.created).size() + udfsDiff.altered.size() == 1);
        boolean created = !((Functions)udfsDiff.created).isEmpty();
        return new Event.SchemaChange(created ? Event.SchemaChange.Change.CREATED : Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.FUNCTION, this.keyspaceName, this.functionName, this.rawArgumentTypes.stream().map(Object::toString).collect(Collectors.toList()));
    }

    @Override
    public void authorize(ClientState client) {
        FunctionName name = new FunctionName(this.keyspaceName, this.functionName);
        if (Schema.instance.findFunction(name, Lists.transform(this.rawArgumentTypes, t -> t.prepare(this.keyspaceName).getType().udfType())).isPresent() && this.orReplace) {
            client.ensurePermission(Permission.ALTER, FunctionResource.functionFromCql(this.keyspaceName, this.functionName, this.rawArgumentTypes));
        } else {
            client.ensurePermission(Permission.CREATE, FunctionResource.keyspace(this.keyspaceName));
        }
    }

    @Override
    Set<IResource> createdResources(Keyspaces.KeyspacesDiff diff) {
        assert (diff.altered.size() == 1);
        Functions.FunctionsDiff<UDFunction> udfsDiff = ((KeyspaceMetadata.KeyspaceDiff)diff.altered.get((int)0)).udfs;
        assert (((Functions)udfsDiff.created).size() + udfsDiff.altered.size() == 1);
        return ((Functions)udfsDiff.created).isEmpty() ? ImmutableSet.of() : ImmutableSet.of((Object)FunctionResource.functionFromCql(this.keyspaceName, this.functionName, this.rawArgumentTypes));
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.CREATE_FUNCTION, this.keyspaceName, this.functionName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.functionName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final FunctionName name;
        private final List<ColumnIdentifier> argumentNames;
        private final List<CQL3Type.Raw> rawArgumentTypes;
        private final CQL3Type.Raw rawReturnType;
        private final boolean calledOnNullInput;
        private final String language;
        private final String body;
        private final boolean orReplace;
        private final boolean ifNotExists;

        public Raw(FunctionName name, List<ColumnIdentifier> argumentNames, List<CQL3Type.Raw> rawArgumentTypes, CQL3Type.Raw rawReturnType, boolean calledOnNullInput, String language, String body, boolean orReplace, boolean ifNotExists) {
            this.name = name;
            this.argumentNames = argumentNames;
            this.rawArgumentTypes = rawArgumentTypes;
            this.rawReturnType = rawReturnType;
            this.calledOnNullInput = calledOnNullInput;
            this.language = language;
            this.body = body;
            this.orReplace = orReplace;
            this.ifNotExists = ifNotExists;
        }

        @Override
        public CreateFunctionStatement prepare(ClientState state) {
            String keyspaceName = this.name.hasKeyspace() ? this.name.keyspace : state.getKeyspace();
            return new CreateFunctionStatement(keyspaceName, this.name.name, this.argumentNames, this.rawArgumentTypes, this.rawReturnType, this.calledOnNullInput, this.language, this.body, this.orReplace, this.ifNotExists);
        }
    }
}

