/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.vint;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class VIntCoding {
    public static final int MAX_SIZE = 10;

    public static long readUnsignedVInt(DataInput input) throws IOException {
        byte firstByte = input.readByte();
        if (firstByte >= 0) {
            return firstByte;
        }
        int size = VIntCoding.numberOfExtraBytesToRead(firstByte);
        long retval = firstByte & VIntCoding.firstByteValueMask(size);
        for (int ii = 0; ii < size; ++ii) {
            byte b = input.readByte();
            retval <<= 8;
            retval |= (long)(b & 0xFF);
        }
        return retval;
    }

    public static void skipUnsignedVInt(DataInputPlus input) throws IOException {
        byte firstByte = input.readByte();
        if (firstByte < 0) {
            input.skipBytesFully(VIntCoding.numberOfExtraBytesToRead(firstByte));
        }
    }

    public static long getUnsignedVInt(ByteBuffer input, int readerIndex) {
        return VIntCoding.getUnsignedVInt(input, readerIndex, input.limit());
    }

    public static long getUnsignedVInt(ByteBuffer input, int readerIndex, int readerLimit) {
        byte firstByte;
        if (readerIndex >= readerLimit) {
            return -1L;
        }
        if ((firstByte = input.get(readerIndex++)) >= 0) {
            return firstByte;
        }
        int size = VIntCoding.numberOfExtraBytesToRead(firstByte);
        if (readerIndex + size > readerLimit) {
            return -1L;
        }
        long retval = firstByte & VIntCoding.firstByteValueMask(size);
        for (int ii = 0; ii < size; ++ii) {
            byte b = input.get(readerIndex++);
            retval <<= 8;
            retval |= (long)(b & 0xFF);
        }
        return retval;
    }

    public static int computeUnsignedVIntSize(ByteBuffer input, int readerIndex) {
        return VIntCoding.computeUnsignedVIntSize(input, readerIndex, input.limit());
    }

    public static int computeUnsignedVIntSize(ByteBuffer input, int readerIndex, int readerLimit) {
        if (readerIndex >= readerLimit) {
            return -1;
        }
        byte firstByte = input.get(readerIndex);
        return 1 + (firstByte >= 0 ? 0 : VIntCoding.numberOfExtraBytesToRead(firstByte));
    }

    public static long readVInt(DataInput input) throws IOException {
        return VIntCoding.decodeZigZag64(VIntCoding.readUnsignedVInt(input));
    }

    public static int firstByteValueMask(int extraBytesToRead) {
        return 255 >> extraBytesToRead;
    }

    public static int encodeExtraBytesToRead(int extraBytesToRead) {
        return ~VIntCoding.firstByteValueMask(extraBytesToRead);
    }

    public static int numberOfExtraBytesToRead(int firstByte) {
        return Integer.numberOfLeadingZeros(~firstByte) - 24;
    }

    public static void writeUnsignedVInt(long value, DataOutputPlus output) throws IOException {
        int size = VIntCoding.computeUnsignedVIntSize(value);
        if (size == 1) {
            output.writeByte((int)value);
        } else if (size < 9) {
            int shift = 8 - size << 3;
            int extraBytes = size - 1;
            long mask = (long)VIntCoding.encodeExtraBytesToRead(extraBytes) << 56;
            long register = value << shift | mask;
            output.writeBytes(register, size);
        } else if (size == 9) {
            output.write(-1);
            output.writeLong(value);
        } else {
            throw new AssertionError();
        }
    }

    public static void writeUnsignedVInt(long value, ByteBuffer output) {
        int size = VIntCoding.computeUnsignedVIntSize(value);
        if (size == 1) {
            output.put((byte)value);
        } else if (size < 9) {
            int pos;
            int limit = output.limit();
            if (limit - (pos = output.position()) >= size) {
                int shift = 8 - size << 3;
                int extraBytes = size - 1;
                long mask = (long)VIntCoding.encodeExtraBytesToRead(extraBytes) << 56;
                long register = value << shift | mask;
                output.putLong(pos, register);
                output.position(pos + size);
            }
        } else if (size == 9) {
            output.put((byte)-1);
            output.putLong(value);
        } else {
            throw new AssertionError();
        }
    }

    public static void writeVInt(long value, DataOutputPlus output) throws IOException {
        VIntCoding.writeUnsignedVInt(VIntCoding.encodeZigZag64(value), output);
    }

    public static void writeVInt(long value, ByteBuffer output) throws IOException {
        VIntCoding.writeUnsignedVInt(VIntCoding.encodeZigZag64(value), output);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static int computeVIntSize(long param) {
        return VIntCoding.computeUnsignedVIntSize(VIntCoding.encodeZigZag64(param));
    }

    public static int computeUnsignedVIntSize(long value) {
        int magnitude = Long.numberOfLeadingZeros(value | 1L);
        return 639 - magnitude * 9 >> 6;
    }
}

