/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import com.codahale.metrics.Timer;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.concurrent.WaitQueue;
import org.apache.cassandra.utils.memory.EnsureOnHeap;
import org.apache.cassandra.utils.memory.MemtablePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MemtableAllocator {
    private static final Logger logger = LoggerFactory.getLogger(MemtableAllocator.class);
    private final SubAllocator onHeap;
    private final SubAllocator offHeap;

    MemtableAllocator(SubAllocator onHeap, SubAllocator offHeap) {
        this.onHeap = onHeap;
        this.offHeap = offHeap;
    }

    public abstract Row.Builder rowBuilder(OpOrder.Group var1);

    public abstract DecoratedKey clone(DecoratedKey var1, OpOrder.Group var2);

    public abstract EnsureOnHeap ensureOnHeap();

    public SubAllocator onHeap() {
        return this.onHeap;
    }

    public SubAllocator offHeap() {
        return this.offHeap;
    }

    public void setDiscarding() {
        this.onHeap.setDiscarding();
        this.offHeap.setDiscarding();
    }

    public void setDiscarded() {
        this.onHeap.setDiscarded();
        this.offHeap.setDiscarded();
    }

    public boolean isLive() {
        return this.onHeap.state == LifeCycle.LIVE || this.offHeap.state == LifeCycle.LIVE;
    }

    public static class SubAllocator {
        private final MemtablePool.SubPool parent;
        private volatile LifeCycle state;
        private volatile long owns;
        private volatile long reclaiming;
        private static final AtomicLongFieldUpdater<SubAllocator> ownsUpdater = AtomicLongFieldUpdater.newUpdater(SubAllocator.class, "owns");
        private static final AtomicLongFieldUpdater<SubAllocator> reclaimingUpdater = AtomicLongFieldUpdater.newUpdater(SubAllocator.class, "reclaiming");

        SubAllocator(MemtablePool.SubPool parent) {
            this.parent = parent;
            this.state = LifeCycle.LIVE;
        }

        void setDiscarding() {
            this.state = this.state.transition(LifeCycle.DISCARDING);
            this.updateReclaiming();
        }

        void setDiscarded() {
            this.state = this.state.transition(LifeCycle.DISCARDED);
            this.releaseAll();
        }

        void releaseAll() {
            this.parent.released(ownsUpdater.getAndSet(this, 0L));
            this.parent.reclaimed(reclaimingUpdater.getAndSet(this, 0L));
        }

        public void adjust(long size, OpOrder.Group opGroup) {
            if (size <= 0L) {
                this.released(-size);
            } else {
                this.allocate(size, opGroup);
            }
        }

        public void allocate(long size, OpOrder.Group opGroup) {
            assert (size >= 0L);
            while (true) {
                if (this.parent.tryAllocate(size)) {
                    this.acquired(size);
                    return;
                }
                if (opGroup.isBlocking()) {
                    this.allocated(size);
                    return;
                }
                WaitQueue.Signal signal = this.parent.hasRoom().register(this.parent.blockedTimerContext(), Timer.Context::stop);
                opGroup.notifyIfBlocking(signal);
                boolean allocated = this.parent.tryAllocate(size);
                if (allocated) {
                    signal.cancel();
                    this.acquired(size);
                    return;
                }
                signal.awaitThrowUncheckedOnInterrupt();
            }
        }

        private void allocated(long size) {
            this.parent.allocated(size);
            ownsUpdater.addAndGet(this, size);
            if (this.state == LifeCycle.DISCARDING) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Allocated {} bytes whilst discarding", (Object)size);
                }
                this.updateReclaiming();
            }
        }

        private void acquired(long size) {
            this.parent.acquired();
            ownsUpdater.addAndGet(this, size);
            if (this.state == LifeCycle.DISCARDING) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Allocated {} bytes whilst discarding", (Object)size);
                }
                this.updateReclaiming();
            }
        }

        void released(long size) {
            if (this.state == LifeCycle.LIVE) {
                this.parent.released(size);
                ownsUpdater.addAndGet(this, -size);
            } else if (logger.isTraceEnabled()) {
                logger.trace("Tried to release {} bytes whilst discarding", (Object)size);
            }
        }

        void updateReclaiming() {
            long cur;
            long prev;
            while (!reclaimingUpdater.compareAndSet(this, prev = this.reclaiming, cur = this.owns)) {
            }
            this.parent.reclaiming(cur - prev);
        }

        public long owns() {
            return this.owns;
        }

        public long getReclaiming() {
            return this.reclaiming;
        }

        public float ownershipRatio() {
            float r = (float)this.owns / (float)this.parent.limit;
            if (Float.isNaN(r)) {
                return 0.0f;
            }
            return r;
        }
    }

    static final class LifeCycle
    extends Enum<LifeCycle> {
        public static final /* enum */ LifeCycle LIVE = new LifeCycle();
        public static final /* enum */ LifeCycle DISCARDING = new LifeCycle();
        public static final /* enum */ LifeCycle DISCARDED = new LifeCycle();
        private static final /* synthetic */ LifeCycle[] $VALUES;

        public static LifeCycle[] values() {
            return (LifeCycle[])$VALUES.clone();
        }

        public static LifeCycle valueOf(String name) {
            return Enum.valueOf(LifeCycle.class, name);
        }

        LifeCycle transition(LifeCycle targetState) {
            switch (targetState) {
                case DISCARDING: {
                    assert (this == LIVE);
                    return DISCARDING;
                }
                case DISCARDED: {
                    assert (this == DISCARDING);
                    return DISCARDED;
                }
            }
            throw new IllegalStateException();
        }

        static {
            $VALUES = new LifeCycle[]{LIVE, DISCARDING, DISCARDED};
        }
    }
}

