/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.snapshot;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.service.snapshot.TableSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotLoader
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotLoader.class);
    static final Pattern SNAPSHOT_DIR_PATTERN = Pattern.compile("(?<keyspace>\\w+)/(?<tableName>\\w+)\\-(?<tableId>[0-9a-f]{32})/snapshots/(?<tag>[\\w-]+)$");
    private final Collection<Path> dataDirectories;
    private final Map<String, TableSnapshot.Builder> snapshots = new HashMap<String, TableSnapshot.Builder>();

    public SnapshotLoader() {
        this(DatabaseDescriptor.getAllDataFileLocations());
    }

    public SnapshotLoader(String[] dataDirectories) {
        this.dataDirectories = Arrays.stream(dataDirectories).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }

    public SnapshotLoader(Collection<Path> dataDirs) {
        this.dataDirectories = dataDirs;
    }

    public Set<TableSnapshot> loadSnapshots() {
        for (Path dataDir : this.dataDirectories) {
            try {
                Files.walkFileTree(dataDir, Collections.EMPTY_SET, 5, this);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error while loading snapshots from %s", dataDir));
            }
        }
        return this.snapshots.values().stream().map(TableSnapshot.Builder::build).collect(Collectors.toSet());
    }

    @Override
    public FileVisitResult preVisitDirectory(Path subdir, BasicFileAttributes attrs) {
        if (subdir.getParent().getFileName().toString().equals("snapshots")) {
            logger.trace("Processing directory " + subdir);
            Matcher snapshotDirMatcher = SNAPSHOT_DIR_PATTERN.matcher(subdir.toString());
            if (snapshotDirMatcher.find()) {
                try {
                    this.loadSnapshotFromDir(snapshotDirMatcher, subdir);
                }
                catch (Throwable e) {
                    logger.warn("Could not load snapshot from {}.", (Object)subdir, (Object)e);
                }
            }
            return FileVisitResult.SKIP_SUBTREE;
        }
        return subdir.getFileName().equals("backups") ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
    }

    private void loadSnapshotFromDir(Matcher snapshotDirMatcher, Path snapshotDir) {
        String keyspaceName = snapshotDirMatcher.group("keyspace");
        String tableName = snapshotDirMatcher.group("tableName");
        UUID tableId = SnapshotLoader.parseUUID(snapshotDirMatcher.group("tableId"));
        String tag = snapshotDirMatcher.group("tag");
        String snapshotId = TableSnapshot.buildSnapshotId(keyspaceName, tableName, tableId, tag);
        TableSnapshot.Builder builder = this.snapshots.computeIfAbsent(snapshotId, k -> new TableSnapshot.Builder(keyspaceName, tableName, tableId, tag));
        builder.addSnapshotDir(new File(snapshotDir));
    }

    protected static UUID parseUUID(String uuidWithoutDashes) throws IllegalArgumentException {
        assert (uuidWithoutDashes.length() == 32 && !uuidWithoutDashes.contains("-"));
        String dashedUUID = uuidWithoutDashes.replaceFirst("([0-9a-f]{8})([0-9a-f]{4})([0-9a-f]{4})([0-9a-f]{4})([0-9a-f]+)", "$1-$2-$3-$4-$5");
        return UUID.fromString(dashedUUID);
    }
}

