/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.metrics.ClearableHistogram;
import org.apache.cassandra.metrics.DecayingEstimatedHistogramReservoir;
import org.apache.cassandra.metrics.ScalingReservoir;
import org.apache.cassandra.metrics.SnapshottingReservoir;
import org.apache.cassandra.metrics.SnapshottingTimer;
import org.apache.cassandra.metrics.ThreadPoolMetrics;
import org.apache.cassandra.utils.MBeanWrapper;

public class CassandraMetricsRegistry
extends MetricRegistry {
    public static final CassandraMetricsRegistry Metrics = new CassandraMetricsRegistry();
    private final Map<String, ThreadPoolMetrics> threadPoolMetrics = new ConcurrentHashMap<String, ThreadPoolMetrics>();
    private final MBeanWrapper mBeanServer = MBeanWrapper.instance;

    private CassandraMetricsRegistry() {
    }

    public Counter counter(MetricName name) {
        Counter counter = this.counter(name.getMetricName());
        this.registerMBean((Metric)counter, name.getMBeanName());
        return counter;
    }

    public Counter counter(MetricName name, MetricName alias) {
        Counter counter = this.counter(name);
        this.registerAlias(name, alias);
        return counter;
    }

    public Meter meter(MetricName name) {
        Meter meter = this.meter(name.getMetricName());
        this.registerMBean((Metric)meter, name.getMBeanName());
        return meter;
    }

    public Meter meter(MetricName name, MetricName alias) {
        Meter meter = this.meter(name);
        this.registerAlias(name, alias);
        return meter;
    }

    public Histogram histogram(MetricName name, boolean considerZeroes) {
        Histogram histogram = this.register(name, new ClearableHistogram(new DecayingEstimatedHistogramReservoir(considerZeroes)));
        this.registerMBean((Metric)histogram, name.getMBeanName());
        return histogram;
    }

    public Histogram histogram(MetricName name, MetricName alias, boolean considerZeroes) {
        Histogram histogram = this.histogram(name, considerZeroes);
        this.registerAlias(name, alias);
        return histogram;
    }

    public Timer timer(MetricName name) {
        return this.timer(name, TimeUnit.MICROSECONDS);
    }

    public SnapshottingTimer timer(MetricName name, MetricName alias) {
        return this.timer(name, alias, TimeUnit.MICROSECONDS);
    }

    public SnapshottingTimer timer(MetricName name, TimeUnit durationUnit) {
        SnapshottingTimer timer = this.register(name, new SnapshottingTimer(CassandraMetricsRegistry.createReservoir(durationUnit)));
        this.registerMBean((Metric)timer, name.getMBeanName());
        return timer;
    }

    public SnapshottingTimer timer(MetricName name, MetricName alias, TimeUnit durationUnit) {
        SnapshottingTimer timer = this.timer(name, durationUnit);
        this.registerAlias(name, alias);
        return timer;
    }

    public static SnapshottingReservoir createReservoir(TimeUnit durationUnit) {
        SnapshottingReservoir reservoir;
        if (durationUnit != TimeUnit.NANOSECONDS) {
            DecayingEstimatedHistogramReservoir underlying = new DecayingEstimatedHistogramReservoir(false, 127, DecayingEstimatedHistogramReservoir.DEFAULT_STRIPE_COUNT);
            reservoir = new ScalingReservoir(underlying, v -> durationUnit.convert(v, TimeUnit.NANOSECONDS));
        } else {
            reservoir = new DecayingEstimatedHistogramReservoir();
        }
        return reservoir;
    }

    public <T extends Metric> T register(MetricName name, T metric) {
        try {
            this.register(name.getMetricName(), metric);
            this.registerMBean(metric, name.getMBeanName());
            return metric;
        }
        catch (IllegalArgumentException e) {
            Metric existing = (Metric)Metrics.getMetrics().get(name.getMetricName());
            return (T)existing;
        }
    }

    public Collection<ThreadPoolMetrics> allThreadPoolMetrics() {
        return Collections.unmodifiableCollection(this.threadPoolMetrics.values());
    }

    public Optional<ThreadPoolMetrics> getThreadPoolMetrics(String poolName) {
        return Optional.ofNullable(this.threadPoolMetrics.get(poolName));
    }

    ThreadPoolMetrics register(ThreadPoolMetrics metrics) {
        this.threadPoolMetrics.put(metrics.poolName, metrics);
        return metrics;
    }

    void remove(ThreadPoolMetrics metrics) {
        this.threadPoolMetrics.remove(metrics.poolName, metrics);
    }

    public <T extends Metric> T register(MetricName name, MetricName aliasName, T metric) {
        T ret = this.register(name, metric);
        this.registerAlias(name, aliasName);
        return ret;
    }

    public <T extends Metric> T register(MetricName name, T metric, MetricName ... aliases) {
        T ret = this.register(name, metric);
        for (MetricName aliasName : aliases) {
            this.registerAlias(name, aliasName);
        }
        return ret;
    }

    public boolean remove(MetricName name) {
        boolean removed = this.remove(name.getMetricName());
        this.mBeanServer.unregisterMBean(name.getMBeanName(), MBeanWrapper.OnException.IGNORE);
        return removed;
    }

    public boolean remove(MetricName name, MetricName ... aliases) {
        if (this.remove(name)) {
            for (MetricName alias : aliases) {
                this.removeAlias(alias);
            }
            return true;
        }
        return false;
    }

    public void registerMBean(Metric metric, ObjectName name) {
        AbstractBean mbean;
        if (metric instanceof Gauge) {
            mbean = new JmxGauge((Gauge)metric, name);
        } else if (metric instanceof Counter) {
            mbean = new JmxCounter((Counter)metric, name);
        } else if (metric instanceof Histogram) {
            mbean = new JmxHistogram((Histogram)metric, name);
        } else if (metric instanceof Timer) {
            mbean = new JmxTimer((Timer)metric, name, TimeUnit.SECONDS, TimeUnit.MICROSECONDS);
        } else if (metric instanceof Metered) {
            mbean = new JmxMeter((Metered)metric, name, TimeUnit.SECONDS);
        } else {
            throw new IllegalArgumentException("Unknown metric type: " + metric.getClass());
        }
        if (!this.mBeanServer.isRegistered(name)) {
            this.mBeanServer.registerMBean((Object)mbean, name, MBeanWrapper.OnException.LOG);
        }
    }

    private void registerAlias(MetricName existingName, MetricName aliasName) {
        Metric existing = (Metric)Metrics.getMetrics().get(existingName.getMetricName());
        assert (existing != null) : existingName + " not registered";
        this.registerMBean(existing, aliasName.getMBeanName());
    }

    private void removeAlias(MetricName name) {
        if (this.mBeanServer.isRegistered(name.getMBeanName())) {
            MBeanWrapper.instance.unregisterMBean(name.getMBeanName(), MBeanWrapper.OnException.IGNORE);
        }
    }

    private static String withoutFinalDollar(String s) {
        int l = s.length();
        return l != 0 && '$' == s.charAt(l - 1) ? s.substring(0, l - 1) : s;
    }

    @VisibleForTesting
    static long[] delta(long[] now, long[] last) {
        long[] delta = new long[now.length];
        if (last == null) {
            last = new long[now.length];
        }
        for (int i = 0; i < now.length; ++i) {
            delta[i] = now[i] - (i < last.length ? last[i] : 0L);
        }
        return delta;
    }

    public static class MetricName
    implements Comparable<MetricName> {
        private final String group;
        private final String type;
        private final String name;
        private final String scope;
        private final String mBeanName;

        public MetricName(Class<?> klass, String name) {
            this(klass, name, null);
        }

        public MetricName(String group, String type, String name) {
            this(group, type, name, null);
        }

        public MetricName(Class<?> klass, String name, String scope) {
            this(klass.getPackage() == null ? "" : klass.getPackage().getName(), CassandraMetricsRegistry.withoutFinalDollar(klass.getSimpleName()), name, scope);
        }

        public MetricName(String group, String type, String name, String scope) {
            this(group, type, name, scope, MetricName.createMBeanName(group, type, name, scope));
        }

        public MetricName(String group, String type, String name, String scope, String mBeanName) {
            if (group == null || type == null) {
                throw new IllegalArgumentException("Both group and type need to be specified");
            }
            if (name == null) {
                throw new IllegalArgumentException("Name needs to be specified");
            }
            this.group = group;
            this.type = type;
            this.name = name;
            this.scope = scope;
            this.mBeanName = mBeanName;
        }

        public String getGroup() {
            return this.group;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getMetricName() {
            return MetricRegistry.name((String)this.group, (String[])new String[]{this.type, this.name, this.scope});
        }

        public String getScope() {
            return this.scope;
        }

        public boolean hasScope() {
            return this.scope != null;
        }

        public ObjectName getMBeanName() {
            String mname = this.mBeanName;
            if (mname == null) {
                mname = this.getMetricName();
            }
            try {
                return new ObjectName(mname);
            }
            catch (MalformedObjectNameException e) {
                try {
                    return new ObjectName(ObjectName.quote(mname));
                }
                catch (MalformedObjectNameException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricName that = (MetricName)o;
            return this.mBeanName.equals(that.mBeanName);
        }

        public int hashCode() {
            return this.mBeanName.hashCode();
        }

        public String toString() {
            return this.mBeanName;
        }

        @Override
        public int compareTo(MetricName o) {
            return this.mBeanName.compareTo(o.mBeanName);
        }

        private static String createMBeanName(String group, String type, String name, String scope) {
            StringBuilder nameBuilder = new StringBuilder();
            nameBuilder.append(ObjectName.quote(group));
            nameBuilder.append(":type=");
            nameBuilder.append(ObjectName.quote(type));
            if (scope != null) {
                nameBuilder.append(",scope=");
                nameBuilder.append(ObjectName.quote(scope));
            }
            if (name.length() > 0) {
                nameBuilder.append(",name=");
                nameBuilder.append(ObjectName.quote(name));
            }
            return nameBuilder.toString();
        }

        public static String chooseGroup(String group, Class<?> klass) {
            if (group == null || group.isEmpty()) {
                group = klass.getPackage() == null ? "" : klass.getPackage().getName();
            }
            return group;
        }

        public static String chooseType(String type, Class<?> klass) {
            if (type == null || type.isEmpty()) {
                type = CassandraMetricsRegistry.withoutFinalDollar(klass.getSimpleName());
            }
            return type;
        }

        public static String chooseName(String name, Method method) {
            if (name == null || name.isEmpty()) {
                name = method.getName();
            }
            return name;
        }
    }

    static class JmxTimer
    extends JmxMeter
    implements JmxTimerMBean {
        private final Timer metric;
        private final String durationUnit;
        private long[] last = null;

        private JmxTimer(Timer metric, ObjectName objectName, TimeUnit rateUnit, TimeUnit durationUnit) {
            super((Metered)metric, objectName, rateUnit);
            this.metric = metric;
            this.durationUnit = durationUnit.toString().toLowerCase(Locale.US);
        }

        @Override
        public double get50thPercentile() {
            return this.metric.getSnapshot().getMedian();
        }

        @Override
        public double getMin() {
            return this.metric.getSnapshot().getMin();
        }

        @Override
        public double getMax() {
            return this.metric.getSnapshot().getMax();
        }

        @Override
        public double getMean() {
            return this.metric.getSnapshot().getMean();
        }

        @Override
        public double getStdDev() {
            return this.metric.getSnapshot().getStdDev();
        }

        @Override
        public double get75thPercentile() {
            return this.metric.getSnapshot().get75thPercentile();
        }

        @Override
        public double get95thPercentile() {
            return this.metric.getSnapshot().get95thPercentile();
        }

        @Override
        public double get98thPercentile() {
            return this.metric.getSnapshot().get98thPercentile();
        }

        @Override
        public double get99thPercentile() {
            return this.metric.getSnapshot().get99thPercentile();
        }

        @Override
        public double get999thPercentile() {
            return this.metric.getSnapshot().get999thPercentile();
        }

        @Override
        public long[] values() {
            return this.metric.getSnapshot().getValues();
        }

        @Override
        public synchronized long[] getRecentValues() {
            long[] now = this.metric.getSnapshot().getValues();
            long[] delta = CassandraMetricsRegistry.delta(now, this.last);
            this.last = now;
            return delta;
        }

        @Override
        public String getDurationUnit() {
            return this.durationUnit;
        }
    }

    public static interface JmxTimerMBean
    extends JmxMeterMBean {
        public double getMin();

        public double getMax();

        public double getMean();

        public double getStdDev();

        public double get50thPercentile();

        public double get75thPercentile();

        public double get95thPercentile();

        public double get98thPercentile();

        public double get99thPercentile();

        public double get999thPercentile();

        public long[] values();

        public long[] getRecentValues();

        public String getDurationUnit();
    }

    private static class JmxMeter
    extends AbstractBean
    implements JmxMeterMBean {
        private final Metered metric;
        private final double rateFactor;
        private final String rateUnit;

        private JmxMeter(Metered metric, ObjectName objectName, TimeUnit rateUnit) {
            super(objectName);
            this.metric = metric;
            this.rateFactor = rateUnit.toSeconds(1L);
            this.rateUnit = "events/" + this.calculateRateUnit(rateUnit);
        }

        @Override
        public long getCount() {
            return this.metric.getCount();
        }

        @Override
        public double getMeanRate() {
            return this.metric.getMeanRate() * this.rateFactor;
        }

        @Override
        public double getOneMinuteRate() {
            return this.metric.getOneMinuteRate() * this.rateFactor;
        }

        @Override
        public double getFiveMinuteRate() {
            return this.metric.getFiveMinuteRate() * this.rateFactor;
        }

        @Override
        public double getFifteenMinuteRate() {
            return this.metric.getFifteenMinuteRate() * this.rateFactor;
        }

        @Override
        public String getRateUnit() {
            return this.rateUnit;
        }

        private String calculateRateUnit(TimeUnit unit) {
            String s = unit.toString().toLowerCase(Locale.US);
            return s.substring(0, s.length() - 1);
        }
    }

    public static interface JmxMeterMBean
    extends MetricMBean {
        public long getCount();

        public double getMeanRate();

        public double getOneMinuteRate();

        public double getFiveMinuteRate();

        public double getFifteenMinuteRate();

        public String getRateUnit();
    }

    private static class JmxCounter
    extends AbstractBean
    implements JmxCounterMBean {
        private final Counter metric;

        private JmxCounter(Counter metric, ObjectName objectName) {
            super(objectName);
            this.metric = metric;
        }

        @Override
        public long getCount() {
            return this.metric.getCount();
        }
    }

    public static interface JmxCounterMBean
    extends MetricMBean {
        public long getCount();
    }

    private static class JmxHistogram
    extends AbstractBean
    implements JmxHistogramMBean {
        private final Histogram metric;
        private long[] last = null;

        private JmxHistogram(Histogram metric, ObjectName objectName) {
            super(objectName);
            this.metric = metric;
        }

        @Override
        public double get50thPercentile() {
            return this.metric.getSnapshot().getMedian();
        }

        @Override
        public long getCount() {
            return this.metric.getCount();
        }

        @Override
        public long getMin() {
            return this.metric.getSnapshot().getMin();
        }

        @Override
        public long getMax() {
            return this.metric.getSnapshot().getMax();
        }

        @Override
        public double getMean() {
            return this.metric.getSnapshot().getMean();
        }

        @Override
        public double getStdDev() {
            return this.metric.getSnapshot().getStdDev();
        }

        @Override
        public double get75thPercentile() {
            return this.metric.getSnapshot().get75thPercentile();
        }

        @Override
        public double get95thPercentile() {
            return this.metric.getSnapshot().get95thPercentile();
        }

        @Override
        public double get98thPercentile() {
            return this.metric.getSnapshot().get98thPercentile();
        }

        @Override
        public double get99thPercentile() {
            return this.metric.getSnapshot().get99thPercentile();
        }

        @Override
        public double get999thPercentile() {
            return this.metric.getSnapshot().get999thPercentile();
        }

        @Override
        public long[] values() {
            return this.metric.getSnapshot().getValues();
        }

        @Override
        public synchronized long[] getRecentValues() {
            long[] now = this.metric.getSnapshot().getValues();
            long[] delta = CassandraMetricsRegistry.delta(now, this.last);
            this.last = now;
            return delta;
        }
    }

    public static interface JmxHistogramMBean
    extends MetricMBean {
        public long getCount();

        public long getMin();

        public long getMax();

        public double getMean();

        public double getStdDev();

        public double get50thPercentile();

        public double get75thPercentile();

        public double get95thPercentile();

        public double get98thPercentile();

        public double get99thPercentile();

        public double get999thPercentile();

        public long[] values();

        public long[] getRecentValues();
    }

    private static class JmxGauge
    extends AbstractBean
    implements JmxGaugeMBean {
        private final Gauge<?> metric;

        private JmxGauge(Gauge<?> metric, ObjectName objectName) {
            super(objectName);
            this.metric = metric;
        }

        @Override
        public Object getValue() {
            return this.metric.getValue();
        }
    }

    public static interface JmxGaugeMBean
    extends MetricMBean {
        public Object getValue();
    }

    private static abstract class AbstractBean
    implements MetricMBean {
        private final ObjectName objectName;

        AbstractBean(ObjectName objectName) {
            this.objectName = objectName;
        }

        @Override
        public ObjectName objectName() {
            return this.objectName;
        }
    }

    public static interface MetricMBean {
        public ObjectName objectName();
    }
}

