/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.BufferClusteringBound;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class RangeTombstoneList
implements Iterable<RangeTombstone>,
IMeasurableMemory {
    private static long EMPTY_SIZE = ObjectSizes.measure(new RangeTombstoneList(null, 0));
    private final ClusteringComparator comparator;
    private ClusteringBound<?>[] starts;
    private ClusteringBound<?>[] ends;
    private long[] markedAts;
    private int[] delTimes;
    private long boundaryHeapSize;
    private int size;

    private RangeTombstoneList(ClusteringComparator comparator, ClusteringBound<?>[] starts, ClusteringBound<?>[] ends, long[] markedAts, int[] delTimes, long boundaryHeapSize, int size) {
        assert (starts.length == ends.length && starts.length == markedAts.length && starts.length == delTimes.length);
        this.comparator = comparator;
        this.starts = starts;
        this.ends = ends;
        this.markedAts = markedAts;
        this.delTimes = delTimes;
        this.size = size;
        this.boundaryHeapSize = boundaryHeapSize;
    }

    public RangeTombstoneList(ClusteringComparator comparator, int capacity) {
        this(comparator, new ClusteringBound[capacity], new ClusteringBound[capacity], new long[capacity], new int[capacity], 0L, 0);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public ClusteringComparator comparator() {
        return this.comparator;
    }

    public RangeTombstoneList copy() {
        return new RangeTombstoneList(this.comparator, Arrays.copyOf(this.starts, this.size), Arrays.copyOf(this.ends, this.size), Arrays.copyOf(this.markedAts, this.size), Arrays.copyOf(this.delTimes, this.size), this.boundaryHeapSize, this.size);
    }

    public RangeTombstoneList copy(AbstractAllocator allocator) {
        RangeTombstoneList copy = new RangeTombstoneList(this.comparator, new ClusteringBound[this.size], new ClusteringBound[this.size], Arrays.copyOf(this.markedAts, this.size), Arrays.copyOf(this.delTimes, this.size), this.boundaryHeapSize, this.size);
        for (int i = 0; i < this.size; ++i) {
            copy.starts[i] = RangeTombstoneList.clone(this.starts[i], allocator);
            copy.ends[i] = RangeTombstoneList.clone(this.ends[i], allocator);
        }
        return copy;
    }

    private static <T> ClusteringBound<ByteBuffer> clone(ClusteringBound<T> bound, AbstractAllocator allocator) {
        ByteBuffer[] values = new ByteBuffer[bound.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = allocator.clone(bound.get(i), bound.accessor());
        }
        return new BufferClusteringBound(bound.kind(), values);
    }

    public void add(RangeTombstone tombstone) {
        this.add(tombstone.deletedSlice().start(), tombstone.deletedSlice().end(), tombstone.deletionTime().markedForDeleteAt(), tombstone.deletionTime().localDeletionTime());
    }

    public void add(ClusteringBound<?> start, ClusteringBound<?> end, long markedAt, int delTime) {
        if (this.isEmpty()) {
            this.addInternal(0, start, end, markedAt, delTime);
            return;
        }
        int c = this.comparator.compare(this.ends[this.size - 1], start);
        if (c <= 0) {
            this.addInternal(this.size, start, end, markedAt, delTime);
        } else {
            int pos = Arrays.binarySearch(this.ends, 0, this.size, start, this.comparator);
            this.insertFrom(pos >= 0 ? pos + 1 : -pos - 1, start, end, markedAt, delTime);
        }
        this.boundaryHeapSize += start.unsharedHeapSize() + end.unsharedHeapSize();
    }

    public void addAll(RangeTombstoneList tombstones) {
        if (tombstones.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            RangeTombstoneList.copyArrays(tombstones, this);
            return;
        }
        if (this.size > 10 * tombstones.size) {
            for (int i = 0; i < tombstones.size; ++i) {
                this.add(tombstones.starts[i], tombstones.ends[i], tombstones.markedAts[i], tombstones.delTimes[i]);
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < this.size && j < tombstones.size) {
                if (this.comparator.compare(tombstones.starts[j], this.ends[i]) < 0) {
                    this.insertFrom(i, tombstones.starts[j], tombstones.ends[j], tombstones.markedAts[j], tombstones.delTimes[j]);
                    ++j;
                    continue;
                }
                ++i;
            }
            while (j < tombstones.size) {
                this.addInternal(this.size, tombstones.starts[j], tombstones.ends[j], tombstones.markedAts[j], tombstones.delTimes[j]);
                ++j;
            }
        }
    }

    public boolean isDeleted(Clustering<?> clustering, Cell<?> cell) {
        int idx = this.searchInternal(clustering, 0, this.size);
        return idx >= 0 && (cell.isCounterCell() || this.markedAts[idx] >= cell.timestamp());
    }

    public DeletionTime searchDeletionTime(Clustering<?> name) {
        int idx = this.searchInternal(name, 0, this.size);
        return idx < 0 ? null : new DeletionTime(this.markedAts[idx], this.delTimes[idx]);
    }

    public RangeTombstone search(Clustering<?> name) {
        int idx = this.searchInternal(name, 0, this.size);
        return idx < 0 ? null : this.rangeTombstone(idx);
    }

    private int searchInternal(ClusteringPrefix<?> name, int startIdx, int endIdx) {
        if (this.isEmpty()) {
            return -1;
        }
        int pos = Arrays.binarySearch(this.starts, startIdx, endIdx, name, this.comparator);
        if (pos >= 0) {
            return -pos - 1;
        }
        int idx = -pos - 2;
        if (idx < 0) {
            return -1;
        }
        return this.comparator.compare(name, this.ends[idx]) < 0 ? idx : -idx - 2;
    }

    public int dataSize() {
        int dataSize = TypeSizes.sizeof(this.size);
        for (int i = 0; i < this.size; ++i) {
            dataSize += this.starts[i].dataSize() + this.ends[i].dataSize();
            dataSize += TypeSizes.sizeof(this.markedAts[i]);
            dataSize += TypeSizes.sizeof(this.delTimes[i]);
        }
        return dataSize;
    }

    public long maxMarkedAt() {
        long max = Long.MIN_VALUE;
        for (int i = 0; i < this.size; ++i) {
            max = Math.max(max, this.markedAts[i]);
        }
        return max;
    }

    public void collectStats(EncodingStats.Collector collector) {
        for (int i = 0; i < this.size; ++i) {
            collector.updateTimestamp(this.markedAts[i]);
            collector.updateLocalDeletionTime(this.delTimes[i]);
        }
    }

    public void updateAllTimestamp(long timestamp) {
        for (int i = 0; i < this.size; ++i) {
            this.markedAts[i] = timestamp;
        }
    }

    private RangeTombstone rangeTombstone(int idx) {
        return new RangeTombstone(Slice.make(this.starts[idx], this.ends[idx]), new DeletionTime(this.markedAts[idx], this.delTimes[idx]));
    }

    private RangeTombstone rangeTombstoneWithNewStart(int idx, ClusteringBound<?> newStart) {
        return new RangeTombstone(Slice.make(newStart, this.ends[idx]), new DeletionTime(this.markedAts[idx], this.delTimes[idx]));
    }

    private RangeTombstone rangeTombstoneWithNewEnd(int idx, ClusteringBound<?> newEnd) {
        return new RangeTombstone(Slice.make(this.starts[idx], newEnd), new DeletionTime(this.markedAts[idx], this.delTimes[idx]));
    }

    private RangeTombstone rangeTombstoneWithNewBounds(int idx, ClusteringBound<?> newStart, ClusteringBound<?> newEnd) {
        return new RangeTombstone(Slice.make(newStart, newEnd), new DeletionTime(this.markedAts[idx], this.delTimes[idx]));
    }

    @Override
    public Iterator<RangeTombstone> iterator() {
        return this.iterator(false);
    }

    public Iterator<RangeTombstone> iterator(boolean reversed) {
        return reversed ? new AbstractIterator<RangeTombstone>(){
            private int idx;
            {
                this.idx = RangeTombstoneList.this.size - 1;
            }

            @Override
            protected RangeTombstone computeNext() {
                if (this.idx < 0) {
                    return (RangeTombstone)this.endOfData();
                }
                return RangeTombstoneList.this.rangeTombstone(this.idx--);
            }
        } : new AbstractIterator<RangeTombstone>(){
            private int idx;

            @Override
            protected RangeTombstone computeNext() {
                if (this.idx >= RangeTombstoneList.this.size) {
                    return (RangeTombstone)this.endOfData();
                }
                return RangeTombstoneList.this.rangeTombstone(this.idx++);
            }
        };
    }

    public Iterator<RangeTombstone> iterator(Slice slice, boolean reversed) {
        return reversed ? this.reverseIterator(slice) : this.forwardIterator(slice);
    }

    private Iterator<RangeTombstone> forwardIterator(final Slice slice) {
        int finish;
        int start;
        int startIdx = slice.start().isBottom() ? 0 : this.searchInternal(slice.start(), 0, this.size);
        int n = start = startIdx < 0 ? -startIdx - 1 : startIdx;
        if (start >= this.size) {
            return Collections.emptyIterator();
        }
        int finishIdx = slice.end().isTop() ? this.size - 1 : this.searchInternal(slice.end(), start, this.size);
        int n2 = finish = finishIdx < 0 ? -finishIdx - 2 : finishIdx;
        if (start > finish) {
            return Collections.emptyIterator();
        }
        if (start == finish) {
            ClusteringBound<?> e;
            ClusteringBound<?> s = this.comparator.compare(this.starts[start], slice.start()) < 0 ? slice.start() : this.starts[start];
            ClusteringBound<?> clusteringBound = e = this.comparator.compare(slice.end(), this.ends[start]) < 0 ? slice.end() : this.ends[start];
            if (Slice.isEmpty(this.comparator, s, e)) {
                return Collections.emptyIterator();
            }
            return Iterators.singletonIterator((Object)this.rangeTombstoneWithNewBounds(start, s, e));
        }
        return new AbstractIterator<RangeTombstone>(){
            private int idx;
            {
                this.idx = start;
            }

            @Override
            protected RangeTombstone computeNext() {
                if (this.idx >= RangeTombstoneList.this.size || this.idx > finish) {
                    return (RangeTombstone)this.endOfData();
                }
                if (this.idx == start && RangeTombstoneList.this.comparator.compare(RangeTombstoneList.this.starts[this.idx], slice.start()) < 0) {
                    return RangeTombstoneList.this.rangeTombstoneWithNewStart(this.idx++, slice.start());
                }
                if (this.idx == finish && RangeTombstoneList.this.comparator.compare(slice.end(), RangeTombstoneList.this.ends[this.idx]) < 0) {
                    return RangeTombstoneList.this.rangeTombstoneWithNewEnd(this.idx++, slice.end());
                }
                return RangeTombstoneList.this.rangeTombstone(this.idx++);
            }
        };
    }

    private Iterator<RangeTombstone> reverseIterator(final Slice slice) {
        int finish;
        int start;
        int startIdx = slice.end().isTop() ? this.size - 1 : this.searchInternal(slice.end(), 0, this.size);
        int n = start = startIdx < 0 ? -startIdx - 2 : startIdx;
        if (start < 0) {
            return Collections.emptyIterator();
        }
        int finishIdx = slice.start().isBottom() ? 0 : this.searchInternal(slice.start(), 0, start + 1);
        int n2 = finish = finishIdx < 0 ? -finishIdx - 1 : finishIdx;
        if (start < finish) {
            return Collections.emptyIterator();
        }
        if (start == finish) {
            ClusteringBound<?> e;
            ClusteringBound<?> s = this.comparator.compare(this.starts[start], slice.start()) < 0 ? slice.start() : this.starts[start];
            ClusteringBound<?> clusteringBound = e = this.comparator.compare(slice.end(), this.ends[start]) < 0 ? slice.end() : this.ends[start];
            if (Slice.isEmpty(this.comparator, s, e)) {
                return Collections.emptyIterator();
            }
            return Iterators.singletonIterator((Object)this.rangeTombstoneWithNewBounds(start, s, e));
        }
        return new AbstractIterator<RangeTombstone>(){
            private int idx;
            {
                this.idx = start;
            }

            @Override
            protected RangeTombstone computeNext() {
                if (this.idx < 0 || this.idx < finish) {
                    return (RangeTombstone)this.endOfData();
                }
                if (this.idx == start && RangeTombstoneList.this.comparator.compare(slice.end(), RangeTombstoneList.this.ends[this.idx]) < 0) {
                    return RangeTombstoneList.this.rangeTombstoneWithNewEnd(this.idx--, slice.end());
                }
                if (this.idx == finish && RangeTombstoneList.this.comparator.compare(RangeTombstoneList.this.starts[this.idx], slice.start()) < 0) {
                    return RangeTombstoneList.this.rangeTombstoneWithNewStart(this.idx--, slice.start());
                }
                return RangeTombstoneList.this.rangeTombstone(this.idx--);
            }
        };
    }

    public boolean equals(Object o) {
        if (!(o instanceof RangeTombstoneList)) {
            return false;
        }
        RangeTombstoneList that = (RangeTombstoneList)o;
        if (this.size != that.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!this.starts[i].equals(that.starts[i])) {
                return false;
            }
            if (!this.ends[i].equals(that.ends[i])) {
                return false;
            }
            if (this.markedAts[i] != that.markedAts[i]) {
                return false;
            }
            if (this.delTimes[i] == that.delTimes[i]) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int result = this.size;
        for (int i = 0; i < this.size; ++i) {
            result += this.starts[i].hashCode() + this.ends[i].hashCode();
            result += (int)(this.markedAts[i] ^ this.markedAts[i] >>> 32);
            result += this.delTimes[i];
        }
        return result;
    }

    private static void copyArrays(RangeTombstoneList src, RangeTombstoneList dst) {
        dst.grow(src.size);
        System.arraycopy(src.starts, 0, dst.starts, 0, src.size);
        System.arraycopy(src.ends, 0, dst.ends, 0, src.size);
        System.arraycopy(src.markedAts, 0, dst.markedAts, 0, src.size);
        System.arraycopy(src.delTimes, 0, dst.delTimes, 0, src.size);
        dst.size = src.size;
        dst.boundaryHeapSize = src.boundaryHeapSize;
    }

    private void insertFrom(int i, ClusteringBound<?> start, ClusteringBound<?> end, long markedAt, int delTime) {
        while (i < this.size) {
            assert (start.isStart() && end.isEnd());
            assert (i == 0 || this.comparator.compare(this.ends[i - 1], start) <= 0);
            assert (this.comparator.compare(start, this.ends[i]) < 0);
            if (Slice.isEmpty(this.comparator, start, end)) {
                return;
            }
            if (markedAt > this.markedAts[i]) {
                int endCmp;
                ClusteringBoundOrBoundary newEnd;
                if (this.comparator.compare(this.starts[i], start) < 0 && !Slice.isEmpty(this.comparator, this.starts[i], newEnd = start.invert())) {
                    this.addInternal(i, this.starts[i], (ClusteringBound<?>)newEnd, this.markedAts[i], this.delTimes[i]);
                    this.setInternal(++i, (ClusteringBound<?>)start, this.ends[i], this.markedAts[i], this.delTimes[i]);
                }
                if ((endCmp = this.comparator.compare(end, this.starts[i])) < 0) {
                    this.addInternal(i, (ClusteringBound<?>)start, end, markedAt, delTime);
                    return;
                }
                int cmp = this.comparator.compare(this.ends[i], end);
                if (cmp <= 0) {
                    if (i == this.size - 1 || this.comparator.compare(end, this.starts[i + 1]) <= 0) {
                        this.setInternal(i, (ClusteringBound<?>)start, end, markedAt, delTime);
                        return;
                    }
                    this.setInternal(i, (ClusteringBound<?>)start, (ClusteringBound<?>)this.starts[i + 1].invert(), markedAt, delTime);
                    start = this.starts[i + 1];
                    ++i;
                    continue;
                }
                this.addInternal(i, (ClusteringBound<?>)start, end, markedAt, delTime);
                ClusteringBoundOrBoundary newStart = end.invert();
                if (!Slice.isEmpty(this.comparator, newStart, this.ends[++i])) {
                    this.setInternal(i, (ClusteringBound<?>)newStart, this.ends[i], this.markedAts[i], this.delTimes[i]);
                }
                return;
            }
            if (this.comparator.compare(start, this.starts[i]) < 0) {
                if (this.comparator.compare(end, this.starts[i]) <= 0) {
                    this.addInternal(i, (ClusteringBound<?>)start, end, markedAt, delTime);
                    return;
                }
                ClusteringBoundOrBoundary newEnd = this.starts[i].invert();
                if (!Slice.isEmpty(this.comparator, start, newEnd)) {
                    this.addInternal(i, (ClusteringBound<?>)start, (ClusteringBound<?>)newEnd, markedAt, delTime);
                    ++i;
                }
            }
            if (this.comparator.compare(end, this.ends[i]) <= 0) {
                return;
            }
            start = this.ends[i].invert();
            ++i;
        }
        this.addInternal(i, (ClusteringBound<?>)start, end, markedAt, delTime);
    }

    private int capacity() {
        return this.starts.length;
    }

    private void addInternal(int i, ClusteringBound<?> start, ClusteringBound<?> end, long markedAt, int delTime) {
        assert (i >= 0);
        if (this.size == this.capacity()) {
            this.growToFree(i);
        } else if (i < this.size) {
            this.moveElements(i);
        }
        this.setInternal(i, start, end, markedAt, delTime);
        ++this.size;
    }

    private void growToFree(int i) {
        int newLength = (int)Math.ceil((double)this.capacity() * DatabaseDescriptor.getRangeTombstoneListGrowthFactor());
        if (newLength <= this.capacity()) {
            newLength = this.capacity() * 3 / 2 + 1;
        }
        this.grow(i, newLength);
    }

    private void grow(int newLength) {
        if (this.capacity() < newLength) {
            this.grow(-1, newLength);
        }
    }

    private void grow(int i, int newLength) {
        this.starts = RangeTombstoneList.grow(this.starts, this.size, newLength, i);
        this.ends = RangeTombstoneList.grow(this.ends, this.size, newLength, i);
        this.markedAts = RangeTombstoneList.grow(this.markedAts, this.size, newLength, i);
        this.delTimes = RangeTombstoneList.grow(this.delTimes, this.size, newLength, i);
    }

    private static ClusteringBound<?>[] grow(ClusteringBound<?>[] a, int size, int newLength, int i) {
        if (i < 0 || i >= size) {
            return Arrays.copyOf(a, newLength);
        }
        ClusteringBound[] newA = new ClusteringBound[newLength];
        System.arraycopy(a, 0, newA, 0, i);
        System.arraycopy(a, i, newA, i + 1, size - i);
        return newA;
    }

    private static long[] grow(long[] a, int size, int newLength, int i) {
        if (i < 0 || i >= size) {
            return Arrays.copyOf(a, newLength);
        }
        long[] newA = new long[newLength];
        System.arraycopy(a, 0, newA, 0, i);
        System.arraycopy(a, i, newA, i + 1, size - i);
        return newA;
    }

    private static int[] grow(int[] a, int size, int newLength, int i) {
        if (i < 0 || i >= size) {
            return Arrays.copyOf(a, newLength);
        }
        int[] newA = new int[newLength];
        System.arraycopy(a, 0, newA, 0, i);
        System.arraycopy(a, i, newA, i + 1, size - i);
        return newA;
    }

    private void moveElements(int i) {
        if (i >= this.size) {
            return;
        }
        System.arraycopy(this.starts, i, this.starts, i + 1, this.size - i);
        System.arraycopy(this.ends, i, this.ends, i + 1, this.size - i);
        System.arraycopy(this.markedAts, i, this.markedAts, i + 1, this.size - i);
        System.arraycopy(this.delTimes, i, this.delTimes, i + 1, this.size - i);
        this.starts[i] = null;
    }

    private void setInternal(int i, ClusteringBound<?> start, ClusteringBound<?> end, long markedAt, int delTime) {
        if (this.starts[i] != null) {
            this.boundaryHeapSize -= this.starts[i].unsharedHeapSize() + this.ends[i].unsharedHeapSize();
        }
        this.starts[i] = start;
        this.ends[i] = end;
        this.markedAts[i] = markedAt;
        this.delTimes[i] = delTime;
        this.boundaryHeapSize += start.unsharedHeapSize() + end.unsharedHeapSize();
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + this.boundaryHeapSize + ObjectSizes.sizeOfArray(this.starts) + ObjectSizes.sizeOfArray(this.ends) + ObjectSizes.sizeOfArray(this.markedAts) + ObjectSizes.sizeOfArray(this.delTimes);
    }
}

