/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;

public final class DropKeyspaceStatement
extends AlterSchemaStatement {
    private final boolean ifExists;

    public DropKeyspaceStatement(String keyspaceName, boolean ifExists) {
        super(keyspaceName);
        this.ifExists = ifExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        if (schema.containsKeyspace(this.keyspaceName)) {
            return schema.without(this.keyspaceName);
        }
        if (this.ifExists) {
            return schema;
        }
        throw DropKeyspaceStatement.ire("Keyspace '%s' doesn't exist", this.keyspaceName);
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, this.keyspaceName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureKeyspacePermission(this.keyspaceName, Permission.DROP);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.DROP_KEYSPACE, this.keyspaceName);
    }

    public String toString() {
        return String.format("%s (%s)", this.getClass().getSimpleName(), this.keyspaceName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final String keyspaceName;
        private final boolean ifExists;

        public Raw(String keyspaceName, boolean ifExists) {
            this.keyspaceName = keyspaceName;
            this.ifExists = ifExists;
        }

        @Override
        public DropKeyspaceStatement prepare(ClientState state) {
            return new DropKeyspaceStatement(this.keyspaceName, this.ifExists);
        }
    }
}

