/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.cassandra.utils.btree.BTree;

class NodeCursor<K> {
    final NodeCursor<K> parent;
    final NodeCursor<K> child;
    final Comparator<? super K> comparator;
    boolean inChild;
    int position;
    Object[] node;
    int nodeOffset;

    NodeCursor(Object[] node, NodeCursor<K> parent, Comparator<? super K> comparator) {
        this.node = node;
        this.parent = parent;
        this.comparator = comparator;
        this.child = BTree.isLeaf(node) ? null : new NodeCursor<K>((Object[])node[BTree.getChildStart(node)], this, comparator);
    }

    void resetNode(Object[] node, int nodeOffset) {
        this.node = node;
        this.nodeOffset = nodeOffset;
    }

    void safeAdvanceIntoBranchFromChild(boolean forwards) {
        if (!forwards) {
            --this.position;
        }
    }

    boolean advanceIntoBranchFromChild(boolean forwards) {
        boolean bl = forwards ? this.position < BTree.getBranchKeyEnd(this.node) : --this.position >= 0;
        return bl;
    }

    boolean advanceLeafNode(boolean forwards) {
        boolean bl = forwards ? ++this.position < BTree.getLeafKeyEnd(this.node) : --this.position >= 0;
        return bl;
    }

    K bound(boolean upper) {
        return (K)this.node[this.position - (upper ? 0 : 1)];
    }

    NodeCursor<K> boundIterator(boolean upper) {
        NodeCursor<K> bound = this.parent;
        while (bound != null && (upper ? bound.position >= BTree.getChildCount(bound.node) - 1 : bound.position <= 0)) {
            bound = bound.parent;
        }
        return bound;
    }

    boolean seekInNode(K key, boolean forwards) {
        int ub;
        int lb;
        int position = this.position;
        if (forwards) {
            lb = position + 1;
            ub = BTree.getKeyEnd(this.node);
        } else {
            ub = position;
            lb = 0;
        }
        int find = Arrays.binarySearch(this.node, lb, ub, key, this.comparator);
        if (find >= 0) {
            this.position = find;
            this.inChild = false;
            return true;
        }
        int delta = this.isLeaf() & !forwards ? -1 : 0;
        this.position = delta - 1 - find;
        return false;
    }

    NodeCursor<K> descendToFirstChild(boolean forwards) {
        if (this.isLeaf()) {
            this.position = forwards ? 0 : BTree.getLeafKeyEnd(this.node) - 1;
            return null;
        }
        this.inChild = true;
        this.position = forwards ? 0 : BTree.getChildCount(this.node) - 1;
        return this.descend();
    }

    NodeCursor<K> descend() {
        Object[] childNode = (Object[])this.node[this.position + BTree.getChildStart(this.node)];
        int childOffset = this.nodeOffset + BTree.treeIndexOffsetOfChild(this.node, this.position);
        this.child.resetNode(childNode, childOffset);
        this.inChild = true;
        return this.child;
    }

    boolean isLeaf() {
        return this.child == null;
    }

    int globalIndex() {
        return this.nodeOffset + BTree.treeIndexOfKey(this.node, this.position);
    }

    int globalLeafIndex() {
        return this.nodeOffset + BTree.treeIndexOfLeafKey(this.position);
    }

    int globalBranchIndex() {
        return this.nodeOffset + BTree.treeIndexOfBranchKey(this.node, this.position);
    }

    K value() {
        return (K)this.node[this.position];
    }
}

