/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.UpdateFunction;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.Cloner;
import org.apache.cassandra.utils.memory.HeapCloner;
import org.apache.cassandra.utils.memory.MemtableAllocator;

public final class AtomicBTreePartition
extends AbstractBTreePartition {
    public static final long EMPTY_SIZE = ObjectSizes.measure(new AtomicBTreePartition(null, DatabaseDescriptor.getPartitioner().decorateKey(ByteBuffer.allocate(1)), null));
    private static final int TRACKER_NEVER_WASTED = 0;
    private static final int TRACKER_PESSIMISTIC_LOCKING = Integer.MAX_VALUE;
    private static final int ALLOCATION_GRANULARITY_BYTES = 1024;
    private static final long EXCESS_WASTE_BYTES = 0xA00000L;
    private static final int EXCESS_WASTE_OFFSET = 10240;
    private static final int CLOCK_SHIFT = 17;
    private static final AtomicIntegerFieldUpdater<AtomicBTreePartition> wasteTrackerUpdater = AtomicIntegerFieldUpdater.newUpdater(AtomicBTreePartition.class, "wasteTracker");
    private static final AtomicReferenceFieldUpdater<AtomicBTreePartition, AbstractBTreePartition.Holder> refUpdater = AtomicReferenceFieldUpdater.newUpdater(AtomicBTreePartition.class, AbstractBTreePartition.Holder.class, "ref");
    private volatile int wasteTracker = 0;
    private final MemtableAllocator allocator;
    private volatile AbstractBTreePartition.Holder ref;
    private final TableMetadataRef metadata;

    public AtomicBTreePartition(TableMetadataRef metadata, DecoratedKey partitionKey, MemtableAllocator allocator) {
        super(partitionKey);
        this.metadata = metadata;
        this.allocator = allocator;
        this.ref = EMPTY;
    }

    @Override
    protected AbstractBTreePartition.Holder holder() {
        return this.ref;
    }

    @Override
    public TableMetadata metadata() {
        return this.metadata.get();
    }

    @Override
    protected boolean canHaveShadowedData() {
        return true;
    }

    private long[] addAllWithSizeDeltaInternal(RowUpdater updater, PartitionUpdate update, UpdateTransaction indexer) {
        DeletionInfo deletionInfo;
        AbstractBTreePartition.Holder current = this.ref;
        updater.reset();
        if (!update.deletionInfo().getPartitionDeletion().isLive()) {
            indexer.onPartitionDeletion(update.deletionInfo().getPartitionDeletion());
        }
        if (update.deletionInfo().hasRanges()) {
            update.deletionInfo().rangeIterator(false).forEachRemaining(indexer::onRangeTombstone);
        }
        if (update.deletionInfo().mayModify(current.deletionInfo)) {
            if (updater.inputDeletionInfoCopy == null) {
                updater.inputDeletionInfoCopy = update.deletionInfo().clone(HeapCloner.instance);
            }
            deletionInfo = current.deletionInfo.mutableCopy().add(updater.inputDeletionInfoCopy);
            updater.onAllocatedOnHeap(deletionInfo.unsharedHeapSize() - current.deletionInfo.unsharedHeapSize());
        } else {
            deletionInfo = current.deletionInfo;
        }
        RegularAndStaticColumns columns = update.columns().mergeTo(current.columns);
        updater.onAllocatedOnHeap(columns.unsharedHeapSize() - current.columns.unsharedHeapSize());
        Row newStatic = update.staticRow();
        Row staticRow = newStatic.isEmpty() ? current.staticRow : (current.staticRow.isEmpty() ? updater.insert(newStatic) : updater.merge(current.staticRow, newStatic));
        Object[] tree = BTree.update(current.tree, update.holder().tree, update.metadata().comparator, updater);
        EncodingStats newStats = current.stats.mergeWith(update.stats());
        updater.onAllocatedOnHeap(newStats.unsharedHeapSize() - current.stats.unsharedHeapSize());
        if (tree != null && refUpdater.compareAndSet(this, current, new AbstractBTreePartition.Holder(columns, tree, deletionInfo, staticRow, newStats))) {
            updater.finish();
            return new long[]{updater.dataSize, updater.colUpdateTimeDelta};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] addAllWithSizeDelta(PartitionUpdate update, Cloner cloner, OpOrder.Group writeOp, UpdateTransaction indexer) {
        RowUpdater updater = new RowUpdater(this.allocator, cloner, writeOp, indexer);
        try {
            boolean shouldLock = this.shouldLock(writeOp);
            indexer.start();
            while (true) {
                if (shouldLock) {
                    AtomicBTreePartition atomicBTreePartition = this;
                    synchronized (atomicBTreePartition) {
                        block12: {
                            long[] result = this.addAllWithSizeDeltaInternal(updater, update, indexer);
                            if (result == null) break block12;
                            long[] lArray = result;
                            return lArray;
                        }
                    }
                }
                long[] result = this.addAllWithSizeDeltaInternal(updater, update, indexer);
                if (result != null) {
                    long[] lArray = result;
                    return lArray;
                }
                shouldLock = this.shouldLock(updater.heapSize, writeOp);
            }
        }
        finally {
            indexer.commit();
        }
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.allocator.ensureOnHeap().applyToDeletionInfo(super.deletionInfo());
    }

    @Override
    public Row staticRow() {
        return this.allocator.ensureOnHeap().applyToStatic(super.staticRow());
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.allocator.ensureOnHeap().applyToPartitionKey(super.partitionKey());
    }

    @Override
    public Row getRow(Clustering<?> clustering) {
        return this.allocator.ensureOnHeap().applyToRow(super.getRow(clustering));
    }

    @Override
    public Row lastRow() {
        return this.allocator.ensureOnHeap().applyToRow(super.lastRow());
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator(ColumnFilter selection, Slices slices, boolean reversed) {
        return this.allocator.ensureOnHeap().applyToPartition(super.unfilteredIterator(selection, slices, reversed));
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator(ColumnFilter selection, NavigableSet<Clustering<?>> clusteringsInQueryOrder, boolean reversed) {
        return this.allocator.ensureOnHeap().applyToPartition(super.unfilteredIterator(selection, clusteringsInQueryOrder, reversed));
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator() {
        return this.allocator.ensureOnHeap().applyToPartition(super.unfilteredIterator());
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator(AbstractBTreePartition.Holder current, ColumnFilter selection, Slices slices, boolean reversed) {
        return this.allocator.ensureOnHeap().applyToPartition(super.unfilteredIterator(current, selection, slices, reversed));
    }

    @Override
    public Iterator<Row> iterator() {
        return this.allocator.ensureOnHeap().applyToPartition(super.iterator());
    }

    private boolean shouldLock(OpOrder.Group writeOp) {
        if (!this.useLock()) {
            return false;
        }
        return this.lockIfOldest(writeOp);
    }

    private boolean shouldLock(long addWaste, OpOrder.Group writeOp) {
        if (!this.updateWastedAllocationTracker(addWaste)) {
            return false;
        }
        return this.lockIfOldest(writeOp);
    }

    private boolean lockIfOldest(OpOrder.Group writeOp) {
        if (!writeOp.isOldestLiveGroup()) {
            Thread.yield();
            return writeOp.isOldestLiveGroup();
        }
        return true;
    }

    public boolean useLock() {
        return this.wasteTracker == Integer.MAX_VALUE;
    }

    private boolean updateWastedAllocationTracker(long wastedBytes) {
        if (wastedBytes < 0xA00000L) {
            int oldTrackerValue;
            int wastedAllocation = (int)(wastedBytes + 1024L - 1L) / 1024;
            while (Integer.MAX_VALUE != (oldTrackerValue = this.wasteTracker)) {
                int time = (int)(System.nanoTime() >>> 17);
                int delta = oldTrackerValue - time;
                if (oldTrackerValue == 0 || delta >= 0 || delta < -10240) {
                    delta = -10240;
                }
                if ((delta += wastedAllocation) >= 0) break;
                if (!wasteTrackerUpdater.compareAndSet(this, oldTrackerValue, AtomicBTreePartition.avoidReservedValues(time + delta))) continue;
                return false;
            }
        }
        wasteTrackerUpdater.set(this, Integer.MAX_VALUE);
        return true;
    }

    private static int avoidReservedValues(int wasteTracker) {
        if (wasteTracker == 0 || wasteTracker == Integer.MAX_VALUE) {
            return wasteTracker + 1;
        }
        return wasteTracker;
    }

    @VisibleForTesting
    public void unsafeSetHolder(AbstractBTreePartition.Holder holder) {
        this.ref = holder;
    }

    @VisibleForTesting
    public AbstractBTreePartition.Holder unsafeGetHolder() {
        return this.ref;
    }

    private static final class RowUpdater
    implements UpdateFunction<Row, Row>,
    ColumnData.PostReconciliationFunction {
        final MemtableAllocator allocator;
        final OpOrder.Group writeOp;
        final UpdateTransaction indexer;
        final Cloner cloner;
        long dataSize;
        long heapSize;
        long colUpdateTimeDelta = Long.MAX_VALUE;
        List<Row> inserted;
        DeletionInfo inputDeletionInfoCopy = null;

        private RowUpdater(MemtableAllocator allocator, Cloner cloner, OpOrder.Group writeOp, UpdateTransaction indexer) {
            this.allocator = allocator;
            this.writeOp = writeOp;
            this.indexer = indexer;
            this.cloner = cloner;
        }

        @Override
        public Row insert(Row insert) {
            Row data = insert.clone(this.cloner);
            this.indexer.onInserted(insert);
            this.dataSize += (long)data.dataSize();
            this.heapSize += data.unsharedHeapSizeExcludingData();
            if (this.inserted == null) {
                this.inserted = new ArrayList<Row>();
            }
            this.inserted.add(data);
            return data;
        }

        @Override
        public Row merge(Row existing, Row update) {
            Row reconciled = Rows.merge(existing, update, this);
            this.indexer.onUpdated(existing, reconciled);
            if (this.inserted == null) {
                this.inserted = new ArrayList<Row>();
            }
            this.inserted.add(reconciled);
            return reconciled;
        }

        public Row retain(Row existing) {
            return existing;
        }

        protected void reset() {
            this.dataSize = 0L;
            this.heapSize = 0L;
            if (this.inserted != null) {
                this.inserted.clear();
            }
        }

        @Override
        public Cell<?> merge(Cell<?> previous, Cell<?> insert) {
            if (insert == previous) {
                return insert;
            }
            long timeDelta = Math.abs(insert.timestamp() - previous.timestamp());
            if (timeDelta < this.colUpdateTimeDelta) {
                this.colUpdateTimeDelta = timeDelta;
            }
            if (this.cloner != null) {
                insert = this.cloner.clone(insert);
            }
            this.dataSize += (long)(insert.dataSize() - previous.dataSize());
            this.heapSize += insert.unsharedHeapSizeExcludingData() - previous.unsharedHeapSizeExcludingData();
            return insert;
        }

        @Override
        public ColumnData insert(ColumnData insert) {
            if (this.cloner != null) {
                insert = insert.clone(this.cloner);
            }
            this.dataSize += (long)insert.dataSize();
            this.heapSize += insert.unsharedHeapSizeExcludingData();
            return insert;
        }

        @Override
        public void delete(ColumnData existing) {
            this.dataSize -= (long)existing.dataSize();
            this.heapSize -= existing.unsharedHeapSizeExcludingData();
        }

        @Override
        public void onAllocatedOnHeap(long heapSize) {
            this.heapSize += heapSize;
        }

        protected void finish() {
            this.allocator.onHeap().adjust(this.heapSize, this.writeOp);
        }
    }
}

