/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import io.netty.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class TimestampSerializer
extends TypeSerializer<Date> {
    private static final List<DateTimeFormatter> dateFormatters = TimestampSerializer.generateFormatters();
    private static final Pattern timestampPattern = Pattern.compile("^-?\\d+$");
    private static final FastThreadLocal<SimpleDateFormat> FORMATTER_UTC = new FastThreadLocal<SimpleDateFormat>(){

        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf;
        }
    };
    private static final FastThreadLocal<SimpleDateFormat> FORMATTER_TO_JSON = new FastThreadLocal<SimpleDateFormat>(){

        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSX");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf;
        }
    };
    public static final TimestampSerializer instance = new TimestampSerializer();

    private static List<DateTimeFormatter> generateFormatters() {
        ArrayList<DateTimeFormatter> formatters = new ArrayList<DateTimeFormatter>();
        String[] dateTimeFormats = new String[]{"y-M-d'T'H:m[:s]", "y-M-d H:m[:s]"};
        String[] offsetFormats = new String[]{" z", "X", " zzzz", "XXX"};
        for (String dateTimeFormat : dateTimeFormats) {
            formatters.add(new DateTimeFormatterBuilder().appendPattern(dateTimeFormat).appendFraction(ChronoField.MILLI_OF_SECOND, 0, 9, true).toFormatter().withZone(ZoneId.systemDefault()));
            for (String offset : offsetFormats) {
                formatters.add(new DateTimeFormatterBuilder().appendPattern(dateTimeFormat).appendFraction(ChronoField.MILLI_OF_SECOND, 0, 9, true).appendPattern(offset).toFormatter());
            }
        }
        for (String offset : offsetFormats) {
            formatters.add(new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").appendPattern(offset).parseDefaulting(ChronoField.NANO_OF_DAY, 0L).toFormatter());
        }
        formatters.add(new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_DATE).parseDefaulting(ChronoField.NANO_OF_DAY, 0L).toFormatter().withZone(ZoneId.systemDefault()));
        return formatters;
    }

    @Override
    public <V> Date deserialize(V value, ValueAccessor<V> accessor) {
        return accessor.isEmpty(value) ? null : new Date(accessor.toLong(value));
    }

    @Override
    public ByteBuffer serialize(Date value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value.getTime());
    }

    public static long dateStringToTimestamp(String source) throws MarshalException {
        if (source.equalsIgnoreCase("now")) {
            return System.currentTimeMillis();
        }
        if (timestampPattern.matcher(source).matches()) {
            try {
                return Long.parseLong(source);
            }
            catch (NumberFormatException e) {
                throw new MarshalException(String.format("Unable to make long (for date) from: '%s'", source), e);
            }
        }
        for (DateTimeFormatter fmt : dateFormatters) {
            try {
                return ZonedDateTime.parse(source, fmt).toInstant().toEpochMilli();
            }
            catch (DateTimeParseException e) {
            }
        }
        throw new MarshalException(String.format("Unable to parse a date/time from '%s'", source));
    }

    public static SimpleDateFormat getJsonDateFormatter() {
        return (SimpleDateFormat)FORMATTER_TO_JSON.get();
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (accessor.size(value) != 8 && !accessor.isEmpty(value)) {
            throw new MarshalException(String.format("Expected 8 or 0 byte long for date (%d)", accessor.size(value)));
        }
    }

    @Override
    public String toString(Date value) {
        return this.toStringUTC(value);
    }

    public String toStringUTC(Date value) {
        return value == null ? "" : ((SimpleDateFormat)FORMATTER_UTC.get()).format(value);
    }

    @Override
    public Class<Date> getType() {
        return Date.class;
    }

    @Override
    public String toCQLLiteral(ByteBuffer buffer) {
        return buffer == null || !buffer.hasRemaining() ? "null" : ((SimpleDateFormat)FORMATTER_UTC.get()).format((Date)this.deserialize(buffer));
    }
}

