/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.threads.MilliPauser;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.WireIn;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class AuditLogViewer {
    private static final String TOOL_NAME = "auditlogviewer";
    private static final String ROLL_CYCLE = "roll_cycle";
    private static final String FOLLOW = "follow";
    private static final String IGNORE = "ignore";
    private static final String HELP_OPTION = "help";

    public static void main(String[] args) {
        AuditLogViewerOptions options = AuditLogViewerOptions.parseArgs(args);
        try {
            AuditLogViewer.dump(options.pathList, options.rollCycle, options.follow, options.ignoreUnsupported, System.out::print);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    static void dump(List<String> pathList, String rollCycle, boolean follow, boolean ignoreUnsupported, Consumer<String> displayFun) {
        MilliPauser pauser = Pauser.millis((int)100);
        List tailers = pathList.stream().distinct().map(path -> SingleChronicleQueueBuilder.single((File)new File((String)path)).readOnly(true).rollCycle((RollCycle)RollCycles.valueOf((String)rollCycle)).build()).map(SingleChronicleQueue::createTailer).collect(Collectors.toList());
        boolean hadWork = true;
        while (hadWork) {
            hadWork = false;
            for (ExcerptTailer tailer : tailers) {
                while (tailer.readDocument((ReadMarshallable)new DisplayRecord(ignoreUnsupported, displayFun))) {
                    hadWork = true;
                }
            }
            if (!follow) continue;
            if (!hadWork) {
                pauser.pause();
            }
            hadWork = true;
        }
    }

    private static class AuditLogViewerOptions {
        private final List<String> pathList;
        private String rollCycle = "HOURLY";
        private boolean follow;
        private boolean ignoreUnsupported;

        private AuditLogViewerOptions(String[] pathList) {
            this.pathList = Arrays.asList(pathList);
        }

        static AuditLogViewerOptions parseArgs(String[] cmdArgs) {
            GnuParser parser = new GnuParser();
            Options options = AuditLogViewerOptions.getCmdLineOptions();
            try {
                String[] args;
                CommandLine cmd = parser.parse(options, cmdArgs, false);
                if (cmd.hasOption(AuditLogViewer.HELP_OPTION)) {
                    AuditLogViewerOptions.printUsage(options);
                    System.exit(0);
                }
                if ((args = cmd.getArgs()).length <= 0) {
                    System.err.println("Audit log files directory path is a required argument.");
                    AuditLogViewerOptions.printUsage(options);
                    System.exit(1);
                }
                AuditLogViewerOptions opts = new AuditLogViewerOptions(args);
                opts.follow = cmd.hasOption(AuditLogViewer.FOLLOW);
                opts.ignoreUnsupported = cmd.hasOption(AuditLogViewer.IGNORE);
                if (cmd.hasOption(AuditLogViewer.ROLL_CYCLE)) {
                    opts.rollCycle = cmd.getOptionValue(AuditLogViewer.ROLL_CYCLE);
                }
                return opts;
            }
            catch (ParseException e) {
                AuditLogViewerOptions.errorMsg(e.getMessage(), options);
                return null;
            }
        }

        static void errorMsg(String msg, Options options) {
            System.err.println(msg);
            AuditLogViewerOptions.printUsage(options);
            System.exit(1);
        }

        static Options getCmdLineOptions() {
            Options options = new Options();
            options.addOption(new Option("r", AuditLogViewer.ROLL_CYCLE, true, "How often to roll the log file was rolled. May be necessary for Chronicle to correctly parse file names. (MINUTELY, HOURLY, DAILY). Default HOURLY."));
            options.addOption(new Option("f", AuditLogViewer.FOLLOW, false, "Upon reacahing the end of the log continue indefinitely waiting for more records"));
            options.addOption(new Option("i", AuditLogViewer.IGNORE, false, "Silently ignore unsupported records"));
            options.addOption(new Option("h", AuditLogViewer.HELP_OPTION, false, "display this help message"));
            return options;
        }

        static void printUsage(Options options) {
            String usage = String.format("%s <path1> [<path2>...<pathN>] [options]", AuditLogViewer.TOOL_NAME);
            StringBuilder header = new StringBuilder();
            header.append("--\n");
            header.append("View the audit log contents in human readable format");
            header.append("\n--\n");
            header.append("Options are:");
            new HelpFormatter().printHelp(usage, header.toString(), options, "");
        }
    }

    private static class DisplayRecord
    implements ReadMarshallable {
        private final boolean ignoreUnsupported;
        private final Consumer<String> displayFun;

        DisplayRecord(boolean ignoreUnsupported, Consumer<String> displayFun) {
            this.ignoreUnsupported = ignoreUnsupported;
            this.displayFun = displayFun;
        }

        public void readMarshallable(WireIn wireIn) throws IORuntimeException {
            short version = wireIn.read("version").int16();
            if (!this.isSupportedVersion(version)) {
                return;
            }
            String type = wireIn.read("type").text();
            if (!this.isSupportedType(type)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Type: ").append(type).append(System.lineSeparator()).append("LogMessage: ").append(wireIn.read("message").text()).append(System.lineSeparator());
            this.displayFun.accept(sb.toString());
        }

        private boolean isSupportedVersion(int version) {
            if ((long)version <= 0L) {
                return true;
            }
            if (this.ignoreUnsupported) {
                return false;
            }
            throw new IORuntimeException("Unsupported record version [" + version + "] - highest supported version is [" + 0L + ']');
        }

        private boolean isSupportedType(String type) {
            if ("audit".equals(type)) {
                return true;
            }
            if (this.ignoreUnsupported) {
                return false;
            }
            throw new IORuntimeException("Unsupported record type field [" + type + "] - supported type is [" + "audit" + ']');
        }
    }
}

